/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor.ui;

import is.codion.common.format.LocaleDateTimePattern;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.ExceptionDialogBuilder;
import is.codion.tools.server.monitor.ClientUserMonitor;
import is.codion.tools.server.monitor.ui.ClientMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class ClientUserMonitorPanel
extends JPanel {
    private static final int SPINNER_COLUMNS = 3;
    private static final Integer[] MAINTENANCE_INTERVAL_VALUES = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 120, 180, 340, 6000, 10000};
    private final ClientUserMonitor model;
    private final ClientMonitorPanel clientTypeMonitorPanel;

    public ClientUserMonitorPanel(ClientUserMonitor model) throws RemoteException {
        this.model = Objects.requireNonNull(model);
        this.clientTypeMonitorPanel = new ClientMonitorPanel(model.clientMonitor());
        this.initializeUI();
    }

    public void disconnectAll() throws RemoteException {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to disconnect all clients?", "Disconnect all", 0) == 0) {
            this.model.disconnectAll();
        }
    }

    private void initializeUI() throws RemoteException {
        this.setLayout(new BorderLayout());
        this.add((Component)Components.tabbedPane().tab("Current", (JComponent)this.createCurrentConnectionsPanel()).tab("History", (JComponent)this.createConnectionHistoryPanel()).build(), "Center");
    }

    private JPanel createCurrentConnectionsPanel() throws RemoteException {
        JPanel actionBase = (JPanel)((PanelBuilder)Components.flowLayoutPanel((int)0).border((Border)BorderFactory.createTitledBorder("Remote connection controls"))).add((JComponent)new JLabel("Reaper interval (s)", 4)).add(this.createMaintenanceIntervalComponent()).add((JComponent)new JLabel("Idle connection timeout (s)")).add(((NumberSpinnerBuilder)Components.integerSpinner((SpinnerNumberModel)new SpinnerNumberModel(), this.model.idleConnectionTimeout()).columns(4)).build()).add(((ButtonBuilder)Components.button((Control)Control.commandControl(this.model::disconnectTimedOut)).text("Disconnect idle").toolTipText("Disconnect those that have exceeded the allowed idle time")).build()).add(((ButtonBuilder)Components.button((Control)Control.commandControl(this::disconnectAll)).text("Disconnect all").toolTipText("Disconnect all clients")).build()).build();
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)actionBase).centerComponent((JComponent)this.clientTypeMonitorPanel).build();
    }

    private JPanel createConnectionHistoryPanel() {
        JPanel configPanel = (JPanel)Components.flowLayoutPanel((int)0).add((JComponent)new JLabel("Update interval (s)")).add(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.updateInterval()).minimum((Number)1).columns(3)).editable(false)).build()).build();
        JPanel configBase = (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)configPanel).eastComponent(Components.button((Control)Control.commandControl(this.model::resetHistory)).text("Reset").build()).build();
        FilterTable userHistoryTable = (FilterTable)((FilterTable.Builder)FilterTable.builder(this.model.userHistoryTableModel(), ClientUserMonitorPanel.createUserHistoryColumns()).popupMenuControls(table -> (Controls)Controls.builder().control((Control.Builder)((Controls.ControlsBuilder)Controls.builder().name("Columns")).control((Control)table.createToggleColumnsControls()).control((Control)table.createResetColumnsControl()).control((Control)table.createAutoResizeModeControl())).build())).autoResizeMode(4).build();
        return (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)new JScrollPane((Component)userHistoryTable)).southComponent((JComponent)configBase).build();
    }

    private static List<FilterTableColumn<ClientUserMonitor.UserHistoryColumns.Id>> createUserHistoryColumns() {
        return Arrays.asList(ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.USERNAME_COLUMN, "Username"), ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.CLIENT_TYPE_COLUMN, "Client type"), ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.CLIENT_VERSION_COLUMN, "Client version"), ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.FRAMEWORK_VERSION_COLUMN, "Framework version"), ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.CLIENT_HOST_COLUMN, "Host"), ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.LAST_SEEN_COLUMN, "Last seen", new LastSeenRenderer()), ClientUserMonitorPanel.createColumn(ClientUserMonitor.UserHistoryColumns.Id.CONNECTION_COUNT_COLUMN, "Connections"));
    }

    private static FilterTableColumn<ClientUserMonitor.UserHistoryColumns.Id> createColumn(ClientUserMonitor.UserHistoryColumns.Id identifier, String headerValue) {
        return ClientUserMonitorPanel.createColumn(identifier, headerValue, null);
    }

    private static FilterTableColumn<ClientUserMonitor.UserHistoryColumns.Id> createColumn(ClientUserMonitor.UserHistoryColumns.Id identifier, String headerValue, TableCellRenderer cellRenderer) {
        return FilterTableColumn.builder((Enum)identifier).headerValue((Object)headerValue).cellRenderer(cellRenderer).build();
    }

    private JComponent createMaintenanceIntervalComponent() throws RemoteException {
        return ((ComboBoxBuilder)Components.comboBox(new DefaultComboBoxModel<Integer>(MAINTENANCE_INTERVAL_VALUES)).initialValue((Object)this.model.getMaintenanceInterval())).itemListener(e -> {
            try {
                this.model.setMaintenanceInterval((Integer)((JComboBox)e.getSource()).getSelectedItem());
            }
            catch (RemoteException ex) {
                this.onException(ex);
            }
        }).build();
    }

    private void onException(Exception exception) {
        ((ExceptionDialogBuilder)Dialogs.exceptionDialog().owner((Component)this)).show((Throwable)exception);
    }

    private static final class LastSeenRenderer
    extends DefaultTableCellRenderer {
        private final DateTimeFormatter formatter = LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutesSeconds().build().createFormatter();

        private LastSeenRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Temporal) {
                super.setValue(this.formatter.format((Temporal)value));
            } else {
                super.setValue(value);
            }
        }
    }
}

