/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor.ui;

import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.tools.server.monitor.ClientInstanceMonitor;
import is.codion.tools.server.monitor.ClientMonitor;
import is.codion.tools.server.monitor.ui.ClientInstanceMonitorPanel;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public final class ClientMonitorPanel
extends JPanel {
    private final ClientMonitor model;
    private final FilterTable<RemoteClient, ClientMonitor.RemoteClientColumns.Id> clientInstanceTable;
    private final JScrollPane filterScrollPane;
    private final JScrollPane clientInstanceScroller;
    private final State advancedFilterState = State.builder().consumer(this::toggleAdvancedFilters).build();

    public ClientMonitorPanel(ClientMonitor model) {
        this.model = model;
        this.clientInstanceTable = (FilterTable)((FilterTable.Builder)FilterTable.builder(model.clientInstanceTableModel(), ClientMonitorPanel.createColumns()).popupMenu(this::createPopupMenu)).autoResizeMode(4).filterState(ColumnConditionPanel.ConditionState.SIMPLE).build();
        this.clientInstanceScroller = (JScrollPane)((ScrollPaneBuilder)Components.scrollPane(this.clientInstanceTable).border((Border)BorderFactory.createTitledBorder("Clients"))).build();
        this.filterScrollPane = ClientMonitorPanel.createLinkedScrollPane(this.clientInstanceScroller, (JComponent)this.clientInstanceTable.filterPanel());
        this.initializeUI();
    }

    public ClientMonitor model() {
        return this.model;
    }

    public void refresh() {
        this.model.refresh();
    }

    private void initializeUI() {
        JPanel clientInstanceBase = (JPanel)Components.borderLayoutPanel().northComponent((JComponent)this.filterScrollPane).centerComponent((JComponent)this.clientInstanceScroller).southComponent(Components.borderLayoutPanel().southComponent(Components.borderLayoutPanel().centerComponent((JComponent)this.clientInstanceTable.searchField()).eastComponent(Components.flexibleGridLayoutPanel((int)1, (int)2).add(((CheckBoxBuilder)Components.checkBox((Value)this.advancedFilterState).text("Advanced filters")).build()).add(Components.button((Control)Control.commandControl(this::refresh)).text("Refresh").build()).build()).build()).build()).build();
        JPanel clientInstancePanel = (JPanel)Components.borderLayoutPanel().build();
        JSplitPane splitPane = (JSplitPane)Components.splitPane().orientation(1).oneTouchExpandable(true).continuousLayout(true).leftComponent((JComponent)clientInstanceBase).rightComponent((JComponent)clientInstancePanel).build();
        this.model.clientInstanceTableModel().selectionModel().selectedItemEvent().addConsumer(remoteClient -> {
            clientInstancePanel.removeAll();
            try {
                if (this.model != null && remoteClient != null) {
                    ClientInstanceMonitorPanel clientMonitor = new ClientInstanceMonitorPanel(new ClientInstanceMonitor(this.model.server(), (RemoteClient)remoteClient));
                    clientInstancePanel.add((Component)clientMonitor, "Center");
                }
                this.revalidate();
                this.repaint();
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        });
        this.setLayout(Layouts.borderLayout());
        this.add((Component)splitPane, "Center");
    }

    private JPopupMenu createPopupMenu(FilterTable<RemoteClient, ClientMonitor.RemoteClientColumns.Id> table) {
        return Components.menu((Controls.ControlsBuilder)Controls.builder().control(((CommandControl.CommandControlBuilder)Control.builder().command(this::disconnect).name("Disconnect")).enabled(this.model.clientInstanceTableModel().selectionModel().selectionNotEmpty())).separator().control((Control.Builder)((Controls.ControlsBuilder)Controls.builder().name("Columns")).control((Control)table.createToggleColumnsControls()).control((Control)table.createResetColumnsControl()).control((Control)table.createAutoResizeModeControl()))).createPopupMenu();
    }

    private void disconnect() throws RemoteException {
        for (RemoteClient remoteClient : this.model.clientInstanceTableModel().selectionModel().getSelectedItems()) {
            this.model.server().disconnect(remoteClient.clientId());
            this.model.clientInstanceTableModel().removeItem((Object)remoteClient);
        }
    }

    private void toggleAdvancedFilters(boolean advanced) {
        this.clientInstanceTable.filterPanel().state().set((Object)(advanced ? ColumnConditionPanel.ConditionState.ADVANCED : ColumnConditionPanel.ConditionState.SIMPLE));
        this.revalidate();
    }

    private static JScrollPane createLinkedScrollPane(JScrollPane parentScrollPane, JComponent componentToScroll) {
        return (JScrollPane)((ScrollPaneBuilder)Components.scrollPane((JComponent)componentToScroll).horizontalScrollBarPolicy(31).verticalScrollBarPolicy(21).onBuild(scrollPane -> Utilities.linkBoundedRangeModels((BoundedRangeModel)parentScrollPane.getHorizontalScrollBar().getModel(), (BoundedRangeModel)scrollPane.getHorizontalScrollBar().getModel()))).build();
    }

    private static List<FilterTableColumn<ClientMonitor.RemoteClientColumns.Id>> createColumns() {
        return Arrays.asList(FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.USER).headerValue((Object)"User").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.CLIENT_HOST).headerValue((Object)"Host").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.CLIENT_TYPE).headerValue((Object)"Type").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.CLIENT_VERSION).headerValue((Object)"Version").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.CODION_VERSION).headerValue((Object)"Framework version").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.CLIENT_ID).headerValue((Object)"Id").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.LOCALE).headerValue((Object)"Locale").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.TIMEZONE).headerValue((Object)"Timezone").build(), FilterTableColumn.builder((Enum)ClientMonitor.RemoteClientColumns.Id.CREATION_TIME).headerValue((Object)"Created").build());
    }
}

