/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor.ui;

import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.text.SearchHighlighter;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.FileSelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.tools.server.monitor.ClientInstanceMonitor;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public final class ClientInstanceMonitorPanel
extends JPanel {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutesSeconds().build().createFormatter();
    private static final DateTimeFormatter DATE_TIME_FILENAME_FORMATTER = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private final ClientInstanceMonitor model;
    private final JTextArea logTextArea;
    private final SearchHighlighter searchHighlighter;
    private final JTextField searchField;
    private final JTextField creationDateField = (JTextField)((TextFieldBuilder)Components.stringField().editable(false)).build();

    public ClientInstanceMonitorPanel(ClientInstanceMonitor model) throws RemoteException {
        this.model = Objects.requireNonNull(model);
        this.logTextArea = this.createLogTextArea();
        this.searchHighlighter = SearchHighlighter.searchHighlighter((JTextComponent)this.logTextArea);
        this.searchField = this.searchHighlighter.createSearchField();
        KeyEvents.builder((int)70).modifiers(128).action((Action)Control.commandControl(this.searchField::requestFocusInWindow)).enable(new JComponent[]{this.logTextArea});
        this.initializeUI();
        this.updateView();
    }

    public void updateView() throws RemoteException {
        this.creationDateField.setText(DATE_TIME_FORMATTER.format(this.model.remoteClient().creationTime()));
        this.model.refreshLog();
    }

    private void initializeUI() {
        JPanel creationDatePanel = (JPanel)Components.flowLayoutPanel((int)0).add((JComponent)new JLabel("Creation time")).add((JComponent)this.creationDateField).build();
        JPanel settingsPanel = (JPanel)Components.flowLayoutPanel((int)0).add(((CheckBoxBuilder)Components.checkBox((Value)this.model.loggingEnabled()).text("Logging enabled")).build()).add(Components.button((Control)Control.commandControl(this::updateView)).text("Refresh log").build()).build();
        JPanel northPanel = (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border((Border)BorderFactory.createTitledBorder("Connection info"))).centerComponent((JComponent)creationDatePanel).eastComponent((JComponent)settingsPanel).build();
        JPanel textLogPanel = (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)new JScrollPane(this.logTextArea)).southComponent((JComponent)this.searchField).build();
        JTabbedPane centerPane = (JTabbedPane)Components.tabbedPane().tab("Text", (JComponent)textLogPanel).tab("Tree", (JComponent)new JScrollPane(this.createLogTree())).build();
        this.setLayout(Layouts.borderLayout());
        this.add((Component)northPanel, "North");
        this.add((Component)centerPane, "Center");
    }

    private JTree createLogTree() {
        JTree treeLog = new JTree(this.model.logTreeModel());
        treeLog.setRootVisible(false);
        return treeLog;
    }

    private JTextArea createLogTextArea() {
        JTextArea textArea = (JTextArea)((TextAreaBuilder)Components.textArea().document(this.model.logDocument()).editable(false)).wrapStyleWord(true).build();
        Font font = textArea.getFont();
        textArea.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        State lineWrapState = State.builder().consumer(textArea::setLineWrap).build();
        textArea.setComponentPopupMenu(Components.menu((Controls.ControlsBuilder)Controls.builder().control(Control.builder().command(() -> this.saveLogToFile(textArea)).name("Save to file...")).separator().control(Control.builder().toggle(lineWrapState).name("Line wrap"))).createPopupMenu());
        return textArea;
    }

    private void saveLogToFile(JTextArea logArea) throws IOException {
        if (this.creationDateField.getText().isEmpty()) {
            throw new IllegalStateException("No client selected");
        }
        User user = this.model.remoteClient().user();
        LocalDateTime creationDate = LocalDateTime.parse(this.creationDateField.getText(), DATE_TIME_FORMATTER);
        String filename = user.username() + "@" + DATE_TIME_FILENAME_FORMATTER.format(creationDate) + ".log";
        Files.write(((FileSelectionDialogBuilder)Dialogs.fileSelectionDialog().owner((Component)this)).selectFileToSave(filename).toPath(), logArea.getText().getBytes(), new OpenOption[0]);
    }
}

