/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor;

import is.codion.common.event.Event;
import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.logging.LoggerProxy;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.ServerInformation;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.tools.server.monitor.ClientUserMonitor;
import is.codion.tools.server.monitor.DatabaseMonitor;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ServerMonitor.class);
    private static final Format MEMORY_USAGE_FORMAT = NumberFormat.getIntegerInstance();
    private static final double THOUSAND = 1000.0;
    private static final String GC_EVENT_PREFIX = "GC ";
    private final Event<?> serverShutDownEvent = Event.event();
    private final Value<Object> logLevelValue;
    private final Value<Integer> connectionLimitValue;
    private final String hostName;
    private final ServerInformation serverInformation;
    private final int registryPort;
    private final EntityServerAdmin server;
    private final User serverAdminUser;
    private final TaskScheduler updateScheduler;
    private final DatabaseMonitor databaseMonitor;
    private final ClientUserMonitor clientMonitor;
    private final LoggerProxy loggerProxy = LoggerProxy.instance();
    private boolean shutdown = false;
    private final Value<Integer> connectionCountValue = Value.nullable((Object)0).build();
    private final Value<String> memoryUsageValue = Value.nullable((Object)"").build();
    private final FilterTableModel<EntityServerAdmin.DomainEntityDefinition, DomainColumns.Id> domainTableModel = FilterTableModel.builder((FilterTableModel.Columns)new DomainColumns()).items((Supplier)new DomainTableItems()).build();
    private final FilterTableModel<EntityServerAdmin.DomainReport, ReportColumns.Id> reportTableModel = FilterTableModel.builder((FilterTableModel.Columns)new ReportColumns()).items((Supplier)new ReportTableItems()).build();
    private final FilterTableModel<EntityServerAdmin.DomainOperation, OperationColumns.Id> operationTableModel = FilterTableModel.builder((FilterTableModel.Columns)new OperationColumns()).items((Supplier)new OperationTableItems()).build();
    private final XYSeries connectionRequestsPerSecondSeries = new XYSeries((Comparable)((Object)"Service requests per second"));
    private final XYSeriesCollection connectionRequestsPerSecondCollection = new XYSeriesCollection();
    private final XYSeries allocatedMemorySeries = new XYSeries((Comparable)((Object)"Allocated memory"));
    private final XYSeries usedMemorySeries = new XYSeries((Comparable)((Object)"Used memory"));
    private final XYSeries maxMemorySeries = new XYSeries((Comparable)((Object)"Maximum memory"));
    private final XYSeriesCollection memoryUsageCollection = new XYSeriesCollection();
    private final XYSeries connectionCountSeries = new XYSeries((Comparable)((Object)"Connection count"));
    private final XYSeries connectionLimitSeries = new XYSeries((Comparable)((Object)"Connection limit"));
    private final XYSeriesCollection connectionCountCollection = new XYSeriesCollection();
    private final Map<String, XYSeries> gcTypeSeries = new HashMap<String, XYSeries>();
    private final XYSeriesCollection gcEventsCollection = new XYSeriesCollection();
    private final XYSeries threadCountSeries = new XYSeries((Comparable)((Object)"Threads"));
    private final XYSeries daemonThreadCountSeries = new XYSeries((Comparable)((Object)"Daemon Threads"));
    private final Map<Thread.State, XYSeries> threadStateSeries = new EnumMap<Thread.State, XYSeries>(Thread.State.class);
    private final XYSeriesCollection threadCountCollection = new XYSeriesCollection();
    private final XYSeries systemLoadSeries = new XYSeries((Comparable)((Object)"System Load"));
    private final XYSeries processLoadSeries = new XYSeries((Comparable)((Object)"Process Load"));
    private final XYSeriesCollection systemLoadCollection = new XYSeriesCollection();
    private long lastStatisticsUpdateTime = System.currentTimeMillis();

    public ServerMonitor(String hostName, ServerInformation serverInformation, int registryPort, User serverAdminUser, int updateRate) throws RemoteException, ServerAuthenticationException {
        this.hostName = Objects.requireNonNull(hostName);
        this.serverInformation = Objects.requireNonNull(serverInformation);
        this.registryPort = registryPort;
        this.serverAdminUser = Objects.requireNonNull(serverAdminUser);
        this.server = this.connectServer(serverInformation.serverName());
        this.connectionLimitValue = Value.nonNull((Object)-1).initialValue((Object)this.getConnectionLimit()).consumer(this::setConnectionLimit).build();
        this.logLevelValue = Value.nullable((Object)this.server.getLogLevel()).consumer(this::setLogLevel).build();
        this.connectionRequestsPerSecondCollection.addSeries(this.connectionRequestsPerSecondSeries);
        this.memoryUsageCollection.addSeries(this.maxMemorySeries);
        this.memoryUsageCollection.addSeries(this.allocatedMemorySeries);
        this.memoryUsageCollection.addSeries(this.usedMemorySeries);
        this.connectionCountCollection.addSeries(this.connectionCountSeries);
        this.connectionCountCollection.addSeries(this.connectionLimitSeries);
        this.threadCountCollection.addSeries(this.threadCountSeries);
        this.threadCountCollection.addSeries(this.daemonThreadCountSeries);
        this.systemLoadCollection.addSeries(this.systemLoadSeries);
        this.systemLoadCollection.addSeries(this.processLoadSeries);
        this.databaseMonitor = new DatabaseMonitor(this.server, updateRate);
        this.clientMonitor = new ClientUserMonitor(this.server, updateRate);
        this.updateScheduler = TaskScheduler.builder(this::updateStatistics).interval(updateRate, TimeUnit.SECONDS).start();
        this.refreshDomainList();
        this.refreshReportList();
        this.refreshOperationList();
    }

    public void shutdown() {
        this.shutdown = true;
        this.updateScheduler.stop();
        this.databaseMonitor.shutdown();
        this.clientMonitor.shutdown();
    }

    public EntityServerAdmin server() {
        return this.server;
    }

    public ServerInformation serverInformation() {
        return this.serverInformation;
    }

    public ValueObserver<String> memoryUsage() {
        return this.memoryUsageValue;
    }

    public ValueObserver<Integer> connectionCount() {
        return this.connectionCountValue;
    }

    public ClientUserMonitor clientMonitor() {
        return this.clientMonitor;
    }

    public DatabaseMonitor databaseMonitor() {
        return this.databaseMonitor;
    }

    public List<Object> logLevels() {
        return this.loggerProxy.levels();
    }

    public XYDataset connectionRequestsDataset() {
        return this.connectionRequestsPerSecondCollection;
    }

    public XYDataset memoryUsageDataset() {
        return this.memoryUsageCollection;
    }

    public XYDataset systemLoadDataset() {
        return this.systemLoadCollection;
    }

    public XYDataset connectionCountDataset() {
        return this.connectionCountCollection;
    }

    public XYDataset gcEventsDataset() {
        return this.gcEventsCollection;
    }

    public XYDataset threadCountDataset() {
        return this.threadCountCollection;
    }

    public String environmentInfo() throws RemoteException {
        StringBuilder contents = new StringBuilder();
        String startDate = LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutesSeconds().build().createFormatter().format(this.serverInformation.startTime());
        contents.append("Server info:").append("\n");
        contents.append(this.serverInformation.serverName()).append(" (").append(startDate).append(")").append(" port: ").append(this.serverInformation.serverPort()).append("\n").append("\n");
        contents.append("Server version:").append("\n");
        contents.append(this.serverInformation.serverVersion()).append("\n");
        contents.append("Database URL:").append("\n");
        contents.append(this.server.databaseUrl()).append("\n").append("\n");
        contents.append("Server locale: ").append("\n");
        contents.append(this.serverInformation.locale()).append("\n");
        contents.append("Server time zone: ").append("\n");
        contents.append(this.serverInformation.timeZone()).append("\n");
        contents.append("System properties:").append("\n");
        contents.append(this.server.systemProperties());
        return contents.toString();
    }

    public void clearStatistics() {
        this.connectionRequestsPerSecondSeries.clear();
        this.allocatedMemorySeries.clear();
        this.usedMemorySeries.clear();
        this.maxMemorySeries.clear();
        this.connectionCountSeries.clear();
        this.connectionLimitSeries.clear();
        this.threadCountSeries.clear();
        this.daemonThreadCountSeries.clear();
        this.systemLoadSeries.clear();
        this.processLoadSeries.clear();
        this.gcTypeSeries.values().forEach(XYSeries::clear);
        this.threadStateSeries.values().forEach(XYSeries::clear);
    }

    public void clearReportCache() throws RemoteException {
        this.server.clearReportCache();
    }

    public void refreshDomainList() {
        this.domainTableModel.refresh();
    }

    public void refreshReportList() {
        this.reportTableModel.refresh();
    }

    public void refreshOperationList() {
        this.operationTableModel.refresh();
    }

    public FilterTableModel<EntityServerAdmin.DomainEntityDefinition, DomainColumns.Id> domainTableModel() {
        return this.domainTableModel;
    }

    public FilterTableModel<EntityServerAdmin.DomainReport, ReportColumns.Id> reportTableModel() {
        return this.reportTableModel;
    }

    public FilterTableModel<EntityServerAdmin.DomainOperation, OperationColumns.Id> operationTableModel() {
        return this.operationTableModel;
    }

    public void shutdownServer() {
        this.shutdown();
        try {
            this.server.shutdown();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.serverShutDownEvent.run();
    }

    public boolean serverReachable() {
        try {
            this.server.usedMemory();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Value<Integer> updateInterval() {
        return this.updateScheduler.interval();
    }

    public void addServerShutDownListener(Runnable listener) {
        this.serverShutDownEvent.addListener(listener);
    }

    public Value<Integer> connectionLimit() {
        return this.connectionLimitValue;
    }

    public Value<Object> logLevel() {
        return this.logLevelValue;
    }

    private int getConnectionLimit() {
        try {
            return this.server.getConnectionLimit();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void setConnectionLimit(Integer value) {
        if (value == null || value < -1) {
            throw new IllegalArgumentException("Connection limit must be -1 or above");
        }
        try {
            this.server.setConnectionLimit(value.intValue());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void setLogLevel(Object level) {
        try {
            this.server.setLogLevel(level);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private EntityServerAdmin connectServer(String serverName) throws RemoteException, ServerAuthenticationException {
        long time = System.currentTimeMillis();
        try {
            Server theServer = (Server)LocateRegistry.getRegistry(this.hostName, this.registryPort).lookup(serverName);
            EntityServerAdmin serverAdmin = (EntityServerAdmin)theServer.serverAdmin(this.serverAdminUser);
            serverAdmin.usedMemory();
            LOG.info("ServerMonitor connected to server: {}", (Object)serverName);
            EntityServerAdmin entityServerAdmin = serverAdmin;
            return entityServerAdmin;
        }
        catch (RemoteException e) {
            LOG.error("Server \"{}\" is unreachable, host: {}, registry port: {}", new Object[]{serverName, this.hostName, this.registryPort, e});
            throw e;
        }
        catch (NotBoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RemoteException("Server " + serverName + " is not bound to registry on host: " + this.hostName + ", port: " + this.registryPort, e);
        }
        finally {
            LOG.debug("Registry.lookup(\"{}\"): {}", (Object)serverName, (Object)(System.currentTimeMillis() - time));
        }
    }

    private void updateStatistics() {
        try {
            if (!this.shutdown) {
                long timestamp;
                ServerAdmin.ServerStatistics statistics = this.server.serverStatistics(this.lastStatisticsUpdateTime);
                this.lastStatisticsUpdateTime = timestamp = statistics.timestamp();
                this.connectionLimitValue.set((Object)statistics.connectionLimit());
                this.connectionCountValue.set((Object)statistics.connectionCount());
                this.memoryUsageValue.set((Object)(MEMORY_USAGE_FORMAT.format(statistics.usedMemory()) + " KB"));
                this.connectionRequestsPerSecondSeries.add((double)timestamp, (double)statistics.requestsPerSecond());
                this.maxMemorySeries.add((double)timestamp, (double)statistics.maximumMemory() / 1000.0);
                this.allocatedMemorySeries.add((double)timestamp, (double)statistics.allocatedMemory() / 1000.0);
                this.usedMemorySeries.add((double)timestamp, (double)statistics.usedMemory() / 1000.0);
                this.systemLoadSeries.add((double)timestamp, statistics.systemCpuLoad() * 100.0);
                this.processLoadSeries.add((double)timestamp, statistics.processCpuLoad() * 100.0);
                this.connectionCountSeries.add((double)timestamp, (double)statistics.connectionCount());
                this.connectionLimitSeries.add((double)timestamp, (double)statistics.connectionLimit());
                this.addThreadStatistics(timestamp, statistics.threadStatistics());
                this.addGCInfo(statistics.gcEvents());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void addThreadStatistics(long timestamp, ServerAdmin.ThreadStatistics threadStatistics) {
        this.threadCountSeries.add((double)timestamp, (double)threadStatistics.threadCount());
        this.daemonThreadCountSeries.add((double)timestamp, (double)threadStatistics.daemonThreadCount());
        for (Map.Entry entry : threadStatistics.threadStateCount().entrySet()) {
            XYSeries stateSeries = this.threadStateSeries.get(entry.getKey());
            if (stateSeries == null) {
                stateSeries = new XYSeries((Comparable)entry.getKey());
                this.threadStateSeries.put((Thread.State)((Object)entry.getKey()), stateSeries);
                this.threadCountCollection.addSeries(stateSeries);
            }
            stateSeries.add((double)timestamp, (Number)entry.getValue());
        }
    }

    private void addGCInfo(List<ServerAdmin.GcEvent> gcEvents) {
        for (ServerAdmin.GcEvent event : gcEvents) {
            XYSeries typeSeries = this.gcTypeSeries.get(GC_EVENT_PREFIX + event.gcName());
            if (typeSeries == null) {
                typeSeries = new XYSeries((Comparable)((Object)(GC_EVENT_PREFIX + event.gcName())));
                this.gcTypeSeries.put(GC_EVENT_PREFIX + event.gcName(), typeSeries);
                this.gcEventsCollection.addSeries(typeSeries);
            }
            typeSeries.add((double)event.timestamp(), (double)event.duration());
        }
    }

    public static final class DomainColumns
    implements FilterTableModel.Columns<EntityServerAdmin.DomainEntityDefinition, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            return String.class;
        }

        public Object value(EntityServerAdmin.DomainEntityDefinition row, Id identifier) {
            switch (identifier) {
                case DOMAIN: {
                    return row.domain();
                }
                case ENTITY: {
                    return row.entity();
                }
                case TABLE: {
                    return row.table();
                }
            }
            throw new IllegalArgumentException();
        }

        public static enum Id {
            DOMAIN,
            ENTITY,
            TABLE;

        }
    }

    private final class DomainTableItems
    implements Supplier<Collection<EntityServerAdmin.DomainEntityDefinition>> {
        private DomainTableItems() {
        }

        @Override
        public Collection<EntityServerAdmin.DomainEntityDefinition> get() {
            try {
                return ServerMonitor.this.server.domainEntityDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class ReportColumns
    implements FilterTableModel.Columns<EntityServerAdmin.DomainReport, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            if (identifier == Id.CACHED) {
                return Boolean.class;
            }
            return String.class;
        }

        public Object value(EntityServerAdmin.DomainReport row, Id identifier) {
            switch (identifier) {
                case DOMAIN: {
                    return row.domain();
                }
                case REPORT: {
                    return row.name();
                }
                case TYPE: {
                    return row.type();
                }
                case PATH: {
                    return row.path();
                }
                case CACHED: {
                    return row.cached();
                }
            }
            throw new IllegalArgumentException();
        }

        public static enum Id {
            DOMAIN,
            REPORT,
            TYPE,
            PATH,
            CACHED;

        }
    }

    private final class ReportTableItems
    implements Supplier<Collection<EntityServerAdmin.DomainReport>> {
        private ReportTableItems() {
        }

        @Override
        public Collection<EntityServerAdmin.DomainReport> get() {
            try {
                return ServerMonitor.this.server.domainReports().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class OperationColumns
    implements FilterTableModel.Columns<EntityServerAdmin.DomainOperation, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            return String.class;
        }

        public Object value(EntityServerAdmin.DomainOperation row, Id identifier) {
            switch (identifier) {
                case DOMAIN: {
                    return row.domain();
                }
                case TYPE: {
                    return row.type();
                }
                case OPERATION: {
                    return row.name();
                }
                case CLASS: {
                    return row.className();
                }
            }
            throw new IllegalArgumentException();
        }

        public static enum Id {
            DOMAIN,
            TYPE,
            OPERATION,
            CLASS;

        }
    }

    private final class OperationTableItems
    implements Supplier<Collection<EntityServerAdmin.DomainOperation>> {
        private OperationTableItems() {
        }

        @Override
        public Collection<EntityServerAdmin.DomainOperation> get() {
            try {
                return ServerMonitor.this.server.domainOperations().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

