/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.rmi.server.ServerInformation;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.user.User;
import is.codion.tools.server.monitor.ServerMonitor;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(HostMonitor.class);
    private final Event<ServerMonitor> serverAddedEvent = Event.event();
    private final Event<ServerMonitor> serverRemovedEvent = Event.event();
    private final String hostName;
    private final int registryPort;
    private final User adminUser;
    private final int updateRate;
    private final Collection<ServerMonitor> serverMonitors = new ArrayList<ServerMonitor>();

    public HostMonitor(String hostName, int registryPort, User adminUser, int updateRate) throws RemoteException {
        this.hostName = Objects.requireNonNull(hostName);
        this.registryPort = registryPort;
        this.adminUser = Objects.requireNonNull(adminUser);
        this.updateRate = updateRate;
        this.refresh();
    }

    public String hostName() {
        return this.hostName;
    }

    public int registryPort() {
        return this.registryPort;
    }

    public void refresh() throws RemoteException {
        this.removeUnreachableServers();
        try {
            for (ServerInformation serverInformation : HostMonitor.findEntityServers(this.hostName, this.registryPort)) {
                if (this.containsServerMonitor(serverInformation.serverId())) continue;
                ServerMonitor serverMonitor = new ServerMonitor(this.hostName, serverInformation, this.registryPort, this.adminUser, this.updateRate);
                serverMonitor.addServerShutDownListener(() -> this.removeServer(serverMonitor));
                this.addServer(serverMonitor);
            }
        }
        catch (ServerAuthenticationException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ServerMonitor> serverMonitors() {
        return this.serverMonitors;
    }

    public EventObserver<ServerMonitor> serverAddedEvent() {
        return this.serverAddedEvent.observer();
    }

    public EventObserver<ServerMonitor> serverRemovedEvent() {
        return this.serverRemovedEvent.observer();
    }

    private void addServer(ServerMonitor serverMonitor) {
        this.serverMonitors.add(serverMonitor);
        this.serverAddedEvent.accept((Object)serverMonitor);
    }

    private void removeServer(ServerMonitor serverMonitor) {
        this.serverMonitors.remove(serverMonitor);
        this.serverRemovedEvent.accept((Object)serverMonitor);
    }

    private boolean containsServerMonitor(UUID serverId) {
        return this.serverMonitors.stream().anyMatch(serverMonitor -> serverMonitor.serverInformation().serverId().equals(serverId));
    }

    private void removeUnreachableServers() {
        ArrayList<ServerMonitor> monitors = new ArrayList<ServerMonitor>(this.serverMonitors);
        for (ServerMonitor monitor : monitors) {
            if (monitor.serverReachable()) continue;
            this.removeServer(monitor);
        }
    }

    private static List<ServerInformation> findEntityServers(String serverHostName, int registryPort) {
        ArrayList<ServerInformation> servers = new ArrayList<ServerInformation>();
        try {
            LOG.debug("HostMonitor locating registry on host: {}, port: {}: ", (Object)serverHostName, (Object)registryPort);
            Registry registry = LocateRegistry.getRegistry(serverHostName, registryPort);
            LOG.debug("HostMonitor located registry: {} on port: {}", (Object)registry, (Object)registryPort);
            Collection<String> boundNames = HostMonitor.findEntityServers(registry);
            if (boundNames.isEmpty()) {
                LOG.debug("HostMonitor found no server bound to registry: {} on port: {}", (Object)registry, (Object)registryPort);
            }
            for (String name : boundNames) {
                LOG.debug("HostMonitor found server '{}'", (Object)name);
                Server server = (Server)LocateRegistry.getRegistry(serverHostName, registryPort).lookup(name);
                servers.add(server.serverInformation());
            }
        }
        catch (NotBoundException | RemoteException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return servers;
    }

    private static Collection<String> findEntityServers(Registry registry) throws RemoteException {
        String[] boundNames = registry.list();
        String serverNamePrefix = (String)ServerConfiguration.SERVER_NAME_PREFIX.get();
        return Arrays.stream(boundNames).filter(name -> name.startsWith(serverNamePrefix)).collect(Collectors.toList());
    }
}

