/*
 * Decompiled with CFR 0.152.
 */
package is.codion.tools.server.monitor;

import is.codion.common.db.database.Database;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.value.Value;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.tools.server.monitor.PoolMonitor;
import java.rmi.RemoteException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class DatabaseMonitor {
    private final EntityServerAdmin server;
    private final PoolMonitor poolMonitor;
    private final XYSeries queriesPerSecond = new XYSeries((Comparable)((Object)"Queries per second"));
    private final XYSeries selectsPerSecond = new XYSeries((Comparable)((Object)"Selects per second"));
    private final XYSeries insertsPerSecond = new XYSeries((Comparable)((Object)"Inserts per second"));
    private final XYSeries updatesPerSecond = new XYSeries((Comparable)((Object)"Updates per second"));
    private final XYSeries deletesPerSecond = new XYSeries((Comparable)((Object)"Deletes per second"));
    private final XYSeries otherPerSecond = new XYSeries((Comparable)((Object)"Other per second"));
    private final XYSeriesCollection queriesPerSecondCollection = new XYSeriesCollection();
    private final TaskScheduler updateScheduler;

    public DatabaseMonitor(EntityServerAdmin server, int updateRate) throws RemoteException {
        this.server = Objects.requireNonNull(server);
        this.poolMonitor = new PoolMonitor(server, updateRate);
        this.queriesPerSecondCollection.addSeries(this.queriesPerSecond);
        this.queriesPerSecondCollection.addSeries(this.selectsPerSecond);
        this.queriesPerSecondCollection.addSeries(this.insertsPerSecond);
        this.queriesPerSecondCollection.addSeries(this.updatesPerSecond);
        this.queriesPerSecondCollection.addSeries(this.deletesPerSecond);
        this.queriesPerSecondCollection.addSeries(this.otherPerSecond);
        this.updateScheduler = TaskScheduler.builder(this::doUpdateStatistics).interval(updateRate, TimeUnit.SECONDS).start();
    }

    public PoolMonitor connectionPoolMonitor() {
        return this.poolMonitor;
    }

    public void shutdown() {
        this.updateScheduler.stop();
        this.poolMonitor.shutdown();
    }

    public void clearStatistics() {
        this.queriesPerSecond.clear();
        this.selectsPerSecond.clear();
        this.insertsPerSecond.clear();
        this.updatesPerSecond.clear();
        this.deletesPerSecond.clear();
        this.otherPerSecond.clear();
    }

    public void updateStatistics() throws RemoteException {
        Database.Statistics dbStats = this.server.databaseStatistics();
        this.queriesPerSecond.add((double)dbStats.timestamp(), (double)dbStats.queriesPerSecond());
        this.selectsPerSecond.add((double)dbStats.timestamp(), (double)dbStats.selectsPerSecond());
        this.insertsPerSecond.add((double)dbStats.timestamp(), (double)dbStats.insertsPerSecond());
        this.updatesPerSecond.add((double)dbStats.timestamp(), (double)dbStats.updatesPerSecond());
        this.deletesPerSecond.add((double)dbStats.timestamp(), (double)dbStats.deletesPerSecond());
        this.otherPerSecond.add((double)dbStats.timestamp(), (double)dbStats.otherPerSecond());
    }

    public XYDataset queriesPerSecondCollection() {
        return this.queriesPerSecondCollection;
    }

    public Value<Integer> updateInterval() {
        return this.updateScheduler.interval();
    }

    private void doUpdateStatistics() {
        try {
            this.updateStatistics();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

