/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.key.TransferFocusOnEnter;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityControls;
import is.codion.swing.framework.ui.component.EntitySearchField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class EntitySearchFieldPanel
extends JPanel {
    private final EntitySearchField searchField;
    private final List<AbstractButton> buttons = new ArrayList<AbstractButton>(0);

    private EntitySearchFieldPanel(DefaultBuilder builder) {
        this.searchField = builder.createSearchField();
        ArrayList<Control> actions = new ArrayList<Control>();
        if (builder.includeSearchButton) {
            actions.add(this.searchField.searchControl());
        }
        if (builder.includeAddButton) {
            this.searchField.addControl().ifPresent(actions::add);
        }
        if (builder.includeEditButton) {
            this.searchField.editControl().ifPresent(actions::add);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)EntityControls.createButtonPanel((JComponent)((Object)this.searchField), builder.buttonsFocusable, builder.buttonLocation, this.buttons, actions.toArray(new Action[0])), "Center");
        this.addFocusListener(new InputFocusAdapter(this.searchField));
    }

    public EntitySearchField searchField() {
        return this.searchField;
    }

    public static Builder builder(EntitySearchModel entitySearchModel) {
        return new DefaultBuilder(entitySearchModel, null);
    }

    public static Builder builder(EntitySearchModel entitySearchModel, Supplier<EntityEditPanel> editPanel) {
        return new DefaultBuilder(entitySearchModel, editPanel, null);
    }

    public static Builder builder(EntitySearchModel entitySearchModel, Supplier<EntityEditPanel> editPanel, Value<Entity> linkedValue) {
        return new DefaultBuilder(entitySearchModel, editPanel, Objects.requireNonNull(linkedValue));
    }

    private static final class DefaultBuilder
    extends AbstractComponentBuilder<Entity, EntitySearchFieldPanel, Builder>
    implements Builder {
        private final EntitySearchField.Builder searchFieldBuilder;
        private final boolean editPanelSupplierAvailable;
        private boolean includeSearchButton;
        private boolean includeAddButton;
        private boolean includeEditButton;
        private boolean buttonsFocusable;
        private String buttonLocation = EntityControls.defaultButtonLocation();

        private DefaultBuilder(EntitySearchModel searchModel, Value<Entity> linkedValue) {
            super(linkedValue);
            this.searchFieldBuilder = EntitySearchField.builder(searchModel);
            this.editPanelSupplierAvailable = false;
        }

        private DefaultBuilder(EntitySearchModel searchModel, Supplier<EntityEditPanel> editPanelSupplier, Value<Entity> linkedValue) {
            super(linkedValue);
            this.searchFieldBuilder = EntitySearchField.builder(searchModel).editPanel(editPanelSupplier);
            this.editPanelSupplierAvailable = editPanelSupplier != null;
        }

        @Override
        public Builder includeSearchButton(boolean includeSearchButton) {
            this.includeSearchButton = includeSearchButton;
            return this;
        }

        @Override
        public Builder includeAddButton(boolean includeAddButton) {
            if (includeAddButton && !this.editPanelSupplierAvailable) {
                throw new IllegalStateException("An edit panel is required for the add button");
            }
            this.includeAddButton = includeAddButton;
            return this;
        }

        @Override
        public Builder includeEditButton(boolean includeEditButton) {
            if (includeEditButton && !this.editPanelSupplierAvailable) {
                throw new IllegalStateException("You must provide an editPanel");
            }
            this.includeEditButton = includeEditButton;
            return this;
        }

        @Override
        public Builder confirmAdd(boolean confirmAdd) {
            this.searchFieldBuilder.confirmAdd(confirmAdd);
            return this;
        }

        @Override
        public Builder confirmEdit(boolean confirmEdit) {
            this.searchFieldBuilder.confirmEdit(confirmEdit);
            return this;
        }

        @Override
        public Builder buttonsFocusable(boolean buttonsFocusable) {
            this.buttonsFocusable = buttonsFocusable;
            return this;
        }

        @Override
        public Builder buttonLocation(String buttonLocation) {
            this.buttonLocation = EntityControls.validateButtonLocation(buttonLocation);
            return this;
        }

        @Override
        public Builder columns(int columns) {
            this.searchFieldBuilder.columns(columns);
            return this;
        }

        @Override
        public Builder upperCase(boolean upperCase) {
            this.searchFieldBuilder.upperCase(upperCase);
            return this;
        }

        @Override
        public Builder lowerCase(boolean lowerCase) {
            this.searchFieldBuilder.lowerCase(lowerCase);
            return this;
        }

        @Override
        public Builder searchHintEnabled(boolean searchHintEnabled) {
            this.searchFieldBuilder.searchHintEnabled(searchHintEnabled);
            return this;
        }

        @Override
        public Builder searchOnFocusLost(boolean searchOnFocusLost) {
            this.searchFieldBuilder.searchOnFocusLost(searchOnFocusLost);
            return this;
        }

        @Override
        public Builder selectAllOnFocusGained(boolean selectAllOnFocusGained) {
            this.searchFieldBuilder.selectAllOnFocusGained(selectAllOnFocusGained);
            return this;
        }

        @Override
        public Builder searchIndicator(EntitySearchField.SearchIndicator searchIndicator) {
            this.searchFieldBuilder.searchIndicator(searchIndicator);
            return this;
        }

        @Override
        public Builder selectorFactory(Function<EntitySearchModel, EntitySearchField.Selector> selectorFactory) {
            this.searchFieldBuilder.selectorFactory(selectorFactory);
            return this;
        }

        @Override
        public Builder limit(int limit) {
            this.searchFieldBuilder.limit(limit);
            return this;
        }

        protected EntitySearchFieldPanel createComponent() {
            return new EntitySearchFieldPanel(this);
        }

        protected ComponentValue<Entity, EntitySearchFieldPanel> createComponentValue(EntitySearchFieldPanel component) {
            return new EntitySearchFieldPanelValue(component);
        }

        protected void enableTransferFocusOnEnter(EntitySearchFieldPanel component) {
            TransferFocusOnEnter.enable((JComponent)((Object)component.searchField()));
            component.buttons.forEach(TransferFocusOnEnter::enable);
        }

        protected void setInitialValue(EntitySearchFieldPanel component, Entity initialValue) {
            component.searchField.model().entity().set((Object)initialValue);
        }

        private EntitySearchField createSearchField() {
            return (EntitySearchField)((Object)((EntitySearchField.Builder)this.searchFieldBuilder.clear()).build());
        }

        private static class EntitySearchFieldPanelValue
        extends AbstractComponentValue<Entity, EntitySearchFieldPanel> {
            private EntitySearchFieldPanelValue(EntitySearchFieldPanel component) {
                super((JComponent)component);
                component.searchField.model().entity().addListener(() -> this.notifyListeners());
            }

            protected Entity getComponentValue() {
                return (Entity)((EntitySearchFieldPanel)this.component()).searchField.model().entity().get();
            }

            protected void setComponentValue(Entity entity) {
                ((EntitySearchFieldPanel)this.component()).searchField.model().entity().set((Object)entity);
            }
        }
    }

    private static final class InputFocusAdapter
    extends FocusAdapter {
        private final EntitySearchField searchField;

        private InputFocusAdapter(EntitySearchField searchField) {
            this.searchField = searchField;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.searchField.requestFocusInWindow();
        }
    }

    public static interface Builder
    extends ComponentBuilder<Entity, EntitySearchFieldPanel, Builder> {
        public Builder includeSearchButton(boolean var1);

        public Builder includeAddButton(boolean var1);

        public Builder includeEditButton(boolean var1);

        public Builder confirmAdd(boolean var1);

        public Builder confirmEdit(boolean var1);

        public Builder buttonsFocusable(boolean var1);

        public Builder buttonLocation(String var1);

        public Builder columns(int var1);

        public Builder upperCase(boolean var1);

        public Builder lowerCase(boolean var1);

        public Builder searchHintEnabled(boolean var1);

        public Builder searchOnFocusLost(boolean var1);

        public Builder selectAllOnFocusGained(boolean var1);

        public Builder searchIndicator(EntitySearchField.SearchIndicator var1);

        public Builder selectorFactory(Function<EntitySearchModel, EntitySearchField.Selector> var1);

        public Builder limit(int var1);

        public EntitySearchFieldPanel build();
    }
}

