/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlKeyStrokes;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityEditPanel
extends EntityEditComponentPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityEditPanel.class);
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(EntityEditPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityEditPanel.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final Consumer<?> EMPTY_CONSUMER = value -> {};
    private static final String ALT_PREFIX = " (ALT-";
    private static final State.Group ACTIVE_STATE_GROUP;
    private static final Consumer<Config> NO_CONFIGURATION;
    private final Controls.Config controlsConfiguration;
    private final ControlMap controls;
    private final State active;
    final Config configuration;
    private boolean initialized = false;

    public EntityEditPanel(SwingEntityEditModel editModel) {
        this(editModel, NO_CONFIGURATION);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, Consumer<Config> config) {
        super(editModel);
        this.configuration = this.configure(config);
        this.active = State.state((!this.configuration.focusActivation ? 1 : 0) != 0);
        this.controls = this.createControls();
        this.controlsConfiguration = this.createControlsConfiguration();
        this.setupFocusActivation();
        this.setupKeyboardActions();
        if (((Boolean)editModel.exists().not().get()).booleanValue()) {
            editModel.defaults();
        }
    }

    @Override
    public final String toString() {
        return this.editModel().toString();
    }

    public final State active() {
        return this.active;
    }

    public final void clearAndRequestFocus() {
        this.editModel().defaults();
        this.requestInitialFocus();
    }

    public <T extends Control> Value<T> control(ControlKey<T> controlKey) {
        return this.controls.control(Objects.requireNonNull(controlKey));
    }

    public final Controls controls() {
        if (!this.initialized()) {
            throw new IllegalStateException("Method must be called after the panel is initialized");
        }
        return this.controlsConfiguration.create();
    }

    public final EntityEditPanel initialize() {
        if (!this.initialized) {
            try {
                this.setupControls();
                this.bindEvents();
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    public final boolean insertWithConfirmation() {
        if (this.confirmInsert()) {
            return this.insert();
        }
        return false;
    }

    public final boolean insert() {
        try {
            this.editModel().insert();
            if (this.configuration.clearAfterInsert) {
                this.editModel().defaults();
            }
            if (this.configuration.requestFocusAfterInsert) {
                this.requestAfterInsertFocus();
            }
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public final boolean deleteWithConfirmation() {
        if (this.confirmDelete()) {
            return this.delete();
        }
        return false;
    }

    public final boolean delete() {
        try {
            this.editModel().delete();
            this.requestInitialFocus();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean updateWithConfirmation() {
        if (this.confirmUpdate()) {
            return this.update();
        }
        return false;
    }

    public final boolean update() {
        try {
            this.editModel().update();
            this.requestAfterUpdateFocus();
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean initialized() {
        return this.initialized;
    }

    protected final boolean confirmInsert() {
        return this.configuration.insertConfirmer.confirm(this);
    }

    protected final boolean confirmUpdate() {
        return this.configuration.updateConfirmer.confirm(this);
    }

    protected final boolean confirmDelete() {
        return this.configuration.deleteConfirmer.confirm(this);
    }

    protected final InsertCommandBuilder insertCommand() {
        return new DefaultInsertCommandBuilder();
    }

    protected final UpdateCommandBuilder updateCommand() {
        return new DefaultUpdateCommandBuilder();
    }

    protected final DeleteCommandBuilder deleteCommand() {
        return new DefaultDeleteCommandBuilder();
    }

    @Override
    protected void onException(Exception exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)((Object)exception));
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)((Object)exception));
        } else {
            super.onException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (exception.operation() == Database.Operation.DELETE && this.configuration.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            EntityDependenciesPanel.displayDependenciesDialog(Collections.singletonList(this.editModel().entity()), this.editModel().connectionProvider(), (JComponent)this, MESSAGES.getString("unknown_dependent_records"));
        } else {
            super.onException((Exception)((Object)exception));
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.editModel().entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
        this.requestComponentFocus(exception.attribute());
    }

    protected void setupControls() {
    }

    protected abstract void initializeUI();

    protected final void configureControls(Consumer<Controls.Config> controlsConfig) {
        Objects.requireNonNull(controlsConfig).accept(this.controlsConfiguration);
    }

    private ControlMap createControls() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("Controls must be configured before the panel is initialized");
            }
        };
        ControlMap controlMap = ControlMap.controlMap(ControlKeys.class);
        controlMap.controls().forEach(control -> control.addValidator(controlValueValidator));
        if (!((Boolean)this.editModel().readOnly().get()).booleanValue()) {
            if (((Boolean)this.editModel().insertEnabled().get()).booleanValue()) {
                controlMap.control(ControlKeys.INSERT).set((Object)this.createInsertControl());
            }
            if (((Boolean)this.editModel().updateEnabled().get()).booleanValue()) {
                controlMap.control(ControlKeys.UPDATE).set((Object)this.createUpdateControl());
            }
            if (((Boolean)this.editModel().deleteEnabled().get()).booleanValue()) {
                controlMap.control(ControlKeys.DELETE).set((Object)this.createDeleteControl());
            }
        }
        controlMap.control(ControlKeys.CLEAR).set((Object)this.createClearControl());
        controlMap.control(ControlKeys.SELECT_INPUT_FIELD).set((Object)this.createSelectInputComponentControl());
        if (this.configuration.includeEntityMenu) {
            controlMap.control(ControlKeys.DISPLAY_ENTITY_MENU).set((Object)this.createShowEntityMenuControl());
        }
        return controlMap;
    }

    private CommandControl createDeleteControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.deleteCommand().confirm(true).build()).name(FrameworkMessages.delete())).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().deleteEnabled(), this.editModel().exists()}))).description(FrameworkMessages.deleteCurrentTip() + ALT_PREFIX + FrameworkMessages.deleteMnemonic() + ")")).mnemonic((int)FrameworkMessages.deleteMnemonic())).smallIcon((Icon)ICONS.delete())).onException(this::onException).build();
    }

    private CommandControl createClearControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::clearAndRequestFocus).name(Messages.clear())).enabled((StateObserver)this.active)).description(Messages.clearTip() + ALT_PREFIX + Messages.clearMnemonic() + ")")).mnemonic((int)Messages.clearMnemonic())).smallIcon((Icon)ICONS.clear())).build();
    }

    private CommandControl createSelectInputComponentControl() {
        return Control.commandControl(this::selectInputComponent);
    }

    private CommandControl createShowEntityMenuControl() {
        return Control.commandControl(this::showEntityMenu);
    }

    private CommandControl createUpdateControl() {
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.updateCommand().confirm(true).build()).name(FrameworkMessages.update())).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().updateEnabled(), this.editModel().editing()}))).description(FrameworkMessages.updateTip() + ALT_PREFIX + FrameworkMessages.updateMnemonic() + ")")).mnemonic((int)FrameworkMessages.updateMnemonic())).smallIcon((Icon)ICONS.update())).onException(this::onException).build();
    }

    private CommandControl createInsertControl() {
        boolean useSaveCaption = (Boolean)Config.USE_SAVE_CAPTION.get();
        char mnemonic = useSaveCaption ? FrameworkMessages.saveMnemonic() : FrameworkMessages.insertMnemonic();
        String caption = useSaveCaption ? FrameworkMessages.save() : FrameworkMessages.insert();
        return (CommandControl)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.insertCommand().confirm(true).build()).name(caption)).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().insertEnabled()}))).description(FrameworkMessages.insertTip() + ALT_PREFIX + mnemonic + ")")).mnemonic((int)mnemonic)).smallIcon((Icon)ICONS.add())).onException(this::onException).build();
    }

    private void bindEvents() {
        this.editModel().beforeEntityEvent().addConsumer(this::beforeEntity);
    }

    private void beforeEntity(Entity entity) {
        if (this.configuration.modifiedWarning && ((Boolean)this.editModel().editing().get()).booleanValue() && !Objects.equals(this.editModel().entity(), entity) && JOptionPane.showConfirmDialog(this, FrameworkMessages.modifiedWarning(), FrameworkMessages.modifiedWarningTitle(), 0) != 0) {
            throw new CancelException();
        }
    }

    private void setupFocusActivation() {
        if (this.configuration.focusActivation) {
            ACTIVE_STATE_GROUP.add(this.active);
        }
    }

    private void setupKeyboardActions() {
        this.configuration.keyStrokes.keyStroke(ControlKeys.DISPLAY_ENTITY_MENU).optional().ifPresent(keyStroke -> this.control(ControlKeys.DISPLAY_ENTITY_MENU).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.keyStrokes.keyStroke(ControlKeys.SELECT_INPUT_FIELD).optional().ifPresent(keyStroke -> this.control(ControlKeys.SELECT_INPUT_FIELD).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
    }

    private void showEntityMenu() {
        new EntityPopupMenu(this.editModel().entity(), this.editModel().connection()).show(this, 0, 0);
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    private Controls.Config createControlsConfiguration() {
        return Controls.config((ControlMap)this.controls, Arrays.asList(ControlKeys.INSERT, ControlKeys.UPDATE, ControlKeys.DELETE, ControlKeys.CLEAR));
    }

    private static <T> Consumer<T> emptyConsumer() {
        return EMPTY_CONSUMER;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new FocusActivationListener());
        ACTIVE_STATE_GROUP = State.group((State[])new State[0]);
        NO_CONFIGURATION = c -> {};
    }

    public static final class Config {
        public static final PropertyValue<Boolean> USE_SAVE_CAPTION = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".useSaveCaption"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".includeEntityMenu"), (boolean)true);
        public static final PropertyValue<Boolean> USE_FOCUS_ACTIVATION = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".useFocusActivation"), (boolean)true);
        public static final PropertyValue<Boolean> MODIFIED_WARNING = Configuration.booleanValue((String)(EntityEditPanel.class.getName() + ".modifiedWarning"), (boolean)false);
        private static final Confirmer DEFAULT_INSERT_CONFIRMER = Confirmer.NONE;
        private static final Confirmer DEFAULT_UPDATE_CONFIRMER = new UpdateConfirmer();
        private static final Confirmer DEFAULT_DELETE_CONFIRMER = new DeleteConfirmer();
        private final EntityEditPanel editPanel;
        private boolean clearAfterInsert = true;
        private boolean requestFocusAfterInsert = true;
        private boolean focusActivation = (Boolean)USE_FOCUS_ACTIVATION.get();
        private boolean includeEntityMenu = (Boolean)INCLUDE_ENTITY_MENU.get();
        private boolean modifiedWarning = (Boolean)MODIFIED_WARNING.get();
        private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());
        private Confirmer insertConfirmer = DEFAULT_INSERT_CONFIRMER;
        private Confirmer deleteConfirmer = DEFAULT_DELETE_CONFIRMER;
        private Confirmer updateConfirmer = DEFAULT_UPDATE_CONFIRMER;
        final ControlKeyStrokes keyStrokes;

        private Config(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
            this.keyStrokes = ControlKeys.KEY_STROKES.copy();
        }

        private Config(Config config) {
            this.editPanel = config.editPanel;
            this.keyStrokes = config.keyStrokes.copy();
            this.clearAfterInsert = config.clearAfterInsert;
            this.requestFocusAfterInsert = config.requestFocusAfterInsert;
            this.referentialIntegrityErrorHandling = config.referentialIntegrityErrorHandling;
            this.focusActivation = config.focusActivation;
            this.insertConfirmer = config.insertConfirmer;
            this.updateConfirmer = config.updateConfirmer;
            this.deleteConfirmer = config.deleteConfirmer;
            this.includeEntityMenu = config.includeEntityMenu;
            this.modifiedWarning = config.modifiedWarning;
        }

        public EntityEditPanel editPanel() {
            return this.editPanel;
        }

        public Config keyStrokes(Consumer<ControlKeyStrokes> keyStrokes) {
            Objects.requireNonNull(keyStrokes).accept(this.keyStrokes);
            return this;
        }

        public Config clearAfterInsert(boolean clearAfterInsert) {
            this.clearAfterInsert = clearAfterInsert;
            return this;
        }

        public Config requestFocusAfterInsert(boolean requestFocusAfterInsert) {
            this.requestFocusAfterInsert = requestFocusAfterInsert;
            return this;
        }

        public Config referentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
            this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
            return this;
        }

        public Config focusActivation(boolean focusActivation) {
            this.focusActivation = focusActivation;
            return this;
        }

        public Config includeEntityMenu(boolean includeEntityMenu) {
            this.includeEntityMenu = includeEntityMenu;
            return this;
        }

        public Config modifiedWarning(boolean modifiedWarning) {
            this.modifiedWarning = modifiedWarning;
            return this;
        }

        public Config insertConfirmer(Confirmer insertConfirmer) {
            this.insertConfirmer = Objects.requireNonNull(insertConfirmer);
            return this;
        }

        public Config deleteConfirmer(Confirmer deleteConfirmer) {
            this.deleteConfirmer = Objects.requireNonNull(deleteConfirmer);
            return this;
        }

        public Config updateConfirmer(Confirmer updateConfirmer) {
            this.updateConfirmer = Objects.requireNonNull(updateConfirmer);
            return this;
        }
    }

    public static interface Confirmer {
        public static final Confirmer NONE = dialogOwner -> true;

        public boolean confirm(JComponent var1);

        default public boolean confirm(JComponent dialogOwner, String message, String title) {
            return JOptionPane.showConfirmDialog(dialogOwner, message, title, 2) == 0;
        }
    }

    private final class DefaultInsertCommandBuilder
    implements InsertCommandBuilder {
        private boolean confirm;
        private Consumer<Collection<Entity>> onInsert = EntityEditPanel.emptyConsumer();

        private DefaultInsertCommandBuilder() {
        }

        @Override
        public InsertCommandBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public InsertCommandBuilder onInsert(Consumer<Collection<Entity>> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return this;
        }

        @Override
        public Control.Command build() {
            return new InsertCommand(this);
        }
    }

    private final class DefaultUpdateCommandBuilder
    implements UpdateCommandBuilder {
        private boolean confirm = true;
        private Consumer<Collection<Entity>> onUpdate = EntityEditPanel.emptyConsumer();

        private DefaultUpdateCommandBuilder() {
        }

        @Override
        public UpdateCommandBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public UpdateCommandBuilder onUpdate(Consumer<Collection<Entity>> onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate);
            return this;
        }

        @Override
        public Control.Command build() {
            return new UpdateCommand(this);
        }
    }

    private final class DefaultDeleteCommandBuilder
    implements DeleteCommandBuilder {
        private boolean confirm = true;
        private Consumer<Collection<Entity>> onDelete = EntityEditPanel.emptyConsumer();

        private DefaultDeleteCommandBuilder() {
        }

        @Override
        public DeleteCommandBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public DeleteCommandBuilder onDelete(Consumer<Collection<Entity>> onDelete) {
            this.onDelete = Objects.requireNonNull(onDelete);
            return this;
        }

        @Override
        public Control.Command build() {
            return new DeleteCommand(this);
        }
    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> INSERT = ControlKey.commandControl();
        public static final ControlKey<CommandControl> UPDATE = ControlKey.commandControl();
        public static final ControlKey<CommandControl> DELETE = ControlKey.commandControl();
        public static final ControlKey<CommandControl> CLEAR = ControlKey.commandControl();
        public static final ControlKey<CommandControl> SELECT_INPUT_FIELD = ControlKey.commandControl((KeyStroke)ControlKeyStrokes.keyStroke((int)73, (int)128));
        public static final ControlKey<CommandControl> DISPLAY_ENTITY_MENU = ControlKey.commandControl((KeyStroke)ControlKeyStrokes.keyStroke((int)86, (int)640));
        public static final ControlKeyStrokes KEY_STROKES = ControlKeyStrokes.controlKeyStrokes(ControlKeys.class);

        private ControlKeys() {
        }
    }

    public static interface DeleteCommandBuilder {
        public DeleteCommandBuilder confirm(boolean var1);

        public DeleteCommandBuilder onDelete(Consumer<Collection<Entity>> var1);

        public Control.Command build();
    }

    public static interface UpdateCommandBuilder {
        public UpdateCommandBuilder confirm(boolean var1);

        public UpdateCommandBuilder onUpdate(Consumer<Collection<Entity>> var1);

        public Control.Command build();
    }

    public static interface InsertCommandBuilder {
        public InsertCommandBuilder confirm(boolean var1);

        public InsertCommandBuilder onInsert(Consumer<Collection<Entity>> var1);

        public Control.Command build();
    }

    private static final class FocusActivationListener
    implements PropertyChangeListener {
        private FocusActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            Component focusedComponent = (Component)changeEvent.getNewValue();
            if (focusedComponent != null) {
                EntityEditPanel editPanel = null;
                EntityPanel entityPanel = FocusActivationListener.entityPanel(focusedComponent);
                if (entityPanel != null) {
                    if (entityPanel.containsEditPanel()) {
                        editPanel = entityPanel.editPanel();
                    }
                } else {
                    editPanel = (EntityEditPanel)Utilities.parentOfType(EntityEditPanel.class, (Component)focusedComponent);
                }
                if (editPanel != null && editPanel.configuration.focusActivation) {
                    editPanel.active.set((Object)true);
                }
            }
        }

        private static EntityPanel entityPanel(Component focusedComponent) {
            Component selectedComponent;
            if (focusedComponent instanceof JTabbedPane && (selectedComponent = ((JTabbedPane)focusedComponent).getSelectedComponent()) instanceof EntityPanel) {
                return (EntityPanel)selectedComponent;
            }
            return (EntityPanel)Utilities.parentOfType(EntityPanel.class, (Component)focusedComponent);
        }
    }

    private static final class DeleteConfirmer
    implements Confirmer {
        private DeleteConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete((int)1), FrameworkMessages.delete());
        }
    }

    private static final class UpdateConfirmer
    implements Confirmer {
        private UpdateConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmUpdate(), FrameworkMessages.update());
        }
    }

    private final class DeleteCommand
    implements Control.Command {
        private final boolean confirm;
        private final Consumer<Collection<Entity>> onDelete;

        private DeleteCommand(DefaultDeleteCommandBuilder builder) {
            this.confirm = builder.confirm;
            this.onDelete = builder.onDelete;
        }

        public void execute() {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmDelete()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Delete.Task)EntityEditPanel.this.editModel().createDelete().prepare()).perform()).title(MESSAGES.getString("deleting"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Delete.Result result) {
            this.onDelete.accept(result.handle());
            EntityEditPanel.this.requestInitialFocus();
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    private final class UpdateCommand
    implements Control.Command {
        private final boolean confirm;
        private final Consumer<Collection<Entity>> onUpdate;

        private UpdateCommand(DefaultUpdateCommandBuilder builder) {
            this.confirm = builder.confirm;
            this.onUpdate = builder.onUpdate;
        }

        public void execute() throws ValidationException {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmUpdate()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Update.Task)EntityEditPanel.this.editModel().createUpdate().prepare()).perform()).title(MESSAGES.getString("updating"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Update.Result result) {
            this.onUpdate.accept(result.handle());
            EntityEditPanel.this.requestAfterUpdateFocus();
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }

    private final class InsertCommand
    implements Control.Command {
        private final boolean confirm;
        private final Consumer<Collection<Entity>> onInsert;

        private InsertCommand(DefaultInsertCommandBuilder builder) {
            this.confirm = builder.confirm;
            this.onInsert = builder.onInsert;
        }

        public void execute() throws ValidationException {
            block3: {
                block2: {
                    if (!this.confirm) break block2;
                    if (!EntityEditPanel.this.confirmInsert()) break block3;
                }
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Insert.Task)EntityEditPanel.this.editModel().createInsert().prepare()).perform()).title(MESSAGES.getString("inserting"))).owner((Component)EntityEditPanel.this)).onResult(this::handleResult).onException(this::onException).execute();
            }
        }

        private void handleResult(EntityEditModel.Insert.Result result) {
            this.onInsert.accept(result.handle());
            if (EntityEditPanel.this.configuration.clearAfterInsert) {
                EntityEditPanel.this.editModel().defaults();
            }
            if (EntityEditPanel.this.configuration.requestFocusAfterInsert) {
                EntityEditPanel.this.requestAfterInsertFocus();
            }
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityEditPanel.this.onException(exception);
        }
    }
}

