/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.resource.MessageBundle;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.text.TextFieldPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.ActionDialogBuilder;
import is.codion.swing.common.ui.dialog.DialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponents;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityDialogs {
    private static final MessageBundle EDIT_PANEL_MESSAGES = MessageBundle.messageBundle(EntityEditPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityEditPanel.class.getName()));
    private static final Consumer<?> EMPTY_CONSUMER = value -> {};

    private EntityDialogs() {
    }

    public static <T> EditAttributeDialogBuilder<T> editAttributeDialog(SwingEntityEditModel editModel, Attribute<T> attribute) {
        return new DefaultEditAttributeDialogBuilder<T>(editModel, attribute);
    }

    public static AddEntityDialogBuilder addEntityDialog(Supplier<EntityEditPanel> editPanel) {
        return new DefaultAddEntityDialogBuilder(editPanel);
    }

    public static EditEntityDialogBuilder editEntityDialog(Supplier<EntityEditPanel> editPanel) {
        return new DefaultEditEntityDialogBuilder(editPanel);
    }

    public static SelectionDialogBuilder selectionDialog(SwingEntityTableModel tableModel) {
        return new DefaultSelectionDialogBuilder(tableModel);
    }

    private static Control createCancelControl(Runnable disposeDialog) {
        return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command((Control.Command)new RunnableCommand(disposeDialog)).name(Messages.cancel())).mnemonic((int)Messages.cancelMnemonic())).build();
    }

    private static <T> Consumer<T> emptyConsumer() {
        return EMPTY_CONSUMER;
    }

    private static final class DefaultEditAttributeDialogBuilder<T>
    extends AbstractDialogBuilder<EditAttributeDialogBuilder<T>>
    implements EditAttributeDialogBuilder<T> {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultEditAttributeDialogBuilder.class);
        private final SwingEntityEditModel editModel;
        private final Attribute<T> attribute;
        private EntityComponentFactory<T, Attribute<T>, ?> componentFactory = new EditEntityComponentFactory();
        private Consumer<ValidationException> onValidationException = new DefaultValidationExceptionHandler();
        private Consumer<Exception> onException = new DefaultExceptionHandler();
        private EditAttributeDialogBuilder.Updater<SwingEntityEditModel> updater;

        private DefaultEditAttributeDialogBuilder(SwingEntityEditModel editModel, Attribute<T> attribute) {
            this.editModel = Objects.requireNonNull(editModel);
            this.attribute = Objects.requireNonNull(attribute);
        }

        @Override
        public EditAttributeDialogBuilder<T> componentFactory(EntityComponentFactory<T, Attribute<T>, ?> componentFactory) {
            this.componentFactory = componentFactory == null ? new EditEntityComponentFactory() : componentFactory;
            return this;
        }

        @Override
        public EditAttributeDialogBuilder<T> onValidationException(Consumer<ValidationException> onValidationException) {
            this.onValidationException = Objects.requireNonNull(onValidationException);
            return this;
        }

        @Override
        public EditAttributeDialogBuilder<T> onException(Consumer<Exception> onException) {
            this.onException = Objects.requireNonNull(onException);
            return this;
        }

        @Override
        public <E extends SwingEntityEditModel> EditAttributeDialogBuilder<T> updater(EditAttributeDialogBuilder.Updater<E> updater) {
            this.updater = Objects.requireNonNull(updater);
            return this;
        }

        @Override
        public void edit(Entity entity) {
            this.edit(Collections.singleton(Objects.requireNonNull(entity)));
        }

        @Override
        public void edit(Collection<Entity> entities) {
            Set entityTypes = Objects.requireNonNull(entities).stream().map(Entity::entityType).collect(Collectors.toSet());
            if (entityTypes.isEmpty()) {
                return;
            }
            if (entityTypes.size() > 1) {
                throw new IllegalArgumentException("All entities must be of the same type when editing");
            }
            EntityDefinition entityDefinition = this.editModel.entityDefinition();
            AttributeDefinition attributeDefinition = entityDefinition.attributes().definition(this.attribute);
            Collection selectedEntities = entities.stream().map(Entity::copy).collect(Collectors.toList());
            Collection values = entities.stream().map(entity -> entity.get(this.attribute)).collect(Collectors.toSet());
            T initialValue = values.size() == 1 ? (T)values.iterator().next() : null;
            ComponentValue<Object, JComponent> componentValue = this.editSelectedComponentValue(this.attribute, initialValue);
            InputValidator<Object> validator = new InputValidator<Object>(entityDefinition, this.attribute, componentValue);
            if (this.updater == null) {
                this.updater = new DefaultUpdater(this.owner, this.locationRelativeTo, this.onException);
            }
            boolean updatePerformed = false;
            while (!updatePerformed) {
                Object newValue = ((InputDialogBuilder)((InputDialogBuilder)((InputDialogBuilder)Dialogs.inputDialog(componentValue).owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).title(FrameworkMessages.edit())).caption(attributeDefinition.caption()).validator(validator).show();
                selectedEntities.forEach(entity -> entity.put(this.attribute, newValue));
                updatePerformed = this.update(selectedEntities.stream().filter(Entity::modified).collect(Collectors.toList()));
            }
        }

        private ComponentValue<T, ? extends JComponent> editSelectedComponentValue(Attribute<T> attribute, T initialValue) {
            if (this.componentFactory == null) {
                EditEntityComponentFactory entityComponentFactory = new EditEntityComponentFactory();
                return entityComponentFactory.componentValue(attribute, this.editModel, initialValue);
            }
            return this.componentFactory.componentValue(attribute, this.editModel, initialValue);
        }

        private boolean update(Collection<Entity> entities) {
            try {
                this.updater.update(this.editModel, entities);
                return true;
            }
            catch (CancelException cancelException) {
            }
            catch (ValidationException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                this.onValidationException.accept(e);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.onException.accept(e);
            }
            return false;
        }

        private final class DefaultValidationExceptionHandler
        implements Consumer<ValidationException> {
            private DefaultValidationExceptionHandler() {
            }

            @Override
            public void accept(ValidationException exception) {
                Objects.requireNonNull(exception);
                String title = DefaultEditAttributeDialogBuilder.this.editModel.entityDefinition().attributes().definition(exception.attribute()).caption();
                JOptionPane.showMessageDialog(DefaultEditAttributeDialogBuilder.this.locationRelativeTo == null ? DefaultEditAttributeDialogBuilder.this.owner : DefaultEditAttributeDialogBuilder.this.locationRelativeTo, exception.getMessage(), title, 0);
            }
        }

        private final class DefaultExceptionHandler
        implements Consumer<Exception> {
            private DefaultExceptionHandler() {
            }

            @Override
            public void accept(Exception exception) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    focusOwner = DefaultEditAttributeDialogBuilder.this.owner;
                }
                Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
            }
        }

        private static final class InputValidator<T>
        implements Predicate<T> {
            private final EntityDefinition entityDefinition;
            private final Attribute<T> attribute;
            private final ComponentValue<T, ?> componentValue;

            private InputValidator(EntityDefinition entityDefinition, Attribute<T> attribute, ComponentValue<T, ?> componentValue) {
                this.entityDefinition = entityDefinition;
                this.attribute = attribute;
                this.componentValue = componentValue;
            }

            @Override
            public boolean test(T value) {
                Entity entity = this.entityDefinition.entity();
                entity.put(this.attribute, value);
                try {
                    this.entityDefinition.validator().validate(entity, this.attribute);
                    this.componentValue.validate(value);
                    return true;
                }
                catch (ValidationException | IllegalArgumentException e) {
                    return false;
                }
            }
        }

        private static final class DefaultUpdater
        implements EditAttributeDialogBuilder.Updater<SwingEntityEditModel> {
            private final Window dialogOwner;
            private final Component locationRelativeTo;
            private final Consumer<Exception> exceptionHandler;

            private DefaultUpdater(Window dialogOwner, Component locationRelativeTo, Consumer<Exception> exceptionHandler) {
                this.dialogOwner = dialogOwner;
                this.locationRelativeTo = locationRelativeTo;
                this.exceptionHandler = exceptionHandler;
            }

            @Override
            public void update(SwingEntityEditModel editModel, Collection<Entity> entities) throws ValidationException {
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Update.Task)editModel.createUpdate(entities).prepare()).perform()).title(EDIT_PANEL_MESSAGES.getString("updating"))).owner(this.dialogOwner)).locationRelativeTo(this.locationRelativeTo)).onException(this.exceptionHandler).onResult(EntityEditModel.Update.Result::handle).execute();
            }
        }
    }

    private static final class DefaultAddEntityDialogBuilder
    extends AbstractDialogBuilder<AddEntityDialogBuilder>
    implements AddEntityDialogBuilder {
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private Consumer<Entity> onInsert = EntityDialogs.emptyConsumer();
        private boolean closeDialog = true;
        private boolean confirm = false;

        private DefaultAddEntityDialogBuilder(Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = Objects.requireNonNull(editPanelSupplier);
        }

        @Override
        public AddEntityDialogBuilder onInsert(Consumer<Entity> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return this;
        }

        @Override
        public AddEntityDialogBuilder closeDialog(boolean closeDialog) {
            this.closeDialog = closeDialog;
            return this;
        }

        @Override
        public AddEntityDialogBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public void show() {
            EntityEditPanel editPanel = this.editPanelSupplier.get().initialize();
            Object editModel = editPanel.editModel();
            DisposeDialog disposeDialog = new DisposeDialog(editPanel);
            ((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)Dialogs.actionDialog((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)editPanel).border(Borders.emptyBorder())).build()).owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).defaultAction((Action)DefaultAddEntityDialogBuilder.createAddControl(editPanel, new InsertConsumer(disposeDialog), this.confirm)).escapeAction((Action)EntityDialogs.createCancelControl(disposeDialog)).title(FrameworkMessages.add() + " - " + editModel.entities().definition(editModel.entityType()).caption())).onShown((Consumer)new ClearAndRequestFocus(editPanel)).show();
        }

        private static Control createAddControl(EntityEditPanel editPanel, Consumer<Collection<Entity>> onInsert, boolean confirm) {
            return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(editPanel.insertCommand().confirm(confirm).onInsert(onInsert).build()).name(FrameworkMessages.add())).mnemonic((int)FrameworkMessages.addMnemonic())).onException((Consumer)new EditPanelExceptionHandler(editPanel)).build();
        }

        private final class InsertConsumer
        implements Consumer<Collection<Entity>> {
            private final Runnable disposeDialog;

            private InsertConsumer(Runnable disposeDialog) {
                this.disposeDialog = disposeDialog;
            }

            @Override
            public void accept(Collection<Entity> inserted) {
                DefaultAddEntityDialogBuilder.this.onInsert.accept(inserted.iterator().next());
                if (DefaultAddEntityDialogBuilder.this.closeDialog) {
                    this.disposeDialog.run();
                }
            }
        }
    }

    private static final class DefaultEditEntityDialogBuilder
    extends AbstractDialogBuilder<EditEntityDialogBuilder>
    implements EditEntityDialogBuilder {
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private Supplier<Entity> entity;
        private Consumer<Entity> onUpdate = EntityDialogs.emptyConsumer();
        private boolean confirm = false;

        private DefaultEditEntityDialogBuilder(Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = Objects.requireNonNull(editPanelSupplier);
        }

        @Override
        public EditEntityDialogBuilder entity(Supplier<Entity> entity) {
            this.entity = Objects.requireNonNull(entity);
            return this;
        }

        @Override
        public EditEntityDialogBuilder onUpdate(Consumer<Entity> onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate);
            return this;
        }

        @Override
        public EditEntityDialogBuilder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        @Override
        public void show() {
            EntityEditPanel editPanel = this.editPanelSupplier.get().initialize();
            Object editModel = editPanel.editModel();
            this.initializeEditModel((SwingEntityEditModel)editModel);
            DisposeDialog disposeDialog = new DisposeDialog(editPanel);
            ((ActionDialogBuilder)((ActionDialogBuilder)((ActionDialogBuilder)Dialogs.actionDialog((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)editPanel).border(Borders.emptyBorder())).build()).owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).defaultAction((Action)DefaultEditEntityDialogBuilder.createUpdateControl(editPanel, new UpdateConsumer(disposeDialog), this.confirm)).escapeAction((Action)EntityDialogs.createCancelControl(disposeDialog)).title(FrameworkMessages.edit() + " - " + editModel.entities().definition(editModel.entityType()).caption())).onShown((Consumer)new RequestFocus(editPanel)).show();
        }

        private void initializeEditModel(SwingEntityEditModel editModel) {
            if (this.entity != null) {
                editModel.set(this.entity.get());
            } else {
                editModel.revert();
            }
        }

        private static Control createUpdateControl(EntityEditPanel editPanel, Consumer<Collection<Entity>> onUpdate, boolean confirm) {
            return ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(editPanel.updateCommand().confirm(confirm).onUpdate(onUpdate).build()).name(FrameworkMessages.update())).mnemonic((int)FrameworkMessages.updateMnemonic())).onException((Consumer)new EditPanelExceptionHandler(editPanel)).enabled(editPanel.editModel().modified())).build();
        }

        private final class UpdateConsumer
        implements Consumer<Collection<Entity>> {
            private final Runnable disposeDialog;

            private UpdateConsumer(Runnable disposeDialog) {
                this.disposeDialog = disposeDialog;
            }

            @Override
            public void accept(Collection<Entity> updated) {
                DefaultEditEntityDialogBuilder.this.onUpdate.accept(updated.iterator().next());
                this.disposeDialog.run();
            }
        }
    }

    private static final class DefaultSelectionDialogBuilder
    extends AbstractDialogBuilder<SelectionDialogBuilder>
    implements SelectionDialogBuilder {
        private final SwingEntityTableModel tableModel;
        private Dimension preferredSize;

        private DefaultSelectionDialogBuilder(SwingEntityTableModel tableModel) {
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        @Override
        public SelectionDialogBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize = Objects.requireNonNull(preferredSize);
            return this;
        }

        @Override
        public List<Entity> select() {
            return new EntitySelectionDialog(this.tableModel, this.owner, this.locationRelativeTo, (ValueObserver<String>)this.title, this.icon, this.preferredSize, false).selectEntities();
        }

        @Override
        public Optional<Entity> selectSingle() {
            List<Entity> entities = new EntitySelectionDialog(this.tableModel, this.owner, this.locationRelativeTo, (ValueObserver<String>)this.title, this.icon, this.preferredSize, true).selectEntities();
            return entities.isEmpty() ? Optional.empty() : Optional.of(entities.get(0));
        }
    }

    private static final class RunnableCommand
    implements Control.Command {
        private final Runnable runnable;

        private RunnableCommand(Runnable runnable) {
            this.runnable = runnable;
        }

        public void execute() throws Exception {
            this.runnable.run();
        }
    }

    private static final class DisposeDialog
    implements Runnable {
        private final EntityEditPanel editPanel;

        private DisposeDialog(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void run() {
            Utilities.parentDialog((Component)this.editPanel).dispose();
        }
    }

    private static final class RequestFocus
    implements Consumer<JDialog> {
        private final EntityEditPanel editPanel;

        private RequestFocus(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void accept(JDialog dialog) {
            this.editPanel.requestInitialFocus();
        }
    }

    private static final class ClearAndRequestFocus
    implements Consumer<JDialog> {
        private final EntityEditPanel editPanel;

        private ClearAndRequestFocus(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void accept(JDialog dialog) {
            this.editPanel.clearAndRequestFocus();
        }
    }

    private static final class EditPanelExceptionHandler
    implements Consumer<Exception> {
        private final EntityEditPanel editPanel;

        private EditPanelExceptionHandler(EntityEditPanel editPanel) {
            this.editPanel = editPanel;
        }

        @Override
        public void accept(Exception exception) {
            this.editPanel.onException(exception);
        }
    }

    private static final class EntitySelectionDialog {
        private final JDialog dialog;
        private final List<Entity> selectedEntities = new ArrayList<Entity>();
        private final SwingEntityTableModel tableModel;
        private final EntityTablePanel entityTablePanel;
        private final Control okControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::ok).name(Messages.ok())).mnemonic((int)Messages.okMnemonic())).build();
        private final Control cancelControl;
        private final Control searchControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this::search).name(FrameworkMessages.searchVerb())).mnemonic((int)FrameworkMessages.searchMnemonic())).build();

        private EntitySelectionDialog(SwingEntityTableModel tableModel, Window owner, Component locationRelativeTo, ValueObserver<String> title, ImageIcon icon, Dimension preferredSize, boolean singleSelection) {
            this.dialog = new JDialog(owner, title == null ? null : (String)title.get());
            if (title != null) {
                title.addConsumer(this.dialog::setTitle);
            }
            if (icon != null) {
                this.dialog.setIconImage(icon.getImage());
            }
            this.dialog.setDefaultCloseOperation(2);
            this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
            this.tableModel.editModel().readOnly().set((Object)true);
            this.entityTablePanel = this.createTablePanel(tableModel, preferredSize, singleSelection);
            this.cancelControl = ((CommandControl.CommandControlBuilder)((CommandControl.CommandControlBuilder)Control.builder().command(this.dialog::dispose).name(Messages.cancel())).mnemonic((int)Messages.cancelMnemonic())).build();
            KeyEvents.builder((int)27).condition(1).action((Action)this.cancelControl).enable(new JComponent[]{this.dialog.getRootPane()});
            JButton okButton = (JButton)Components.button((Control)this.okControl).build();
            JPanel buttonPanel = (JPanel)Components.flowLayoutPanel((int)2).add((JComponent)okButton).add(Components.button((Control)this.cancelControl).build()).add(Components.button((Control)this.searchControl).build()).build();
            this.dialog.getRootPane().setDefaultButton(okButton);
            this.dialog.setLayout(new BorderLayout());
            this.dialog.add((Component)this.entityTablePanel, "Center");
            this.dialog.add((Component)buttonPanel, "South");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(locationRelativeTo);
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
        }

        private EntityTablePanel createTablePanel(SwingEntityTableModel tableModel, Dimension preferredSize, boolean singleSelection) {
            EntityTablePanel tablePanel = new EntityTablePanel(tableModel);
            tablePanel.initialize();
            tablePanel.table().doubleClickEvent().addListener(() -> {
                if (!tableModel.selectionModel().isSelectionEmpty()) {
                    this.okControl.actionPerformed(null);
                }
            });
            tablePanel.conditionPanel().state().set((Object)ColumnConditionPanel.ConditionState.SIMPLE);
            tablePanel.table().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
            tablePanel.table().setSelectionMode(singleSelection ? 0 : 2);
            if (preferredSize != null) {
                tablePanel.setPreferredSize(preferredSize);
            }
            return tablePanel;
        }

        private void ok() {
            this.selectedEntities.addAll(this.tableModel.selectionModel().getSelectedItems());
            this.dialog.dispose();
        }

        private void search() {
            this.tableModel.refresh();
            if (this.tableModel.getRowCount() > 0) {
                this.tableModel.selectionModel().setSelectedIndexes(Collections.singletonList(0));
                this.entityTablePanel.table().requestFocusInWindow();
            } else {
                JOptionPane.showMessageDialog(Utilities.parentWindow((Component)this.entityTablePanel), FrameworkMessages.noSearchResults());
            }
        }

        private List<Entity> selectEntities() {
            this.dialog.setVisible(true);
            return this.selectedEntities;
        }
    }

    private static final class EditEntityComponentFactory<T, A extends Attribute<T>, C extends JComponent>
    extends DefaultEntityComponentFactory<T, A, C> {
        private static final int TEXT_INPUT_PANEL_COLUMNS = 20;

        private EditEntityComponentFactory() {
        }

        @Override
        public ComponentValue<T, C> componentValue(A attribute, SwingEntityEditModel editModel, T initialValue) {
            AttributeDefinition attributeDefinition = editModel.entityDefinition().attributes().definition(attribute);
            if (attributeDefinition.items().isEmpty() && attribute.type().isString()) {
                return ((TextFieldPanel.Builder)EntityComponents.entityComponents(editModel.entityDefinition()).textFieldPanel((Attribute<String>)attribute).initialValue((Object)((String)initialValue))).columns(20).buildValue();
            }
            return super.componentValue(attribute, editModel, initialValue);
        }
    }

    public static interface SelectionDialogBuilder
    extends DialogBuilder<SelectionDialogBuilder> {
        public SelectionDialogBuilder preferredSize(Dimension var1);

        public List<Entity> select();

        public Optional<Entity> selectSingle();
    }

    public static interface EditEntityDialogBuilder
    extends DialogBuilder<EditEntityDialogBuilder> {
        public EditEntityDialogBuilder entity(Supplier<Entity> var1);

        public EditEntityDialogBuilder onUpdate(Consumer<Entity> var1);

        public EditEntityDialogBuilder confirm(boolean var1);

        public void show();
    }

    public static interface AddEntityDialogBuilder
    extends DialogBuilder<AddEntityDialogBuilder> {
        public AddEntityDialogBuilder onInsert(Consumer<Entity> var1);

        public AddEntityDialogBuilder closeDialog(boolean var1);

        public AddEntityDialogBuilder confirm(boolean var1);

        public void show();
    }

    public static interface EditAttributeDialogBuilder<T>
    extends DialogBuilder<EditAttributeDialogBuilder<T>> {
        public EditAttributeDialogBuilder<T> componentFactory(EntityComponentFactory<T, Attribute<T>, ?> var1);

        public EditAttributeDialogBuilder<T> onValidationException(Consumer<ValidationException> var1);

        public EditAttributeDialogBuilder<T> onException(Consumer<Exception> var1);

        public <E extends SwingEntityEditModel> EditAttributeDialogBuilder<T> updater(Updater<E> var1);

        public void edit(Entity var1);

        public void edit(Collection<Entity> var1);

        public static interface Updater<E extends SwingEntityEditModel> {
            public void update(E var1, Collection<Entity> var2) throws ValidationException, DatabaseException;
        }
    }
}

