/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchModel;
import is.codion.framework.model.ForeignKeyConditionModel;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.table.FilterColumnConditionPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.framework.model.SwingForeignKeyConditionModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.component.EntitySearchField;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;

public final class EntityConditionFieldFactory
implements FilterColumnConditionPanel.FieldFactory<Attribute<?>> {
    private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Character.class, String.class, Boolean.class, Short.class, Integer.class, Double.class, BigDecimal.class, Long.class, LocalTime.class, LocalDate.class, LocalDateTime.class, OffsetDateTime.class, Entity.class);
    private final EntityComponents inputComponents;

    public EntityConditionFieldFactory(EntityDefinition entityDefinition) {
        this.inputComponents = EntityComponents.entityComponents(entityDefinition);
    }

    public boolean supportsType(Class<?> columnClass) {
        return SUPPORTED_TYPES.contains(Objects.requireNonNull(columnClass));
    }

    public JComponent createEqualField(ColumnConditionModel<Attribute<?>, ?> conditionModel) {
        if (conditionModel.columnIdentifier() instanceof ForeignKey) {
            return this.createEqualForeignKeyField(conditionModel);
        }
        return this.inputComponents.component((Attribute)conditionModel.columnIdentifier()).link(conditionModel.equalValue()).build();
    }

    public Optional<JComponent> createUpperBoundField(ColumnConditionModel<Attribute<?>, ?> conditionModel) {
        Class columnClass = conditionModel.columnClass();
        if (columnClass.equals(Boolean.class) || columnClass.equals(Entity.class)) {
            return Optional.empty();
        }
        return Optional.of(this.inputComponents.component((Attribute)conditionModel.columnIdentifier()).link(conditionModel.upperBoundValue()).build());
    }

    public Optional<JComponent> createLowerBoundField(ColumnConditionModel<Attribute<?>, ?> conditionModel) {
        Class columnClass = conditionModel.columnClass();
        if (columnClass.equals(Boolean.class) || columnClass.equals(Entity.class)) {
            return Optional.empty();
        }
        return Optional.of(this.inputComponents.component((Attribute)conditionModel.columnIdentifier()).link(conditionModel.lowerBoundValue()).build());
    }

    public JComponent createInField(ColumnConditionModel<Attribute<?>, ?> conditionModel) {
        if (conditionModel.columnIdentifier() instanceof ForeignKey) {
            return this.createInForeignKeyField(conditionModel);
        }
        return Components.listBox((ComponentValue)this.inputComponents.component((Attribute)conditionModel.columnIdentifier()).buildValue(), (ValueSet)conditionModel.inValues()).build();
    }

    private JComponent createEqualForeignKeyField(ColumnConditionModel<? extends Attribute<?>, ?> model) {
        if (model instanceof ForeignKeyConditionModel) {
            EntitySearchModel searchModel = ((ForeignKeyConditionModel)model).equalSearchModel();
            return this.inputComponents.foreignKeySearchField((ForeignKey)model.columnIdentifier(), searchModel).build();
        }
        if (model instanceof SwingForeignKeyConditionModel) {
            EntityComboBoxModel comboBoxModel = ((SwingForeignKeyConditionModel)model).equalComboBoxModel();
            return ((EntityComboBox.Builder)((EntityComboBox.Builder)this.inputComponents.foreignKeyComboBox((ForeignKey)model.columnIdentifier(), comboBoxModel).completionMode(Completion.Mode.MAXIMUM_MATCH)).onSetVisible(comboBox -> comboBoxModel.refresh())).build();
        }
        throw new IllegalArgumentException("Unknown foreign key condition model type: " + model);
    }

    private JComponent createInForeignKeyField(ColumnConditionModel<? extends Attribute<?>, ?> model) {
        if (model instanceof ForeignKeyConditionModel) {
            EntitySearchModel searchModel = ((ForeignKeyConditionModel)model).inSearchModel();
            return EntityConditionFieldFactory.configureSearchField(searchModel, (EntitySearchField)((Object)this.inputComponents.foreignKeySearchField((ForeignKey)model.columnIdentifier(), searchModel).build()));
        }
        if (model instanceof SwingForeignKeyConditionModel) {
            EntitySearchModel searchModel = ((SwingForeignKeyConditionModel)model).inSearchModel();
            return EntityConditionFieldFactory.configureSearchField(searchModel, (EntitySearchField)((Object)this.inputComponents.foreignKeySearchField((ForeignKey)model.columnIdentifier(), searchModel).build()));
        }
        throw new IllegalArgumentException("Unknown foreign key condition model type: " + model);
    }

    private static EntitySearchField configureSearchField(EntitySearchModel searchModel, EntitySearchField searchField) {
        boolean searchable;
        boolean bl = searchable = !searchModel.connectionProvider().entities().definition(searchModel.entityType()).columns().searchable().isEmpty();
        if (!searchable) {
            searchField.setEditable(false);
            searchField.hint().set((Object)"");
        }
        return searchField;
    }
}

