/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.swing.framework.ui.EntityTablePanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONObject;

final class ColumnPreferences {
    private static final String LEGACY_COLUMN_INDEX = "index";
    private static final String LEGACY_COLUMN_WIDTH = "width";
    static final String COLUMNS_KEY = "columns";
    static final String WIDTH_KEY = "w";
    static final String INDEX_KEY = "i";
    private final Attribute<?> attribute;
    private final int index;
    private final int width;

    ColumnPreferences(Attribute<?> attribute, int index, int width) {
        this.attribute = Objects.requireNonNull(attribute);
        this.index = index;
        this.width = width;
    }

    Attribute<?> attribute() {
        return this.attribute;
    }

    int index() {
        return this.index;
    }

    boolean visible() {
        return this.index != -1;
    }

    int width() {
        return this.width;
    }

    JSONObject toJSONObject() {
        JSONObject columnObject = new JSONObject();
        columnObject.put(WIDTH_KEY, this.width());
        columnObject.put(INDEX_KEY, this.index());
        return columnObject;
    }

    static ColumnPreferences columnPreferences(Attribute<?> attribute, int index, int width) {
        return new ColumnPreferences(attribute, index, width);
    }

    static String toString(Map<Attribute<?>, ColumnPreferences> columnPreferences) {
        Objects.requireNonNull(columnPreferences);
        JSONObject jsonColumnPreferences = new JSONObject();
        columnPreferences.forEach((attribute, preferences) -> jsonColumnPreferences.put(attribute.name(), (Object)preferences.toJSONObject()));
        JSONObject preferencesRoot = new JSONObject();
        preferencesRoot.put(COLUMNS_KEY, (Object)jsonColumnPreferences);
        return preferencesRoot.toString();
    }

    static Map<Attribute<?>, ColumnPreferences> fromString(Collection<Attribute<?>> attributes, String preferencesString) {
        Objects.requireNonNull(preferencesString);
        JSONObject jsonObject = new JSONObject(preferencesString).getJSONObject(COLUMNS_KEY);
        return Objects.requireNonNull(attributes).stream().map(attribute -> ColumnPreferences.columnPreferences(attribute, Objects.requireNonNull(jsonObject))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ColumnPreferences::attribute, Function.identity()));
    }

    static void apply(EntityTablePanel tablePanel, Collection<Attribute<?>> columnAttributes, String preferencesString, BiConsumer<Attribute<?>, Integer> setColumnWidth) {
        Objects.requireNonNull(tablePanel);
        Objects.requireNonNull(columnAttributes);
        Objects.requireNonNull(preferencesString);
        Objects.requireNonNull(setColumnWidth);
        Map<Attribute<?>, ColumnPreferences> columnPreferences = ColumnPreferences.fromString(columnAttributes, preferencesString);
        ArrayList columnAttributesWithoutPreferences = new ArrayList();
        for (Attribute<?> attribute : columnAttributes) {
            ColumnPreferences preferences = columnPreferences.get(attribute);
            if (preferences == null) {
                columnAttributesWithoutPreferences.add(attribute);
                continue;
            }
            setColumnWidth.accept(attribute, preferences.width());
        }
        List visibleColumnAttributes = columnPreferences.values().stream().filter(ColumnPreferences::visible).sorted(Comparator.comparingInt(ColumnPreferences::index)).map(ColumnPreferences::attribute).collect(Collectors.toList());
        visibleColumnAttributes.addAll(0, columnAttributesWithoutPreferences);
        tablePanel.table().columnModel().setVisibleColumns(visibleColumnAttributes);
    }

    static Optional<ColumnPreferences> columnPreferences(Attribute<?> attribute, JSONObject preferences) {
        if (preferences.has(attribute.name())) {
            JSONObject jsonObject = preferences.getJSONObject(attribute.name());
            return Optional.of(jsonObject.has(LEGACY_COLUMN_INDEX) ? ColumnPreferences.fromLegacyJSONObject(attribute, jsonObject) : ColumnPreferences.fromJSONObject(attribute, jsonObject));
        }
        return Optional.empty();
    }

    private static ColumnPreferences fromJSONObject(Attribute<?> attribute, JSONObject jsonObject) {
        return new ColumnPreferences(attribute, jsonObject.getInt(INDEX_KEY), jsonObject.getInt(WIDTH_KEY));
    }

    private static ColumnPreferences fromLegacyJSONObject(Attribute<?> attribute, JSONObject jsonObject) {
        return new ColumnPreferences(attribute, jsonObject.getInt(LEGACY_COLUMN_INDEX), jsonObject.getInt(LEGACY_COLUMN_WIDTH));
    }
}

