/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.text.TemporalFieldPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.component.EntitySearchField;
import java.time.temporal.Temporal;
import java.util.Objects;
import javax.swing.JComponent;

public class DefaultEntityComponentFactory<T, A extends Attribute<T>, C extends JComponent>
implements EntityComponentFactory<T, A, C> {
    @Override
    public ComponentValue<T, C> componentValue(A attribute, SwingEntityEditModel editModel, T initialValue) {
        Objects.requireNonNull(attribute, "attribute");
        Objects.requireNonNull(editModel, "editModel");
        EntityComponents inputComponents = EntityComponents.entityComponents(editModel.entityDefinition());
        if (attribute instanceof ForeignKey) {
            return this.createForeignKeyComponentValue((ForeignKey)attribute, editModel, (Entity)initialValue, inputComponents);
        }
        if (attribute.type().isTemporal()) {
            return DefaultEntityComponentFactory.createTemporalComponentValue(attribute, (Temporal)initialValue, inputComponents);
        }
        if (attribute.type().isByteArray()) {
            return Components.fileInputPanel().buildValue();
        }
        return inputComponents.component(attribute).initialValue(initialValue).buildValue();
    }

    private ComponentValue<T, C> createForeignKeyComponentValue(ForeignKey foreignKey, SwingEntityEditModel editModel, Entity initialValue, EntityComponents inputComponents) {
        if (editModel.entities().definition(foreignKey.referencedType()).smallDataset()) {
            return ((EntityComboBox.Builder)((EntityComboBox.Builder)inputComponents.foreignKeyComboBox(foreignKey, editModel.createForeignKeyComboBoxModel(foreignKey)).initialValue(initialValue)).onSetVisible(comboBox -> comboBox.getModel().refresh())).buildValue();
        }
        return ((EntitySearchField.Builder)inputComponents.foreignKeySearchField(foreignKey, editModel.createForeignKeySearchModel(foreignKey)).initialValue(initialValue)).buildValue();
    }

    private static <T, A extends Attribute<T>, C extends JComponent> ComponentValue<T, C> createTemporalComponentValue(A attribute, Temporal initialValue, EntityComponents inputComponents) {
        if (TemporalFieldPanel.supports((Class)attribute.type().valueClass())) {
            return ((TemporalFieldPanel.Builder)inputComponents.temporalFieldPanel(attribute).initialValue((Object)initialValue)).buildValue();
        }
        return ((TemporalField.Builder)inputComponents.temporalField(attribute).initialValue((Object)initialValue)).buildValue();
    }
}

