/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.UserPreferences;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.model.table.TableSummaryModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSelectionModel;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.ColumnSummaryPanel;
import is.codion.swing.common.ui.component.table.FilterColumnConditionPanel;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilterTableCellRendererFactory;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import is.codion.swing.common.ui.component.table.FilterTableColumnComponentPanel;
import is.codion.swing.common.ui.component.table.FilterTableColumnModel;
import is.codion.swing.common.ui.component.table.FilterTableConditionPanel;
import is.codion.swing.common.ui.component.table.TableConditionPanel;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.ColumnPreferences;
import is.codion.swing.framework.ui.ComboBoxEnterPressedAction;
import is.codion.swing.framework.ui.ConditionPreferences;
import is.codion.swing.framework.ui.EntityConditionFieldFactory;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityDialogs;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.EntityTableCellEditor;
import is.codion.swing.framework.ui.EntityTableCellRendererFactory;
import is.codion.swing.framework.ui.EntityTableColumns;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTablePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTablePanel.class);
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(EntityTablePanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityTablePanel.class.getName()));
    private static final MessageBundle EDIT_PANEL_MESSAGES = MessageBundle.messageBundle(EntityEditPanel.class, (ResourceBundle)ResourceBundle.getBundle(EntityEditPanel.class.getName()));
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final String COLUMN_PREFERENCES = "-columns";
    private static final String CONDITIONS_PREFERENCES = "-conditions";
    private static final int FONT_SIZE_TO_ROW_HEIGHT = 4;
    private static final Consumer<Config> NO_CONFIGURATION = c -> {};
    private final State summaryPanelVisibleState = State.state((boolean)((Boolean)Config.SUMMARY_PANEL_VISIBLE.get()));
    private final State orderQueryBySortOrder = State.state((boolean)((Boolean)Config.ORDER_QUERY_BY_SORT_ORDER.get()));
    private final State queryHiddenColumns = State.state((boolean)((Boolean)Config.QUERY_HIDDEN_COLUMNS.get()));
    private final FilterTable<Entity, Attribute<?>> table;
    private final JScrollPane tableScrollPane = new JScrollPane();
    private final TablePanel tablePanel = new TablePanel();
    private final EntityEditPanel editPanel;
    private final Map<EntityTablePanelControl, Value<Control>> controls;
    private final Controls.Config<EntityTablePanelControl> popupMenuConfiguration;
    private final Controls.Config<EntityTablePanelControl> toolBarConfiguration;
    private final SwingEntityTableModel tableModel;
    private final Control conditionRefreshControl;
    private final JToolBar refreshButtonToolBar;
    private final List<Controls> additionalPopupControls = new ArrayList<Controls>();
    private final List<Controls> additionalToolBarControls = new ArrayList<Controls>();
    private TableConditionPanel<Attribute<?>> tableConditionPanel;
    private JScrollPane conditionPanelScrollPane;
    private JScrollPane filterPanelScrollPane;
    private StatusPanel statusPanel;
    private FilterTableColumnComponentPanel<Attribute<?>> summaryPanel;
    private JScrollPane summaryPanelScrollPane;
    final Config configuration;
    private boolean initialized = false;

    public EntityTablePanel(SwingEntityTableModel tableModel) {
        this(tableModel, NO_CONFIGURATION);
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, Consumer<Config> config) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.editPanel = null;
        this.conditionRefreshControl = this.createConditionRefreshControl();
        this.configuration = this.configure(config);
        this.table = (FilterTable)this.configuration.tableBuilder.build();
        this.controls = this.createControls();
        this.refreshButtonToolBar = this.createRefreshButtonToolBar();
        this.popupMenuConfiguration = this.createPopupMenuConfiguration();
        this.toolBarConfiguration = this.createToolBarConfiguration();
        this.bindTableEvents();
        this.applyPreferences();
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityEditPanel editPanel) {
        this(tableModel, editPanel, NO_CONFIGURATION);
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityEditPanel editPanel, Consumer<Config> config) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.editPanel = this.validateEditModel(Objects.requireNonNull(editPanel, "editPanel"));
        this.conditionRefreshControl = this.createConditionRefreshControl();
        this.configuration = this.configure(config);
        this.table = (FilterTable)this.configuration.tableBuilder.build();
        this.controls = this.createControls();
        this.refreshButtonToolBar = this.createRefreshButtonToolBar();
        this.popupMenuConfiguration = this.createPopupMenuConfiguration();
        this.toolBarConfiguration = this.createToolBarConfiguration();
        this.bindTableEvents();
        this.applyPreferences();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.conditionPanelScrollPane, this.filterPanelScrollPane});
        Utilities.updateUI((JComponent[])new JComponent[]{this.tableConditionPanel});
    }

    public final FilterTable<Entity, Attribute<?>> table() {
        if (this.table == null) {
            throw new IllegalStateException("The table is not initialized until after configuration has finished");
        }
        return this.table;
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)this.tableModel;
    }

    public final <T extends TableConditionPanel<Attribute<?>>> T conditionPanel() {
        if (!this.configuration.includeConditionPanel) {
            throw new IllegalStateException("No condition panel is available");
        }
        if (this.tableConditionPanel == null) {
            this.initializeConditionPanel();
        }
        return (T)this.tableConditionPanel;
    }

    public final State summaryPanelVisible() {
        return this.summaryPanelVisibleState;
    }

    public final State orderQueryBySortOrder() {
        return this.orderQueryBySortOrder;
    }

    public final State queryHiddenColumns() {
        return this.queryHiddenColumns;
    }

    public void addPopupMenuControls(Controls additionalPopupMenuControls) {
        this.throwIfInitialized();
        this.additionalPopupControls.add(Objects.requireNonNull(additionalPopupMenuControls));
    }

    public void addToolBarControls(Controls additionalToolBarControls) {
        this.throwIfInitialized();
        this.additionalToolBarControls.add(Objects.requireNonNull(additionalToolBarControls));
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.tableModel.entityType();
    }

    public final Value<Control> control(EntityTablePanelControl control) {
        return this.controls.get((Object)Objects.requireNonNull(control));
    }

    public final void editSelected() {
        List sortedDefinitions = ((Set)this.configuration.editable.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).collect(Collectors.toList());
        ((SelectionDialogBuilder)Dialogs.selectionDialog(sortedDefinitions).owner((Component)this)).selectSingle().map(AttributeDefinition::attribute).ifPresent(this::editSelected);
    }

    public final void editSelected(Attribute<?> attributeToEdit) {
        Objects.requireNonNull(attributeToEdit);
        if (!this.tableModel.selectionModel().isSelectionEmpty()) {
            this.editDialogBuilder(attributeToEdit).edit(this.tableModel.selectionModel().getSelectedItems());
        }
    }

    public final void viewDependencies() {
        if (!this.tableModel.selectionModel().isSelectionEmpty()) {
            EntityDependenciesPanel.displayDependenciesDialog(this.tableModel.selectionModel().getSelectedItems(), this.tableModel.connectionProvider(), this);
        }
    }

    public final boolean deleteSelectedWithConfirmation() {
        if (this.confirmDelete()) {
            return this.deleteSelected();
        }
        return false;
    }

    public final boolean deleteSelected() {
        try {
            this.tableModel.deleteSelected();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public void savePreferences() {
        try {
            UserPreferences.setUserPreference((String)(this.userPreferencesKey() + COLUMN_PREFERENCES), (String)ColumnPreferences.toString(this.createColumnPreferences()));
        }
        catch (Exception e) {
            LOG.error("Error while saving column preferences", (Throwable)e);
        }
        try {
            UserPreferences.setUserPreference((String)(this.userPreferencesKey() + CONDITIONS_PREFERENCES), (String)ConditionPreferences.toString(this.createConditionPreferences()));
        }
        catch (Exception e) {
            LOG.error("Error while saving condition preferences", (Throwable)e);
        }
    }

    public final EntityTablePanel initialize() {
        if (!this.initialized) {
            try {
                this.setupComponents();
                this.setupControls();
                this.setupStandardControls();
                this.addTablePopupMenu();
                this.layoutPanel(this.tablePanel, this.configuration.includeSouthPanel ? this.initializeSouthPanel() : null);
                this.setSummaryPanelVisible((Boolean)this.summaryPanelVisibleState.get());
                this.bindEvents();
                this.setupKeyboardActions();
                Utilities.updateComponentTreeUI((JComponent[])new JComponent[]{this});
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    protected void setupControls() {
    }

    protected JPanel initializeSouthPanel() {
        return new SouthPanel();
    }

    protected void setupKeyboardActions() {
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.REFRESH).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.REFRESH).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.REQUEST_TABLE_FOCUS).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.REQUEST_TABLE_FOCUS).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.SELECT_CONDITION_PANEL).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.SELECT_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.TOGGLE_FILTER_PANEL).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.TOGGLE_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.SELECT_FILTER_PANEL).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.SELECT_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.PRINT).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.PRINT).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).condition(1).action((Action)control).enable(new JComponent[]{this})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.ADD).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.ADD).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.EDIT).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.EDIT).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.EDIT_SELECTED_ATTRIBUTE).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.EDIT_SELECTED_ATTRIBUTE).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.DELETE).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.DELETE).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.MOVE_SELECTION_UP).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.MOVE_SELECTION_UP).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.MOVE_SELECTION_DOWN).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.MOVE_SELECTION_DOWN).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.DISPLAY_ENTITY_MENU).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.DISPLAY_ENTITY_MENU).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
        this.configuration.shortcuts.keyStroke((Enum)EntityTablePanelControl.DISPLAY_POPUP_MENU).optional().ifPresent(keyStroke -> this.control(EntityTablePanelControl.DISPLAY_POPUP_MENU).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{this.table})));
    }

    protected final void configureToolBar(Consumer<Controls.Config<EntityTablePanelControl>> toolBarConfig) {
        this.throwIfInitialized();
        Objects.requireNonNull(toolBarConfig).accept(this.toolBarConfiguration);
    }

    protected final void configurePopupMenu(Consumer<Controls.Config<EntityTablePanelControl>> popupMenuConfig) {
        this.throwIfInitialized();
        Objects.requireNonNull(popupMenuConfig).accept(this.popupMenuConfiguration);
    }

    protected final <T extends EntityEditPanel> T editPanel() {
        if (this.editPanel == null) {
            throw new IllegalStateException("No editPanel is available");
        }
        return (T)this.editPanel;
    }

    protected TableCellEditor createTableCellEditor(Attribute<?> attribute) {
        if (!this.configuration.editable.contains(attribute)) {
            return null;
        }
        if (this.nonUpdatableForeignKey(attribute)) {
            return null;
        }
        return new EntityTableCellEditor(() -> this.cellEditorComponentValue(attribute, null));
    }

    protected void layoutPanel(JComponent tableComponent, JPanel southPanel) {
        Objects.requireNonNull(tableComponent, "tableComponent");
        this.setLayout(new BorderLayout());
        this.add((Component)tableComponent, "Center");
        if (southPanel != null) {
            this.add((Component)southPanel, "South");
        }
    }

    protected void onException(Exception exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)((Object)exception));
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)((Object)exception));
        } else {
            this.displayException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (this.configuration.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            EntityDependenciesPanel.displayDependenciesDialog(this.tableModel.selectionModel().getSelectedItems(), this.tableModel.connectionProvider(), (JComponent)this, EDIT_PANEL_MESSAGES.getString("unknown_dependent_records"));
        } else {
            this.displayException((Exception)((Object)exception));
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.tableModel.entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
    }

    protected <T> EntityDialogs.EditAttributeDialogBuilder<T> editDialogBuilder(Attribute<T> attribute) {
        return ((EntityDialogs.EditAttributeDialogBuilder)EntityDialogs.editAttributeDialog(this.tableModel.editModel(), attribute).owner(this)).componentFactory(this.configuration.editComponentFactories.get(attribute));
    }

    protected String userPreferencesKey() {
        return this.tableModel.getClass().getSimpleName() + "-" + this.tableModel.entityType();
    }

    protected final void displayException(Exception exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    protected final boolean confirmDelete() {
        return this.configuration.deleteConfirmer.confirm(this);
    }

    final void clearPreferences() {
        String userPreferencesKey = this.userPreferencesKey();
        UserPreferences.removeUserPreference((String)(userPreferencesKey + COLUMN_PREFERENCES));
        UserPreferences.removeUserPreference((String)(userPreferencesKey + CONDITIONS_PREFERENCES));
    }

    private Control createAddControl() {
        return Control.builder(() -> ((EntityDialogs.AddEntityDialogBuilder)EntityDialogs.addEntityDialog(() -> this.editPanel).owner(this)).closeDialog(false).show()).name(FrameworkMessages.add()).mnemonic(FrameworkMessages.addMnemonic()).smallIcon((Icon)ICONS.add()).build();
    }

    private Control createEditControl() {
        return Control.builder(() -> ((EntityDialogs.EditEntityDialogBuilder)EntityDialogs.editEntityDialog(() -> this.editPanel).owner(this)).show()).name(FrameworkMessages.edit()).mnemonic(FrameworkMessages.editMnemonic()).smallIcon((Icon)ICONS.edit()).enabled(this.tableModel().selectionModel().singleSelection()).build();
    }

    private Control createEditSelectedAttributeControl() {
        return Control.builder(this::editSelected).name(FrameworkMessages.edit()).enabled(this.createEditSelectedEnabledObserver()).smallIcon((Icon)ICONS.edit()).description(FrameworkMessages.editSelectedTip()).build();
    }

    private Controls createEditAttributeControls() {
        StateObserver editSelectedEnabledObserver = this.createEditSelectedEnabledObserver();
        Controls editControls = (Controls)((Controls.Builder)((Controls.Builder)((Controls.Builder)((Controls.Builder)Controls.builder().name(FrameworkMessages.edit())).enabled(editSelectedEnabledObserver)).smallIcon((Icon)ICONS.edit())).description(FrameworkMessages.editSelectedTip())).build();
        ((Set)this.configuration.editable.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).forEach(attributeDefinition -> editControls.add((Action)Control.builder(() -> this.editSelected(attributeDefinition.attribute())).name(attributeDefinition.caption() == null ? attributeDefinition.attribute().name() : attributeDefinition.caption()).enabled(editSelectedEnabledObserver).build()));
        return editControls.empty() ? null : editControls;
    }

    private StateObserver createEditSelectedEnabledObserver() {
        StateObserver selectionNotEmpty = this.tableModel.selectionModel().selectionNotEmpty();
        State updateEnabled = this.tableModel.editModel().updateEnabled();
        State.Combination updateMultipleEnabledOrSingleSelection = State.or((StateObserver[])new StateObserver[]{this.tableModel.editModel().updateMultipleEnabled(), this.tableModel.selectionModel().singleSelection()});
        return State.and((StateObserver[])new StateObserver[]{selectionNotEmpty, updateEnabled, updateMultipleEnabledOrSingleSelection});
    }

    private Control createViewDependenciesControl() {
        return Control.builder(this::viewDependencies).name(FrameworkMessages.dependencies()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).description(FrameworkMessages.dependenciesTip()).smallIcon((Icon)ICONS.dependencies()).build();
    }

    private Control createDeleteControl() {
        return Control.builder((Control.Command)new DeleteCommand()).name(FrameworkMessages.delete()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.tableModel.editModel().deleteEnabled(), this.tableModel.selectionModel().selectionNotEmpty()})).description(FrameworkMessages.deleteSelectedTip()).smallIcon((Icon)ICONS.delete()).build();
    }

    private Control createRefreshControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).refresh()).name(Messages.refresh()).description(Messages.refreshTip()).mnemonic(Messages.refreshMnemonic()).smallIcon((Icon)ICONS.refresh()).enabled(this.tableModel.refresher().observer().not()).build();
    }

    private Control createColumnSelectionControl() {
        return this.configuration.columnSelection == ColumnSelection.DIALOG ? this.table.createSelectColumnsControl() : this.table.createToggleColumnsControls();
    }

    private Control createClearControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).clear()).name(Messages.clear()).description(Messages.clearTip()).mnemonic(Messages.clearMnemonic()).smallIcon((Icon)ICONS.clear()).build();
    }

    private Controls createPrintControls() {
        Controls.Builder builder = (Controls.Builder)((Controls.Builder)((Controls.Builder)Controls.builder().name(Messages.print())).mnemonic(Messages.printMnemonic())).smallIcon((Icon)ICONS.print());
        this.control(EntityTablePanelControl.PRINT).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        Controls printControls = (Controls)builder.build();
        return printControls.empty() ? null : printControls;
    }

    private Controls createAdditionalPopupControls() {
        Controls additionalControls = Controls.controls();
        this.additionalPopupControls.forEach(controlList -> {
            if (Text.nullOrEmpty((String)controlList.getName())) {
                additionalControls.addAll(controlList);
            } else {
                additionalControls.add(controlList);
            }
        });
        return additionalControls.empty() ? null : additionalControls;
    }

    private Controls createAdditionalToolbarControls() {
        Controls additionalControls = Controls.controls();
        this.additionalToolBarControls.forEach(controlsList -> {
            if (Text.nullOrEmpty((String)controlsList.getName())) {
                additionalControls.addAll(controlsList);
            } else {
                additionalControls.add(controlsList);
            }
        });
        return additionalControls.empty() ? null : additionalControls;
    }

    private Control createToggleConditionPanelControl() {
        return Control.builder(this::toggleConditionPanel).smallIcon((Icon)ICONS.search()).description(MESSAGES.getString("show_condition_panel")).build();
    }

    private Control createSelectConditionPanelControl() {
        return Control.control(() -> this.conditionPanel().selectConditionPanel((JComponent)this));
    }

    private Controls createConditionControls() {
        if (!this.configuration.includeConditionPanel || this.tableConditionPanel == null) {
            return null;
        }
        Controls conditionControls = (Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(FrameworkMessages.searchNoun())).smallIcon((Icon)ICONS.search())).build();
        Controls conditionPanelControls = this.tableConditionPanel.controls();
        if (conditionPanelControls.notEmpty()) {
            conditionControls.addAll(conditionPanelControls);
            conditionControls.addSeparator();
        }
        conditionControls.add((Action)ToggleControl.builder((State)this.tableModel.conditionRequired()).name(MESSAGES.getString("require_query_condition")).description(MESSAGES.getString("require_query_condition_description")).build());
        return conditionControls.empty() ? null : conditionControls;
    }

    private Control createToggleFilterPanelControl() {
        return Control.builder(this::toggleFilterPanel).smallIcon((Icon)ICONS.filter()).description(MESSAGES.getString("show_filter_panel")).build();
    }

    private Control createSelectFilterPanelControl() {
        return Control.control(() -> this.table.filterPanel().selectConditionPanel((JComponent)this));
    }

    private void toggleConditionPanel() {
        Value conditionState = this.conditionPanel().state();
        switch ((ColumnConditionPanel.ConditionState)conditionState.get()) {
            case HIDDEN: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.SIMPLE);
                break;
            }
            case SIMPLE: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.ADVANCED);
                break;
            }
            case ADVANCED: {
                this.setConditionStateAdvance(this.conditionPanelScrollPane, (Value<ColumnConditionPanel.ConditionState>)conditionState);
            }
        }
    }

    private void toggleFilterPanel() {
        Value conditionState = this.table.filterPanel().state();
        switch ((ColumnConditionPanel.ConditionState)conditionState.get()) {
            case HIDDEN: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.SIMPLE);
                break;
            }
            case SIMPLE: {
                conditionState.set((Object)ColumnConditionPanel.ConditionState.ADVANCED);
                break;
            }
            case ADVANCED: {
                this.setConditionStateAdvance(this.filterPanelScrollPane, (Value<ColumnConditionPanel.ConditionState>)conditionState);
            }
        }
    }

    private Controls createFilterControls() {
        if (!this.configuration.includeFilterPanel) {
            return null;
        }
        Controls filterControls = (Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(FrameworkMessages.filterNoun())).smallIcon((Icon)ICONS.filter())).build();
        Controls filterPanelControls = this.table.filterPanel().controls();
        if (filterPanelControls.notEmpty()) {
            filterControls.addAll(filterPanelControls);
        }
        return filterControls.empty() ? null : filterControls;
    }

    private Control createToggleSummaryPanelControl() {
        return ToggleControl.builder((State)this.summaryPanelVisibleState).smallIcon((Icon)ICONS.summary()).description(MESSAGES.getString("toggle_summary_tip")).build();
    }

    private Control createClearSelectionControl() {
        return Control.builder(() -> this.tableModel.selectionModel().clearSelection()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).smallIcon((Icon)ICONS.clearSelection()).description(MESSAGES.getString("clear_selection_tip")).build();
    }

    private Control createMoveSelectionDownControl() {
        return Control.builder(() -> ((FilterTableSelectionModel)this.tableModel.selectionModel()).moveSelectionDown()).smallIcon((Icon)ICONS.down()).description(MESSAGES.getString("selection_down_tip")).build();
    }

    private Control createMoveSelectionUpControl() {
        return Control.builder(() -> ((FilterTableSelectionModel)this.tableModel.selectionModel()).moveSelectionUp()).smallIcon((Icon)ICONS.up()).description(MESSAGES.getString("selection_up_tip")).build();
    }

    private Control createRequestTableFocusControl() {
        return Control.control(() -> this.table.requestFocus());
    }

    private Control createRequestSearchFieldFocusControl() {
        return Control.control(this.table.searchField()::requestFocusInWindow);
    }

    private Controls createColumnControls() {
        Controls.Builder builder = (Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString("columns"))).smallIcon((Icon)ICONS.columns());
        this.control(EntityTablePanelControl.SELECT_COLUMNS).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(EntityTablePanelControl.RESET_COLUMNS).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(EntityTablePanelControl.COLUMN_AUTO_RESIZE_MODE).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        Controls columnControls = (Controls)builder.build();
        return columnControls.empty() ? null : columnControls;
    }

    private Controls createCopyControls() {
        Controls.Builder builder = (Controls.Builder)((Controls.Builder)Controls.builder().name(Messages.copy())).smallIcon((Icon)ICONS.copy());
        this.control(EntityTablePanelControl.COPY_CELL).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(EntityTablePanelControl.COPY_ROWS).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        Controls copyControls = (Controls)builder.build();
        return copyControls.empty() ? null : copyControls;
    }

    private Control createCopyRowsControl() {
        return Control.builder(() -> this.table.copyToClipboard()).name(FrameworkMessages.copyTableWithHeader()).build();
    }

    private boolean includeAddControl() {
        return this.editPanel != null && this.configuration.includeAddControl && (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().insertEnabled().get() != false;
    }

    private boolean includeEditControl() {
        return this.editPanel != null && this.updatable() && this.configuration.includeEditControl;
    }

    private boolean includeEditAttributeControls() {
        return !this.configuration.editable.empty() && this.updatable() && this.configuration.includeEditAttributeControl;
    }

    private boolean updatable() {
        return (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().updateEnabled().get() != false;
    }

    private boolean includeDeleteControl() {
        return (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().deleteEnabled().get() != false;
    }

    private Control createConditionRefreshControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).refresh()).enabled(this.tableModel.conditionChanged()).smallIcon((Icon)ICONS.refreshRequired()).build();
    }

    private <T> ComponentValue<T, ? extends JComponent> cellEditorComponentValue(Attribute<T> attribute, T initialValue) {
        return this.configuration.cellEditorComponentFactories.computeIfAbsent(attribute, a -> new DefaultEntityComponentFactory()).componentValue(attribute, this.tableModel.editModel(), initialValue);
    }

    private JToolBar createRefreshButtonToolBar() {
        KeyEvents.builder((int)116).condition(1).action((Action)this.conditionRefreshControl).enable(new JComponent[]{this});
        return (JToolBar)((ToolBarBuilder)((ToolBarBuilder)Components.toolBar().action((Action)this.conditionRefreshControl)).floatable(false).rollover(false).visible(this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || this.tableConditionPanel != null && this.tableConditionPanel.state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN))).build();
    }

    private Collection<ColumnConditionPanel<Attribute<?>, ?>> createConditionPanels() {
        return this.tableModel.conditionModel().conditionModels().values().stream().filter(conditionModel -> this.table.columnModel().containsColumn((Object)((Attribute)conditionModel.columnIdentifier()))).filter(conditionModel -> this.configuration.conditionFieldFactory.supportsType(conditionModel.columnClass())).map(this::createConditionPanel).collect(Collectors.toList());
    }

    private FilterColumnConditionPanel<Attribute<?>, ?> createConditionPanel(ColumnConditionModel<Attribute<?>, ?> conditionModel) {
        FilterColumnConditionPanel conditionPanel = FilterColumnConditionPanel.filterColumnConditionPanel(conditionModel, (String)Objects.toString(this.table.columnModel().column((Object)((Attribute)conditionModel.columnIdentifier())).getHeaderValue()), this.configuration.conditionFieldFactory);
        this.configureConditionPanel(conditionPanel);
        return conditionPanel;
    }

    private void configureConditionPanel(FilterColumnConditionPanel<Attribute<?>, ?> conditionPanel) {
        conditionPanel.components().forEach(component -> this.configureConditionComponent((JComponent)component, (Attribute<?>)((Attribute)conditionPanel.conditionModel().columnIdentifier())));
    }

    private void configureConditionComponent(JComponent component, Attribute<?> attribute) {
        TableCellRenderer cellRenderer = this.table.columnModel().column(attribute).getCellRenderer();
        if (cellRenderer instanceof DefaultTableCellRenderer && component instanceof JTextField) {
            ((JTextField)component).setHorizontalAlignment(((DefaultTableCellRenderer)cellRenderer).getHorizontalAlignment());
        } else if (component instanceof JCheckBox) {
            ((JCheckBox)component).setHorizontalAlignment(0);
        }
    }

    private TableConditionPanel<Attribute<?>> createConditionPanel() {
        if (this.configuration.includeConditionPanel) {
            return this.configuration.tableConditionPanelFactory.create((TableConditionModel)this.tableModel.conditionModel(), this.createConditionPanels(), this.table.getColumnModel());
        }
        return null;
    }

    private void bindTableEvents() {
        Runnable setSelectAttributes = () -> this.tableModel.attributes().set(this.selectAttributes());
        this.table.columnModel().columnShownEvent().addListener(setSelectAttributes);
        this.table.columnModel().columnHiddenEvent().addListener(setSelectAttributes);
        this.table.columnModel().columnHiddenEvent().addConsumer(this::onColumnHidden);
        this.queryHiddenColumns.addListener(setSelectAttributes);
        this.orderQueryBySortOrder.addConsumer(enabled -> this.tableModel.orderBy().set((Object)(enabled != false ? this.orderByFromSortModel() : null)));
        this.table.sortModel().sortingChangedEvent().addListener(() -> this.tableModel.orderBy().set((Object)((Boolean)this.orderQueryBySortOrder.get() != false ? this.orderByFromSortModel() : null)));
    }

    private void bindEvents() {
        this.summaryPanelVisibleState.addConsumer(this::setSummaryPanelVisible);
        this.tableModel.conditionModel().conditionChangedEvent().addListener(this::onConditionChanged);
        this.tableModel.refresher().observer().addConsumer(this::onRefreshingChanged);
        this.tableModel.refresher().refreshFailedEvent().addConsumer(this::onException);
        this.tableModel.editModel().insertUpdateOrDeleteEvent().addListener(() -> this.table.repaint());
        if (this.configuration.includeFilterPanel) {
            this.table.filterPanel().conditionPanels().forEach(conditionPanel -> conditionPanel.focusGainedEvent().ifPresent(focusGainedEvent -> focusGainedEvent.addConsumer((Consumer)new ScrollToColumn())));
        }
    }

    private void initializeConditionPanel() {
        this.tableConditionPanel = this.createConditionPanel();
        this.conditionPanelScrollPane = this.createLinkedScrollPane((JComponent)this.tableConditionPanel);
        this.tableConditionPanel.conditionPanels().forEach(conditionPanel -> conditionPanel.focusGainedEvent().ifPresent(focusGainedEvent -> focusGainedEvent.addConsumer((Consumer)new ScrollToColumn())));
        this.tableConditionPanel.state().addConsumer(this.tablePanel::conditionPanelStateChanged);
        if (this.tableConditionPanel.state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN)) {
            this.tablePanel.add((Component)this.conditionPanelScrollPane, "North");
        }
        this.refreshButtonToolBar.setVisible(this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || this.tableConditionPanel.state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN));
        KeyEvents.builder((int)10).condition(1).action((Action)this.conditionRefreshControl).enable(new JComponent[]{this.tableConditionPanel});
        this.tableConditionPanel.conditionPanels().stream().flatMap(panel -> panel.components().stream()).forEach(this::enableConditionPanelRefreshOnEnter);
    }

    private void enableConditionPanelRefreshOnEnter(JComponent component) {
        if (component instanceof JComboBox) {
            new ComboBoxEnterPressedAction((JComboBox)component, (Action)this.conditionRefreshControl);
        } else if (component instanceof TemporalField) {
            ((TemporalField)component).addActionListener((ActionListener)this.conditionRefreshControl);
        }
    }

    private void setSummaryPanelVisible(boolean visible) {
        if (this.summaryPanelScrollPane != null) {
            this.summaryPanelScrollPane.setVisible(visible);
            this.revalidate();
        }
    }

    private void setupComponents() {
        this.tableScrollPane.setViewportView((Component)this.table());
        this.tablePanel.initialize();
        this.table.getColumnModel().columns().forEach(this::configureColumn);
        this.summaryPanelVisibleState.addValidator((Value.Validator)new ComponentAvailableValidator((JComponent)this.summaryPanel, "summary"));
    }

    private Map<EntityTablePanelControl, Value<Control>> createControls() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("Controls must be configured before the panel is initialized");
            }
        };
        Map controlMap = Stream.of(EntityTablePanelControl.values()).collect(Collectors.toMap(Function.identity(), controlCode -> Value.nullable().validator(controlValueValidator).build()));
        if (this.includeDeleteControl()) {
            controlMap.get((Object)EntityTablePanelControl.DELETE).set((Object)this.createDeleteControl());
        }
        if (this.includeAddControl()) {
            controlMap.get((Object)EntityTablePanelControl.ADD).set((Object)this.createAddControl());
        }
        if (this.includeEditControl()) {
            controlMap.get((Object)EntityTablePanelControl.EDIT).set((Object)this.createEditControl());
        }
        if (this.includeEditAttributeControls()) {
            controlMap.get((Object)EntityTablePanelControl.EDIT_ATTRIBUTE_CONTROLS).set((Object)this.createEditAttributeControls());
            controlMap.get((Object)EntityTablePanelControl.EDIT_SELECTED_ATTRIBUTE).set((Object)this.createEditSelectedAttributeControl());
        }
        if (this.configuration.includeClearControl) {
            controlMap.get((Object)EntityTablePanelControl.CLEAR).set((Object)this.createClearControl());
        }
        controlMap.get((Object)EntityTablePanelControl.REFRESH).set((Object)this.createRefreshControl());
        controlMap.get((Object)EntityTablePanelControl.SELECT_COLUMNS).set((Object)this.createColumnSelectionControl());
        controlMap.get((Object)EntityTablePanelControl.RESET_COLUMNS).set((Object)this.table.createResetColumnsControl());
        controlMap.get((Object)EntityTablePanelControl.COLUMN_AUTO_RESIZE_MODE).set((Object)this.table.createAutoResizeModeControl());
        if (this.includeViewDependenciesControl()) {
            controlMap.get((Object)EntityTablePanelControl.VIEW_DEPENDENCIES).set((Object)this.createViewDependenciesControl());
        }
        if (this.configuration.includeSummaryPanel) {
            controlMap.get((Object)EntityTablePanelControl.TOGGLE_SUMMARY_PANEL).set((Object)this.createToggleSummaryPanelControl());
        }
        if (this.configuration.includeConditionPanel) {
            controlMap.get((Object)EntityTablePanelControl.TOGGLE_CONDITION_PANEL).set((Object)this.createToggleConditionPanelControl());
            controlMap.get((Object)EntityTablePanelControl.SELECT_CONDITION_PANEL).set((Object)this.createSelectConditionPanelControl());
        }
        if (this.configuration.includeFilterPanel) {
            controlMap.get((Object)EntityTablePanelControl.TOGGLE_FILTER_PANEL).set((Object)this.createToggleFilterPanelControl());
            controlMap.get((Object)EntityTablePanelControl.SELECT_FILTER_PANEL).set((Object)this.createSelectFilterPanelControl());
        }
        controlMap.get((Object)EntityTablePanelControl.CLEAR_SELECTION).set((Object)this.createClearSelectionControl());
        controlMap.get((Object)EntityTablePanelControl.MOVE_SELECTION_UP).set((Object)this.createMoveSelectionUpControl());
        controlMap.get((Object)EntityTablePanelControl.MOVE_SELECTION_DOWN).set((Object)this.createMoveSelectionDownControl());
        controlMap.get((Object)EntityTablePanelControl.COPY_CELL).set((Object)this.table.createCopyCellControl());
        controlMap.get((Object)EntityTablePanelControl.COPY_ROWS).set((Object)this.createCopyRowsControl());
        if (this.configuration.includeEntityMenu) {
            controlMap.get((Object)EntityTablePanelControl.DISPLAY_ENTITY_MENU).set((Object)Control.control(this::showEntityMenu));
        }
        if (this.configuration.includePopupMenu) {
            controlMap.get((Object)EntityTablePanelControl.DISPLAY_POPUP_MENU).set((Object)Control.control(this::showPopupMenu));
        }
        if (this.configuration.includeSelectionModeControl) {
            controlMap.get((Object)EntityTablePanelControl.SELECTION_MODE).set((Object)this.table.createSingleSelectionModeControl());
        }
        controlMap.get((Object)EntityTablePanelControl.REQUEST_TABLE_FOCUS).set((Object)this.createRequestTableFocusControl());
        controlMap.get((Object)EntityTablePanelControl.REQUEST_SEARCH_FIELD_FOCUS).set((Object)this.createRequestSearchFieldFocusControl());
        return Collections.unmodifiableMap(controlMap);
    }

    private void setupStandardControls() {
        this.controls.get((Object)EntityTablePanelControl.ADDITIONAL_POPUP_MENU_CONTROLS).set((Object)this.createAdditionalPopupControls());
        this.controls.get((Object)EntityTablePanelControl.ADDITIONAL_TOOLBAR_CONTROLS).set((Object)this.createAdditionalToolbarControls());
        this.controls.get((Object)EntityTablePanelControl.PRINT_CONTROLS).set((Object)this.createPrintControls());
        this.controls.get((Object)EntityTablePanelControl.CONDITION_CONTROLS).set((Object)this.createConditionControls());
        this.controls.get((Object)EntityTablePanelControl.FILTER_CONTROLS).set((Object)this.createFilterControls());
        this.controls.get((Object)EntityTablePanelControl.COLUMN_CONTROLS).set((Object)this.createColumnControls());
        this.controls.get((Object)EntityTablePanelControl.COPY_CONTROLS).set((Object)this.createCopyControls());
    }

    private boolean includeViewDependenciesControl() {
        return this.tableModel.entities().definitions().stream().flatMap(entityDefinition -> entityDefinition.foreignKeys().definitions().stream()).filter(foreignKeyDefinition -> !foreignKeyDefinition.soft()).anyMatch(foreignKeyDefinition -> foreignKeyDefinition.attribute().referencedType().equals(this.tableModel.entityType()));
    }

    private void configureColumn(FilterTableColumn<Attribute<?>> column) {
        TableCellEditor tableCellEditor = this.createTableCellEditor((Attribute)column.getIdentifier());
        if (tableCellEditor != null) {
            column.setCellEditor(tableCellEditor);
        }
        column.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(column.getHeaderRenderer()));
    }

    private void addTablePopupMenu() {
        if (this.configuration.includePopupMenu) {
            Controls popupControls = this.popupMenuConfiguration.create();
            if (popupControls == null || popupControls.empty()) {
                return;
            }
            JPopupMenu popupMenu = Components.menu((Controls)popupControls).createPopupMenu();
            this.table.setComponentPopupMenu(popupMenu);
            this.tableScrollPane.setComponentPopupMenu(popupMenu);
        }
    }

    private void showEntityMenu() {
        Point location = EntityTablePanel.popupLocation(this.table);
        this.tableModel.selectionModel().selectedItem().ifPresent(selected -> new EntityPopupMenu(selected.copy(), this.tableModel.connection()).show((Component)this.table, location.x, location.y));
    }

    private void showPopupMenu() {
        Point location = EntityTablePanel.popupLocation(this.table);
        this.table.getComponentPopupMenu().show((Component)this.table, location.x, location.y);
    }

    private void onConditionChanged() {
        if (this.table != null) {
            this.table.getTableHeader().repaint();
            this.table.repaint();
        }
    }

    private void onRefreshingChanged(boolean refreshing) {
        if (refreshing) {
            this.setCursor(Cursors.WAIT);
        } else {
            this.setCursor(Cursors.DEFAULT);
        }
    }

    private void setConditionStateAdvance(JScrollPane scrollPane, Value<ColumnConditionPanel.ConditionState> conditionState) {
        boolean parentOfFocusOwner = Utilities.parentOfType(JScrollPane.class, (Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == scrollPane;
        conditionState.set((Object)ColumnConditionPanel.ConditionState.HIDDEN);
        if (parentOfFocusOwner) {
            this.table.requestFocusInWindow();
        }
    }

    private boolean nonUpdatableForeignKey(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return foreignKey.references().stream().map(ForeignKey.Reference::column).map(referenceAttribute -> this.tableModel.entityDefinition().columns().definition(referenceAttribute)).filter(ColumnDefinition.class::isInstance).map(ColumnDefinition.class::cast).noneMatch(ColumnDefinition::updatable);
        }
        return false;
    }

    private EntityEditPanel validateEditModel(EntityEditPanel editPanel) {
        if (editPanel.editModel() != this.tableModel.editModel()) {
            throw new IllegalArgumentException("Edit panel model must be the same as the table edit model");
        }
        return editPanel;
    }

    private Map<Attribute<?>, ColumnPreferences> createColumnPreferences() {
        HashMap columnPreferencesMap = new HashMap();
        FilterTableColumnModel columnModel = this.table.getColumnModel();
        for (FilterTableColumn column : columnModel.columns()) {
            Attribute attribute = (Attribute)column.getIdentifier();
            int index = (Boolean)columnModel.visible((Object)attribute).get() != false ? columnModel.getColumnIndex((Object)attribute) : -1;
            columnPreferencesMap.put(attribute, ColumnPreferences.columnPreferences(attribute, index, column.getWidth()));
        }
        return columnPreferencesMap;
    }

    private Map<Attribute<?>, ConditionPreferences> createConditionPreferences() {
        HashMap conditionPreferencesMap = new HashMap();
        for (Attribute attribute : this.tableModel.columns().identifiers()) {
            ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.tableModel.conditionModel().conditionModels().get(attribute);
            if (columnConditionModel == null) continue;
            conditionPreferencesMap.put(attribute, ConditionPreferences.conditionPreferences(attribute, (Boolean)columnConditionModel.autoEnable().get(), (Boolean)columnConditionModel.caseSensitive().get(), (ColumnConditionModel.AutomaticWildcard)columnConditionModel.automaticWildcard().get()));
        }
        return conditionPreferencesMap;
    }

    private void applyConditionPreferences(String preferencesString) {
        try {
            ConditionPreferences.apply(this.tableModel, this.tableModel.columns().identifiers(), preferencesString);
        }
        catch (Exception e) {
            LOG.error("Error while applying condition preferences: {}", (Object)preferencesString, (Object)e);
        }
    }

    private Collection<Attribute<?>> selectAttributes() {
        FilterTableColumnModel columnModel = this.table.getColumnModel();
        if (((Boolean)this.queryHiddenColumns.get()).booleanValue() || columnModel.hidden().isEmpty()) {
            return Collections.emptyList();
        }
        return this.tableModel.entityDefinition().attributes().selected().stream().filter(this::columnNotHidden).collect(Collectors.toList());
    }

    private boolean columnNotHidden(Attribute<?> attribute) {
        return !this.table.getColumnModel().containsColumn(attribute) || (Boolean)this.table.getColumnModel().visible(attribute).get() != false;
    }

    private OrderBy orderByFromSortModel() {
        if (!this.table.sortModel().sorted()) {
            return null;
        }
        OrderBy.Builder builder = OrderBy.builder();
        this.table.sortModel().columnSortOrder().stream().filter(columnSortOrder -> this.isColumn((Attribute)columnSortOrder.columnIdentifier())).forEach(columnSortOrder -> {
            switch (columnSortOrder.sortOrder()) {
                case ASCENDING: {
                    builder.ascending(new Column[]{(Column)columnSortOrder.columnIdentifier()});
                    break;
                }
                case DESCENDING: {
                    builder.descending(new Column[]{(Column)columnSortOrder.columnIdentifier()});
                    break;
                }
            }
        });
        return builder.build();
    }

    private boolean isColumn(Attribute<?> attribute) {
        return this.tableModel.entityDefinition().attributes().definition(attribute) instanceof ColumnDefinition;
    }

    private void onColumnHidden(Attribute<?> attribute) {
        ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.tableModel.conditionModel().conditionModels().get(attribute);
        if (columnConditionModel != null && !((Boolean)columnConditionModel.locked().get()).booleanValue()) {
            columnConditionModel.enabled().set((Object)false);
        }
    }

    private void applyPreferences() {
        String conditionPreferencesString;
        String columnPreferencesString = UserPreferences.getUserPreference((String)(this.userPreferencesKey() + COLUMN_PREFERENCES), (String)"");
        if (columnPreferencesString.isEmpty()) {
            columnPreferencesString = UserPreferences.getUserPreference((String)this.userPreferencesKey(), (String)"");
        }
        if (!columnPreferencesString.isEmpty()) {
            this.applyColumnPreferences(columnPreferencesString);
        }
        if (!(conditionPreferencesString = UserPreferences.getUserPreference((String)(this.userPreferencesKey() + CONDITIONS_PREFERENCES), (String)"")).isEmpty()) {
            this.applyConditionPreferences(conditionPreferencesString);
        }
    }

    private void applyColumnPreferences(String preferencesString) {
        List<Attribute<?>> columnAttributes = this.table.getColumnModel().columns().stream().map(FilterTableColumn::getIdentifier).collect(Collectors.toList());
        try {
            ColumnPreferences.apply(this, columnAttributes, preferencesString, (attribute, columnWidth) -> this.table.getColumnModel().column(attribute).setPreferredWidth(columnWidth.intValue()));
        }
        catch (Exception e) {
            LOG.error("Error while applying column preferences: {}", (Object)preferencesString, (Object)e);
        }
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    private Controls.Config<EntityTablePanelControl> createPopupMenuConfiguration() {
        return Controls.config(identifier -> this.control((EntityTablePanelControl)((Object)identifier)).optional(), Arrays.asList(EntityTablePanelControl.REFRESH, EntityTablePanelControl.CLEAR, null, EntityTablePanelControl.ADD, EntityTablePanelControl.EDIT, EntityTablePanelControl.DELETE, null, this.configuration.popupMenuEditAttributeControl(), null, EntityTablePanelControl.VIEW_DEPENDENCIES, null, EntityTablePanelControl.ADDITIONAL_POPUP_MENU_CONTROLS, null, EntityTablePanelControl.PRINT_CONTROLS, null, EntityTablePanelControl.COLUMN_CONTROLS, null, EntityTablePanelControl.SELECTION_MODE, null, EntityTablePanelControl.CONDITION_CONTROLS, null, EntityTablePanelControl.FILTER_CONTROLS, null, EntityTablePanelControl.COPY_CONTROLS));
    }

    private Controls.Config<EntityTablePanelControl> createToolBarConfiguration() {
        return Controls.config(identifier -> this.control((EntityTablePanelControl)((Object)identifier)).optional(), Arrays.asList(EntityTablePanelControl.TOGGLE_SUMMARY_PANEL, EntityTablePanelControl.TOGGLE_CONDITION_PANEL, EntityTablePanelControl.TOGGLE_FILTER_PANEL, null, EntityTablePanelControl.ADD, EntityTablePanelControl.EDIT, EntityTablePanelControl.DELETE, null, this.editPanel == null ? EntityTablePanelControl.EDIT_SELECTED_ATTRIBUTE : null, null, EntityTablePanelControl.PRINT, null, EntityTablePanelControl.ADDITIONAL_TOOLBAR_CONTROLS));
    }

    private static GridBagConstraints createHorizontalFillConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        return constraints;
    }

    private JScrollPane createLinkedScrollPane(JComponent componentToScroll) {
        return (JScrollPane)((ScrollPaneBuilder)Components.scrollPane((JComponent)componentToScroll).horizontalScrollBarPolicy(31).verticalScrollBarPolicy(21).onBuild(scrollPane -> Utilities.linkBoundedRangeModels((BoundedRangeModel)this.tableScrollPane.getHorizontalScrollBar().getModel(), (BoundedRangeModel)scrollPane.getHorizontalScrollBar().getModel()))).build();
    }

    private static Point popupLocation(JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        int x = visibleRect.x + visibleRect.width / 2;
        int y = table.getSelectionModel().isSelectionEmpty() ? visibleRect.y + visibleRect.height / 2 : table.getCellRect((int)table.getSelectedRow(), (int)table.getSelectedColumn(), (boolean)true).y;
        return new Point(x, y + table.getRowHeight() / 2);
    }

    public static final class Config {
        public static final PropertyValue<Boolean> QUERY_HIDDEN_COLUMNS = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".queryHiddenColumns"), (boolean)true);
        public static final PropertyValue<Boolean> ORDER_QUERY_BY_SORT_ORDER = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".orderQueryBySortOrder"), (boolean)false);
        public static final PropertyValue<ColumnConditionPanel.ConditionState> CONDITION_STATE = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".conditionState"), ColumnConditionPanel.ConditionState.class, (Enum)ColumnConditionPanel.ConditionState.HIDDEN);
        public static final PropertyValue<ColumnConditionPanel.ConditionState> FILTER_STATE = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".filterState"), ColumnConditionPanel.ConditionState.class, (Enum)ColumnConditionPanel.ConditionState.HIDDEN);
        public static final PropertyValue<Boolean> SUMMARY_PANEL_VISIBLE = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".summaryPanelVisible"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_POPUP_MENU = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includePopupMenu"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeEntityMenu"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_CLEAR_CONTROL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeClearControl"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_CONDITION_PANEL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeConditionPanel"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_FILTER_PANEL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeFilterPanel"), (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_SUMMARY_PANEL = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeSummaryPanel"), (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_LIMIT_MENU = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".includeLimitMenu"), (boolean)false);
        public static final PropertyValue<Boolean> SHOW_REFRESH_PROGRESS_BAR = Configuration.booleanValue((String)(EntityTablePanel.class.getName() + ".showRefreshProgressBar"), (boolean)false);
        public static final PropertyValue<RefreshButtonVisible> REFRESH_BUTTON_VISIBLE = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".refreshButtonVisible"), RefreshButtonVisible.class, (Enum)RefreshButtonVisible.WHEN_CONDITION_PANEL_IS_VISIBLE);
        public static final PropertyValue<ColumnSelection> COLUMN_SELECTION = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".columnSelection"), ColumnSelection.class, (Enum)ColumnSelection.DIALOG);
        public static final PropertyValue<EditAttributeSelection> EDIT_ATTRIBUTE_SELECTION = Configuration.enumValue((String)(EntityTablePanel.class.getName() + ".editAttributeSelection"), EditAttributeSelection.class, (Enum)EditAttributeSelection.MENU);
        public static final KeyboardShortcuts<EntityTablePanelControl> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(EntityTablePanelControl.class);
        private static final Function<SwingEntityTableModel, String> DEFAULT_STATUS_MESSAGE = new DefaultStatusMessage();
        private final EntityTablePanel tablePanel;
        private final EntityDefinition entityDefinition;
        private final ValueSet<Attribute<?>> editable;
        private final Map<Attribute<?>, EntityComponentFactory<?, ?, ?>> editComponentFactories;
        private final Map<Attribute<?>, EntityComponentFactory<?, ?, ?>> cellEditorComponentFactories;
        private final FilterTable.Builder<Entity, Attribute<?>> tableBuilder;
        private TableConditionPanel.Factory<Attribute<?>> tableConditionPanelFactory = new DefaultTableConditionPanelFactory();
        private FilterColumnConditionPanel.FieldFactory<Attribute<?>> conditionFieldFactory;
        private boolean includeSouthPanel = true;
        private boolean includeConditionPanel = (Boolean)INCLUDE_CONDITION_PANEL.get();
        private boolean includeFilterPanel = (Boolean)INCLUDE_FILTER_PANEL.get();
        private boolean includeSummaryPanel = (Boolean)INCLUDE_SUMMARY_PANEL.get();
        private boolean includeClearControl = (Boolean)INCLUDE_CLEAR_CONTROL.get();
        private boolean includeLimitMenu = (Boolean)INCLUDE_LIMIT_MENU.get();
        private boolean includeEntityMenu = (Boolean)INCLUDE_ENTITY_MENU.get();
        private boolean includePopupMenu = (Boolean)INCLUDE_POPUP_MENU.get();
        private boolean includeSelectionModeControl = false;
        private boolean includeAddControl = true;
        private boolean includeEditControl = true;
        private boolean includeEditAttributeControl = true;
        private boolean includeToolBar = true;
        private ColumnSelection columnSelection = (ColumnSelection)((Object)COLUMN_SELECTION.get());
        private EditAttributeSelection editAttributeSelection = (EditAttributeSelection)((Object)EDIT_ATTRIBUTE_SELECTION.get());
        private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling;
        private RefreshButtonVisible refreshButtonVisible;
        private Function<SwingEntityTableModel, String> statusMessage = DEFAULT_STATUS_MESSAGE;
        private boolean showRefreshProgressBar = (Boolean)SHOW_REFRESH_PROGRESS_BAR.get();
        private EntityEditPanel.Confirmer deleteConfirmer;
        final KeyboardShortcuts<EntityTablePanelControl> shortcuts;

        private Config(EntityTablePanel tablePanel) {
            this.tablePanel = tablePanel;
            this.entityDefinition = tablePanel.tableModel.entityDefinition();
            this.tableBuilder = (FilterTable.Builder)FilterTable.builder((FilterTableModel)tablePanel.tableModel, EntityTableColumns.entityTableColumns(this.entityDefinition)).summaryValuesFactory((ColumnSummaryModel.SummaryValues.Factory)new EntitySummaryValuesFactory(this.entityDefinition, (FilterTableModel<?, Attribute<?>>)tablePanel.tableModel)).cellRendererFactory((FilterTableCellRendererFactory)new EntityTableCellRendererFactory(tablePanel.tableModel)).onBuild(filterTable -> filterTable.setRowHeight(filterTable.getFont().getSize() + 4));
            this.tableConditionPanelFactory = new DefaultTableConditionPanelFactory();
            this.conditionFieldFactory = new EntityConditionFieldFactory(this.entityDefinition);
            this.shortcuts = KEYBOARD_SHORTCUTS.copy();
            this.editable = ValueSet.valueSet((Collection)this.entityDefinition.attributes().updatable().stream().map(AttributeDefinition::attribute).collect(Collectors.toSet()));
            this.editable.addValidator((Value.Validator)new EditMenuAttributeValidator(this.entityDefinition));
            this.editComponentFactories = new HashMap();
            this.cellEditorComponentFactories = new HashMap();
            this.referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());
            this.refreshButtonVisible = RefreshButtonVisible.WHEN_CONDITION_PANEL_IS_VISIBLE;
            this.deleteConfirmer = new DeleteConfirmer(tablePanel.tableModel.selectionModel());
        }

        private Config(Config config) {
            this.tablePanel = config.tablePanel;
            this.entityDefinition = config.entityDefinition;
            this.tableBuilder = config.tableBuilder;
            this.shortcuts = config.shortcuts.copy();
            this.editable = ValueSet.valueSet((Collection)((Collection)config.editable.get()));
            this.includeSouthPanel = config.includeSouthPanel;
            this.includeConditionPanel = config.includeConditionPanel;
            this.includeFilterPanel = config.includeFilterPanel;
            this.includeSummaryPanel = config.includeSummaryPanel;
            this.includeClearControl = config.includeClearControl;
            this.includeLimitMenu = config.includeLimitMenu;
            this.includeEntityMenu = config.includeEntityMenu;
            this.includePopupMenu = config.includePopupMenu;
            this.includeSelectionModeControl = config.includeSelectionModeControl;
            this.includeAddControl = config.includeAddControl;
            this.includeEditControl = config.includeEditControl;
            this.includeEditAttributeControl = config.includeEditAttributeControl;
            this.columnSelection = config.columnSelection;
            this.editAttributeSelection = config.editAttributeSelection;
            this.editComponentFactories = new HashMap(config.editComponentFactories);
            this.cellEditorComponentFactories = new HashMap(config.cellEditorComponentFactories);
            this.referentialIntegrityErrorHandling = config.referentialIntegrityErrorHandling;
            this.refreshButtonVisible = config.refreshButtonVisible;
            this.statusMessage = config.statusMessage;
            this.showRefreshProgressBar = config.showRefreshProgressBar;
            this.deleteConfirmer = config.deleteConfirmer;
            this.includeToolBar = config.includeToolBar;
            this.tableConditionPanelFactory = config.tableConditionPanelFactory;
            this.conditionFieldFactory = config.conditionFieldFactory;
        }

        public EntityTablePanel tablePanel() {
            return this.tablePanel;
        }

        public Config configureTable(Consumer<FilterTable.Builder<Entity, Attribute<?>>> tableBuilder) {
            Objects.requireNonNull(tableBuilder).accept(this.tableBuilder);
            return this;
        }

        public Config tableConditionPanelFactory(TableConditionPanel.Factory<Attribute<?>> tableConditionPanelFactory) {
            this.tableConditionPanelFactory = Objects.requireNonNull(tableConditionPanelFactory);
            return this;
        }

        public Config conditionFieldFactory(FilterColumnConditionPanel.FieldFactory<Attribute<?>> conditionFieldFactory) {
            this.conditionFieldFactory = Objects.requireNonNull(conditionFieldFactory);
            return this;
        }

        public Config includeSouthPanel(boolean includeSouthPanel) {
            this.includeSouthPanel = includeSouthPanel;
            return this;
        }

        public Config includeConditionPanel(boolean includeConditionPanel) {
            this.includeConditionPanel = includeConditionPanel;
            return this;
        }

        public Config includeFilterPanel(boolean includeFilterPanel) {
            this.includeFilterPanel = includeFilterPanel;
            return this;
        }

        public Config includeSummaryPanel(boolean includeSummaryPanel) {
            this.includeSummaryPanel = includeSummaryPanel;
            return this;
        }

        public Config includePopupMenu(boolean includePopupMenu) {
            this.includePopupMenu = includePopupMenu;
            return this;
        }

        public Config includeClearControl(boolean includeClearControl) {
            this.includeClearControl = includeClearControl;
            return this;
        }

        public Config includeLimitMenu(boolean includeLimitMenu) {
            this.includeLimitMenu = includeLimitMenu;
            return this;
        }

        public Config includeEntityMenu(boolean includeEntityMenu) {
            this.includeEntityMenu = includeEntityMenu;
            return this;
        }

        public Config includeSelectionModeControl(boolean includeSelectionModeControl) {
            this.includeSelectionModeControl = includeSelectionModeControl;
            return this;
        }

        public Config includeToolBar(boolean includeToolBar) {
            this.includeToolBar = includeToolBar;
            return this;
        }

        public Config includeAddControl(boolean includeAddControl) {
            this.includeAddControl = includeAddControl;
            return this;
        }

        public Config includeEditControl(boolean includeEditControl) {
            this.includeEditControl = includeEditControl;
            return this;
        }

        public Config includeEditAttributeControl(boolean includeEditAttributeControl) {
            this.includeEditAttributeControl = includeEditAttributeControl;
            return this;
        }

        public Config columnSelection(ColumnSelection columnSelection) {
            this.columnSelection = Objects.requireNonNull(columnSelection);
            return this;
        }

        public Config editAttributeSelection(EditAttributeSelection editAttributeSelection) {
            this.editAttributeSelection = Objects.requireNonNull(editAttributeSelection);
            return this;
        }

        public Config keyStrokes(Consumer<KeyboardShortcuts<EntityTablePanelControl>> shortcuts) {
            Objects.requireNonNull(shortcuts).accept(this.shortcuts);
            return this;
        }

        public Config editable(Consumer<ValueSet<Attribute<?>>> attributes) {
            Objects.requireNonNull(attributes).accept(this.editable);
            return this;
        }

        public Config deleteConfirmer(EntityEditPanel.Confirmer deleteConfirmer) {
            this.deleteConfirmer = Objects.requireNonNull(deleteConfirmer);
            return this;
        }

        public <T, A extends Attribute<T>, C extends JComponent> Config editComponentFactory(A attribute, EntityComponentFactory<T, A, C> componentFactory) {
            this.entityDefinition.attributes().definition(attribute);
            this.editComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
            return this;
        }

        public <T, A extends Attribute<T>, C extends JComponent> Config tableCellEditorFactory(A attribute, EntityComponentFactory<T, A, C> componentFactory) {
            this.entityDefinition.attributes().definition(attribute);
            this.cellEditorComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
            return this;
        }

        public Config referentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
            this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
            return this;
        }

        public Config refreshButtonVisible(RefreshButtonVisible refreshButtonVisible) {
            this.refreshButtonVisible = Objects.requireNonNull(refreshButtonVisible);
            return this;
        }

        public Config statusMessage(Function<SwingEntityTableModel, String> statusMessage) {
            this.statusMessage = Objects.requireNonNull(statusMessage);
            return this;
        }

        public Config showRefreshProgressBar(boolean showRefreshProgressBar) {
            this.showRefreshProgressBar = showRefreshProgressBar;
            return this;
        }

        private EntityTablePanelControl popupMenuEditAttributeControl() {
            return this.editAttributeSelection == EditAttributeSelection.MENU ? EntityTablePanelControl.EDIT_ATTRIBUTE_CONTROLS : EntityTablePanelControl.EDIT_SELECTED_ATTRIBUTE;
        }

        private static final class DefaultTableConditionPanelFactory
        implements TableConditionPanel.Factory<Attribute<?>> {
            private DefaultTableConditionPanelFactory() {
            }

            public TableConditionPanel<Attribute<?>> create(TableConditionModel<Attribute<?>> conditionModel, Collection<ColumnConditionPanel<Attribute<?>, ?>> columnConditionPanels, FilterTableColumnModel<Attribute<?>> columnModel) {
                return FilterTableConditionPanel.filterTableConditionPanel(conditionModel, columnConditionPanels, columnModel);
            }
        }

        private static final class EditMenuAttributeValidator
        implements Value.Validator<Set<Attribute<?>>> {
            private final EntityDefinition entityDefinition;

            private EditMenuAttributeValidator(EntityDefinition entityDefinition) {
                this.entityDefinition = entityDefinition;
            }

            public void validate(Set<Attribute<?>> attributes) {
                attributes.forEach(attribute -> this.entityDefinition.attributes().definition(attribute));
            }
        }
    }

    private final class TablePanel
    extends JPanel {
        private final JPanel tableSouthPanel;

        private TablePanel() {
            super(new BorderLayout());
            this.tableSouthPanel = new JPanel(new BorderLayout());
            this.add((Component)EntityTablePanel.this.tableScrollPane, "Center");
            this.add((Component)this.tableSouthPanel, "South");
        }

        private void initialize() {
            if (EntityTablePanel.this.configuration.includeSummaryPanel && TablePanel.containsSummaryModels(EntityTablePanel.this.table)) {
                EntityTablePanel.this.summaryPanel = this.createSummaryPanel();
                if (EntityTablePanel.this.summaryPanel != null) {
                    EntityTablePanel.this.summaryPanelScrollPane = EntityTablePanel.this.createLinkedScrollPane((JComponent)EntityTablePanel.this.summaryPanel);
                    EntityTablePanel.this.summaryPanelScrollPane.setVisible(false);
                    this.tableSouthPanel.add((Component)EntityTablePanel.this.summaryPanelScrollPane, "North");
                }
            }
            if (EntityTablePanel.this.configuration.includeFilterPanel) {
                EntityTablePanel.this.filterPanelScrollPane = EntityTablePanel.this.createLinkedScrollPane((JComponent)EntityTablePanel.this.table.filterPanel());
                EntityTablePanel.this.table.filterPanel().state().addConsumer(this::filterPanelStateChanged);
                if (EntityTablePanel.this.table.filterPanel().state().isNotEqualTo((Object)ColumnConditionPanel.ConditionState.HIDDEN)) {
                    this.tableSouthPanel.add((Component)EntityTablePanel.this.filterPanelScrollPane, "South");
                }
            }
        }

        private void conditionPanelStateChanged(ColumnConditionPanel.ConditionState conditionState) {
            EntityTablePanel.this.refreshButtonToolBar.setVisible(EntityTablePanel.this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || conditionState != ColumnConditionPanel.ConditionState.HIDDEN);
            if (conditionState == ColumnConditionPanel.ConditionState.HIDDEN) {
                this.remove(EntityTablePanel.this.conditionPanelScrollPane);
            } else {
                this.add((Component)EntityTablePanel.this.conditionPanelScrollPane, "North");
            }
            this.revalidate();
        }

        private void filterPanelStateChanged(ColumnConditionPanel.ConditionState conditionState) {
            if (conditionState == ColumnConditionPanel.ConditionState.HIDDEN) {
                this.tableSouthPanel.remove(EntityTablePanel.this.filterPanelScrollPane);
            } else {
                this.tableSouthPanel.add((Component)EntityTablePanel.this.filterPanelScrollPane, "South");
            }
            this.revalidate();
        }

        private static boolean containsSummaryModels(FilterTable<Entity, Attribute<?>> table) {
            return table.getColumnModel().columns().stream().map(FilterTableColumn::getIdentifier).map(arg_0 -> ((TableSummaryModel)table.summaryModel()).summaryModel(arg_0)).anyMatch(Optional::isPresent);
        }

        private FilterTableColumnComponentPanel<Attribute<?>> createSummaryPanel() {
            Map<Attribute<?>, JComponent> columnSummaryPanels = this.createColumnSummaryPanels();
            if (columnSummaryPanels.isEmpty()) {
                return null;
            }
            return FilterTableColumnComponentPanel.filterTableColumnComponentPanel((FilterTableColumnModel)EntityTablePanel.this.table.getColumnModel(), columnSummaryPanels);
        }

        private Map<Attribute<?>, JComponent> createColumnSummaryPanels() {
            HashMap components = new HashMap();
            EntityTablePanel.this.table.getColumnModel().columns().forEach(column -> EntityTablePanel.this.table.summaryModel().summaryModel((Object)((Attribute)column.getIdentifier())).ifPresent(columnSummaryModel -> components.put((Attribute<?>)((Attribute)column.getIdentifier()), (JComponent)ColumnSummaryPanel.columnSummaryPanel((ColumnSummaryModel)columnSummaryModel, (int)((FilterTableCellRenderer)column.getCellRenderer()).horizontalAlignment()))));
            return components;
        }
    }

    private final class SouthPanel
    extends JPanel {
        private SouthPanel() {
            JToolBar southToolBar;
            super(new BorderLayout());
            this.add((Component)Components.splitPane().continuousLayout(true).leftComponent(Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)EntityTablePanel.this.table.searchField(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build()).rightComponent((JComponent)this.statusPanel()).build(), "Center");
            this.add((Component)EntityTablePanel.this.refreshButtonToolBar, "West");
            if (EntityTablePanel.this.configuration.includeToolBar && (southToolBar = this.createToolBar()) != null) {
                this.add((Component)southToolBar, "East");
            }
        }

        private StatusPanel statusPanel() {
            if (EntityTablePanel.this.statusPanel == null) {
                EntityTablePanel.this.statusPanel = new StatusPanel();
            }
            return EntityTablePanel.this.statusPanel;
        }

        private JToolBar createToolBar() {
            Controls toolbarControls = EntityTablePanel.this.toolBarConfiguration.create();
            if (toolbarControls == null || toolbarControls.empty()) {
                return null;
            }
            return (JToolBar)((ToolBarBuilder)Components.toolBar().controls(toolbarControls)).floatable(false).rollover(true).build(toolBar -> Arrays.stream(toolBar.getComponents()).map(JComponent.class::cast).forEach(component -> component.setToolTipText(null)));
        }
    }

    public static enum EntityTablePanelControl implements KeyboardShortcuts.Shortcut
    {
        ADD(KeyboardShortcuts.keyStroke((int)155)),
        EDIT(KeyboardShortcuts.keyStroke((int)155, (int)128)),
        EDIT_SELECTED_ATTRIBUTE(KeyboardShortcuts.keyStroke((int)155, (int)64)),
        REQUEST_TABLE_FOCUS(KeyboardShortcuts.keyStroke((int)84, (int)128)),
        TOGGLE_CONDITION_PANEL(KeyboardShortcuts.keyStroke((int)83, (int)640)),
        SELECT_CONDITION_PANEL(KeyboardShortcuts.keyStroke((int)83, (int)128)),
        TOGGLE_FILTER_PANEL(KeyboardShortcuts.keyStroke((int)70, (int)640)),
        SELECT_FILTER_PANEL(KeyboardShortcuts.keyStroke((int)70, (int)192)),
        MOVE_SELECTION_UP(KeyboardShortcuts.keyStroke((int)38, (int)576)),
        MOVE_SELECTION_DOWN(KeyboardShortcuts.keyStroke((int)40, (int)576)),
        PRINT(KeyboardShortcuts.keyStroke((int)80, (int)128)),
        DELETE(KeyboardShortcuts.keyStroke((int)127)),
        DISPLAY_POPUP_MENU(KeyboardShortcuts.keyStroke((int)71, (int)128)),
        DISPLAY_ENTITY_MENU(KeyboardShortcuts.keyStroke((int)86, (int)640)),
        PRINT_CONTROLS,
        ADDITIONAL_POPUP_MENU_CONTROLS,
        ADDITIONAL_TOOLBAR_CONTROLS,
        VIEW_DEPENDENCIES,
        EDIT_ATTRIBUTE_CONTROLS,
        SELECT_COLUMNS,
        RESET_COLUMNS,
        COLUMN_AUTO_RESIZE_MODE,
        SELECTION_MODE,
        CLEAR,
        REFRESH(KeyboardShortcuts.keyStroke((int)82, (int)512)),
        TOGGLE_SUMMARY_PANEL,
        CONDITION_CONTROLS,
        FILTER_CONTROLS,
        CLEAR_SELECTION,
        COPY_CONTROLS,
        COPY_CELL(KeyboardShortcuts.keyStroke((int)67, (int)640)),
        COPY_ROWS,
        COLUMN_CONTROLS,
        REQUEST_SEARCH_FIELD_FOCUS(KeyboardShortcuts.keyStroke((int)70, (int)128));

        private final KeyStroke defaultKeystroke;

        private EntityTablePanelControl() {
            this(null);
        }

        private EntityTablePanelControl(KeyStroke defaultKeystroke) {
            this.defaultKeystroke = defaultKeystroke;
        }

        public Optional<KeyStroke> defaultKeystroke() {
            return Optional.ofNullable(this.defaultKeystroke);
        }
    }

    private final class DeleteCommand
    implements Control.Command {
        private DeleteCommand() {
        }

        public void execute() {
            if (EntityTablePanel.this.confirmDelete()) {
                List selectedItems = EntityTablePanel.this.tableModel().selectionModel().getSelectedItems();
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Delete.Task)EntityTablePanel.this.tableModel().editModel().createDelete((Collection)selectedItems).prepare()).perform()).title(EDIT_PANEL_MESSAGES.getString("deleting"))).owner((Component)EntityTablePanel.this)).onException(this::onException).onResult(EntityEditModel.Delete.Result::handle).execute();
            }
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityTablePanel.this.onException(exception);
        }
    }

    public static enum ColumnSelection {
        DIALOG,
        MENU;

    }

    public static enum RefreshButtonVisible {
        ALWAYS,
        WHEN_CONDITION_PANEL_IS_VISIBLE;

    }

    private static final class ComponentAvailableValidator
    implements Value.Validator<Boolean> {
        private final JComponent component;
        private final String panelType;

        private ComponentAvailableValidator(JComponent component, String panelType) {
            this.component = component;
            this.panelType = panelType;
        }

        public void validate(Boolean visible) throws IllegalArgumentException {
            if (visible.booleanValue() && this.component == null) {
                throw new IllegalArgumentException("No " + this.panelType + " panel available");
            }
        }
    }

    private final class HeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer wrappedRenderer;

        private HeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.wrappedRenderer == null ? table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            FilterTableColumn tableColumn = EntityTablePanel.this.table().getColumnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            boolean useBoldFont = renderer instanceof FilterTableCellRenderer && ((FilterTableCellRenderer)renderer).columnShading() && EntityTablePanel.this.tableModel.conditionModel().enabled((Object)((Attribute)tableColumn.getIdentifier()));
            Font defaultFont = component.getFont();
            component.setFont(useBoldFont ? defaultFont.deriveFont(defaultFont.getStyle() | 1) : defaultFont);
            return component;
        }
    }

    private final class ScrollToColumn
    implements Consumer<Attribute<?>> {
        private ScrollToColumn() {
        }

        @Override
        public void accept(Attribute<?> attribute) {
            EntityTablePanel.this.table.scrollToColumn(attribute);
        }
    }

    private final class StatusPanel
    extends JPanel {
        private final Value<String> statusMessage;
        private final JLabel label;
        private final JPanel progressPanel;

        private StatusPanel() {
            super(new BorderLayout());
            this.statusMessage = Value.nonNull((Object)"").initialValue((Object)EntityTablePanel.this.configuration.statusMessage.apply(EntityTablePanel.this.tableModel)).build();
            this.label = this.createStatusLabel();
            this.progressPanel = StatusPanel.createProgressPanel();
            this.add((Component)this.label, "Center");
            EntityTablePanel.this.tableModel.refresher().observer().addConsumer((Consumer)new ConfigurePanel());
            EntityTablePanel.this.tableModel.selectionModel().addListSelectionListener(e -> this.updateStatusMessage());
            EntityTablePanel.this.tableModel.dataChangedEvent().addListener(this::updateStatusMessage);
            if (EntityTablePanel.this.configuration.includeLimitMenu) {
                this.setComponentPopupMenu(this.createLimitMenu());
            }
        }

        private JLabel createStatusLabel() {
            return (JLabel)Components.label(this.statusMessage).horizontalAlignment(0).build();
        }

        private static JPanel createProgressPanel() {
            return (JPanel)Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)Components.progressBar().indeterminate(true).string(MESSAGES.getString("refreshing")).stringPainted(true).build(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build();
        }

        private JPopupMenu createLimitMenu() {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add((Action)Control.builder(this::configureLimit).name(MESSAGES.getString("row_limit")).build());
            return popupMenu;
        }

        private void configureLimit() {
            ComponentValue limitValue = ((NumberField.Builder)((NumberField.Builder)Components.integerField().initialValue((Object)((Integer)EntityTablePanel.this.tableModel.limit().get()))).groupingUsed(true).minimumValue((Number)0).columns(6)).buildValue();
            EntityTablePanel.this.tableModel.limit().set((Object)((Integer)((InputDialogBuilder)((InputDialogBuilder)Dialogs.inputDialog((ComponentValue)limitValue).title(MESSAGES.getString("row_limit"))).owner((Component)EntityTablePanel.this)).validator((Predicate)new LimitValidator()).show()));
        }

        private void updateStatusMessage() {
            this.statusMessage.set((Object)EntityTablePanel.this.configuration.statusMessage.apply(EntityTablePanel.this.tableModel));
        }

        private final class ConfigurePanel
        implements Consumer<Boolean> {
            private ConfigurePanel() {
            }

            @Override
            public void accept(Boolean isRefreshing) {
                if (EntityTablePanel.this.configuration.showRefreshProgressBar) {
                    StatusPanel.this.removeAll();
                    StatusPanel.this.add((Component)(isRefreshing != false ? StatusPanel.this.progressPanel : StatusPanel.this.label), "Center");
                    StatusPanel.this.revalidate();
                    StatusPanel.this.repaint();
                }
            }
        }

        private final class LimitValidator
        implements Predicate<Integer> {
            private LimitValidator() {
            }

            @Override
            public boolean test(Integer limit) {
                try {
                    EntityTablePanel.this.tableModel.limit().validate((Object)limit);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
    }

    private static final class DefaultStatusMessage
    implements Function<SwingEntityTableModel, String> {
        private static final NumberFormat STATUS_MESSAGE_NUMBER_FORMAT = NumberFormat.getIntegerInstance();

        private DefaultStatusMessage() {
        }

        @Override
        public String apply(SwingEntityTableModel tableModel) {
            int rowCount = tableModel.getRowCount();
            int filteredCount = tableModel.filteredCount();
            if (rowCount == 0 && filteredCount == 0) {
                return "";
            }
            int selectionCount = tableModel.selectionModel().selectionCount();
            StringBuilder builder = new StringBuilder();
            if (tableModel.limit().isEqualTo((Object)tableModel.getRowCount())) {
                builder.append(MESSAGES.getString("limited_to")).append(" ");
            }
            builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(rowCount));
            if (selectionCount > 0 || filteredCount > 0) {
                builder.append(" (");
                if (selectionCount > 0) {
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(selectionCount)).append(" ").append(MESSAGES.getString("selected"));
                }
                if (filteredCount > 0) {
                    if (selectionCount > 0) {
                        builder.append(" - ");
                    }
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(filteredCount)).append(" ").append(MESSAGES.getString("filtered"));
                }
                builder.append(")");
            }
            return builder.toString();
        }
    }

    private static final class EntitySummaryValuesFactory
    implements ColumnSummaryModel.SummaryValues.Factory<Attribute<?>> {
        private final EntityDefinition entityDefinition;
        private final FilterTableModel<?, Attribute<?>> tableModel;

        private EntitySummaryValuesFactory(EntityDefinition entityDefinition, FilterTableModel<?, Attribute<?>> tableModel) {
            this.entityDefinition = Objects.requireNonNull(entityDefinition);
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        public <T extends Number> Optional<ColumnSummaryModel.SummaryValues<T>> createSummaryValues(Attribute<?> attribute, Format format) {
            AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
            if (attribute.type().isNumerical() && attributeDefinition.items().isEmpty()) {
                return Optional.of(FilterTable.summaryValues(attribute, this.tableModel, (Format)format));
            }
            return Optional.empty();
        }
    }

    private static final class DeleteConfirmer
    implements EntityEditPanel.Confirmer {
        private final FilterTableSelectionModel<?> selectionModel;

        private DeleteConfirmer(FilterTableSelectionModel<?> selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete((int)this.selectionModel.selectionCount()), FrameworkMessages.delete());
        }
    }

    public static enum EditAttributeSelection {
        DIALOG,
        MENU;

    }
}

