/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.model.EntityTableModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONObject;

final class ConditionPreferences {
    static final String CONDITIONS_KEY = "conditions";
    static final String AUTO_ENABLE_KEY = "ae";
    static final String CASE_SENSITIVE_KEY = "cs";
    static final String AUTOMATIC_WILDCARD_KEY = "aw";
    private final Attribute<?> attribute;
    private final boolean autoEnable;
    private final boolean caseSensitive;
    private final ColumnConditionModel.AutomaticWildcard automaticWildcard;

    ConditionPreferences(Attribute<?> attribute, boolean autoEnable, boolean caseSensitive, ColumnConditionModel.AutomaticWildcard automaticWildcard) {
        this.attribute = attribute;
        this.autoEnable = autoEnable;
        this.caseSensitive = caseSensitive;
        this.automaticWildcard = Objects.requireNonNull(automaticWildcard);
    }

    Attribute<?> attribute() {
        return this.attribute;
    }

    boolean autoEnable() {
        return this.autoEnable;
    }

    boolean caseSensitive() {
        return this.caseSensitive;
    }

    ColumnConditionModel.AutomaticWildcard automaticWildcard() {
        return this.automaticWildcard;
    }

    JSONObject toJSONObject() {
        JSONObject conditionObject = new JSONObject();
        conditionObject.put(AUTO_ENABLE_KEY, this.autoEnable() ? 1 : 0);
        conditionObject.put(CASE_SENSITIVE_KEY, this.caseSensitive() ? 1 : 0);
        conditionObject.put(AUTOMATIC_WILDCARD_KEY, (Object)this.automaticWildcard());
        return conditionObject;
    }

    static ConditionPreferences conditionPreferences(Attribute<?> attribute, boolean autoEnable, boolean caseSensitive, ColumnConditionModel.AutomaticWildcard automaticWildcard) {
        return new ConditionPreferences(attribute, autoEnable, caseSensitive, automaticWildcard);
    }

    static String toString(Map<Attribute<?>, ConditionPreferences> conditionPreferences) {
        Objects.requireNonNull(conditionPreferences);
        JSONObject jsonConditionPreferences = new JSONObject();
        conditionPreferences.forEach((attribute, preferences) -> jsonConditionPreferences.put(attribute.name(), (Object)preferences.toJSONObject()));
        JSONObject preferencesRoot = new JSONObject();
        preferencesRoot.put(CONDITIONS_KEY, (Object)jsonConditionPreferences);
        return preferencesRoot.toString();
    }

    static Map<Attribute<?>, ConditionPreferences> fromString(Collection<Attribute<?>> attributes, String preferencesString) {
        Objects.requireNonNull(preferencesString);
        JSONObject jsonObject = new JSONObject(preferencesString).getJSONObject(CONDITIONS_KEY);
        return Objects.requireNonNull(attributes).stream().map(attribute -> ConditionPreferences.conditionPreferences(attribute, Objects.requireNonNull(jsonObject))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ConditionPreferences::attribute, Function.identity()));
    }

    static void apply(EntityTableModel<?> tableModel, List<Attribute<?>> columnAttributes, String preferencesString) {
        Objects.requireNonNull(tableModel);
        Objects.requireNonNull(columnAttributes);
        Objects.requireNonNull(preferencesString);
        Map<Attribute<?>, ConditionPreferences> conditionPreferences = ConditionPreferences.fromString(columnAttributes, preferencesString);
        for (Attribute<?> attribute : columnAttributes) {
            ColumnConditionModel conditionModel;
            ConditionPreferences preferences = conditionPreferences.get(attribute);
            if (preferences == null || (conditionModel = tableModel.conditionModel().conditionModel(attribute)) == null) continue;
            conditionModel.caseSensitive().set((Object)preferences.caseSensitive());
            conditionModel.autoEnable().set((Object)preferences.autoEnable());
            conditionModel.automaticWildcard().set((Object)preferences.automaticWildcard());
        }
    }

    static Optional<ConditionPreferences> conditionPreferences(Attribute<?> attribute, JSONObject preferences) {
        if (preferences.has(attribute.name())) {
            return Optional.of(ConditionPreferences.fromJSONObject(attribute, preferences.getJSONObject(attribute.name())));
        }
        return Optional.empty();
    }

    private static ConditionPreferences fromJSONObject(Attribute<?> attribute, JSONObject conditionObject) {
        return new ConditionPreferences(attribute, conditionObject.getInt(AUTO_ENABLE_KEY) == 1, conditionObject.getInt(CASE_SENSITIVE_KEY) == 1, ColumnConditionModel.AutomaticWildcard.valueOf((String)conditionObject.getString(AUTOMATIC_WILDCARD_KEY)));
    }
}

