/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Text;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.model.UserPreferences;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.DomainType;
import is.codion.framework.model.EntityApplicationModel;
import is.codion.swing.common.model.worker.ProgressWorker;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.LoginDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.icon.Icons;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import is.codion.swing.framework.model.SwingEntityApplicationModel;
import is.codion.swing.framework.ui.EntityApplicationPanel;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEntityApplicationPanelBuilder<M extends SwingEntityApplicationModel, P extends EntityApplicationPanel<M>>
implements EntityApplicationPanel.Builder<M, P> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntityApplicationPanelBuilder.class);
    private static final String CODION_APPLICATION_VERSION = "codion.application.version";
    private static final int DEFAULT_LOGO_SIZE = 68;
    private static final String DASH = " - ";
    private final Class<M> applicationModelClass;
    private final Class<P> applicationPanelClass;
    private final String applicationDefaultUsernameProperty;
    private final String applicationLookAndFeelProperty;
    private final String applicationFontSizeProperty;
    private DomainType domainType = (DomainType)EntityConnectionProvider.CLIENT_DOMAIN_TYPE.get();
    private String applicationName = "";
    private EntityApplicationPanel.Builder.ConnectionProviderFactory connectionProviderFactory = new DefaultConnectionProviderFactory();
    private Function<EntityConnectionProvider, M> applicationModelFactory = new DefaultApplicationModelFactory();
    private Function<M, P> applicationPanelFactory = new DefaultApplicationPanelFactory();
    private ValueObserver<String> frameTitleProvider;
    private EntityApplicationPanel.Builder.LoginProvider loginProvider = new DefaultDialogLoginProvider();
    private Supplier<JFrame> frameSupplier = new DefaultFrameSupplier();
    private boolean displayStartupDialog = (Boolean)EntityApplicationPanel.SHOW_STARTUP_DIALOG.get();
    private ImageIcon applicationIcon;
    private Version applicationVersion;
    private boolean saveDefaultUsername = (Boolean)EntityApplicationModel.SAVE_DEFAULT_USERNAME.get();
    private Supplier<JComponent> loginPanelSouthComponentSupplier = new DefaultSouthComponentSupplier();
    private Runnable beforeApplicationStarted;
    private Consumer<P> onApplicationStarted;
    private String defaultLookAndFeelClassName = Utilities.systemLookAndFeelClassName();
    private String lookAndFeelClassName;
    private boolean setUncaughtExceptionHandler = true;
    private boolean maximizeFrame = false;
    private boolean displayFrame = true;
    private boolean includeMainMenu = true;
    private Dimension frameSize;
    private boolean loginRequired = (Boolean)EntityApplicationModel.AUTHENTICATION_REQUIRED.get();
    private User defaultLoginUser;
    private User automaticLoginUser;

    DefaultEntityApplicationPanelBuilder(Class<M> applicationModelClass, Class<P> applicationPanelClass) {
        this.applicationModelClass = Objects.requireNonNull(applicationModelClass);
        this.applicationPanelClass = Objects.requireNonNull(applicationPanelClass);
        this.applicationDefaultUsernameProperty = "is.codion.swing.framework.ui.defaultUsername#" + applicationPanelClass.getSimpleName();
        this.applicationLookAndFeelProperty = "is.codion.swing.framework.ui.LookAndFeel#" + applicationPanelClass.getSimpleName();
        this.applicationFontSizeProperty = "is.codion.swing.framework.ui.FontSize#" + applicationPanelClass.getSimpleName();
        this.defaultLoginUser = User.user((String)UserPreferences.getUserPreference((String)this.applicationDefaultUsernameProperty, (String)((String)EntityApplicationModel.USERNAME_PREFIX.get() + System.getProperty("user.name"))));
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> domainType(DomainType domainType) {
        this.domainType = Objects.requireNonNull(domainType);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> applicationIcon(ImageIcon applicationIcon) {
        this.applicationIcon = Objects.requireNonNull(applicationIcon);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> defaultLookAndFeelClassName(String defaultLookAndFeelClassName) {
        this.defaultLookAndFeelClassName = Objects.requireNonNull(defaultLookAndFeelClassName);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> lookAndFeelClassName(String lookAndFeelClassName) {
        this.lookAndFeelClassName = Objects.requireNonNull(lookAndFeelClassName);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> applicationName(String applicationName) {
        this.applicationName = Objects.requireNonNull(applicationName);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> applicationVersion(Version applicationVersion) {
        this.applicationVersion = Objects.requireNonNull(applicationVersion);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> applicationModelFactory(Function<EntityConnectionProvider, M> applicationModelFactory) {
        this.applicationModelFactory = Objects.requireNonNull(applicationModelFactory);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> applicationPanelFactory(Function<M, P> applicationPanelFactory) {
        this.applicationPanelFactory = Objects.requireNonNull(applicationPanelFactory);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> defaultLoginUser(User defaultLoginUser) {
        this.defaultLoginUser = defaultLoginUser;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> automaticLoginUser(User automaticLoginUser) {
        this.automaticLoginUser = automaticLoginUser;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> loginProvider(EntityApplicationPanel.Builder.LoginProvider loginProvider) {
        this.loginProvider = Objects.requireNonNull(loginProvider);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> saveDefaultUsername(boolean saveDefaultUsername) {
        this.saveDefaultUsername = saveDefaultUsername;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> frameSupplier(Supplier<JFrame> frameSupplier) {
        this.frameSupplier = Objects.requireNonNull(frameSupplier);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> frameTitle(String frameTitle) {
        return this.frameTitleProvider((ValueObserver<String>)Value.nullable((Object)Objects.requireNonNull(frameTitle)).build());
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> frameTitleProvider(ValueObserver<String> frameTitleProvider) {
        this.frameTitleProvider = Objects.requireNonNull(frameTitleProvider);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> includeMainMenu(boolean includeMainMenu) {
        this.includeMainMenu = includeMainMenu;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> maximizeFrame(boolean maximizeFrame) {
        this.maximizeFrame = maximizeFrame;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> displayFrame(boolean displayFrame) {
        this.displayFrame = displayFrame;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> setUncaughtExceptionHandler(boolean setUncaughtExceptionHandler) {
        this.setUncaughtExceptionHandler = setUncaughtExceptionHandler;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> displayStartupDialog(boolean displayStartupDialog) {
        this.displayStartupDialog = displayStartupDialog;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> frameSize(Dimension frameSize) {
        this.frameSize = frameSize;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> loginRequired(boolean loginRequired) {
        this.loginRequired = loginRequired;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> loginPanelSouthComponent(Supplier<JComponent> loginPanelSouthComponentSupplier) {
        this.loginPanelSouthComponentSupplier = Objects.requireNonNull(loginPanelSouthComponentSupplier);
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> beforeApplicationStarted(Runnable beforeApplicationStarted) {
        this.beforeApplicationStarted = beforeApplicationStarted;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> onApplicationStarted(Consumer<P> onApplicationStarted) {
        this.onApplicationStarted = onApplicationStarted;
        return this;
    }

    @Override
    public EntityApplicationPanel.Builder<M, P> connectionProviderFactory(EntityApplicationPanel.Builder.ConnectionProviderFactory connectionProviderFactory) {
        this.connectionProviderFactory = Objects.requireNonNull(connectionProviderFactory);
        return this;
    }

    @Override
    public void start() {
        this.start(true);
    }

    @Override
    public void start(boolean onEventDispatchThread) {
        if (onEventDispatchThread) {
            SwingUtilities.invokeLater(new ApplicationStarter());
        } else {
            this.startApplication();
        }
    }

    private void startApplication() {
        LOG.debug("{} application starting", (Object)this.applicationName);
        if (this.setUncaughtExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(new DisplayUncaughtExceptionAndExit());
        }
        this.setVersionProperty();
        this.enableLookAndFeel();
        this.configureFontsAndIcons();
        if (this.beforeApplicationStarted != null) {
            this.beforeApplicationStarted.run();
        }
        EntityConnectionProvider connectionProvider = this.initializeConnectionProvider(this.initializeUser());
        long initializationStarted = System.currentTimeMillis();
        if (this.displayStartupDialog) {
            ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog((ProgressWorker.ResultTask)new InitializeApplicationModel(connectionProvider)).title(this.applicationName)).icon(this.applicationIcon)).border(Borders.emptyBorder()).westPanel(this.createStartupIconPanel()).onResult((Consumer)new StartApplication(initializationStarted)).onException((Consumer)new DisplayExceptionAndExit()).execute();
        } else {
            this.startApplication(this.initializeApplicationModel(connectionProvider), initializationStarted);
        }
    }

    private void enableLookAndFeel() {
        try {
            LookAndFeelProvider.findLookAndFeelProvider((String)this.lookAndFeelClassName()).orElse(LookAndFeelProvider.lookAndFeelProvider((UIManager.LookAndFeelInfo)new UIManager.LookAndFeelInfo("LookAndFeel", this.lookAndFeelClassName()))).enable();
        }
        catch (Exception e) {
            LOG.error("Exception while enabling Look and Feel", (Throwable)e);
        }
    }

    private String lookAndFeelClassName() {
        if (this.lookAndFeelClassName != null) {
            return this.lookAndFeelClassName;
        }
        return UserPreferences.getUserPreference((String)this.applicationLookAndFeelProperty, (String)this.defaultLookAndFeelClassName);
    }

    private void configureFontsAndIcons() {
        int fontSizePercentage = this.fontSizePercentage();
        int logoSize = 68;
        if (fontSizePercentage != 100) {
            Utilities.setFontSizePercentage((int)fontSizePercentage);
            Icons.ICON_SIZE.set((Object)Math.round((float)((Integer)Icons.ICON_SIZE.get()).intValue() * ((float)fontSizePercentage / 100.0f)));
            logoSize = Math.round((float)logoSize * ((float)fontSizePercentage / 100.0f));
        }
        if (this.applicationIcon == null) {
            this.applicationIcon = FrameworkIcons.instance().logo(logoSize);
        }
    }

    private int fontSizePercentage() {
        return Integer.parseInt(UserPreferences.getUserPreference((String)this.applicationFontSizeProperty, (String)"100"));
    }

    private void setVersionProperty() {
        if (this.applicationVersion != null) {
            System.setProperty(CODION_APPLICATION_VERSION, this.applicationVersion.toString());
        }
    }

    private void startApplication(M applicationModel, long initializationStarted) {
        P applicationPanel = this.initializeApplicationPanel(applicationModel);
        JFrame applicationFrame = this.applicationFrame(applicationPanel);
        if (this.setUncaughtExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(new DisplayUncaughtExceptionHandler(applicationFrame));
        }
        LOG.info("{}, application started successfully: {} ms", (Object)applicationFrame.getTitle(), (Object)(System.currentTimeMillis() - initializationStarted));
        if (this.displayFrame) {
            applicationFrame.setVisible(true);
        }
        if (this.onApplicationStarted != null) {
            this.onApplicationStarted.accept(applicationPanel);
        }
    }

    private User initializeUser() {
        if (this.automaticLoginUser != null) {
            return this.automaticLoginUser;
        }
        if (!this.loginRequired) {
            return null;
        }
        User user = this.loginProvider.login();
        if (this.saveDefaultUsername) {
            UserPreferences.setUserPreference((String)this.applicationDefaultUsernameProperty, (String)user.username());
        }
        return user;
    }

    private M initializeApplicationModel(EntityConnectionProvider connectionProvider) {
        return (M)((SwingEntityApplicationModel)this.applicationModelFactory.apply(connectionProvider));
    }

    private P initializeApplicationPanel(M applicationModel) {
        EntityApplicationPanel applicationPanel = (EntityApplicationPanel)this.applicationPanelFactory.apply(applicationModel);
        applicationPanel.initialize();
        return (P)applicationPanel;
    }

    private JFrame applicationFrame(P applicationPanel) {
        JMenuBar menuBar;
        JFrame frame = this.frameSupplier.get();
        frame.setDefaultCloseOperation(0);
        frame.setIconImage(this.applicationIcon.getImage());
        frame.addWindowListener(new ExitOnClose((EntityApplicationPanel<?>)applicationPanel));
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)applicationPanel, "Center");
        if (this.frameSize != null) {
            frame.setSize(this.frameSize);
        } else {
            frame.pack();
            Windows.setSizeWithinScreenBounds((Window)frame);
        }
        frame.setLocationRelativeTo(null);
        if (this.maximizeFrame) {
            frame.setExtendedState(6);
        }
        if (this.frameTitleProvider != null) {
            frame.setTitle((String)this.frameTitleProvider.get());
            this.frameTitleProvider.addConsumer((Consumer)new FrameTitleConsumer(frame));
        } else {
            frame.setTitle(this.createDefaultFrameTitle(((EntityApplicationPanel)applicationPanel).applicationModel()));
        }
        if (this.includeMainMenu && (menuBar = ((EntityApplicationPanel)applicationPanel).createMenuBar()) != null) {
            frame.setJMenuBar(menuBar);
        }
        frame.setAlwaysOnTop((Boolean)((EntityApplicationPanel)applicationPanel).alwaysOnTop().get());
        return frame;
    }

    private String createDefaultFrameTitle(M applicationModel) {
        StringBuilder builder = new StringBuilder(this.applicationName);
        if (this.applicationVersion != null) {
            if (builder.length() > 0) {
                builder.append(DASH);
            }
            builder.append(this.applicationVersion);
        }
        if (builder.length() > 0) {
            builder.append(DASH);
        }
        builder.append(DefaultEntityApplicationPanelBuilder.userInfo(applicationModel.connectionProvider()));
        return builder.toString();
    }

    private JPanel createStartupIconPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        if (this.applicationIcon != null) {
            panel.add((Component)new JLabel(this.applicationIcon), "Center");
        }
        return panel;
    }

    private EntityConnectionProvider initializeConnectionProvider(User user) {
        if (this.loginProvider instanceof DefaultDialogLoginProvider && ((DefaultDialogLoginProvider)this.loginProvider).loginValidator.connectionProvider != null) {
            return ((DefaultDialogLoginProvider)this.loginProvider).loginValidator.connectionProvider;
        }
        return this.initializeConnectionProvider(user, this.domainType, this.applicationPanelClass.getName(), this.applicationVersion);
    }

    private EntityConnectionProvider initializeConnectionProvider(User user, DomainType domainType, String clientTypeId, Version clientVersion) {
        return this.connectionProviderFactory.createConnectionProvider(user, domainType, clientTypeId, clientVersion);
    }

    private static String userInfo(EntityConnectionProvider connectionProvider) {
        String description = connectionProvider.description();
        return DefaultEntityApplicationPanelBuilder.removeUsernamePrefix(connectionProvider.user().username().toUpperCase()) + (String)(description != null ? "@" + description.toUpperCase() : "");
    }

    private static String removeUsernamePrefix(String username) {
        String usernamePrefix = (String)EntityApplicationModel.USERNAME_PREFIX.get();
        if (!Text.nullOrEmpty((String)usernamePrefix) && username.toUpperCase().startsWith(usernamePrefix.toUpperCase())) {
            return username.substring(usernamePrefix.length());
        }
        return username;
    }

    private static void displayExceptionAndExit(Throwable exception) {
        if (exception instanceof CancelException) {
            System.exit(0);
        } else {
            DefaultEntityApplicationPanelBuilder.displayException(exception, null);
            System.exit(1);
        }
    }

    private static void displayException(Throwable exception, JFrame applicationFrame) {
        if (!(exception instanceof CancelException)) {
            Window focusOwnerParentWindow = Utilities.parentWindow((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
            Dialogs.displayExceptionDialog((Throwable)exception, (Window)(focusOwnerParentWindow == null ? applicationFrame : focusOwnerParentWindow));
        }
    }

    private static final class DefaultConnectionProviderFactory
    implements EntityApplicationPanel.Builder.ConnectionProviderFactory {
        private DefaultConnectionProviderFactory() {
        }
    }

    private final class DefaultApplicationModelFactory
    implements Function<EntityConnectionProvider, M> {
        private DefaultApplicationModelFactory() {
        }

        @Override
        public M apply(EntityConnectionProvider connectionProvider) {
            try {
                return (SwingEntityApplicationModel)DefaultEntityApplicationPanelBuilder.this.applicationModelClass.getConstructor(EntityConnectionProvider.class).newInstance(connectionProvider);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class DefaultApplicationPanelFactory
    implements Function<M, P> {
        private DefaultApplicationPanelFactory() {
        }

        @Override
        public P apply(M model) {
            try {
                return (EntityApplicationPanel)DefaultEntityApplicationPanelBuilder.this.applicationPanelClass.getConstructor(model.getClass()).newInstance(model);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class DefaultDialogLoginProvider
    implements EntityApplicationPanel.Builder.LoginProvider {
        private final DefaultLoginValidator loginValidator;

        private DefaultDialogLoginProvider() {
            this.loginValidator = new DefaultLoginValidator();
        }

        @Override
        public User login() {
            return ((LoginDialogBuilder)((LoginDialogBuilder)Dialogs.loginDialog().defaultUser(DefaultEntityApplicationPanelBuilder.this.defaultLoginUser).validator((LoginDialogBuilder.LoginValidator)this.loginValidator).title(this.loginDialogTitle())).icon(DefaultEntityApplicationPanelBuilder.this.applicationIcon)).southComponent(DefaultEntityApplicationPanelBuilder.this.loginPanelSouthComponentSupplier.get()).show();
        }

        private String loginDialogTitle() {
            StringBuilder builder = new StringBuilder(DefaultEntityApplicationPanelBuilder.this.applicationName);
            if (builder.length() > 0 && DefaultEntityApplicationPanelBuilder.this.applicationVersion != null) {
                builder.append(DefaultEntityApplicationPanelBuilder.DASH).append(DefaultEntityApplicationPanelBuilder.this.applicationVersion);
            }
            if (builder.length() > 0) {
                builder.append(DefaultEntityApplicationPanelBuilder.DASH);
            }
            return builder.append(Messages.login()).toString();
        }
    }

    private static final class DefaultFrameSupplier
    implements Supplier<JFrame> {
        private DefaultFrameSupplier() {
        }

        @Override
        public JFrame get() {
            return new JFrame();
        }
    }

    private static final class DefaultSouthComponentSupplier
    implements Supplier<JComponent> {
        private DefaultSouthComponentSupplier() {
        }

        @Override
        public JComponent get() {
            return null;
        }
    }

    private final class ApplicationStarter
    implements Runnable {
        private ApplicationStarter() {
        }

        @Override
        public void run() {
            DefaultEntityApplicationPanelBuilder.this.startApplication();
        }
    }

    private static class DisplayUncaughtExceptionAndExit
    implements Thread.UncaughtExceptionHandler {
        private DisplayUncaughtExceptionAndExit() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable e) {
            DefaultEntityApplicationPanelBuilder.displayExceptionAndExit(e);
        }
    }

    private final class InitializeApplicationModel
    implements ProgressWorker.ResultTask<M> {
        private final EntityConnectionProvider connectionProvider;

        private InitializeApplicationModel(EntityConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public M execute() throws Exception {
            return DefaultEntityApplicationPanelBuilder.this.initializeApplicationModel(this.connectionProvider);
        }
    }

    private final class StartApplication
    implements Consumer<M> {
        private final long initializationStarted;

        private StartApplication(long initializationStarted) {
            this.initializationStarted = initializationStarted;
        }

        @Override
        public void accept(M applicationModel) {
            DefaultEntityApplicationPanelBuilder.this.startApplication(applicationModel, this.initializationStarted);
        }
    }

    private static class DisplayExceptionAndExit
    implements Consumer<Exception> {
        private DisplayExceptionAndExit() {
        }

        @Override
        public void accept(Exception e) {
            DefaultEntityApplicationPanelBuilder.displayExceptionAndExit(e);
        }
    }

    private static class DisplayUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final JFrame applicationFrame;

        private DisplayUncaughtExceptionHandler(JFrame applicationFrame) {
            this.applicationFrame = applicationFrame;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            DefaultEntityApplicationPanelBuilder.displayException(exception, this.applicationFrame);
        }
    }

    private static final class ExitOnClose
    extends WindowAdapter {
        private final EntityApplicationPanel<?> applicationPanel;

        private ExitOnClose(EntityApplicationPanel<?> applicationPanel) {
            this.applicationPanel = applicationPanel;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            try {
                this.applicationPanel.exit();
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    private static final class FrameTitleConsumer
    implements Consumer<String> {
        private final JFrame frame;

        public FrameTitleConsumer(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public void accept(String title) {
            SwingUtilities.invokeLater(new SetFrameTitle(this.frame, title));
        }
    }

    private final class DefaultLoginValidator
    implements LoginDialogBuilder.LoginValidator {
        private EntityConnectionProvider connectionProvider;

        private DefaultLoginValidator() {
        }

        public void validate(User user) {
            this.connectionProvider = DefaultEntityApplicationPanelBuilder.this.initializeConnectionProvider(user, DefaultEntityApplicationPanelBuilder.this.domainType, DefaultEntityApplicationPanelBuilder.this.applicationPanelClass.getName(), DefaultEntityApplicationPanelBuilder.this.applicationVersion);
            try {
                this.connectionProvider.connection();
            }
            catch (Exception e) {
                this.connectionProvider.close();
                this.connectionProvider = null;
                throw e;
            }
        }
    }

    private static class SetFrameTitle
    implements Runnable {
        private final JFrame frame;
        private final String title;

        private SetFrameTitle(JFrame frame, String title) {
            this.frame = frame;
            this.title = title;
        }

        @Override
        public void run() {
            this.frame.setTitle(this.title);
        }
    }
}

