/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.framework.ui.ControlConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Action;

abstract class DefaultControlConfig<T extends Enum<T>, C extends ControlConfig<T, C>>
implements ControlConfig<T, C> {
    private static final MenuItem SEPARATOR = new Separator();
    private final List<T> defaults;
    private final T additionalControls;
    private final List<MenuItem> items = new ArrayList<MenuItem>();
    private final Additional additional = new Additional();

    protected DefaultControlConfig(T additionalControls, List<T> defaults) {
        this.defaults = defaults;
        this.additionalControls = additionalControls;
        this.defaults();
    }

    @Override
    public final C separator() {
        if (this.items.isEmpty() || this.items.get(this.items.size() - 1) != SEPARATOR) {
            this.items.add(SEPARATOR);
        }
        return (C)this;
    }

    @Override
    public final C standard(T control) {
        this.add((Enum)Objects.requireNonNull(control));
        return (C)this;
    }

    @Override
    public final C control(Control control) {
        this.items.add(new CustomControl(Objects.requireNonNull(control)));
        return (C)this;
    }

    @Override
    public final C clear() {
        this.items.clear();
        return (C)this;
    }

    @Override
    public final C defaults() {
        return this.defaults(null);
    }

    @Override
    public final C defaults(T stopBefore) {
        for (Enum control : this.defaults) {
            if (stopBefore != null && control == stopBefore) {
                return (C)this;
            }
            if (control == null) {
                this.separator();
                continue;
            }
            if (control == this.additionalControls && !this.items.contains(this.additional)) {
                this.items.add(this.additional);
                continue;
            }
            this.add(control);
        }
        return (C)this;
    }

    @Override
    public final Controls createControls() {
        Controls created = Controls.controls();
        this.items.forEach(item -> item.addTo(created));
        return created;
    }

    protected abstract Optional<Control> control(T var1);

    private void add(T tableControl) {
        StandardControl<Enum> standardControl = new StandardControl<Enum>((Enum)tableControl, (Function<Enum, Optional<Control>>)((Function<Enum, Optional>)this::control));
        if (!this.items.contains(standardControl)) {
            this.items.add(standardControl);
        }
    }

    private final class Additional
    implements MenuItem {
        private Additional() {
        }

        @Override
        public void addTo(Controls popupControls) {
            DefaultControlConfig.this.control(DefaultControlConfig.this.additionalControls).map(Controls.class::cast).ifPresent(controlsToAdd -> this.add((Controls)controlsToAdd, popupControls));
        }

        private void add(Controls controls, Controls popupControls) {
            controls.actions().forEach(action -> {
                if (action == null) {
                    popupControls.addSeparator();
                } else {
                    popupControls.add(action);
                }
            });
            if (controls.notEmpty()) {
                popupControls.addSeparator();
            }
        }
    }

    private static interface MenuItem {
        public void addTo(Controls var1);
    }

    private static final class CustomControl
    implements MenuItem {
        private final Control control;

        private CustomControl(Control control) {
            this.control = control;
        }

        @Override
        public void addTo(Controls popupControls) {
            popupControls.add((Action)this.control);
        }
    }

    private static final class StandardControl<T>
    implements MenuItem {
        private final T tableControl;
        private final Function<T, Optional<Control>> controls;

        private StandardControl(T tableControl, Function<T, Optional<Control>> controls) {
            this.tableControl = tableControl;
            this.controls = controls;
        }

        @Override
        public void addTo(Controls popupControls) {
            this.controls.apply(this.tableControl).ifPresent(control -> {
                if (control instanceof Controls) {
                    if (((Controls)control).notEmpty()) {
                        popupControls.add((Action)control);
                    }
                } else if (control != null) {
                    popupControls.add((Action)control);
                }
            });
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StandardControl)) {
                return false;
            }
            StandardControl that = (StandardControl)object;
            return this.tableControl == that.tableControl;
        }

        public int hashCode() {
            return Objects.hash(this.tableControl);
        }
    }

    private static final class Separator
    implements MenuItem {
        private Separator() {
        }

        @Override
        public void addTo(Controls popupControls) {
            List actions = popupControls.actions();
            if (actions.isEmpty() || actions.get(actions.size() - 1) != Controls.SEPARATOR) {
                popupControls.addSeparator();
            }
        }
    }
}

