/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedDetailLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class WindowDetailLayout
implements EntityPanel.DetailLayout {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TabbedDetailLayout.class.getName());
    private static final String DETAIL_TABLES = "detail_tables";
    private static final Value.Validator<EntityPanel.PanelState> PANEL_STATE_VALIDATOR = new RejectEmbedded();
    private final EntityPanel entityPanel;
    private final Map<EntityPanel, DetailWindow> panelWindows = new HashMap<EntityPanel, DetailWindow>();
    private final EntityPanel.WindowType windowType;
    private final WindowDetailController detailController = new WindowDetailController();

    private WindowDetailLayout(DefaultBuilder builder) {
        this.entityPanel = builder.entityPanel;
        this.windowType = builder.windowType;
    }

    @Override
    public Optional<JComponent> layout() {
        if (this.entityPanel.detailPanels().isEmpty()) {
            throw new IllegalStateException("EntityPanel " + this.entityPanel + " has no detail panels");
        }
        if (!this.panelWindows.isEmpty()) {
            throw new IllegalStateException("EntityPanel " + this.entityPanel + " has already been laid out");
        }
        this.entityPanel.detailPanels().forEach(this::addDetailPanel);
        this.entityPanel.detailPanels().forEach(this::bindEvents);
        this.setupControls(this.entityPanel);
        return Optional.empty();
    }

    @Override
    public Optional<EntityPanel.DetailController> controller() {
        return Optional.of(this.detailController);
    }

    public static Builder builder(EntityPanel entityPanel) {
        return new DefaultBuilder(entityPanel);
    }

    private void addDetailPanel(EntityPanel detailPanel) {
        this.panelWindows.put(detailPanel, new DetailWindow(detailPanel));
    }

    private void bindEvents(EntityPanel detailPanel) {
        detailPanel.activateEvent().addConsumer(this.detailController::activated);
    }

    private void setupControls(EntityPanel entityPanel) {
        if (entityPanel.containsTablePanel()) {
            ((EntityTablePanel)entityPanel.tablePanel()).addPopupMenuControls((Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString(DETAIL_TABLES))).smallIcon((Icon)FrameworkIcons.instance().detail())).controls((Control[])entityPanel.detailPanels().stream().map(detailPanel -> Control.builder((Control.Command)this.windowCommand((EntityPanel)detailPanel)).name(detailPanel.caption()).smallIcon((Icon)detailPanel.icon().orElse(null)).build()).toArray(Control[]::new)).build());
        }
    }

    private Control.Command windowCommand(EntityPanel detailPanel) {
        return () -> this.panelWindows.get((Object)detailPanel).panelState.set((Object)EntityPanel.PanelState.WINDOW);
    }

    private final class WindowDetailController
    implements EntityPanel.DetailController {
        private WindowDetailController() {
        }

        @Override
        public Value<EntityPanel.PanelState> panelState(EntityPanel detailPanel) {
            return this.detailWindow((EntityPanel)detailPanel).panelState;
        }

        @Override
        public void activated(EntityPanel detailPanel) {
            Window panelWindow = this.detailWindow((EntityPanel)detailPanel).window;
            if (panelWindow != null && panelWindow.isShowing()) {
                panelWindow.toFront();
            }
        }

        private DetailWindow detailWindow(EntityPanel detailPanel) {
            DetailWindow detailWindow = WindowDetailLayout.this.panelWindows.get(Objects.requireNonNull(detailPanel));
            if (detailWindow == null) {
                throw new IllegalArgumentException("Detail panel not found: " + detailPanel);
            }
            return detailWindow;
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final EntityPanel entityPanel;
        private EntityPanel.WindowType windowType;

        private DefaultBuilder(EntityPanel entityPanel) {
            this.entityPanel = Objects.requireNonNull(entityPanel);
            this.windowType = entityPanel.windowType();
        }

        @Override
        public Builder windowType(EntityPanel.WindowType windowType) {
            this.windowType = Objects.requireNonNull(windowType);
            return this;
        }

        @Override
        public WindowDetailLayout build() {
            return new WindowDetailLayout(this);
        }
    }

    private final class DetailWindow {
        private final Value<EntityPanel.PanelState> panelState = Value.nonNull((Object)((Object)EntityPanel.PanelState.HIDDEN)).notify(Value.Notify.WHEN_SET).validator(PANEL_STATE_VALIDATOR).consumer(this::updateDetailState).build();
        private final EntityPanel detailPanel;
        private Window window;
        private boolean initialized = false;

        private DetailWindow(EntityPanel detailPanel) {
            this.detailPanel = detailPanel;
        }

        private void updateDetailState(EntityPanel.PanelState panelState) {
            if (this.window == null) {
                this.window = this.createDetailWindow();
            }
            if (panelState == EntityPanel.PanelState.WINDOW) {
                this.detailPanel.initialize();
                if (!this.initialized) {
                    this.window.pack();
                    this.detailPanel.requestInitialFocus();
                    this.initialized = true;
                }
                this.window.setVisible(true);
                this.window.toFront();
            } else {
                this.window.setVisible(false);
            }
            Object detailModel = this.detailPanel.model();
            if (WindowDetailLayout.this.entityPanel.model().containsDetailModel(detailModel)) {
                WindowDetailLayout.this.entityPanel.model().detailModelLink(detailModel).active().set((Object)(panelState == EntityPanel.PanelState.WINDOW ? 1 : 0));
            }
        }

        private Window createDetailWindow() {
            if (WindowDetailLayout.this.windowType == EntityPanel.WindowType.FRAME) {
                return Windows.frame((JComponent)this.detailPanel).locationRelativeTo((Component)WindowDetailLayout.this.entityPanel).title(this.detailPanel.caption()).icon((ImageIcon)this.detailPanel.icon().orElse(null)).onClosing(windowEvent -> WindowDetailLayout.this.panelWindows.get((Object)this.detailPanel).panelState.set((Object)EntityPanel.PanelState.HIDDEN)).build();
            }
            return ((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.detailPanel).owner((Component)WindowDetailLayout.this.entityPanel)).locationRelativeTo((Component)WindowDetailLayout.this.entityPanel)).title(this.detailPanel.caption())).icon((ImageIcon)this.detailPanel.icon().orElse(null))).modal(false).onClosed(windowEvent -> WindowDetailLayout.this.panelWindows.get((Object)this.detailPanel).panelState.set((Object)EntityPanel.PanelState.HIDDEN)).build();
        }
    }

    private static final class RejectEmbedded
    implements Value.Validator<EntityPanel.PanelState> {
        private RejectEmbedded() {
        }

        public void validate(EntityPanel.PanelState panelState) {
            if (panelState == EntityPanel.PanelState.EMBEDDED) {
                throw new IllegalArgumentException("WindowedDetailLayout does not support the EMBEDDED PanelState");
            }
        }
    }

    public static interface Builder {
        public Builder windowType(EntityPanel.WindowType var1);

        public WindowDetailLayout build();
    }
}

