/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.i18n.Messages;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

final class KeyboardShortcutsPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(KeyboardShortcutsPanel.class.getName());
    private static final int VERTICAL_UNIT_INCREMENT = 16;
    private static final String ALT = "Alt + ";
    private static final String CTRL = "Ctrl + ";
    private static final String SHIFT = "Shift + ";
    private static final String INSERT = "Insert";
    private static final String ENTER = "Enter";
    private static final String LEFT_RIGHT = "\u2190/\u2192";
    private static final String UP_DOWN = "\u2191/\u2193";
    private static final String DOWN_UP = "\u2193/\u2191";
    private static final String UP = "\u2191";
    private static final String DOWN = "\u2193";
    private static final String OR = " or ";

    KeyboardShortcutsPanel() {
        super(Layouts.borderLayout());
        ((ScrollPaneBuilder)Components.flexibleGridLayoutPanel((int)0, (int)1).add((JComponent)KeyboardShortcutsPanel.navigation()).add((JComponent)KeyboardShortcutsPanel.resizing()).add((JComponent)KeyboardShortcutsPanel.focusTransferral()).add((JComponent)KeyboardShortcutsPanel.editPanel()).add((JComponent)KeyboardShortcutsPanel.tablePanel()).add((JComponent)KeyboardShortcutsPanel.conditionPanel()).add((JComponent)KeyboardShortcutsPanel.searchField()).add((JComponent)KeyboardShortcutsPanel.dateTimeField()).add((JComponent)KeyboardShortcutsPanel.calendar()).add((JComponent)KeyboardShortcutsPanel.entityField()).add((JComponent)KeyboardShortcutsPanel.textFieldPanel()).add((JComponent)KeyboardShortcutsPanel.dependencies()).scrollPane().verticalUnitIncrement(16).onBuild(KeyboardShortcutsPanel::addScrollKeyEvents)).build(this::add);
    }

    private static JPanel navigation() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("navigate_up_down")), new JLabel("Ctrl + Alt + \u2191/\u2193")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("navigate_left_right")), new JLabel("Ctrl + Alt + \u2190/\u2192")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("navigation")))).build();
    }

    private static JPanel resizing() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("resize_left_right")), new JLabel("Shift + Alt + \u2190/\u2192")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("toggle_edit_panel")), new JLabel("Ctrl + Alt + E")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("resizing")))).build();
    }

    private static JPanel focusTransferral() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_edit_panel")), new JLabel("Ctrl + E")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_table")), new JLabel("Ctrl + T")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_input_field")), new JLabel("Ctrl + I")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_search_field")), new JLabel("Ctrl + S")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_find_in_table")), new JLabel("Ctrl + F")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("transfer_focus")))).build();
    }

    private static JPanel editPanel() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_to_next_input_field")), new JLabel(ENTER)}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("transfer_focus_to_previous_input_field")), new JLabel("Shift + Enter")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("add")), new JLabel(ALT + FrameworkMessages.addMnemonic())}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("save")), new JLabel(ALT + FrameworkMessages.saveMnemonic())}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("update")), new JLabel(ALT + FrameworkMessages.updateMnemonic())}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("delete")), new JLabel(ALT + FrameworkMessages.deleteMnemonic())}).addAll(new JComponent[]{new JLabel(Messages.clear()), new JLabel(ALT + Messages.clearMnemonic())}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("refresh")), new JLabel(ALT + Messages.refreshMnemonic())}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("edit_panel")))).build();
    }

    private static JPanel tablePanel() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("add_new_item")), new JLabel(INSERT)}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("edit_selected_item")), new JLabel("Ctrl + Insert")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("edit_value")), new JLabel("Shift + Insert")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("delete_selected")), new JLabel("Delete")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("copy_selected_rows")), new JLabel("Ctrl + C")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("copy_selected_cell")), new JLabel("Ctrl + Alt + C")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("move_selected_column")), new JLabel("Ctrl + Shift + \u2190/\u2192")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("resize_selected_column")), new JLabel("Ctrl + +/-")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("show_popup_menu")), new JLabel("Ctrl + G")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("print")), new JLabel("Ctrl + P")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("refresh_button")), new JLabel("F5")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("toggle_condition_panel")), new JLabel("Ctrl + Alt + S")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("select_condition_panel")), new JLabel("Ctrl + S")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("toggle_filter_panel")), new JLabel("Ctrl + Alt + F")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("select_filter_panel")), new JLabel("Ctrl + Shift + F")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("toggle_column_sort")), new JLabel("Alt + \u2193")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("toggle_column_sort_add")), new JLabel("Alt + \u2191")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("table_panel")))).build();
    }

    private static JPanel conditionPanel() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_operator")), new JLabel("Ctrl + \u2191/\u2193")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("enable_disable_condition")), new JLabel("Ctrl + Enter")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("refresh_table_data")), new JLabel(ENTER)}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("condition_panel")))).build();
    }

    private static JPanel searchField() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("find_next")), new JLabel("Enter or \u2193")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("find_and_select_next")), new JLabel("Shift + Enter or \u2193")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("find_previous")), new JLabel(UP)}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("find_and_select_previous")), new JLabel("Shift + \u2191")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("move_focus_to_table")), new JLabel("Esc")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("table_search_field")))).build();
    }

    private static JPanel dateTimeField() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("display_calendar")), new JLabel(INSERT)}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("increment_decrement")), new JLabel(UP_DOWN)}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("date_time_field")))).build();
    }

    private static JPanel calendar() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_year")), new JLabel("Ctrl + \u2193/\u2191")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_month")), new JLabel("Shift + \u2193/\u2191")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_day")), new JLabel("Alt + \u2190/\u2192")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_week")), new JLabel("Alt + \u2191/\u2193")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_hour")), new JLabel("Shift + Alt + \u2193/\u2191")}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("previous_next_minute")), new JLabel("Ctrl + Alt + \u2193/\u2191")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("calendar")))).build();
    }

    private static JPanel entityField() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("add_new_item")), new JLabel(INSERT)}).addAll(new JComponent[]{new JLabel(MESSAGES.getString("edit_selected_item")), new JLabel("Ctrl + Insert")}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("entity_field")))).build();
    }

    private static JPanel textFieldPanel() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("display_input_dialog")), new JLabel(INSERT)}).border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("text_field_panel")))).build();
    }

    private static JPanel dependencies() {
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).addAll(new JComponent[]{new JLabel(MESSAGES.getString("navigate_left_right")), new JLabel("Ctrl + Alt + \u2190/\u2192")}).border((Border)BorderFactory.createTitledBorder(FrameworkMessages.dependencies()))).build();
    }

    private static void addScrollKeyEvents(JScrollPane scrollPane) {
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        KeyEvents.builder((int)38).action((Action)Control.control(() -> verticalScrollBar.setValue(verticalScrollBar.getValue() - 16))).enable(new JComponent[]{scrollPane});
        KeyEvents.builder((int)40).action((Action)Control.control(() -> verticalScrollBar.setValue(verticalScrollBar.getValue() + 16))).enable(new JComponent[]{scrollPane});
    }
}

