/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.NullOrEmpty;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSelectionModel;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.ColumnSummaryPanel;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilteredTableCellRendererFactory;
import is.codion.swing.common.ui.component.table.FilteredTableColumnComponentPanel;
import is.codion.swing.common.ui.component.table.FilteredTableConditionPanel;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.ComboBoxEnterPressedAction;
import is.codion.swing.framework.ui.EntityConditionPanelFactory;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityDialogs;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.EntityTableCellEditor;
import is.codion.swing.framework.ui.EntityTableCellRenderer;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTablePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTablePanel.class);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityTablePanel.class.getName());
    private static final ResourceBundle EDIT_PANEL_MESSAGES = ResourceBundle.getBundle(EntityEditPanel.class.getName());
    private static final FrameworkIcons ICONS = FrameworkIcons.instance();
    private static final int FONT_SIZE_TO_ROW_HEIGHT = 4;
    private static final Consumer<Config> NO_CONFIGURATION = c -> {};
    private final State conditionPanelVisibleState = State.state((boolean)((Boolean)Config.CONDITION_PANEL_VISIBLE.get()));
    private final State filterPanelVisibleState = State.state((boolean)((Boolean)Config.FILTER_PANEL_VISIBLE.get()));
    private final State summaryPanelVisibleState = State.state((boolean)((Boolean)Config.SUMMARY_PANEL_VISIBLE.get()));
    private final EntityEditPanel editPanel;
    private final Map<TableControl, Value<Control>> controls = this.createControlsMap();
    private final Config configuration;
    private final SwingEntityTableModel tableModel;
    private final Control conditionRefreshControl;
    private final JToolBar refreshButtonToolBar;
    private final List<Controls> additionalPopupControls = new ArrayList<Controls>();
    private final List<Controls> additionalToolBarControls = new ArrayList<Controls>();
    private FilteredTable<Entity, Attribute<?>> table;
    private StatusPanel statusPanel;
    private JScrollPane tableScrollPane;
    private FilteredTableConditionPanel<Attribute<?>> conditionPanel;
    private JScrollPane conditionPanelScrollPane;
    private JScrollPane filterPanelScrollPane;
    private FilteredTableColumnComponentPanel<Attribute<?>, JPanel> summaryPanel;
    private JScrollPane summaryPanelScrollPane;
    private TablePanel tablePanel;
    private boolean initialized = false;

    public EntityTablePanel(SwingEntityTableModel tableModel) {
        this(tableModel, NO_CONFIGURATION);
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, Consumer<Config> configuration) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.editPanel = null;
        this.conditionRefreshControl = this.createConditionRefreshControl();
        this.configuration = this.configure(configuration);
        this.refreshButtonToolBar = this.createRefreshButtonToolBar();
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityEditPanel editPanel) {
        this(tableModel, editPanel, NO_CONFIGURATION);
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityEditPanel editPanel, Consumer<Config> configuration) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.editPanel = this.validateEditModel(Objects.requireNonNull(editPanel, "editPanel"));
        this.conditionRefreshControl = this.createConditionRefreshControl();
        this.configuration = this.configure(configuration);
        this.refreshButtonToolBar = this.createRefreshButtonToolBar();
    }

    public final FilteredTable<Entity, Attribute<?>> table() {
        if (this.table == null) {
            this.table = this.createTable();
        }
        return this.table;
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)this.tableModel;
    }

    public final FilteredTableConditionPanel<Attribute<?>> conditionPanel() {
        if (this.conditionPanel == null) {
            this.conditionPanel = this.createConditionPanel();
            if (this.conditionPanel == null) {
                throw new IllegalStateException("No condition panel is available");
            }
        }
        return this.conditionPanel;
    }

    public final State conditionPanelVisible() {
        return this.conditionPanelVisibleState;
    }

    public final State filterPanelVisible() {
        return this.filterPanelVisibleState;
    }

    public final State summaryPanelVisible() {
        return this.summaryPanelVisibleState;
    }

    public final void toggleConditionPanel() {
        if (this.conditionPanelScrollPane != null) {
            this.toggleConditionPanel(this.conditionPanelScrollPane, this.conditionPanel.advanced(), this.conditionPanelVisibleState);
        }
    }

    public final void toggleFilterPanel() {
        if (this.filterPanelScrollPane != null) {
            this.toggleConditionPanel(this.filterPanelScrollPane, this.table.filterPanel().advanced(), this.filterPanelVisibleState);
        }
    }

    public final void selectConditionPanel() {
        if (this.configuration.includeConditionPanel) {
            EntityTablePanel.selectConditionPanel(this.conditionPanel, this.conditionPanelScrollPane, this.conditionPanel.advanced(), this.conditionPanelVisibleState, this.tableModel, this, FrameworkMessages.selectSearchField());
        }
    }

    public final void selectFilterPanel() {
        if (this.configuration.includeFilterPanel) {
            EntityTablePanel.selectConditionPanel(this.table.filterPanel(), this.filterPanelScrollPane, this.table.filterPanel().advanced(), this.filterPanelVisibleState, this.tableModel, this, FrameworkMessages.selectFilterField());
        }
    }

    public void addPopupMenuControls(Controls additionalPopupMenuControls) {
        this.throwIfInitialized();
        this.additionalPopupControls.add(Objects.requireNonNull(additionalPopupMenuControls));
    }

    public void addToolBarControls(Controls additionalToolBarControls) {
        this.throwIfInitialized();
        this.additionalToolBarControls.add(Objects.requireNonNull(additionalToolBarControls));
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.tableModel.entityType();
    }

    public final Value<Control> control(TableControl tableControl) {
        return this.controls.get((Object)Objects.requireNonNull(tableControl));
    }

    public final void editSelected() {
        List sortedDefinitions = ((Set)this.configuration.editable.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).collect(Collectors.toList());
        ((SelectionDialogBuilder)Dialogs.selectionDialog(sortedDefinitions).owner((Component)this)).selectSingle().map(AttributeDefinition::attribute).ifPresent(this::editSelected);
    }

    public final void editSelected(Attribute<?> attributeToEdit) {
        Objects.requireNonNull(attributeToEdit);
        if (!this.tableModel.selectionModel().isSelectionEmpty()) {
            this.editDialogBuilder(attributeToEdit).edit(this.tableModel.selectionModel().getSelectedItems());
        }
    }

    public final void viewDependencies() {
        if (!this.tableModel.selectionModel().isSelectionEmpty()) {
            EntityDependenciesPanel.displayDependenciesDialog(this.tableModel.selectionModel().getSelectedItems(), this.tableModel.connectionProvider(), this);
        }
    }

    public final boolean deleteSelectedWithConfirmation() {
        if (this.confirmDelete()) {
            return this.deleteSelected();
        }
        return false;
    }

    public final boolean deleteSelected() {
        try {
            this.tableModel.deleteSelected();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public final EntityTablePanel initialize() {
        if (!this.initialized) {
            try {
                this.setupComponents();
                this.setupStandardControls();
                this.setupControls();
                this.addTablePopupMenu();
                this.layoutPanel(this.tablePanel, this.configuration.includeSouthPanel ? this.initializeSouthPanel() : null);
                this.setConditionPanelVisible((Boolean)this.conditionPanelVisibleState.get());
                this.setFilterPanelVisible((Boolean)this.filterPanelVisibleState.get());
                this.setSummaryPanelVisible((Boolean)this.summaryPanelVisibleState.get());
                this.bindEvents();
                this.setupKeyboardActions();
                Utilities.updateComponentTreeUI((JComponent[])new JComponent[]{this});
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    protected void setupControls() {
    }

    protected JPanel initializeSouthPanel() {
        return new SouthPanel();
    }

    protected void setupKeyboardActions() {
        this.control(TableControl.REQUEST_TABLE_FOCUS).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_TABLE_FOCUS).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
        this.control(TableControl.SELECT_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
        this.control(TableControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
        this.control(TableControl.TOGGLE_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
        this.control(TableControl.SELECT_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
        this.control(TableControl.PRINT).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.PRINT).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
        this.control(TableControl.ADD).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.ADD).get())).condition(1).action((Action)control).enable(new JComponent[]{this.table}));
        this.control(TableControl.EDIT).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.EDIT).get())).condition(1).action((Action)control).enable(new JComponent[]{this.table}));
        this.control(TableControl.EDIT_SELECTED_ATTRIBUTE).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.EDIT_SELECTED_ATTRIBUTE).get())).condition(1).action((Action)control).enable(new JComponent[]{this.table}));
        this.control(TableControl.DELETE).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.DELETE).get())).action((Action)control).enable(new JComponent[]{this.table}));
        if (this.configuration.includeEntityMenu) {
            KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.DISPLAY_ENTITY_MENU).get())).action((Action)Control.control(this::showEntityMenu)).enable(new JComponent[]{this.table});
        }
    }

    protected Controls createToolBarControls(List<Controls> additionalToolBarControls) {
        Objects.requireNonNull(additionalToolBarControls);
        Controls toolbarControls = Controls.controls();
        this.control(TableControl.TOGGLE_SUMMARY_PANEL).optional().ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        Control toggleConditionPanelControl = this.control(TableControl.TOGGLE_CONDITION_PANEL).optional().orElse(null);
        Control toggleFilterPanelControl = this.control(TableControl.TOGGLE_FILTER_PANEL).optional().orElse(null);
        if (toggleConditionPanelControl != null || toggleFilterPanelControl != null) {
            if (toggleConditionPanelControl != null) {
                toolbarControls.add((Action)toggleConditionPanelControl);
            }
            if (toggleFilterPanelControl != null) {
                toolbarControls.add((Action)toggleFilterPanelControl);
            }
            toolbarControls.addSeparator();
        }
        Controls editControls = Controls.controls();
        if (this.editPanel != null) {
            this.control(TableControl.ADD).optional().ifPresent(arg_0 -> ((Controls)editControls).add(arg_0));
            this.control(TableControl.EDIT).optional().ifPresent(arg_0 -> ((Controls)editControls).add(arg_0));
        } else {
            this.control(TableControl.EDIT_SELECTED_ATTRIBUTE).optional().ifPresent(arg_0 -> ((Controls)editControls).add(arg_0));
        }
        this.control(TableControl.DELETE).optional().ifPresent(arg_0 -> ((Controls)editControls).add(arg_0));
        if (editControls.notEmpty()) {
            toolbarControls.addAll(editControls);
            toolbarControls.addSeparator();
        }
        this.control(TableControl.PRINT).optional().ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        this.control(TableControl.CLEAR_SELECTION).optional().ifPresent(control -> {
            toolbarControls.add((Action)control);
            toolbarControls.addSeparator();
        });
        this.control(TableControl.MOVE_SELECTION_UP).optional().ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        this.control(TableControl.MOVE_SELECTION_DOWN).optional().ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        additionalToolBarControls.forEach(additionalControls -> {
            toolbarControls.addSeparator();
            additionalControls.actions().forEach(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        });
        return toolbarControls;
    }

    protected Controls createPopupMenuControls(List<Controls> additionalPopupMenuControls) {
        Controls columnControls;
        Objects.requireNonNull(additionalPopupMenuControls);
        Controls popupControls = Controls.controls();
        this.control(TableControl.REFRESH).optional().ifPresent(arg_0 -> ((Controls)popupControls).add(arg_0));
        this.control(TableControl.CLEAR).optional().ifPresent(arg_0 -> ((Controls)popupControls).add(arg_0));
        if (popupControls.notEmpty()) {
            popupControls.addSeparator();
        }
        State separatorRequired = State.state();
        this.control(TableControl.ADD).optional().ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        this.control(TableControl.EDIT).optional().ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        this.control(TableControl.DELETE).optional().ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        if (((Boolean)separatorRequired.get()).booleanValue()) {
            popupControls.addSeparator();
            separatorRequired.set((Object)false);
        }
        if (this.includeEditAttributeControls()) {
            if (this.configuration.editAttributeSelection == EditAttributeSelection.DIALOG) {
                this.control(TableControl.EDIT_SELECTED_ATTRIBUTE).optional().ifPresent(control -> {
                    popupControls.add((Action)control);
                    separatorRequired.set((Object)true);
                });
            } else {
                this.control(TableControl.EDIT_ATTRIBUTE).optional().ifPresent(control -> {
                    popupControls.add((Action)control);
                    separatorRequired.set((Object)true);
                });
            }
        }
        if (((Boolean)separatorRequired.get()).booleanValue()) {
            popupControls.addSeparator();
            separatorRequired.set((Object)false);
        }
        this.control(TableControl.VIEW_DEPENDENCIES).optional().ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        if (((Boolean)separatorRequired.get()).booleanValue()) {
            popupControls.addSeparator();
            separatorRequired.set((Object)false);
        }
        EntityTablePanel.addAdditionalControls(popupControls, additionalPopupMenuControls);
        Controls printControls = this.createPrintMenuControls();
        if (printControls != null && printControls.notEmpty()) {
            popupControls.add(printControls);
            separatorRequired.set((Object)true);
        }
        if ((columnControls = this.createColumnControls()).notEmpty()) {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            popupControls.add(columnControls);
            separatorRequired.set((Object)true);
        }
        this.control(TableControl.SELECTION_MODE).optional().ifPresent(control -> {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        if (this.configuration.includeConditionPanel && this.conditionPanel != null) {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            this.addConditionControls(popupControls);
            separatorRequired.set((Object)true);
        }
        if (this.configuration.includeFilterPanel) {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            this.addFilterControls(popupControls);
            separatorRequired.set((Object)true);
        }
        this.control(TableControl.COPY_TABLE_DATA).optional().ifPresent(control -> {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            popupControls.add((Action)control);
        });
        return popupControls;
    }

    protected Controls createPrintMenuControls() {
        Controls.Builder builder = (Controls.Builder)((Controls.Builder)((Controls.Builder)Controls.builder().name(Messages.print())).mnemonic(Messages.printMnemonic())).smallIcon((Icon)ICONS.print());
        this.control(TableControl.PRINT).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        return (Controls)builder.build();
    }

    protected TableCellRenderer createTableCellRenderer(Attribute<?> attribute) {
        return EntityTableCellRenderer.builder(this.tableModel, attribute).build();
    }

    protected TableCellEditor createTableCellEditor(Attribute<?> attribute) {
        if (!this.configuration.editable.contains(attribute)) {
            return null;
        }
        if (this.nonUpdatableForeignKey(attribute)) {
            return null;
        }
        return new EntityTableCellEditor(() -> this.cellEditorComponentValue(attribute, null));
    }

    protected void layoutPanel(JComponent tableComponent, JPanel southPanel) {
        Objects.requireNonNull(tableComponent, "tableComponent");
        this.setLayout(new BorderLayout());
        this.add((Component)tableComponent, "Center");
        if (southPanel != null) {
            this.add((Component)southPanel, "South");
        }
    }

    protected JToolBar createToolBar() {
        Controls toolbarControls = this.createToolBarControls(this.additionalToolBarControls);
        if (toolbarControls == null || toolbarControls.empty()) {
            return null;
        }
        return (JToolBar)((ToolBarBuilder)Components.toolBar().controls(toolbarControls)).floatable(false).rollover(true).build(toolBar -> Arrays.stream(toolBar.getComponents()).map(JComponent.class::cast).forEach(component -> component.setToolTipText(null)));
    }

    protected void onException(Exception exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)((Object)exception));
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)((Object)exception));
        } else {
            this.displayException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (this.configuration.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            EntityDependenciesPanel.displayDependenciesDialog(this.tableModel.selectionModel().getSelectedItems(), this.tableModel.connectionProvider(), (JComponent)this, EDIT_PANEL_MESSAGES.getString("unknown_dependent_records"));
        } else {
            this.displayException((Exception)((Object)exception));
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.tableModel.entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
    }

    protected <T> EntityDialogs.EditAttributeDialogBuilder<T> editDialogBuilder(Attribute<T> attribute) {
        return ((EntityDialogs.EditAttributeDialogBuilder)EntityDialogs.editAttributeDialog(this.tableModel.editModel(), attribute).owner(this)).componentFactory(this.configuration.editComponentFactories.get(attribute));
    }

    protected final void displayException(Exception exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    protected final boolean confirmDelete() {
        return this.configuration.deleteConfirmer.confirm(this);
    }

    private Control createAddControl() {
        return Control.builder(() -> ((EntityDialogs.AddEntityDialogBuilder)EntityDialogs.addEntityDialog(() -> this.editPanel).owner(this)).closeDialog(false).show()).name(FrameworkMessages.add()).mnemonic(FrameworkMessages.addMnemonic()).smallIcon((Icon)ICONS.add()).build();
    }

    private Control createEditControl() {
        return Control.builder(() -> ((EntityDialogs.EditEntityDialogBuilder)EntityDialogs.editEntityDialog(() -> this.editPanel).owner(this)).show()).name(FrameworkMessages.edit()).mnemonic(FrameworkMessages.editMnemonic()).smallIcon((Icon)ICONS.edit()).enabled(this.tableModel().selectionModel().singleSelection()).build();
    }

    private Control createEditSelectedAttributeControl() {
        return Control.builder(this::editSelected).name(FrameworkMessages.edit()).enabled(this.createEditSelectedEnabledObserver()).smallIcon((Icon)ICONS.edit()).description(FrameworkMessages.editSelectedTip()).build();
    }

    private Controls createEditAttributeControls() {
        StateObserver editSelectedEnabledObserver = this.createEditSelectedEnabledObserver();
        Controls editControls = (Controls)((Controls.Builder)((Controls.Builder)((Controls.Builder)((Controls.Builder)Controls.builder().name(FrameworkMessages.edit())).enabled(editSelectedEnabledObserver)).smallIcon((Icon)ICONS.edit())).description(FrameworkMessages.editSelectedTip())).build();
        ((Set)this.configuration.editable.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).forEach(attributeDefinition -> editControls.add((Action)Control.builder(() -> this.editSelected(attributeDefinition.attribute())).name(attributeDefinition.caption() == null ? attributeDefinition.attribute().name() : attributeDefinition.caption()).enabled(editSelectedEnabledObserver).build()));
        return editControls;
    }

    private StateObserver createEditSelectedEnabledObserver() {
        StateObserver selectionNotEmpty = this.tableModel.selectionModel().selectionNotEmpty();
        State updateEnabled = this.tableModel.editModel().updateEnabled();
        State.Combination updateMultipleEnabledOrSingleSelection = State.or((StateObserver[])new StateObserver[]{this.tableModel.editModel().updateMultipleEnabled(), this.tableModel.selectionModel().singleSelection()});
        return State.and((StateObserver[])new StateObserver[]{selectionNotEmpty, updateEnabled, updateMultipleEnabledOrSingleSelection});
    }

    private Control createViewDependenciesControl() {
        return Control.builder(this::viewDependencies).name(FrameworkMessages.dependencies()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).description(FrameworkMessages.dependenciesTip()).smallIcon((Icon)ICONS.dependencies()).build();
    }

    private Control createDeleteControl() {
        return Control.builder((Control.Command)new DeleteCommand()).name(FrameworkMessages.delete()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.tableModel.editModel().deleteEnabled(), this.tableModel.selectionModel().selectionNotEmpty()})).description(FrameworkMessages.deleteSelectedTip()).smallIcon((Icon)ICONS.delete()).build();
    }

    private Control createRefreshControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).refresh()).name(Messages.refresh()).description(Messages.refreshTip()).mnemonic(Messages.refreshMnemonic()).smallIcon((Icon)ICONS.refresh()).enabled(this.tableModel.refresher().observer().not()).build();
    }

    private Control createColumnSelectionControl() {
        return this.configuration.columnSelection == ColumnSelection.DIALOG ? this.table.createSelectColumnsControl() : this.table.createToggleColumnsControls();
    }

    private Control createClearControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).clear()).name(Messages.clear()).description(Messages.clearTip()).mnemonic(Messages.clearMnemonic()).smallIcon((Icon)ICONS.clear()).build();
    }

    private Control createToggleConditionPanelControl() {
        return Control.builder(this::toggleConditionPanel).smallIcon((Icon)ICONS.search()).description(MESSAGES.getString("show_condition_panel")).build();
    }

    private Control createSelectConditionPanelControl() {
        return Control.control(this::selectConditionPanel);
    }

    private Control createToggleFilterPanelControl() {
        return Control.builder(this::toggleFilterPanel).smallIcon((Icon)ICONS.filter()).description(MESSAGES.getString("show_filter_panel")).build();
    }

    private Control createSelectFilterPanelControl() {
        return Control.control(this::selectFilterPanel);
    }

    private Control createToggleSummaryPanelControl() {
        return ToggleControl.builder((State)this.summaryPanelVisibleState).smallIcon((Icon)ICONS.summary()).description(MESSAGES.getString("toggle_summary_tip")).build();
    }

    private Control createClearSelectionControl() {
        return Control.builder(() -> this.tableModel.selectionModel().clearSelection()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).smallIcon((Icon)ICONS.clearSelection()).description(MESSAGES.getString("clear_selection_tip")).build();
    }

    private Control createMoveSelectionDownControl() {
        return Control.builder(() -> ((FilteredTableSelectionModel)this.tableModel.selectionModel()).moveSelectionDown()).smallIcon((Icon)ICONS.down()).description(MESSAGES.getString("selection_down_tip")).build();
    }

    private Control createMoveSelectionUpControl() {
        return Control.builder(() -> ((FilteredTableSelectionModel)this.tableModel.selectionModel()).moveSelectionUp()).smallIcon((Icon)ICONS.up()).description(MESSAGES.getString("selection_up_tip")).build();
    }

    private Control createRequestTableFocusControl() {
        return Control.control(() -> this.table.requestFocus());
    }

    private Controls createColumnControls() {
        Controls.Builder builder = (Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString("columns"))).smallIcon((Icon)ICONS.columns());
        this.control(TableControl.SELECT_COLUMNS).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(TableControl.RESET_COLUMNS).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(TableControl.COLUMN_AUTO_RESIZE_MODE).optional().ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        return (Controls)builder.build();
    }

    private Control createConditionPanelControl() {
        return ToggleControl.builder((State)this.conditionPanelVisibleState).name(FrameworkMessages.show()).build();
    }

    private Control createFilterPanelControl() {
        return ToggleControl.builder((State)this.filterPanelVisibleState).name(FrameworkMessages.show()).build();
    }

    private Controls createCopyControls() {
        return (Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(Messages.copy())).smallIcon((Icon)ICONS.copy())).controls(new Control[]{this.createCopyCellControl(), this.createCopyTableRowsWithHeaderControl()}).build();
    }

    private Control createCopyCellControl() {
        return Control.builder(() -> this.table.copySelectedCell()).name(FrameworkMessages.copyCell()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).build();
    }

    private Control createCopyTableRowsWithHeaderControl() {
        return Control.builder(() -> this.table.copyRowsAsTabDelimitedString()).name(FrameworkMessages.copyTableWithHeader()).build();
    }

    private boolean includeAddControl() {
        return this.editPanel != null && this.configuration.includeAddControl && (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().insertEnabled().get() != false;
    }

    private boolean includeEditControl() {
        return this.editPanel != null && this.updatable() && this.configuration.includeEditControl;
    }

    private boolean includeEditAttributeControls() {
        return !this.configuration.editable.empty() && this.updatable() && this.configuration.includeEditAttributeControl;
    }

    private boolean updatable() {
        return (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().updateEnabled().get() != false;
    }

    private boolean includeDeleteControl() {
        return (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().deleteEnabled().get() != false;
    }

    private FilteredTable<Entity, Attribute<?>> createTable() {
        return (FilteredTable)((FilteredTable.Builder)FilteredTable.builder((FilteredTableModel)this.tableModel).cellRendererFactory((FilteredTableCellRendererFactory)new EntityTableCellRendererFactory()).onBuild(filteredTable -> filteredTable.setRowHeight(filteredTable.getFont().getSize() + 4))).build();
    }

    private Control createConditionRefreshControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).refresh()).enabled(this.tableModel.conditionChanged()).smallIcon((Icon)ICONS.refreshRequired()).build();
    }

    private <T> ComponentValue<T, ? extends JComponent> cellEditorComponentValue(Attribute<T> attribute, T initialValue) {
        return this.configuration.cellEditorComponentFactories.computeIfAbsent(attribute, a -> new DefaultEntityComponentFactory()).componentValue(attribute, this.tableModel.editModel(), initialValue);
    }

    private JToolBar createRefreshButtonToolBar() {
        KeyEvents.builder((int)116).condition(1).action((Action)this.conditionRefreshControl).enable(new JComponent[]{this});
        return (JToolBar)((ToolBarBuilder)((ToolBarBuilder)Components.toolBar().action((Action)this.conditionRefreshControl)).floatable(false).rollover(false).visible(this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || (Boolean)this.conditionPanelVisibleState.get() != false)).build();
    }

    private FilteredTableConditionPanel<Attribute<?>> createConditionPanel() {
        return this.configuration.includeConditionPanel ? FilteredTableConditionPanel.filteredTableConditionPanel((TableConditionModel)this.tableModel.conditionModel(), (FilteredTableColumnModel)this.tableModel.columnModel(), (ColumnConditionPanel.Factory)this.configuration.conditionPanelFactory) : null;
    }

    private void bindEvents() {
        this.conditionPanelVisibleState.addConsumer(this::setConditionPanelVisible);
        this.filterPanelVisibleState.addConsumer(this::setFilterPanelVisible);
        this.summaryPanelVisibleState.addConsumer(this::setSummaryPanelVisible);
        this.tableModel.conditionModel().conditionChangedEvent().addListener(this::onConditionChanged);
        this.tableModel.refresher().observer().addConsumer(this::onRefreshingChanged);
        this.tableModel.refresher().refreshFailedEvent().addConsumer(this::onException);
        this.tableModel.editModel().insertUpdateOrDeleteEvent().addListener(() -> this.table.repaint());
        if (this.conditionPanel != null) {
            this.enableConditionPanelRefreshOnEnter();
            this.conditionPanel.focusGainedEvent().addConsumer(arg_0 -> this.table.scrollToColumn(arg_0));
            this.conditionPanel.advanced().addConsumer(advanced -> {
                if (((Boolean)this.conditionPanelVisibleState.get()).booleanValue()) {
                    this.revalidate();
                }
            });
        }
        if (this.configuration.includeFilterPanel) {
            this.table.filterPanel().focusGainedEvent().addConsumer(arg_0 -> this.table.scrollToColumn(arg_0));
            this.table.filterPanel().advanced().addConsumer(advanced -> {
                if (((Boolean)this.filterPanelVisibleState.get()).booleanValue()) {
                    this.revalidate();
                }
            });
        }
    }

    private void enableConditionPanelRefreshOnEnter() {
        KeyEvents.builder((int)10).condition(1).action((Action)this.conditionRefreshControl).enable(new JComponent[]{this.conditionPanel});
        this.tableModel.columnModel().columns().stream().map(column -> this.conditionPanel.conditionPanel((Object)((Attribute)column.getIdentifier()))).filter(Optional::isPresent).map(Optional::get).flatMap(panel -> Stream.of(panel.operatorComboBox(), panel.equalField(), panel.lowerBoundField(), panel.upperBoundField())).forEach(this::enableConditionPanelRefreshOnEnter);
    }

    private void enableConditionPanelRefreshOnEnter(JComponent component) {
        if (component instanceof JComboBox) {
            new ComboBoxEnterPressedAction((JComboBox)component, (Action)this.conditionRefreshControl);
        } else if (component instanceof TemporalField) {
            ((TemporalField)component).addActionListener((ActionListener)this.conditionRefreshControl);
        }
    }

    private void setConditionPanelVisible(boolean visible) {
        if (this.conditionPanelScrollPane != null) {
            this.conditionPanelScrollPane.setVisible(visible);
            this.refreshButtonToolBar.setVisible(this.configuration.refreshButtonVisible == RefreshButtonVisible.ALWAYS || visible);
            this.revalidate();
        }
    }

    private void setFilterPanelVisible(boolean visible) {
        if (this.filterPanelScrollPane != null) {
            this.filterPanelScrollPane.setVisible(visible);
            this.revalidate();
        }
    }

    private void setSummaryPanelVisible(boolean visible) {
        if (this.summaryPanelScrollPane != null) {
            this.summaryPanelScrollPane.setVisible(visible);
            this.revalidate();
        }
    }

    private void setupComponents() {
        this.tableScrollPane = new JScrollPane((Component)this.table());
        this.tablePanel = new TablePanel();
        this.tableModel.columnModel().columns().forEach(this::configureColumn);
        this.conditionPanelVisibleState.addValidator((Value.Validator)new PanelAvailableValidator((JPanel)this.conditionPanel, "condition"));
        this.filterPanelVisibleState.addValidator((Value.Validator)new PanelAvailableValidator((JPanel)this.table.filterPanel(), "filter"));
        this.summaryPanelVisibleState.addValidator((Value.Validator)new PanelAvailableValidator((JPanel)this.summaryPanel, "summary"));
    }

    private void setupStandardControls() {
        if (this.includeDeleteControl()) {
            this.controls.get((Object)TableControl.DELETE).mapNull(this::createDeleteControl);
        }
        if (this.includeAddControl()) {
            this.controls.get((Object)TableControl.ADD).mapNull(this::createAddControl);
        }
        if (this.includeEditControl()) {
            this.controls.get((Object)TableControl.EDIT).mapNull(this::createEditControl);
        }
        if (this.includeEditAttributeControls()) {
            this.controls.get((Object)TableControl.EDIT_ATTRIBUTE).mapNull(this::createEditAttributeControls);
            this.controls.get((Object)TableControl.EDIT_SELECTED_ATTRIBUTE).mapNull(this::createEditSelectedAttributeControl);
        }
        if (this.configuration.includeClearControl) {
            this.controls.get((Object)TableControl.CLEAR).mapNull(this::createClearControl);
        }
        this.controls.get((Object)TableControl.REFRESH).mapNull(this::createRefreshControl);
        this.controls.get((Object)TableControl.SELECT_COLUMNS).mapNull(this::createColumnSelectionControl);
        this.controls.get((Object)TableControl.RESET_COLUMNS).mapNull(() -> this.table.createResetColumnsControl());
        this.controls.get((Object)TableControl.COLUMN_AUTO_RESIZE_MODE).mapNull(() -> this.table.createAutoResizeModeControl());
        if (this.includeViewDependenciesControl()) {
            this.controls.get((Object)TableControl.VIEW_DEPENDENCIES).mapNull(this::createViewDependenciesControl);
        }
        if (this.summaryPanelScrollPane != null) {
            this.controls.get((Object)TableControl.TOGGLE_SUMMARY_PANEL).mapNull(this::createToggleSummaryPanelControl);
        }
        if (this.configuration.includeConditionPanel && this.conditionPanel != null) {
            this.controls.get((Object)TableControl.CONDITION_PANEL_VISIBLE).mapNull(this::createConditionPanelControl);
            this.controls.get((Object)TableControl.TOGGLE_CONDITION_PANEL).mapNull(this::createToggleConditionPanelControl);
            this.controls.get((Object)TableControl.SELECT_CONDITION_PANEL).mapNull(this::createSelectConditionPanelControl);
        }
        if (this.configuration.includeFilterPanel) {
            this.controls.get((Object)TableControl.FILTER_PANEL_VISIBLE).mapNull(this::createFilterPanelControl);
            this.controls.get((Object)TableControl.TOGGLE_FILTER_PANEL).mapNull(this::createToggleFilterPanelControl);
            this.controls.get((Object)TableControl.SELECT_FILTER_PANEL).mapNull(this::createSelectFilterPanelControl);
        }
        this.controls.get((Object)TableControl.CLEAR_SELECTION).mapNull(this::createClearSelectionControl);
        this.controls.get((Object)TableControl.MOVE_SELECTION_UP).mapNull(this::createMoveSelectionDownControl);
        this.controls.get((Object)TableControl.MOVE_SELECTION_DOWN).mapNull(this::createMoveSelectionUpControl);
        this.controls.get((Object)TableControl.COPY_TABLE_DATA).mapNull(this::createCopyControls);
        if (this.configuration.includeSelectionModeControl) {
            this.controls.get((Object)TableControl.SELECTION_MODE).mapNull(() -> this.table.createSingleSelectionModeControl());
        }
        this.controls.get((Object)TableControl.REQUEST_TABLE_FOCUS).mapNull(this::createRequestTableFocusControl);
        this.controls.get((Object)TableControl.CONFIGURE_COLUMNS).mapNull(this::createColumnControls);
    }

    private boolean includeViewDependenciesControl() {
        return this.tableModel.entities().definitions().stream().flatMap(entityDefinition -> entityDefinition.foreignKeys().definitions().stream()).filter(foreignKeyDefinition -> !foreignKeyDefinition.soft()).anyMatch(foreignKeyDefinition -> foreignKeyDefinition.attribute().referencedType().equals(this.tableModel.entityType()));
    }

    private void configureColumn(FilteredTableColumn<Attribute<?>> column) {
        TableCellEditor tableCellEditor = this.createTableCellEditor((Attribute)column.getIdentifier());
        if (tableCellEditor != null) {
            column.setCellEditor(tableCellEditor);
        }
        column.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(column.getHeaderRenderer()));
    }

    private void addTablePopupMenu() {
        if (!this.configuration.includePopupMenu) {
            return;
        }
        Controls popupControls = this.createPopupMenuControls(this.additionalPopupControls);
        if (popupControls == null || popupControls.empty()) {
            return;
        }
        JPopupMenu popupMenu = Components.menu((Controls)popupControls).createPopupMenu();
        this.table.setComponentPopupMenu(popupMenu);
        this.tableScrollPane.setComponentPopupMenu(popupMenu);
        KeyEvents.builder((KeyStroke)((KeyStroke)this.configuration.shortcuts.keyStroke((Enum)KeyboardShortcut.DISPLAY_POPUP_MENU).get())).action((Action)Control.control(() -> {
            Point location = EntityTablePanel.popupLocation(this.table);
            popupMenu.show((Component)this.table, location.x, location.y);
        })).enable(new JComponent[]{this.table});
    }

    private void addConditionControls(Controls popupControls) {
        Controls conditionControls = (Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(FrameworkMessages.search())).smallIcon((Icon)ICONS.search())).build();
        this.control(TableControl.CONDITION_PANEL_VISIBLE).optional().ifPresent(arg_0 -> ((Controls)conditionControls).add(arg_0));
        Controls conditionPanelControls = this.conditionPanel.controls();
        if (conditionPanelControls.notEmpty()) {
            conditionControls.addAll(conditionPanelControls);
            conditionControls.addSeparator();
        }
        conditionControls.add((Action)ToggleControl.builder((State)this.tableModel.conditionRequired()).name(MESSAGES.getString("require_query_condition")).description(MESSAGES.getString("require_query_condition_description")).build());
        if (conditionControls.notEmpty()) {
            popupControls.add(conditionControls);
        }
    }

    private void addFilterControls(Controls popupControls) {
        Controls filterControls = (Controls)((Controls.Builder)((Controls.Builder)Controls.builder().name(FrameworkMessages.filter())).smallIcon((Icon)ICONS.filter())).build();
        this.control(TableControl.FILTER_PANEL_VISIBLE).optional().ifPresent(arg_0 -> ((Controls)filterControls).add(arg_0));
        Controls filterPanelControls = this.table.filterPanel().controls();
        if (filterPanelControls.notEmpty()) {
            filterControls.addAll(filterPanelControls);
        }
        if (filterControls.notEmpty()) {
            popupControls.add(filterControls);
        }
    }

    private void showEntityMenu() {
        Point location = EntityTablePanel.popupLocation(this.table);
        this.tableModel.selectionModel().selectedItem().ifPresent(selected -> new EntityPopupMenu(selected.copy(), this.tableModel.connection()).show((Component)this.table, location.x, location.y));
    }

    private void onConditionChanged() {
        if (this.table != null) {
            this.table.getTableHeader().repaint();
            this.table.repaint();
        }
    }

    private void onRefreshingChanged(boolean refreshing) {
        if (refreshing) {
            this.setCursor(Cursors.WAIT);
        } else {
            this.setCursor(Cursors.DEFAULT);
        }
    }

    private void toggleConditionPanel(JScrollPane scrollPane, State advancedState, State visibleState) {
        if (scrollPane != null && scrollPane.isVisible()) {
            if (((Boolean)advancedState.get()).booleanValue()) {
                boolean parentOfFocusOwner = Utilities.parentOfType(JScrollPane.class, (Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == scrollPane;
                visibleState.set((Object)false);
                if (parentOfFocusOwner) {
                    this.table.requestFocusInWindow();
                }
            } else {
                advancedState.set((Object)true);
            }
        } else {
            advancedState.set((Object)false);
            visibleState.set((Object)true);
        }
    }

    private boolean nonUpdatableForeignKey(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return foreignKey.references().stream().map(ForeignKey.Reference::column).map(referenceAttribute -> this.tableModel.entityDefinition().columns().definition(referenceAttribute)).filter(ColumnDefinition.class::isInstance).map(ColumnDefinition.class::cast).noneMatch(ColumnDefinition::updatable);
        }
        return false;
    }

    private Map<TableControl, Value<Control>> createControlsMap() {
        Value.Validator controlValueValidator = control -> {
            if (this.initialized) {
                throw new IllegalStateException("TablePanel has already been initialized");
            }
        };
        return Stream.of(TableControl.values()).collect(Collectors.toMap(Function.identity(), controlCode -> Value.nullable().validator(controlValueValidator).build()));
    }

    private EntityEditPanel validateEditModel(EntityEditPanel editPanel) {
        if (editPanel.editModel() != this.tableModel.editModel()) {
            throw new IllegalArgumentException("Edit panel model must be the same as the table edit model");
        }
        return editPanel;
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private Config configure(Consumer<Config> configuration) {
        Config config = new Config(this);
        Objects.requireNonNull(configuration).accept(config);
        return new Config(config);
    }

    private static final void selectConditionPanel(FilteredTableConditionPanel<Attribute<?>> tableConditionPanel, JScrollPane conditionPanelScrollPane, State conditionPanelAdvancedState, State conditionPanelVisibleState, SwingEntityTableModel tableModel, JComponent dialogOwner, String dialogTitle) {
        if (tableConditionPanel != null) {
            List attributes = tableConditionPanel.conditionPanels().stream().map(panel -> (Attribute)panel.model().columnIdentifier()).filter(attribute -> (Boolean)tableModel.columnModel().visible(attribute).get()).collect(Collectors.toList());
            if (attributes.size() == 1) {
                EntityTablePanel.displayConditionPanel(conditionPanelScrollPane, conditionPanelAdvancedState, conditionPanelVisibleState);
                tableConditionPanel.conditionPanel((Object)((Attribute)attributes.get(0))).ifPresent(ColumnConditionPanel::requestInputFocus);
            } else if (!attributes.isEmpty()) {
                List sortedDefinitions = attributes.stream().map(attribute -> tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).collect(Collectors.toList());
                ((SelectionDialogBuilder)((SelectionDialogBuilder)Dialogs.selectionDialog(sortedDefinitions).owner((Component)dialogOwner)).title(dialogTitle)).selectSingle().flatMap(attributeDefinition -> tableConditionPanel.conditionPanel((Object)attributeDefinition.attribute())).ifPresent(conditionPanel -> {
                    EntityTablePanel.displayConditionPanel(conditionPanelScrollPane, conditionPanelAdvancedState, conditionPanelVisibleState);
                    conditionPanel.requestInputFocus();
                });
            }
        }
    }

    private static void displayConditionPanel(JScrollPane conditionPanelScrollPane, State conditionPanelAdvancedState, State conditionPanelVisibleState) {
        if (conditionPanelScrollPane != null && !conditionPanelScrollPane.isVisible()) {
            conditionPanelAdvancedState.set((Object)false);
            conditionPanelVisibleState.set((Object)true);
        }
    }

    private static GridBagConstraints createHorizontalFillConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        return constraints;
    }

    private static void addAdditionalControls(Controls popupControls, List<Controls> additionalPopupControls) {
        additionalPopupControls.forEach(controls -> {
            if (NullOrEmpty.nullOrEmpty((String)controls.getName())) {
                popupControls.addAll(controls);
            } else {
                popupControls.add(controls);
            }
            popupControls.addSeparator();
        });
    }

    private static JScrollPane createHiddenLinkedScrollPane(JScrollPane parentScrollPane, JPanel panelToScroll) {
        return (JScrollPane)((ScrollPaneBuilder)((ScrollPaneBuilder)Components.scrollPane((JComponent)panelToScroll).horizontalScrollBarPolicy(31).verticalScrollBarPolicy(21).visible(false)).onBuild(scrollPane -> Utilities.linkBoundedRangeModels((BoundedRangeModel)parentScrollPane.getHorizontalScrollBar().getModel(), (BoundedRangeModel)scrollPane.getHorizontalScrollBar().getModel()))).build();
    }

    private static Point popupLocation(JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        int x = visibleRect.x + visibleRect.width / 2;
        int y = table.getSelectionModel().isSelectionEmpty() ? visibleRect.y + visibleRect.height / 2 : table.getCellRect((int)table.getSelectedRow(), (int)table.getSelectedColumn(), (boolean)true).y;
        return new Point(x, y + table.getRowHeight() / 2);
    }

    public static final class Config {
        public static final PropertyValue<Boolean> CONDITION_PANEL_VISIBLE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.conditionPanelVisible", (boolean)false);
        public static final PropertyValue<Boolean> FILTER_PANEL_VISIBLE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.filterPanelVisible", (boolean)false);
        public static final PropertyValue<Boolean> SUMMARY_PANEL_VISIBLE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.summaryPanelVisible", (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_POPUP_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includePopupMenu", (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeEntityMenu", (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_CLEAR_CONTROL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeClearControl", (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_CONDITION_PANEL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeConditionPanel", (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_FILTER_PANEL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeFilterPanel", (boolean)false);
        public static final PropertyValue<Boolean> INCLUDE_SUMMARY_PANEL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeSummaryPanel", (boolean)true);
        public static final PropertyValue<Boolean> INCLUDE_LIMIT_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeLimitMenu", (boolean)false);
        public static final PropertyValue<Boolean> SHOW_REFRESH_PROGRESS_BAR = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.showRefreshProgressBar", (boolean)false);
        public static final PropertyValue<RefreshButtonVisible> REFRESH_BUTTON_VISIBLE = Configuration.enumValue((String)"is.codion.swing.framework.ui.EntityTablePanel.refreshButtonVisible", RefreshButtonVisible.class, (Enum)RefreshButtonVisible.WHEN_CONDITION_PANEL_IS_VISIBLE);
        public static final PropertyValue<ColumnSelection> COLUMN_SELECTION = Configuration.enumValue((String)"is.codion.swing.framework.ui.EntityTablePanel.columnSelection", ColumnSelection.class, (Enum)ColumnSelection.DIALOG);
        public static final PropertyValue<EditAttributeSelection> EDIT_ATTRIBUTE_SELECTION = Configuration.enumValue((String)"is.codion.swing.framework.ui.EntityTablePanel.editAttributeSelection", EditAttributeSelection.class, (Enum)EditAttributeSelection.MENU);
        public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class);
        private static final Function<SwingEntityTableModel, String> DEFAULT_STATUS_MESSAGE = new DefaultStatusMessage();
        private final EntityTablePanel tablePanel;
        private final EntityDefinition entityDefinition;
        private final KeyboardShortcuts<KeyboardShortcut> shortcuts;
        private final ValueSet<Attribute<?>> editable;
        private final Map<Attribute<?>, EntityComponentFactory<?, ?, ?>> editComponentFactories;
        private final Map<Attribute<?>, EntityComponentFactory<?, ?, ?>> cellEditorComponentFactories;
        private EntityConditionPanelFactory conditionPanelFactory;
        private boolean includeSouthPanel = true;
        private boolean includeConditionPanel = (Boolean)INCLUDE_CONDITION_PANEL.get();
        private boolean includeFilterPanel = (Boolean)INCLUDE_FILTER_PANEL.get();
        private boolean includeSummaryPanel = (Boolean)INCLUDE_SUMMARY_PANEL.get();
        private boolean includeClearControl = (Boolean)INCLUDE_CLEAR_CONTROL.get();
        private boolean includeLimitMenu = (Boolean)INCLUDE_LIMIT_MENU.get();
        private boolean includeEntityMenu = (Boolean)INCLUDE_ENTITY_MENU.get();
        private boolean includePopupMenu = (Boolean)INCLUDE_POPUP_MENU.get();
        private boolean includeSelectionModeControl = false;
        private boolean includeAddControl = true;
        private boolean includeEditControl = true;
        private boolean includeEditAttributeControl = true;
        private boolean includeToolBar = true;
        private ColumnSelection columnSelection = (ColumnSelection)((Object)COLUMN_SELECTION.get());
        private EditAttributeSelection editAttributeSelection = (EditAttributeSelection)((Object)EDIT_ATTRIBUTE_SELECTION.get());
        private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling;
        private RefreshButtonVisible refreshButtonVisible;
        private Function<SwingEntityTableModel, String> statusMessage = DEFAULT_STATUS_MESSAGE;
        private boolean showRefreshProgressBar = (Boolean)SHOW_REFRESH_PROGRESS_BAR.get();
        private EntityEditPanel.Confirmer deleteConfirmer;

        private Config(EntityTablePanel tablePanel) {
            this.tablePanel = tablePanel;
            this.entityDefinition = tablePanel.tableModel.entityDefinition();
            this.shortcuts = KEYBOARD_SHORTCUTS.copy();
            this.conditionPanelFactory = new EntityConditionPanelFactory(this.entityDefinition);
            this.editable = ValueSet.valueSet((Collection)this.entityDefinition.attributes().updatable().stream().map(AttributeDefinition::attribute).collect(Collectors.toSet()));
            this.editable.addValidator((Value.Validator)new EditMenuAttributeValidator(this.entityDefinition));
            this.editComponentFactories = new HashMap();
            this.cellEditorComponentFactories = new HashMap();
            this.referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());
            this.refreshButtonVisible = RefreshButtonVisible.WHEN_CONDITION_PANEL_IS_VISIBLE;
            this.deleteConfirmer = new DeleteConfirmer(tablePanel.tableModel.selectionModel());
        }

        private Config(Config config) {
            this.tablePanel = config.tablePanel;
            this.entityDefinition = config.entityDefinition;
            this.shortcuts = config.shortcuts.copy();
            this.editable = ValueSet.valueSet((Collection)((Collection)config.editable.get()));
            this.conditionPanelFactory = config.conditionPanelFactory;
            this.includeSouthPanel = config.includeSouthPanel;
            this.includeConditionPanel = config.includeConditionPanel;
            this.includeFilterPanel = config.includeFilterPanel;
            this.includeSummaryPanel = config.includeSummaryPanel;
            this.includeClearControl = config.includeClearControl;
            this.includeLimitMenu = config.includeLimitMenu;
            this.includeEntityMenu = config.includeEntityMenu;
            this.includePopupMenu = config.includePopupMenu;
            this.includeSelectionModeControl = config.includeSelectionModeControl;
            this.includeAddControl = config.includeAddControl;
            this.includeEditControl = config.includeEditControl;
            this.includeEditAttributeControl = config.includeEditAttributeControl;
            this.columnSelection = config.columnSelection;
            this.editAttributeSelection = config.editAttributeSelection;
            this.editComponentFactories = new HashMap(config.editComponentFactories);
            this.cellEditorComponentFactories = new HashMap(config.cellEditorComponentFactories);
            this.referentialIntegrityErrorHandling = config.referentialIntegrityErrorHandling;
            this.refreshButtonVisible = config.refreshButtonVisible;
            this.statusMessage = config.statusMessage;
            this.showRefreshProgressBar = config.showRefreshProgressBar;
            this.deleteConfirmer = config.deleteConfirmer;
            this.includeToolBar = config.includeToolBar;
        }

        public EntityTablePanel tablePanel() {
            return this.tablePanel;
        }

        public Config conditionPanelFactory(EntityConditionPanelFactory conditionPanelFactory) {
            this.conditionPanelFactory = Objects.requireNonNull(conditionPanelFactory);
            return this;
        }

        public Config includeSouthPanel(boolean includeSouthPanel) {
            this.includeSouthPanel = includeSouthPanel;
            return this;
        }

        public Config includeConditionPanel(boolean includeConditionPanel) {
            this.includeConditionPanel = includeConditionPanel;
            return this;
        }

        public Config includeFilterPanel(boolean includeFilterPanel) {
            this.includeFilterPanel = includeFilterPanel;
            return this;
        }

        public Config includeSummaryPanel(boolean includeSummaryPanel) {
            this.includeSummaryPanel = includeSummaryPanel;
            return this;
        }

        public Config includePopupMenu(boolean includePopupMenu) {
            this.includePopupMenu = includePopupMenu;
            return this;
        }

        public Config includeClearControl(boolean includeClearControl) {
            this.includeClearControl = includeClearControl;
            return this;
        }

        public Config includeLimitMenu(boolean includeLimitMenu) {
            this.includeLimitMenu = includeLimitMenu;
            return this;
        }

        public Config includeEntityMenu(boolean includeEntityMenu) {
            this.includeEntityMenu = includeEntityMenu;
            return this;
        }

        public Config includeSelectionModeControl(boolean includeSelectionModeControl) {
            this.includeSelectionModeControl = includeSelectionModeControl;
            return this;
        }

        public Config includeToolBar(boolean includeToolBar) {
            this.includeToolBar = includeToolBar;
            return this;
        }

        public Config includeAddControl(boolean includeAddControl) {
            this.includeAddControl = includeAddControl;
            return this;
        }

        public Config includeEditControl(boolean includeEditControl) {
            this.includeEditControl = includeEditControl;
            return this;
        }

        public Config includeEditAttributeControl(boolean includeEditAttributeControl) {
            this.includeEditAttributeControl = includeEditAttributeControl;
            return this;
        }

        public Config columnSelection(ColumnSelection columnSelection) {
            this.columnSelection = Objects.requireNonNull(columnSelection);
            return this;
        }

        public Config editAttributeSelection(EditAttributeSelection editAttributeSelection) {
            this.editAttributeSelection = Objects.requireNonNull(editAttributeSelection);
            return this;
        }

        public Config keyStrokes(Consumer<KeyboardShortcuts<KeyboardShortcut>> shortcuts) {
            Objects.requireNonNull(shortcuts).accept(this.shortcuts);
            return this;
        }

        public Config editable(Consumer<ValueSet<Attribute<?>>> attributes) {
            Objects.requireNonNull(attributes).accept(this.editable);
            return this;
        }

        public Config deleteConfirmer(EntityEditPanel.Confirmer deleteConfirmer) {
            this.deleteConfirmer = Objects.requireNonNull(deleteConfirmer);
            return this;
        }

        public <T, A extends Attribute<T>, C extends JComponent> Config editComponentFactory(A attribute, EntityComponentFactory<T, A, C> componentFactory) {
            this.entityDefinition.attributes().definition(attribute);
            this.editComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
            return this;
        }

        public <T, A extends Attribute<T>, C extends JComponent> Config tableCellEditorFactory(A attribute, EntityComponentFactory<T, A, C> componentFactory) {
            this.entityDefinition.attributes().definition(attribute);
            this.cellEditorComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
            return this;
        }

        public Config referentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
            this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
            return this;
        }

        public Config refreshButtonVisible(RefreshButtonVisible refreshButtonVisible) {
            this.refreshButtonVisible = Objects.requireNonNull(refreshButtonVisible);
            return this;
        }

        public Config statusMessage(Function<SwingEntityTableModel, String> statusMessage) {
            this.statusMessage = Objects.requireNonNull(statusMessage);
            return this;
        }

        public Config showRefreshProgressBar(boolean showRefreshProgressBar) {
            this.showRefreshProgressBar = showRefreshProgressBar;
            return this;
        }

        private static final class EditMenuAttributeValidator
        implements Value.Validator<Set<Attribute<?>>> {
            private final EntityDefinition entityDefinition;

            private EditMenuAttributeValidator(EntityDefinition entityDefinition) {
                this.entityDefinition = entityDefinition;
            }

            public void validate(Set<Attribute<?>> attributes) {
                attributes.forEach(attribute -> this.entityDefinition.attributes().definition(attribute));
            }
        }
    }

    private final class TablePanel
    extends JPanel {
        private TablePanel() {
            super(new BorderLayout());
            if (EntityTablePanel.this.configuration.includeConditionPanel) {
                if (EntityTablePanel.this.conditionPanel == null) {
                    EntityTablePanel.this.conditionPanel = EntityTablePanel.this.createConditionPanel();
                }
                EntityTablePanel.this.conditionPanelScrollPane = EntityTablePanel.createHiddenLinkedScrollPane(EntityTablePanel.this.tableScrollPane, EntityTablePanel.this.conditionPanel);
                this.add((Component)EntityTablePanel.this.conditionPanelScrollPane, "North");
            }
            JPanel tableSouthPanel = new JPanel(new BorderLayout());
            if (EntityTablePanel.this.configuration.includeSummaryPanel) {
                EntityTablePanel.this.summaryPanel = this.createSummaryPanel();
                if (EntityTablePanel.this.summaryPanel != null) {
                    EntityTablePanel.this.summaryPanelScrollPane = EntityTablePanel.createHiddenLinkedScrollPane(EntityTablePanel.this.tableScrollPane, EntityTablePanel.this.summaryPanel);
                    tableSouthPanel.add((Component)EntityTablePanel.this.summaryPanelScrollPane, "North");
                }
            }
            if (EntityTablePanel.this.configuration.includeFilterPanel) {
                EntityTablePanel.this.filterPanelScrollPane = EntityTablePanel.createHiddenLinkedScrollPane(EntityTablePanel.this.tableScrollPane, (JPanel)EntityTablePanel.this.table.filterPanel());
                tableSouthPanel.add((Component)EntityTablePanel.this.filterPanelScrollPane, "Center");
            }
            this.add((Component)EntityTablePanel.this.tableScrollPane, "Center");
            this.add((Component)tableSouthPanel, "South");
        }

        private FilteredTableColumnComponentPanel<Attribute<?>, JPanel> createSummaryPanel() {
            Map<Attribute<?>, JPanel> columnSummaryPanels = this.createColumnSummaryPanels((FilteredTableModel<?, Attribute<?>>)EntityTablePanel.this.tableModel);
            if (columnSummaryPanels.isEmpty()) {
                return null;
            }
            return FilteredTableColumnComponentPanel.filteredTableColumnComponentPanel((FilteredTableColumnModel)EntityTablePanel.this.tableModel.columnModel(), columnSummaryPanels);
        }

        private Map<Attribute<?>, JPanel> createColumnSummaryPanels(FilteredTableModel<?, Attribute<?>> tableModel) {
            HashMap components = new HashMap();
            tableModel.columnModel().columns().forEach(column -> tableModel.summaryModel().summaryModel((Object)((Attribute)column.getIdentifier())).ifPresent(columnSummaryModel -> components.put((Attribute<?>)((Attribute)column.getIdentifier()), (JPanel)ColumnSummaryPanel.columnSummaryPanel((ColumnSummaryModel)columnSummaryModel, (int)((FilteredTableCellRenderer)column.getCellRenderer()).horizontalAlignment()))));
            return components;
        }
    }

    private final class SouthPanel
    extends JPanel {
        private SouthPanel() {
            JToolBar southToolBar;
            super(new BorderLayout());
            this.add((Component)Components.splitPane().continuousLayout(true).leftComponent(Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)EntityTablePanel.this.table.searchField(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build()).rightComponent((JComponent)this.statusPanel()).build(), "Center");
            this.add((Component)EntityTablePanel.this.refreshButtonToolBar, "West");
            if (EntityTablePanel.this.configuration.includeToolBar && (southToolBar = EntityTablePanel.this.createToolBar()) != null) {
                this.add((Component)southToolBar, "East");
            }
        }

        private StatusPanel statusPanel() {
            if (EntityTablePanel.this.statusPanel == null) {
                EntityTablePanel.this.statusPanel = new StatusPanel();
            }
            return EntityTablePanel.this.statusPanel;
        }
    }

    public static enum TableControl {
        PRINT,
        DELETE,
        VIEW_DEPENDENCIES,
        ADD,
        EDIT,
        EDIT_ATTRIBUTE,
        EDIT_SELECTED_ATTRIBUTE,
        SELECT_COLUMNS,
        RESET_COLUMNS,
        COLUMN_AUTO_RESIZE_MODE,
        SELECTION_MODE,
        CLEAR,
        REFRESH,
        TOGGLE_SUMMARY_PANEL,
        TOGGLE_CONDITION_PANEL,
        CONDITION_PANEL_VISIBLE,
        TOGGLE_FILTER_PANEL,
        FILTER_PANEL_VISIBLE,
        CLEAR_SELECTION,
        MOVE_SELECTION_UP,
        MOVE_SELECTION_DOWN,
        COPY_TABLE_DATA,
        REQUEST_TABLE_FOCUS,
        SELECT_CONDITION_PANEL,
        SELECT_FILTER_PANEL,
        CONFIGURE_COLUMNS;

    }

    public static enum KeyboardShortcut implements KeyboardShortcuts.Shortcut
    {
        ADD(KeyboardShortcuts.keyStroke((int)155)),
        EDIT(KeyboardShortcuts.keyStroke((int)155, (int)128)),
        EDIT_SELECTED_ATTRIBUTE(KeyboardShortcuts.keyStroke((int)155, (int)64)),
        REQUEST_TABLE_FOCUS(KeyboardShortcuts.keyStroke((int)84, (int)128)),
        TOGGLE_CONDITION_PANEL(KeyboardShortcuts.keyStroke((int)83, (int)640)),
        SELECT_CONDITION_PANEL(KeyboardShortcuts.keyStroke((int)83, (int)128)),
        TOGGLE_FILTER_PANEL(KeyboardShortcuts.keyStroke((int)70, (int)640)),
        SELECT_FILTER_PANEL(KeyboardShortcuts.keyStroke((int)70, (int)192)),
        PRINT(KeyboardShortcuts.keyStroke((int)80, (int)128)),
        DELETE(KeyboardShortcuts.keyStroke((int)127)),
        DISPLAY_POPUP_MENU(KeyboardShortcuts.keyStroke((int)71, (int)128)),
        DISPLAY_ENTITY_MENU(KeyboardShortcuts.keyStroke((int)86, (int)640));

        private final KeyStroke defaultKeystroke;

        private KeyboardShortcut(KeyStroke defaultKeystroke) {
            this.defaultKeystroke = defaultKeystroke;
        }

        public KeyStroke defaultKeystroke() {
            return this.defaultKeystroke;
        }
    }

    public static enum EditAttributeSelection {
        DIALOG,
        MENU;

    }

    private final class DeleteCommand
    implements Control.Command {
        private DeleteCommand() {
        }

        public void execute() {
            if (EntityTablePanel.this.confirmDelete()) {
                List selectedItems = EntityTablePanel.this.tableModel().selectionModel().getSelectedItems();
                ((ProgressWorkerDialogBuilder)((ProgressWorkerDialogBuilder)Dialogs.progressWorkerDialog(() -> ((EntityEditModel.Delete.Task)EntityTablePanel.this.tableModel().editModel().createDelete((Collection)selectedItems).prepare()).perform()).title(EDIT_PANEL_MESSAGES.getString("deleting"))).owner((Component)EntityTablePanel.this)).onException(this::onException).onResult(EntityEditModel.Delete.Result::handle).execute();
            }
        }

        private void onException(Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            EntityTablePanel.this.onException(exception);
        }
    }

    public static enum ColumnSelection {
        DIALOG,
        MENU;

    }

    private final class EntityTableCellRendererFactory
    implements FilteredTableCellRendererFactory<Attribute<?>> {
        private EntityTableCellRendererFactory() {
        }

        public TableCellRenderer tableCellRenderer(FilteredTableColumn<Attribute<?>> column) {
            return EntityTablePanel.this.createTableCellRenderer((Attribute)column.getIdentifier());
        }
    }

    public static enum RefreshButtonVisible {
        ALWAYS,
        WHEN_CONDITION_PANEL_IS_VISIBLE;

    }

    private static final class PanelAvailableValidator
    implements Value.Validator<Boolean> {
        private final JPanel panel;
        private final String panelType;

        private PanelAvailableValidator(JPanel panel, String panelType) {
            this.panel = panel;
            this.panelType = panelType;
        }

        public void validate(Boolean visible) throws IllegalArgumentException {
            if (visible.booleanValue() && this.panel == null) {
                throw new IllegalArgumentException("No " + this.panelType + " panel available");
            }
        }
    }

    private final class HeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer wrappedRenderer;

        private HeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.wrappedRenderer == null ? table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            FilteredTableColumn tableColumn = EntityTablePanel.this.tableModel.columnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            boolean useBoldFont = renderer instanceof FilteredTableCellRenderer && ((FilteredTableCellRenderer)renderer).columnShadingEnabled() && EntityTablePanel.this.tableModel.conditionModel().enabled((Object)((Attribute)tableColumn.getIdentifier()));
            Font defaultFont = component.getFont();
            component.setFont(useBoldFont ? defaultFont.deriveFont(defaultFont.getStyle() | 1) : defaultFont);
            return component;
        }
    }

    private final class StatusPanel
    extends JPanel {
        private static final String STATUS = "status";
        private static final String REFRESHING = "refreshing";
        private final Value<String> statusMessage;

        private StatusPanel() {
            super(new CardLayout());
            this.statusMessage = Value.nonNull((Object)"").build();
            this.add((Component)Components.label(this.statusMessage).horizontalAlignment(0).build(), STATUS);
            this.add((Component)this.createRefreshingProgressPanel(), REFRESHING);
            CardLayout layout = (CardLayout)this.getLayout();
            EntityTablePanel.this.tableModel.refresher().observer().addConsumer(isRefreshing -> {
                if (EntityTablePanel.this.configuration.showRefreshProgressBar) {
                    layout.show(this, isRefreshing != false ? REFRESHING : STATUS);
                }
            });
            if (EntityTablePanel.this.configuration.includeLimitMenu) {
                this.setComponentPopupMenu(this.createPopupMenu());
            }
            EntityTablePanel.this.tableModel.selectionModel().addListSelectionListener(e -> this.updateStatusMessage());
            EntityTablePanel.this.tableModel.dataChangedEvent().addListener(this::updateStatusMessage);
            this.updateStatusMessage();
        }

        private JPanel createRefreshingProgressPanel() {
            return (JPanel)Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)Components.progressBar().indeterminate(true).string(MESSAGES.getString(REFRESHING)).stringPainted(true).build(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build();
        }

        private JPopupMenu createPopupMenu() {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add((Action)Control.builder(this::configureLimit).name(MESSAGES.getString("row_limit")).build());
            return popupMenu;
        }

        private void configureLimit() {
            ComponentValue limitValue = ((NumberField.Builder)((NumberField.Builder)Components.integerField().initialValue((Object)((Integer)EntityTablePanel.this.tableModel.limit().get()))).groupingUsed(true).minimumValue((Number)0).columns(6)).buildValue();
            EntityTablePanel.this.tableModel.limit().set((Object)((Integer)((InputDialogBuilder)Dialogs.inputDialog((ComponentValue)limitValue).title(MESSAGES.getString("row_limit"))).validator((Predicate)new LimitValidator()).show()));
        }

        private void updateStatusMessage() {
            this.statusMessage.set((Object)EntityTablePanel.this.configuration.statusMessage.apply(EntityTablePanel.this.tableModel));
        }

        private final class LimitValidator
        implements Predicate<Integer> {
            private LimitValidator() {
            }

            @Override
            public boolean test(Integer limit) {
                try {
                    EntityTablePanel.this.tableModel.limit().validate((Object)limit);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
    }

    private static final class DefaultStatusMessage
    implements Function<SwingEntityTableModel, String> {
        private static final NumberFormat STATUS_MESSAGE_NUMBER_FORMAT = NumberFormat.getIntegerInstance();

        private DefaultStatusMessage() {
        }

        @Override
        public String apply(SwingEntityTableModel tableModel) {
            int rowCount = tableModel.getRowCount();
            int filteredCount = tableModel.filteredCount();
            if (rowCount == 0 && filteredCount == 0) {
                return "";
            }
            int selectionCount = tableModel.selectionModel().selectionCount();
            StringBuilder builder = new StringBuilder();
            if (tableModel.limit().isEqualTo((Object)tableModel.getRowCount())) {
                builder.append(MESSAGES.getString("limited_to")).append(" ");
            }
            builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(rowCount));
            if (selectionCount > 0 || filteredCount > 0) {
                builder.append(" (");
                if (selectionCount > 0) {
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(selectionCount)).append(" ").append(MESSAGES.getString("selected"));
                }
                if (filteredCount > 0) {
                    if (selectionCount > 0) {
                        builder.append(" - ");
                    }
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(filteredCount)).append(" ").append(MESSAGES.getString("filtered"));
                }
                builder.append(")");
            }
            return builder.toString();
        }
    }

    private static final class DeleteConfirmer
    implements EntityEditPanel.Confirmer {
        private final FilteredTableSelectionModel<?> selectionModel;

        private DeleteConfirmer(FilteredTableSelectionModel<?> selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete((int)this.selectionModel.selectionCount()), FrameworkMessages.delete());
        }
    }
}

