/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedDetailLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class WindowDetailLayout
implements EntityPanel.DetailLayout {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TabbedDetailLayout.class.getName());
    private static final String DETAIL_TABLES = "detail_tables";
    private static final Value.Validator<EntityPanel.PanelState> PANEL_STATE_VALIDATOR = new RejectEmbedded();
    private final Map<EntityPanel, DetailWindow> panelWindows = new HashMap<EntityPanel, DetailWindow>();
    private final WindowType windowType;
    private EntityPanel entityPanel;

    private WindowDetailLayout(DefaultBuilder builder) {
        this.windowType = builder.windowType;
    }

    @Override
    public JComponent layout(EntityPanel entityPanel) {
        Objects.requireNonNull(entityPanel);
        if (this.entityPanel != null) {
            throw new IllegalStateException("EntityPanel has already been laid out: " + entityPanel);
        }
        this.entityPanel = entityPanel;
        if (!entityPanel.detailPanels().isEmpty()) {
            entityPanel.detailPanels().forEach(detailPanel -> this.panelWindows.put((EntityPanel)detailPanel, new DetailWindow((EntityPanel)detailPanel)));
            this.setupControls(entityPanel);
        }
        return entityPanel.mainPanel();
    }

    @Override
    public Value<EntityPanel.PanelState> panelState(EntityPanel detailPanel) {
        this.throwIfNotLaidOut();
        return this.detailWindow((EntityPanel)detailPanel).panelState;
    }

    @Override
    public void select(EntityPanel entityPanel) {
        this.throwIfNotLaidOut();
        Window panelWindow = this.detailWindow((EntityPanel)entityPanel).window;
        if (panelWindow.isShowing()) {
            panelWindow.toFront();
        }
    }

    public static WindowDetailLayout windowDetailLayout() {
        return WindowDetailLayout.windowDetailLayout(WindowType.DIALOG);
    }

    public static WindowDetailLayout windowDetailLayout(WindowType windowType) {
        return WindowDetailLayout.builder().windowType(windowType).build();
    }

    private void throwIfNotLaidOut() {
        if (this.entityPanel == null) {
            throw new IllegalStateException("EntityPanel has not been laid out");
        }
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private void setupControls(EntityPanel entityPanel) {
        if (entityPanel.containsTablePanel()) {
            Controls.Builder controls = (Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString(DETAIL_TABLES))).smallIcon((Icon)FrameworkIcons.instance().detail());
            entityPanel.detailPanels().forEach(detailPanel -> controls.control(Control.builder(() -> this.panelWindows.get((Object)detailPanel).panelState.set((Object)EntityPanel.PanelState.WINDOW)).name((String)detailPanel.caption().get()).build()));
            ((EntityTablePanel)entityPanel.tablePanel()).addPopupMenuControls((Controls)controls.build());
        }
    }

    private DetailWindow detailWindow(EntityPanel detailPanel) {
        DetailWindow detailWindow = this.panelWindows.get(Objects.requireNonNull(detailPanel));
        if (detailWindow == null) {
            throw new IllegalArgumentException("Detail panel not found: " + detailPanel);
        }
        return detailWindow;
    }

    private static final class DefaultBuilder
    implements Builder {
        private WindowType windowType = (Boolean)EntityPanel.Config.USE_FRAME_PANEL_DISPLAY.get() != false ? WindowType.FRAME : WindowType.DIALOG;

        private DefaultBuilder() {
        }

        @Override
        public Builder windowType(WindowType windowType) {
            this.windowType = windowType;
            return this;
        }

        @Override
        public WindowDetailLayout build() {
            return new WindowDetailLayout(this);
        }
    }

    public static enum WindowType {
        FRAME,
        DIALOG;

    }

    private final class DetailWindow {
        private final Value<EntityPanel.PanelState> panelState = Value.value((Object)((Object)EntityPanel.PanelState.HIDDEN), (Object)((Object)EntityPanel.PanelState.HIDDEN), (Value.Notify)Value.Notify.WHEN_SET);
        private final EntityPanel detailPanel;
        private Window window;
        private boolean initialized = false;

        private DetailWindow(EntityPanel detailPanel) {
            this.detailPanel = detailPanel;
            this.panelState.addValidator(PANEL_STATE_VALIDATOR);
            this.panelState.addDataListener(this::updateDetailState);
        }

        private void updateDetailState(EntityPanel.PanelState panelState) {
            if (this.window == null) {
                this.window = this.createDetailWindow();
            }
            if (panelState == EntityPanel.PanelState.WINDOW) {
                this.detailPanel.initialize();
                if (!this.initialized) {
                    this.window.pack();
                    this.detailPanel.requestInitialFocus();
                    this.initialized = true;
                }
                this.window.setVisible(true);
                this.window.toFront();
            } else {
                this.window.setVisible(false);
            }
            Object model = this.detailPanel.model();
            if (WindowDetailLayout.this.entityPanel.model().containsDetailModel(model)) {
                WindowDetailLayout.this.entityPanel.model().detailModelLink(model).active().set((Object)(panelState == EntityPanel.PanelState.WINDOW ? 1 : 0));
            }
        }

        private Window createDetailWindow() {
            if (WindowDetailLayout.this.windowType == WindowType.FRAME) {
                return Windows.frame((JComponent)this.detailPanel).locationRelativeTo((Component)WindowDetailLayout.this.entityPanel).title((String)this.detailPanel.caption().get()).onClosing(windowEvent -> WindowDetailLayout.this.panelWindows.get((Object)this.detailPanel).panelState.set((Object)EntityPanel.PanelState.HIDDEN)).build();
            }
            return ((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.detailPanel).owner((Component)WindowDetailLayout.this.entityPanel)).locationRelativeTo((Component)WindowDetailLayout.this.entityPanel)).title((String)this.detailPanel.caption().get())).modal(false).onClosed(windowEvent -> WindowDetailLayout.this.panelWindows.get((Object)this.detailPanel).panelState.set((Object)EntityPanel.PanelState.HIDDEN)).build();
        }
    }

    public static interface Builder {
        public Builder windowType(WindowType var1);

        public WindowDetailLayout build();
    }

    private static final class RejectEmbedded
    implements Value.Validator<EntityPanel.PanelState> {
        private RejectEmbedded() {
        }

        public void validate(EntityPanel.PanelState panelState) {
            if (panelState == EntityPanel.PanelState.EMBEDDED) {
                throw new IllegalArgumentException("WindowedDetailLayout does not support the EMBEDDED PanelState");
            }
        }
    }
}

