/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public final class TabbedDetailLayout
implements EntityPanel.DetailLayout {
    public static final PropertyValue<Boolean> INCLUDE_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.TabbedPanelLayout.includeControls", (boolean)true);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TabbedDetailLayout.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, TabbedDetailLayout::defaultKeyStroke);
    private static final int RESIZE_AMOUNT = 30;
    private static final String DETAIL_TABLES = "detail_tables";
    private static final double DEFAULT_SPLIT_PANE_RESIZE_WEIGHT = 0.5;
    private static final int DETAIL_WINDOW_OFFSET = 38;
    private static final double DETAIL_WINDOW_SIZE_RATIO = 0.66;
    private final TabbedDetailController detailController;
    private final boolean includeTabbedPane;
    private final boolean includeControls;
    private final double splitPaneResizeWeight;
    private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts;
    private EntityPanel entityPanel;
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private Window panelWindow;
    private EntityPanel.PanelState panelState = EntityPanel.PanelState.EMBEDDED;

    private TabbedDetailLayout(DefaultBuilder builder) {
        this.panelState = builder.panelState;
        this.includeTabbedPane = builder.includeTabbedPane;
        this.includeControls = builder.includeControls;
        this.splitPaneResizeWeight = builder.splitPaneResizeWeight;
        this.detailController = new TabbedDetailController();
        this.keyboardShortcuts = builder.keyboardShortcuts;
    }

    @Override
    public void updateUI() {
        Utilities.updateUI((JComponent[])new JComponent[]{this.tabbedPane, this.splitPane});
    }

    @Override
    public JComponent layout(EntityPanel entityPanel) {
        Objects.requireNonNull(entityPanel);
        if (this.entityPanel != null) {
            throw new IllegalStateException("EntityPanel has already been laid out: " + entityPanel);
        }
        this.entityPanel = entityPanel;
        if (!this.includeTabbedPane || entityPanel.detailPanels().isEmpty()) {
            return entityPanel.mainPanel();
        }
        return this.layoutPanel(entityPanel);
    }

    @Override
    public void select(EntityPanel entityPanel) {
        this.throwIfNotLaidOut();
        this.detailController.select(Objects.requireNonNull(entityPanel));
    }

    @Override
    public Value<EntityPanel.PanelState> panelState(EntityPanel detailPanel) {
        Objects.requireNonNull(detailPanel);
        this.throwIfNotLaidOut();
        return this.detailController.panelState();
    }

    private void throwIfNotLaidOut() {
        if (this.entityPanel == null) {
            throw new IllegalStateException("EntityPanel has not been laid out");
        }
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private void setupResizing(EntityPanel detailPanel) {
        detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)((KeyStroke)this.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.RESIZE_RIGHT).get())).condition(1).action((Action)new ResizeHorizontally(detailPanel, EntityPanel.Direction.RIGHT)));
        detailPanel.addKeyEvent(KeyEvents.builder((KeyStroke)((KeyStroke)this.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.RESIZE_LEFT).get())).condition(1).action((Action)new ResizeHorizontally(detailPanel, EntityPanel.Direction.LEFT)));
    }

    private void setupControls(EntityPanel entityPanel) {
        if (entityPanel.containsTablePanel()) {
            Object tablePanel = entityPanel.tablePanel();
            Controls controls = Controls.controls();
            this.detailController.toggleDetailControl().ifPresent(arg_0 -> ((Controls)controls).add(arg_0));
            if (controls.notEmpty()) {
                ((EntityTablePanel)tablePanel).addToolBarControls(controls);
            }
            this.detailController.detailControls().ifPresent(arg_0 -> tablePanel.addPopupMenuControls(arg_0));
        }
    }

    private void initializePanelState() {
        this.selectedDetailPanel().ifPresent(selectedDetailPanel -> {
            Value<EntityPanel.PanelState> detailPanelStateValue = this.detailController.panelState();
            if (detailPanelStateValue.isNotEqualTo((Object)this.panelState)) {
                detailPanelStateValue.set((Object)this.panelState);
            } else {
                this.detailController.updateDetailState();
            }
        });
    }

    private Optional<EntityPanel> selectedDetailPanel() {
        return Optional.ofNullable(this.tabbedPane == null ? null : (EntityPanel)this.tabbedPane.getSelectedComponent());
    }

    private JComponent layoutPanel(EntityPanel entityPanel) {
        this.splitPane = this.createSplitPane(entityPanel.mainPanel());
        this.tabbedPane = this.createTabbedPane(entityPanel.detailPanels());
        entityPanel.detailPanels().forEach(this::setupResizing);
        this.setupControls(entityPanel);
        this.initializePanelState();
        return this.splitPane;
    }

    private JSplitPane createSplitPane(JPanel editControlTablePanel) {
        return (JSplitPane)Components.splitPane().orientation(1).continuousLayout(true).oneTouchExpandable(true).dividerSize((Integer)Layouts.GAP.get() * 2).resizeWeight(this.splitPaneResizeWeight).leftComponent((JComponent)editControlTablePanel).build();
    }

    private JTabbedPane createTabbedPane(Collection<EntityPanel> detailPanels) {
        TabbedPaneBuilder builder = (TabbedPaneBuilder)((TabbedPaneBuilder)Components.tabbedPane().focusable(false)).changeListener(e -> this.selectedDetailPanel().ifPresent(EntityPanel::activate)).onBuild(tabbedPane -> tabbedPane.setFocusCycleRoot(true));
        detailPanels.forEach(detailPanel -> builder.tabBuilder((String)detailPanel.caption().get(), (JComponent)detailPanel).toolTipText((String)detailPanel.description().get()).add());
        if (this.includeControls) {
            builder.mouseListener((MouseListener)new TabbedPaneMouseReleasedListener());
        }
        return (JTabbedPane)builder.build();
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case RESIZE_LEFT: {
                return KeyboardShortcuts.keyStroke((int)37, (int)576);
            }
            case RESIZE_RIGHT: {
                return KeyboardShortcuts.keyStroke((int)39, (int)576);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private EntityPanel.PanelState panelState = EntityPanel.PanelState.EMBEDDED;
        private double splitPaneResizeWeight = 0.5;
        private boolean includeTabbedPane = true;
        private boolean includeControls = (Boolean)INCLUDE_CONTROLS.get();

        private DefaultBuilder() {
        }

        @Override
        public Builder panelState(EntityPanel.PanelState panelState) {
            this.panelState = Objects.requireNonNull(panelState);
            return this;
        }

        @Override
        public Builder splitPaneResizeWeight(double splitPaneResizeWeight) {
            this.splitPaneResizeWeight = splitPaneResizeWeight;
            return this;
        }

        @Override
        public Builder includeTabbedPane(boolean includeTabbedPane) {
            this.includeTabbedPane = includeTabbedPane;
            return this;
        }

        @Override
        public Builder includeControls(boolean includeControls) {
            this.includeControls = includeControls;
            return this;
        }

        @Override
        public Builder keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke((Enum)keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        @Override
        public TabbedDetailLayout build() {
            return new TabbedDetailLayout(this);
        }
    }

    private final class TabbedDetailController {
        private final Value<EntityPanel.PanelState> panelState = Value.value((Object)((Object)EntityPanel.PanelState.EMBEDDED), (Object)((Object)EntityPanel.PanelState.EMBEDDED));

        private TabbedDetailController() {
            this.panelState.addListener(this::updateDetailState);
        }

        private void select(EntityPanel detailPanel) {
            if (TabbedDetailLayout.this.tabbedPane != null) {
                TabbedDetailLayout.this.tabbedPane.setFocusable(true);
                TabbedDetailLayout.this.tabbedPane.setSelectedComponent(detailPanel);
                TabbedDetailLayout.this.tabbedPane.setFocusable(false);
            }
            this.activateDetailModelLink((SwingEntityModel)detailPanel.model());
        }

        private Value<EntityPanel.PanelState> panelState() {
            return this.panelState;
        }

        private void updateDetailState() {
            TabbedDetailLayout.this.selectedDetailPanel().ifPresent(selectedDetailPanel -> {
                if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                    selectedDetailPanel.initialize();
                }
                Object selectedDetailModel = selectedDetailPanel.model();
                if (TabbedDetailLayout.this.entityPanel.model().containsDetailModel(selectedDetailModel)) {
                    TabbedDetailLayout.this.entityPanel.model().detailModelLink(selectedDetailModel).active().set((Object)this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.HIDDEN));
                }
            });
            if (this.previousPanelState() == EntityPanel.PanelState.WINDOW) {
                this.disposeDetailWindow();
            }
            if (this.panelState.isEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                TabbedDetailLayout.this.splitPane.setRightComponent(TabbedDetailLayout.this.tabbedPane);
            } else if (this.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                TabbedDetailLayout.this.splitPane.setRightComponent(null);
            } else {
                this.displayDetailWindow();
            }
            TabbedDetailLayout.this.entityPanel.revalidate();
        }

        private EntityPanel.PanelState previousPanelState() {
            if (TabbedDetailLayout.this.tabbedPane == null) {
                throw new IllegalStateException("No tabbed detail pane available");
            }
            if (TabbedDetailLayout.this.panelWindow != null) {
                return EntityPanel.PanelState.WINDOW;
            }
            if (TabbedDetailLayout.this.tabbedPane.isShowing()) {
                return EntityPanel.PanelState.EMBEDDED;
            }
            return EntityPanel.PanelState.HIDDEN;
        }

        private void activateDetailModelLink(SwingEntityModel detailModel) {
            Object model = TabbedDetailLayout.this.entityPanel.model();
            if (model.containsDetailModel((DefaultEntityModel)detailModel)) {
                ((Set)model.activeDetailModels().get()).stream().filter(activeDetailModel -> activeDetailModel != detailModel).forEach(activeDetailModel -> model.detailModelLink((DefaultEntityModel)activeDetailModel).active().set((Object)false));
                model.detailModelLink((DefaultEntityModel)detailModel).active().set((Object)true);
            }
        }

        private Optional<Control> toggleDetailControl() {
            if (TabbedDetailLayout.this.includeControls && !TabbedDetailLayout.this.entityPanel.detailPanels().isEmpty()) {
                return Optional.of(this.createToggleDetailControl());
            }
            return Optional.empty();
        }

        private Optional<Controls> detailControls() {
            if (TabbedDetailLayout.this.includeControls && !TabbedDetailLayout.this.entityPanel.detailPanels().isEmpty()) {
                return Optional.of(this.createDetailControls());
            }
            return Optional.empty();
        }

        private Control createToggleDetailControl() {
            return Control.builder(this::toggleDetailState).smallIcon((Icon)FrameworkIcons.instance().detail()).description(MESSAGES.getString("toggle_detail")).build();
        }

        private void toggleDetailState() {
            this.panelState.map(EntityPanel.PANEL_STATE_MAPPER);
        }

        private Controls createDetailControls() {
            Controls.Builder controls = (Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES))).smallIcon((Icon)FrameworkIcons.instance().detail());
            TabbedDetailLayout.this.entityPanel.detailPanels().forEach(detailPanel -> controls.control(Control.builder((Control.Command)new ActivateDetailPanel((EntityPanel)detailPanel)).name((String)detailPanel.caption().get())));
            return (Controls)controls.build();
        }

        private void displayDetailWindow() {
            Window parent = Utilities.parentWindow((Component)TabbedDetailLayout.this.entityPanel);
            if (parent != null) {
                Dimension parentSize = parent.getSize();
                Dimension size = this.detailWindowSize(parentSize);
                Point parentLocation = parent.getLocation();
                int detailWindowX = parentLocation.x + (parentSize.width - size.width);
                int detailWindowY = parentLocation.y + (parentSize.height - size.height) - 38;
                TabbedDetailLayout.this.panelWindow = this.createDetailWindow();
                TabbedDetailLayout.this.panelWindow.setSize(size);
                TabbedDetailLayout.this.panelWindow.setLocation(new Point(detailWindowX, detailWindowY));
                TabbedDetailLayout.this.panelWindow.setVisible(true);
            }
        }

        private void disposeDetailWindow() {
            if (TabbedDetailLayout.this.panelWindow != null) {
                TabbedDetailLayout.this.panelWindow.setVisible(false);
                TabbedDetailLayout.this.panelWindow.dispose();
                TabbedDetailLayout.this.panelWindow = null;
            }
        }

        private Dimension detailWindowSize(Dimension parentSize) {
            int detailWindowWidth = (int)((double)parentSize.width * 0.66);
            int detailWindowHeight = TabbedDetailLayout.this.entityPanel.containsEditPanel() ? (int)((double)parentSize.height * 0.66) : parentSize.height;
            return new Dimension(detailWindowWidth, detailWindowHeight);
        }

        private Window createDetailWindow() {
            if (((Boolean)EntityPanel.Config.USE_FRAME_PANEL_DISPLAY.get()).booleanValue()) {
                return Windows.frame((JComponent)this.createEmptyBorderBasePanel(TabbedDetailLayout.this.tabbedPane)).title((String)TabbedDetailLayout.this.entityPanel.caption().get() + " - " + MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES)).defaultCloseOperation(2).onClosed(windowEvent -> {
                    if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                        this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                    }
                }).build();
            }
            return ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.createEmptyBorderBasePanel(TabbedDetailLayout.this.tabbedPane)).owner((Component)TabbedDetailLayout.this.entityPanel)).title((String)TabbedDetailLayout.this.entityPanel.caption().get() + " - " + MESSAGES.getString(TabbedDetailLayout.DETAIL_TABLES))).modal(false).onClosed(e -> {
                if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                    this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                }
            }).build();
        }

        private JPanel createEmptyBorderBasePanel(JComponent component) {
            int gap = (Integer)Layouts.GAP.get();
            return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(component).border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).build();
        }

        private final class ActivateDetailPanel
        implements Control.Command {
            private final EntityPanel detailPanel;

            private ActivateDetailPanel(EntityPanel detailPanel) {
                this.detailPanel = detailPanel;
            }

            public void execute() {
                if (TabbedDetailController.this.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                    TabbedDetailController.this.panelState.set((Object)EntityPanel.PanelState.EMBEDDED);
                }
                this.detailPanel.activate();
            }
        }
    }

    public static enum KeyboardShortcut {
        RESIZE_RIGHT,
        RESIZE_LEFT;

    }

    private static final class ResizeHorizontally
    extends AbstractAction {
        private final EntityPanel panel;
        private final EntityPanel.Direction direction;

        private ResizeHorizontally(EntityPanel panel, EntityPanel.Direction direction) {
            super("Resize " + direction);
            this.panel = panel;
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.panel.parentPanel().ifPresent(parentPanel -> ResizeHorizontally.resizePanel(parentPanel, this.direction));
        }

        private static void resizePanel(EntityPanel panel, EntityPanel.Direction direction) {
            TabbedDetailLayout detailPanelLayout = (TabbedDetailLayout)panel.detailLayout();
            JSplitPane splitPane = detailPanelLayout.splitPane;
            switch (Objects.requireNonNull(direction)) {
                case RIGHT: {
                    if (splitPane == null) break;
                    splitPane.setDividerLocation(Math.min(splitPane.getDividerLocation() + 30, splitPane.getMaximumDividerLocation()));
                    break;
                }
                case LEFT: {
                    if (splitPane == null) break;
                    splitPane.setDividerLocation(Math.max(splitPane.getDividerLocation() - 30, 0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Undefined resize direction: " + direction);
                }
            }
        }
    }

    private final class TabbedPaneMouseReleasedListener
    extends MouseAdapter {
        private TabbedPaneMouseReleasedListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TabbedDetailLayout.this.selectedDetailPanel().ifPresent(selectedDetailPanel -> {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    TabbedDetailLayout.this.detailController.panelState().map(state -> state == EntityPanel.PanelState.WINDOW ? EntityPanel.PanelState.EMBEDDED : EntityPanel.PanelState.WINDOW);
                } else if (e.getButton() == 2) {
                    TabbedDetailLayout.this.detailController.panelState().map(state -> state == EntityPanel.PanelState.EMBEDDED ? EntityPanel.PanelState.HIDDEN : EntityPanel.PanelState.EMBEDDED);
                }
            });
        }
    }

    public static interface Builder {
        public Builder panelState(EntityPanel.PanelState var1);

        public Builder splitPaneResizeWeight(double var1);

        public Builder includeTabbedPane(boolean var1);

        public Builder includeControls(boolean var1);

        public Builder keyStroke(KeyboardShortcut var1, KeyStroke var2);

        public TabbedDetailLayout build();
    }
}

