/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.combobox.ItemComboBoxBuilder;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.component.slider.SliderBuilder;
import is.codion.swing.common.ui.component.spinner.ItemSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.ListSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.text.MaskedTextFieldBuilder;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.text.TemporalFieldPanel;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.text.TextFieldPanel;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComboBoxPanel;
import is.codion.swing.framework.ui.component.EntityComponentValidators;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.component.EntitySearchField;
import is.codion.swing.framework.ui.component.EntitySearchFieldPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class EntityEditComponentPanel
extends JPanel {
    public static final PropertyValue<Boolean> MODIFIED_INDICATOR = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditComponentPanel.modifiedIndicator", (boolean)true);
    public static final PropertyValue<Integer> MODIFIED_INDICATOR_UNDERLINE_STYLE = Configuration.integerValue((String)"is.codion.swing.framework.ui.EntityEditComponentPanel.modifiedIndicatorUnderlineStyle", (int)TextAttribute.UNDERLINE_LOW_DOTTED);
    public static final PropertyValue<Integer> DEFAULT_TEXT_FIELD_COLUMNS = Configuration.integerValue((String)"is.codion.swing.framework.ui.EntityEditComponentPanel.defaultTextFieldColumns", (int)12);
    private final SwingEntityEditModel editModel;
    private final EntityComponents entityComponents;
    private final Map<Attribute<?>, Value<JComponent>> components = new HashMap();
    private final Map<Attribute<?>, ComponentBuilder<?, ?, ?>> componentBuilders = new HashMap();
    private final ValueSet<Attribute<?>> selectableComponents;
    private final Value<JComponent> focusedInputComponent = Value.value();
    private final Value<JComponent> initialFocusComponent = Value.value();
    private final Value<Attribute<?>> initialFocusAttribute = Value.value();
    private final Value<JComponent> afterInsertFocusComponent = Value.value();
    private final Value<Attribute<?>> afterInsertFocusAttribute = Value.value();
    private final State transferFocusOnEnter = State.state((boolean)true);
    private final State modifiedIndicator = State.state((boolean)((Boolean)MODIFIED_INDICATOR.get()));
    private final Defaults defaults = new Defaults();

    protected EntityEditComponentPanel(SwingEntityEditModel editModel) {
        this(editModel, new EntityComponents(Objects.requireNonNull(editModel, "editModel").entityDefinition()));
    }

    protected EntityEditComponentPanel(SwingEntityEditModel editModel, EntityComponents entityComponents) {
        this.editModel = Objects.requireNonNull(editModel, "editModel");
        this.entityComponents = Objects.requireNonNull(entityComponents, "entityComponents");
        if (!editModel.entityType().equals(entityComponents.entityDefinition().entityType())) {
            throw new IllegalArgumentException("Entity type mismatch, editModel: " + editModel.entityType() + ", entityComponents: " + entityComponents.entityDefinition().entityType());
        }
        this.selectableComponents = ValueSet.valueSet(new HashSet(editModel.entityDefinition().attributes().get()));
        this.selectableComponents.addValidator((Value.Validator)new SelectableComponentValidator(editModel.entityDefinition()));
        this.addFocusedComponentListener();
    }

    public final <T extends SwingEntityEditModel> T editModel() {
        return (T)this.editModel;
    }

    public final Collection<Attribute<?>> attributes() {
        HashSet attributes = new HashSet(this.components.keySet());
        attributes.addAll(this.componentBuilders.keySet());
        return Collections.unmodifiableCollection(attributes);
    }

    public final Value<JComponent> component(Attribute<?> attribute) {
        ComponentBuilder<?, ?, ?> componentBuilder = this.componentBuilders.get(Objects.requireNonNull(attribute));
        if (componentBuilder != null) {
            componentBuilder.build();
        }
        return this.components.computeIfAbsent(attribute, k -> Value.value());
    }

    public final <T> Attribute<T> attribute(JComponent component) {
        Objects.requireNonNull(component);
        return this.components.entrySet().stream().filter(entry -> ((Value)entry.getValue()).get() == component).findFirst().map(Map.Entry::getKey).orElseThrow(() -> new IllegalArgumentException("No attribute is associated with this component"));
    }

    public final Value<JComponent> initialFocusComponent() {
        return this.initialFocusComponent;
    }

    public final Value<Attribute<?>> initialFocusAttribute() {
        return this.initialFocusAttribute;
    }

    public final Value<JComponent> afterInsertFocusComponent() {
        return this.afterInsertFocusComponent;
    }

    public final Value<Attribute<?>> afterInsertFocusAttribute() {
        return this.afterInsertFocusAttribute;
    }

    public final void requestInitialFocus() {
        if (this.isVisible()) {
            this.requestFocus(this.getInitialFocusComponent());
        }
    }

    public final void requestComponentFocus(Attribute<?> attribute) {
        this.component(attribute).optional().ifPresent(component -> EntityEditComponentPanel.focusableComponent(component).requestFocus());
    }

    public final void selectInputComponent() {
        Entities entities = this.editModel().entities();
        List attributeDefinitions = this.selectComponentAttributes().stream().map(attribute -> entities.definition(attribute.entityType()).attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).collect(Collectors.toList());
        if (!attributeDefinitions.isEmpty()) {
            Optional optionalAttribute = attributeDefinitions.size() == 1 ? Optional.of((AttributeDefinition)attributeDefinitions.iterator().next()) : ((SelectionDialogBuilder)((SelectionDialogBuilder)Dialogs.selectionDialog(attributeDefinitions).owner((Component)this)).title(FrameworkMessages.selectInputField())).selectSingle();
            optionalAttribute.ifPresent(attributeDefinition -> this.requestComponentFocus(attributeDefinition.attribute()));
        }
    }

    public final ValueSet<Attribute<?>> selectableComponents() {
        return this.selectableComponents;
    }

    protected void onException(Throwable exception) {
        this.displayException(exception);
    }

    protected final void displayException(Throwable exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    protected final Defaults defaults() {
        return this.defaults;
    }

    protected final State modifiedIndicator() {
        return this.modifiedIndicator;
    }

    protected final State transferFocusOnEnter() {
        return this.transferFocusOnEnter;
    }

    protected final void addInputPanel(Attribute<?> attribute) {
        this.add(this.createInputPanel(attribute));
    }

    protected final void addInputPanel(Attribute<?> attribute, Object constraints) {
        this.add((Component)this.createInputPanel(attribute), constraints);
    }

    protected final void addInputPanel(Attribute<?> attribute, JComponent inputComponent) {
        this.add(this.createInputPanel(attribute, inputComponent));
    }

    protected final void addInputPanel(Attribute<?> attribute, JComponent inputComponent, Object constraints) {
        this.add((Component)this.createInputPanel(attribute, inputComponent), constraints);
    }

    protected final JPanel createInputPanel(Attribute<?> attribute) {
        return this.createInputPanel(attribute, this.getComponentOrThrow(attribute));
    }

    protected final JPanel createInputPanel(Attribute<?> attribute, JComponent inputComponent) {
        return this.createInputPanel(attribute, inputComponent, "North");
    }

    protected final JPanel createInputPanel(Attribute<?> attribute, JComponent inputComponent, String labelBorderLayoutConstraints) {
        return this.createInputPanel(attribute, inputComponent, labelBorderLayoutConstraints, 10);
    }

    protected final JPanel createInputPanel(Attribute<?> attribute, JComponent inputComponent, String labelBorderLayoutConstraints, int labelAlignment) {
        return this.createInputPanel(this.createLabel(attribute).horizontalAlignment(labelAlignment).build(), inputComponent, labelBorderLayoutConstraints);
    }

    protected final JPanel createInputPanel(JComponent labelComponent, JComponent inputComponent) {
        return this.createInputPanel(labelComponent, inputComponent, "North");
    }

    protected final JPanel createInputPanel(JComponent labelComponent, JComponent inputComponent, String labelBorderLayoutConstraints) {
        Objects.requireNonNull(labelComponent, "labelComponent");
        Objects.requireNonNull(inputComponent, "inputComponent");
        if (labelComponent instanceof JLabel) {
            this.components.values().stream().map(Supplier::get).filter(component -> EntityEditComponentPanel.sameOrParentOf(inputComponent, component)).findAny().ifPresent(component -> EntityEditComponentPanel.setLabelForComponent((JLabel)labelComponent, component));
        }
        return (JPanel)Components.panel((LayoutManager)Layouts.borderLayout()).add(inputComponent, (Object)"Center").add(labelComponent, (Object)labelBorderLayoutConstraints).build();
    }

    protected final TextAreaBuilder createTextArea(Attribute<String> attribute) {
        return this.setComponentBuilder(attribute, (TextAreaBuilder)this.entityComponents.textArea(attribute).onBuild(textArea -> EntityComponentValidators.addValidator(attribute, textArea, this.editModel())));
    }

    protected final TextFieldPanel.Builder createTextFieldPanel(Attribute<String> attribute) {
        return this.setComponentBuilder(attribute, (TextFieldPanel.Builder)this.entityComponents.textFieldPanel(attribute).columns(((Integer)this.defaults.textFieldColumns.get()).intValue()).onBuild(inputPanel -> EntityComponentValidators.addValidator(attribute, inputPanel.textField(), this.editModel())));
    }

    protected final <T extends Temporal> TemporalFieldPanel.Builder<T> createTemporalFieldPanel(Attribute<T> attribute) {
        return this.setComponentBuilder(attribute, (TemporalFieldPanel.Builder)this.entityComponents.temporalFieldPanel(attribute).onBuild(inputPanel -> EntityComponentValidators.addFormattedValidator(attribute, (JTextComponent)inputPanel.temporalField(), this.editModel())));
    }

    protected final <T extends Temporal> TemporalFieldPanel.Builder<T> createTemporalFieldPanel(Attribute<T> attribute, String dateTimePattern) {
        return this.setComponentBuilder(attribute, (TemporalFieldPanel.Builder)this.entityComponents.temporalFieldPanel(attribute, dateTimePattern).onBuild(inputPanel -> EntityComponentValidators.addFormattedValidator(attribute, (JTextComponent)inputPanel.temporalField(), this.editModel())));
    }

    protected final <T, C extends JTextField, B extends TextFieldBuilder<T, C, B>> TextFieldBuilder<T, C, B> createTextField(Attribute<T> attribute) {
        return this.setComponentBuilder(attribute, (TextFieldBuilder)this.entityComponents.textField(attribute).columns(((Integer)this.defaults.textFieldColumns.get()).intValue()).onBuild(field -> EntityComponentValidators.addFormattedValidator(attribute, field, this.editModel())));
    }

    protected final <T extends Temporal> TemporalField.Builder<T> createTemporalField(Attribute<T> attribute) {
        return this.setComponentBuilder(attribute, (TemporalField.Builder)this.entityComponents.temporalField(attribute).onBuild(field -> EntityComponentValidators.addFormattedValidator(attribute, (JTextComponent)field, this.editModel())));
    }

    protected final <T extends Temporal> TemporalField.Builder<T> createTemporalField(Attribute<T> attribute, String dateTimePattern) {
        return this.setComponentBuilder(attribute, (TemporalField.Builder)this.entityComponents.temporalField(attribute, dateTimePattern).onBuild(field -> EntityComponentValidators.addFormattedValidator(attribute, (JTextComponent)field, this.editModel())));
    }

    protected final SliderBuilder createSlider(Attribute<Integer> attribute) {
        return this.setComponentBuilder(attribute, this.entityComponents.slider(attribute));
    }

    protected final NumberSpinnerBuilder<Integer> createIntegerSpinner(Attribute<Integer> attribute) {
        return this.setComponentBuilder((Attribute)attribute, (ComponentBuilder)this.entityComponents.integerSpinner(attribute));
    }

    protected final NumberSpinnerBuilder<Double> createDoubleSpinner(Attribute<Double> attribute) {
        return this.setComponentBuilder((Attribute)attribute, (ComponentBuilder)this.entityComponents.doubleSpinner(attribute));
    }

    protected final <T> ListSpinnerBuilder<T> createListSpinner(Attribute<T> attribute, SpinnerListModel spinnerListModel) {
        return this.setComponentBuilder(attribute, (ComponentBuilder)this.entityComponents.listSpinner(attribute, spinnerListModel));
    }

    protected final <T> ItemSpinnerBuilder<T> createItemSpinner(Attribute<T> attribute) {
        return this.setComponentBuilder(attribute, (ComponentBuilder)this.entityComponents.itemSpinner(attribute));
    }

    protected final NumberField.Builder<Integer> createIntegerField(Attribute<Integer> attribute) {
        return this.setComponentBuilder(attribute, (NumberField.Builder)((NumberField.Builder)this.entityComponents.integerField(attribute).columns(((Integer)this.defaults.textFieldColumns.get()).intValue())).onBuild(field -> EntityComponentValidators.addValidator(attribute, (JTextComponent)field, this.editModel())));
    }

    protected final NumberField.Builder<Long> createLongField(Attribute<Long> attribute) {
        return this.setComponentBuilder(attribute, (NumberField.Builder)((NumberField.Builder)this.entityComponents.longField(attribute).columns(((Integer)this.defaults.textFieldColumns.get()).intValue())).onBuild(field -> EntityComponentValidators.addValidator(attribute, (JTextComponent)field, this.editModel())));
    }

    protected final NumberField.Builder<Double> createDoubleField(Attribute<Double> attribute) {
        return this.setComponentBuilder(attribute, (NumberField.Builder)((NumberField.Builder)this.entityComponents.doubleField(attribute).columns(((Integer)this.defaults.textFieldColumns.get()).intValue())).onBuild(field -> EntityComponentValidators.addValidator(attribute, (JTextComponent)field, this.editModel())));
    }

    protected final NumberField.Builder<BigDecimal> createBigDecimalField(Attribute<BigDecimal> attribute) {
        return this.setComponentBuilder(attribute, (NumberField.Builder)((NumberField.Builder)this.entityComponents.bigDecimalField(attribute).columns(((Integer)this.defaults.textFieldColumns.get()).intValue())).onBuild(field -> EntityComponentValidators.addValidator(attribute, (JTextComponent)field, this.editModel())));
    }

    protected final MaskedTextFieldBuilder createMaskedTextField(Attribute<String> attribute) {
        return this.setComponentBuilder(attribute, (MaskedTextFieldBuilder)this.entityComponents.maskedTextField(attribute).onBuild(textField -> EntityComponentValidators.addFormattedValidator(attribute, textField, this.editModel())));
    }

    protected final CheckBoxBuilder createCheckBox(Attribute<Boolean> attribute) {
        return this.setComponentBuilder(attribute, this.entityComponents.checkBox(attribute));
    }

    protected final ItemComboBoxBuilder<Boolean> createBooleanComboBox(Attribute<Boolean> attribute) {
        return this.setComponentBuilder((Attribute)attribute, (ComponentBuilder)this.entityComponents.booleanComboBox(attribute));
    }

    protected final <T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>> ComboBoxBuilder<T, C, B> createComboBox(Attribute<T> attribute, ComboBoxModel<T> comboBoxModel) {
        return this.setComponentBuilder(attribute, (ComboBoxBuilder)this.entityComponents.comboBox(attribute, comboBoxModel).preferredWidth(((Integer)this.defaults.comboBoxPreferredWidth.get()).intValue()));
    }

    protected final <T> ItemComboBoxBuilder<T> createItemComboBox(Attribute<T> attribute) {
        return this.setComponentBuilder(attribute, (ItemComboBoxBuilder)this.entityComponents.itemComboBox(attribute).preferredWidth(((Integer)this.defaults.itemComboBoxPreferredWidth.get()).intValue()));
    }

    protected final <T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>> ComboBoxBuilder<T, C, B> createComboBox(Column<T> column) {
        FilteredComboBoxModel comboBoxModel = this.editModel().comboBoxModel(column);
        comboBoxModel.refresher().addRefreshFailedListener(this::onException);
        return this.setComponentBuilder((Attribute<T>)column, (B)((ComboBoxBuilder)((ComboBoxBuilder)this.entityComponents.comboBox(column, comboBoxModel).preferredWidth(((Integer)this.defaults.comboBoxPreferredWidth.get()).intValue())).onSetVisible(EntityEditComponentPanel::refreshIfCleared)));
    }

    protected final <B extends ComboBoxBuilder<Entity, EntityComboBox, B>> ComboBoxBuilder<Entity, EntityComboBox, B> createForeignKeyComboBox(ForeignKey foreignKey) {
        EntityComboBoxModel comboBoxModel = this.editModel().foreignKeyComboBoxModel(foreignKey);
        comboBoxModel.refresher().addRefreshFailedListener(this::onException);
        return this.setComponentBuilder((Attribute)foreignKey, (B)((ComboBoxBuilder)((ComboBoxBuilder)this.entityComponents.foreignKeyComboBox(foreignKey, comboBoxModel).preferredWidth(((Integer)this.defaults.foreignKeyComboBoxPreferredWidth.get()).intValue())).onSetVisible(EntityEditComponentPanel::refreshIfCleared)));
    }

    protected final EntityComboBoxPanel.Builder createForeignKeyComboBoxPanel(ForeignKey foreignKey, Supplier<EntityEditPanel> editPanelSupplier) {
        EntityComboBoxModel comboBoxModel = this.editModel().foreignKeyComboBoxModel(foreignKey);
        comboBoxModel.refresher().addRefreshFailedListener(this::onException);
        return (EntityComboBoxPanel.Builder)this.setComponentBuilder((Attribute)foreignKey, (ComponentBuilder)this.entityComponents.foreignKeyComboBoxPanel(foreignKey, comboBoxModel, editPanelSupplier)).comboBoxPreferredWidth((Integer)this.defaults.foreignKeyComboBoxPreferredWidth.get()).onSetVisible(entityComboBoxPanel -> EntityEditComponentPanel.refreshIfCleared(entityComboBoxPanel.comboBox()));
    }

    protected final EntitySearchField.Builder createForeignKeySearchField(ForeignKey foreignKey) {
        return this.setComponentBuilder((Attribute)foreignKey, (ComponentBuilder)this.entityComponents.foreignKeySearchField(foreignKey, this.editModel().foreignKeySearchModel(foreignKey)).columns((Integer)this.defaults.foreignKeySearchFieldColumns.get()));
    }

    protected final EntitySearchFieldPanel.Builder createForeignKeySearchFieldPanel(ForeignKey foreignKey, Supplier<EntityEditPanel> editPanelSupplier) {
        return this.setComponentBuilder((Attribute)foreignKey, (ComponentBuilder)this.entityComponents.foreignKeySearchFieldPanel(foreignKey, this.editModel().foreignKeySearchModel(foreignKey), editPanelSupplier).columns((Integer)this.defaults.foreignKeySearchFieldColumns.get()));
    }

    protected final <B extends TextFieldBuilder<Entity, JTextField, B>> TextFieldBuilder<Entity, JTextField, B> createForeignKeyTextField(ForeignKey foreignKey) {
        return this.setComponentBuilder((Attribute)foreignKey, (B)this.entityComponents.foreignKeyTextField(foreignKey));
    }

    protected final LabelBuilder<Entity> createForeignKeyLabel(ForeignKey foreignKey) {
        return this.setComponentBuilder((Attribute)foreignKey, (ComponentBuilder)this.entityComponents.foreignKeyLabel(foreignKey));
    }

    protected final <T> LabelBuilder<T> createLabel(Attribute<T> attribute) {
        AttributeDefinition attributeDefinition = this.editModel().entities().definition(Objects.requireNonNull(attribute).entityType()).attributes().definition(attribute);
        return Components.label((String)attributeDefinition.caption()).displayedMnemonic(attributeDefinition.mnemonic()).labelFor((JComponent)this.component(attribute).get());
    }

    protected JComponent getInitialFocusComponent() {
        if (this.initialFocusComponent.isNotNull()) {
            return (JComponent)this.initialFocusComponent.get();
        }
        if (this.initialFocusAttribute.isNotNull()) {
            return (JComponent)this.component((Attribute)this.initialFocusAttribute.get()).get();
        }
        return null;
    }

    protected JComponent getAfterInsertFocusComponent() {
        if (this.afterInsertFocusComponent.isNotNull()) {
            return (JComponent)this.afterInsertFocusComponent.get();
        }
        if (this.afterInsertFocusAttribute.isNotNull()) {
            return (JComponent)this.component((Attribute)this.afterInsertFocusAttribute.get()).get();
        }
        return this.getInitialFocusComponent();
    }

    protected final void requestAfterInsertFocus() {
        this.requestFocus(this.getAfterInsertFocusComponent());
    }

    protected final void requestAfterUpdateFocus() {
        this.requestFocus(this.focusedInputComponent.optional().orElse(this.getInitialFocusComponent()));
    }

    private <T, B extends ComponentBuilder<T, ?, ?>> B setComponentBuilder(Attribute<T> attribute, B componentBuilder) {
        Objects.requireNonNull(attribute);
        Objects.requireNonNull(componentBuilder);
        if (this.componentBuilders.containsKey(attribute) || this.components.containsKey(attribute)) {
            throw new IllegalStateException("Component has already been created for attribute: " + attribute);
        }
        this.componentBuilders.put(attribute, componentBuilder.transferFocusOnEnter(((Boolean)this.transferFocusOnEnter.get()).booleanValue()).linkedValue(this.editModel().value(attribute)).onBuild(new SetComponent(attribute)));
        return componentBuilder;
    }

    private void requestFocus(JComponent component) {
        if (component != null && component.isFocusable()) {
            component.requestFocus();
        } else {
            this.requestFocus();
        }
    }

    private JComponent getComponentOrThrow(Attribute<?> attribute) {
        Value<JComponent> component = this.component(attribute);
        if (component.isNull()) {
            throw new IllegalArgumentException("No component associated with attribute: " + attribute);
        }
        return (JComponent)component.get();
    }

    private void addFocusedComponentListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new FocusedInputComponentListener());
    }

    private Collection<Attribute<?>> selectComponentAttributes() {
        return this.components.keySet().stream().filter(arg_0 -> this.selectableComponents.contains(arg_0)).filter(attribute -> EntityEditComponentPanel.componentSelectable((JComponent)this.component((Attribute<?>)attribute).get())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableCollection));
    }

    private static boolean componentSelectable(JComponent component) {
        return component != null && component.isDisplayable() && component.isVisible() && component.isEnabled() && EntityEditComponentPanel.focusable(component);
    }

    private static boolean focusable(JComponent component) {
        if (component instanceof JSpinner) {
            return ((JSpinner.DefaultEditor)((JSpinner)component).getEditor()).getTextField().isFocusable();
        }
        return component.isFocusable();
    }

    private static JComponent focusableComponent(JComponent component) {
        if (component instanceof JSpinner) {
            return ((JSpinner.DefaultEditor)((JSpinner)component).getEditor()).getTextField();
        }
        return component;
    }

    private static JLabel setLabelForComponent(JLabel label, JComponent component) {
        if (component != null && label.getLabelFor() != component) {
            label.setLabelFor(component);
        }
        return label;
    }

    private static void refreshIfCleared(JComboBox<?> comboBox) {
        FilteredComboBoxModel comboBoxModel;
        ComboBoxModel<?> model = comboBox.getModel();
        if (model instanceof FilteredComboBoxModel && (comboBoxModel = (FilteredComboBoxModel)model).cleared()) {
            comboBoxModel.refresh();
        }
    }

    private static boolean sameOrParentOf(JComponent parent, JComponent component) {
        if (parent == component) {
            return true;
        }
        return Arrays.stream(parent.getComponents()).anyMatch(childComponent -> childComponent instanceof JComponent && EntityEditComponentPanel.sameOrParentOf((JComponent)childComponent, component));
    }

    protected static final class Defaults {
        private final Value<Integer> textFieldColumns = Value.value((Object)((Integer)DEFAULT_TEXT_FIELD_COLUMNS.get()), (Object)((Integer)DEFAULT_TEXT_FIELD_COLUMNS.get()));
        private final Value<Integer> foreignKeySearchFieldColumns = Value.value((Object)((Integer)DEFAULT_TEXT_FIELD_COLUMNS.get()), (Object)((Integer)DEFAULT_TEXT_FIELD_COLUMNS.get()));
        private final Value<Integer> foreignKeyComboBoxPreferredWidth = Value.value((Object)0, (Object)0);
        private final Value<Integer> itemComboBoxPreferredWidth = Value.value((Object)0, (Object)0);
        private final Value<Integer> comboBoxPreferredWidth = Value.value((Object)0, (Object)0);

        protected Defaults() {
        }

        public Value<Integer> textFieldColumns() {
            return this.textFieldColumns;
        }

        public Value<Integer> foreignKeySearchFieldColumns() {
            return this.foreignKeySearchFieldColumns;
        }

        public Value<Integer> comboBoxPreferredWidth() {
            return this.comboBoxPreferredWidth;
        }

        public Value<Integer> itemComboBoxPreferredWidth() {
            return this.itemComboBoxPreferredWidth;
        }

        public Value<Integer> foreignKeyComboBoxPreferredWidth() {
            return this.foreignKeyComboBoxPreferredWidth;
        }
    }

    private static final class SelectableComponentValidator
    implements Value.Validator<Set<Attribute<?>>> {
        private final EntityDefinition definition;

        private SelectableComponentValidator(EntityDefinition definition) {
            this.definition = definition;
        }

        public void validate(Set<Attribute<?>> attributes) {
            attributes.forEach(attribute -> this.definition.attributes().definition(attribute));
        }
    }

    private final class SetComponent<C extends JComponent>
    implements Consumer<C> {
        private final Attribute<?> attribute;

        private SetComponent(Attribute<?> attribute) {
            this.attribute = attribute;
        }

        @Override
        public void accept(C component) {
            EntityEditComponentPanel.this.componentBuilders.remove(this.attribute);
            EntityEditComponentPanel.this.components.computeIfAbsent(this.attribute, k -> Value.value()).set(component);
            if (((Boolean)EntityEditComponentPanel.this.modifiedIndicator.get()).booleanValue() && this.attribute.entityType().equals(EntityEditComponentPanel.this.editModel.entityType())) {
                EntityEditComponentPanel.this.editModel.modified(this.attribute).addDataListener((Consumer)new ModifiedIndicator((JComponent)component));
            }
        }
    }

    private final class FocusedInputComponentListener
    implements PropertyChangeListener {
        private FocusedInputComponentListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Component component = (Component)event.getNewValue();
            if (component instanceof JComponent && this.inputComponent((JComponent)component)) {
                EntityEditComponentPanel.this.focusedInputComponent.set((Object)((JComponent)component));
            }
        }

        private boolean inputComponent(JComponent component) {
            return EntityEditComponentPanel.this.components.values().stream().filter(ValueObserver::isNotNull).map(Supplier::get).anyMatch(comp -> EntityEditComponentPanel.sameOrParentOf(comp, component));
        }
    }

    private static final class ModifiedIndicator
    implements Consumer<Boolean> {
        private static final String LABELED_BY_PROPERTY = "labeledBy";
        private static final int UNDERLINE_STYLE = (Integer)MODIFIED_INDICATOR_UNDERLINE_STYLE.get();
        private final JComponent component;

        private ModifiedIndicator(JComponent component) {
            this.component = component;
        }

        @Override
        public void accept(Boolean modified) {
            JLabel label = (JLabel)this.component.getClientProperty(LABELED_BY_PROPERTY);
            if (label != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    ModifiedIndicator.setModifiedIndicator(label, modified);
                } else {
                    SwingUtilities.invokeLater(() -> ModifiedIndicator.setModifiedIndicator(label, modified));
                }
            }
        }

        private static void setModifiedIndicator(JLabel label, boolean modified) {
            Font font = label.getFont();
            Map<TextAttribute, ?> attributes = font.getAttributes();
            attributes.put(TextAttribute.INPUT_METHOD_UNDERLINE, modified ? Integer.valueOf(UNDERLINE_STYLE) : null);
            label.setFont(font.deriveFont(attributes));
        }
    }
}

