/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.db.exception.DatabaseException;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public final class EntityDependenciesPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityDependenciesPanel.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, EntityDependenciesPanel::defaultKeyStroke);
    private final JTabbedPane tabPane = new JTabbedPane(1);

    EntityDependenciesPanel(Map<EntityType, Collection<Entity>> dependencies, EntityConnectionProvider connectionProvider) {
        super(new BorderLayout());
        for (Map.Entry<EntityType, Collection<Entity>> entry : dependencies.entrySet()) {
            this.tabPane.addTab(connectionProvider.entities().definition(entry.getKey()).caption(), EntityDependenciesPanel.createTablePanel(entry.getValue(), connectionProvider));
        }
        this.add((Component)this.tabPane, "Center");
        KeyEvents.builder((KeyStroke)((KeyStroke)KEYBOARD_SHORTCUTS.keyStroke((Enum)KeyboardShortcut.NAVIGATE_RIGHT).get())).condition(1).action((Action)Control.control((Control.Command)new NavigateRightCommand())).enable(new JComponent[]{this.tabPane});
        KeyEvents.builder((KeyStroke)((KeyStroke)KEYBOARD_SHORTCUTS.keyStroke((Enum)KeyboardShortcut.NAVIGATE_LEFT).get())).condition(1).action((Action)Control.control((Control.Command)new NavigateLeftCommand())).enable(new JComponent[]{this.tabPane});
    }

    public static void displayDependenciesDialog(Collection<Entity> entities, EntityConnectionProvider connectionProvider, JComponent dialogParent) {
        EntityDependenciesPanel.displayDependenciesDialog(entities, connectionProvider, dialogParent, MESSAGES.getString("no_dependencies"));
    }

    public static void displayDependenciesDialog(Collection<Entity> entities, EntityConnectionProvider connectionProvider, JComponent dialogParent, String noDependenciesMessage) {
        Objects.requireNonNull(entities);
        Objects.requireNonNull(connectionProvider);
        Objects.requireNonNull(dialogParent);
        Map<EntityType, Collection<Entity>> dependencies = EntityDependenciesPanel.dependencies(entities, connectionProvider, dialogParent);
        EntityDependenciesPanel.displayDependenciesDialog(dependencies, connectionProvider, dialogParent, noDependenciesMessage);
    }

    private static EntityTablePanel createTablePanel(Collection<Entity> entities, EntityConnectionProvider connectionProvider) {
        SwingEntityTableModel tableModel = SwingEntityTableModel.tableModel(entities, (EntityConnectionProvider)connectionProvider);
        EntityTablePanel tablePanel = new EntityTablePanel(tableModel, config -> config.includeConditionPanel(false)){

            @Override
            protected Controls createPopupMenuControls(List<Controls> additionalPopupMenuControls) {
                Controls popupMenuControls = Controls.controls();
                this.control(EntityTablePanel.TableControl.EDIT_SELECTED).optional().ifPresent(arg_0 -> ((Controls)popupMenuControls).add(arg_0));
                this.control(EntityTablePanel.TableControl.DELETE_SELECTED).optional().ifPresent(arg_0 -> ((Controls)popupMenuControls).add(arg_0));
                this.control(EntityTablePanel.TableControl.VIEW_DEPENDENCIES).optional().ifPresent(viewDependencies -> {
                    if (popupMenuControls.notEmpty()) {
                        popupMenuControls.addSeparator();
                    }
                    popupMenuControls.add((Action)viewDependencies);
                });
                return popupMenuControls;
            }
        };
        return tablePanel.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<EntityType, Collection<Entity>> dependencies(Collection<Entity> entities, EntityConnectionProvider connectionProvider, JComponent dialogParent) {
        dialogParent.setCursor(Cursors.WAIT);
        try {
            Map map = connectionProvider.connection().dependencies(entities);
            return map;
        }
        catch (DatabaseException e) {
            Dialogs.displayExceptionDialog((Throwable)e, (Window)Utilities.parentWindow((Component)dialogParent));
            Map<EntityType, Collection<Entity>> map = Collections.emptyMap();
            return map;
        }
        finally {
            dialogParent.setCursor(Cursors.DEFAULT);
        }
    }

    private static void displayDependenciesDialog(Map<EntityType, Collection<Entity>> dependencies, EntityConnectionProvider connectionProvider, JComponent dialogParent, String noDependenciesMessage) {
        if (dependencies.isEmpty()) {
            JOptionPane.showMessageDialog(dialogParent, noDependenciesMessage, MESSAGES.getString("no_dependencies_title"), 1);
        } else {
            EntityDependenciesPanel dependenciesPanel = new EntityDependenciesPanel(dependencies, connectionProvider);
            int gap = (Integer)Layouts.GAP.get();
            dependenciesPanel.setBorder(BorderFactory.createEmptyBorder(0, gap, 0, gap));
            ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)dependenciesPanel).owner((Component)dialogParent)).title(FrameworkMessages.dependencies())).onShown(dialog -> dependenciesPanel.requestSelectedTableFocus()).show();
        }
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case NAVIGATE_LEFT: {
                return KeyboardShortcuts.keyStroke((int)37, (int)640);
            }
            case NAVIGATE_RIGHT: {
                return KeyboardShortcuts.keyStroke((int)39, (int)640);
            }
        }
        throw new IllegalArgumentException();
    }

    void requestSelectedTableFocus() {
        ((EntityTablePanel)this.tabPane.getSelectedComponent()).table().requestFocusInWindow();
    }

    public static enum KeyboardShortcut {
        NAVIGATE_LEFT,
        NAVIGATE_RIGHT;

    }

    private final class NavigateRightCommand
    implements Control.Command {
        private NavigateRightCommand() {
        }

        public void execute() {
            int selectedIndex = EntityDependenciesPanel.this.tabPane.getSelectedIndex();
            EntityDependenciesPanel.this.tabPane.setSelectedIndex(selectedIndex == EntityDependenciesPanel.this.tabPane.getTabCount() - 1 ? 0 : selectedIndex + 1);
            EntityDependenciesPanel.this.requestSelectedTableFocus();
        }
    }

    private final class NavigateLeftCommand
    implements Control.Command {
        private NavigateLeftCommand() {
        }

        public void execute() {
            int selectedIndex = EntityDependenciesPanel.this.tabPane.getSelectedIndex();
            EntityDependenciesPanel.this.tabPane.setSelectedIndex(selectedIndex == 0 ? EntityDependenciesPanel.this.tabPane.getTabCount() - 1 : selectedIndex - 1);
            EntityDependenciesPanel.this.requestSelectedTableFocus();
        }
    }
}

