/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public final class TabbedPanelLayout
implements EntityPanel.PanelLayout {
    public static final PropertyValue<Boolean> INCLUDE_DETAIL_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.TabbedPanelLayout.includeDetailControls", (boolean)true);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(TabbedPanelLayout.class.getName());
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, TabbedPanelLayout::defaultKeyStroke);
    private static final int RESIZE_AMOUNT = 30;
    private static final String DETAIL_TABLES = "detail_tables";
    private static final double DEFAULT_SPLIT_PANE_RESIZE_WEIGHT = 0.5;
    private static final int DETAIL_WINDOW_OFFSET = 38;
    private static final double DETAIL_WINDOW_SIZE_RATIO = 0.66;
    private final TabbedDetailController detailController;
    private EntityPanel entityPanel;
    private JTabbedPane detailPanelTabbedPane;
    private JSplitPane detailPanelSplitPane;
    private Window detailPanelWindow;
    private EntityPanel.PanelState detailPanelState = EntityPanel.PanelState.EMBEDDED;
    private final boolean includeDetailTabbedPane;
    private final boolean includeDetailPanelControls;
    private final double splitPaneResizeWeight;
    private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts;

    private TabbedPanelLayout(DefaultBuilder builder) {
        this.detailPanelState = builder.detailPanelState;
        this.includeDetailTabbedPane = builder.includeDetailTabbedPane;
        this.includeDetailPanelControls = builder.includeDetailControls;
        this.splitPaneResizeWeight = builder.splitPaneResizeWeight;
        this.detailController = new TabbedDetailController();
        this.keyboardShortcuts = builder.keyboardShortcuts;
    }

    @Override
    public void updateUI() {
        Utilities.updateUI((JComponent[])new JComponent[]{this.detailPanelTabbedPane, this.detailPanelSplitPane});
    }

    @Override
    public void layout(EntityPanel entityPanel) {
        this.entityPanel = Objects.requireNonNull(entityPanel);
        entityPanel.setLayout(Layouts.borderLayout());
        entityPanel.add((Component)this.createCenterComponent(), "Center");
        this.setupResizing();
        this.setupControls();
        this.initializeDetailPanelState();
    }

    @Override
    public <T extends EntityPanel.DetailController> Optional<T> detailController() {
        return Optional.of(this.detailController);
    }

    public static TabbedPanelLayout detailPanelState(EntityPanel.PanelState detailPanelState) {
        return TabbedPanelLayout.builder().detailPanelState(detailPanelState).build();
    }

    public static TabbedPanelLayout splitPaneResizeWeight(double splitPaneResizeWeight) {
        return TabbedPanelLayout.builder().splitPaneResizeWeight(splitPaneResizeWeight).build();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private void setupResizing() {
        this.entityPanel.addKeyEvent(KeyEvents.builder((KeyStroke)((KeyStroke)this.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.RESIZE_RIGHT).get())).condition(1).action((Action)new ResizeHorizontally(this.entityPanel, EntityPanel.Direction.RIGHT)));
        this.entityPanel.addKeyEvent(KeyEvents.builder((KeyStroke)((KeyStroke)this.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.RESIZE_LEFT).get())).condition(1).action((Action)new ResizeHorizontally(this.entityPanel, EntityPanel.Direction.LEFT)));
    }

    private void setupControls() {
        if (this.entityPanel.containsTablePanel()) {
            Object tablePanel = this.entityPanel.tablePanel();
            Controls controls = Controls.controls();
            this.detailController.toggleDetailControl().ifPresent(arg_0 -> ((Controls)controls).add(arg_0));
            if (controls.notEmpty()) {
                ((EntityTablePanel)tablePanel).configure().addToolBarControls(controls);
            }
            this.detailController.detailControls().ifPresent(((EntityTablePanel)tablePanel).configure()::addPopupMenuControls);
        }
    }

    private void initializeDetailPanelState() {
        this.selectedDetailPanel().ifPresent(selectedDetailPanel -> {
            Value<EntityPanel.PanelState> detailPanelStateValue = this.detailController.panelState((EntityPanel)selectedDetailPanel);
            if (detailPanelStateValue.isNotEqualTo((Object)this.detailPanelState)) {
                detailPanelStateValue.set((Object)this.detailPanelState);
            } else {
                this.detailController.updateDetailState();
            }
        });
    }

    private Optional<EntityPanel> selectedDetailPanel() {
        return Optional.ofNullable(this.detailPanelTabbedPane == null ? null : (EntityPanel)this.detailPanelTabbedPane.getSelectedComponent());
    }

    private JComponent createCenterComponent() {
        if (this.includeDetailTabbedPane && !this.entityPanel.detailPanels().isEmpty()) {
            this.detailPanelSplitPane = this.createTableDetailSplitPane(this.entityPanel.editControlTablePanel());
            this.detailPanelTabbedPane = this.createDetailTabbedPane(this.entityPanel.detailPanels());
            return this.detailPanelSplitPane;
        }
        return this.entityPanel.editControlTablePanel();
    }

    private JSplitPane createTableDetailSplitPane(JPanel editControlTablePanel) {
        return (JSplitPane)Components.splitPane().orientation(1).continuousLayout(true).oneTouchExpandable(true).dividerSize((Integer)Layouts.GAP.get() * 2).resizeWeight(this.splitPaneResizeWeight).leftComponent((JComponent)editControlTablePanel).build();
    }

    private JTabbedPane createDetailTabbedPane(Collection<EntityPanel> detailPanels) {
        TabbedPaneBuilder builder = (TabbedPaneBuilder)((TabbedPaneBuilder)Components.tabbedPane().focusable(false)).changeListener(e -> this.selectedDetailPanel().ifPresent(EntityPanel::activate)).onBuild(tabbedPane -> tabbedPane.setFocusCycleRoot(true));
        detailPanels.forEach(detailPanel -> builder.tabBuilder((String)detailPanel.caption().get(), (JComponent)detailPanel).toolTipText(detailPanel.getDescription()).add());
        if (this.includeDetailPanelControls) {
            builder.mouseListener((MouseListener)new TabbedPaneMouseReleasedListener());
        }
        return (JTabbedPane)builder.build();
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case RESIZE_LEFT: {
                return KeyboardShortcuts.keyStroke((int)37, (int)576);
            }
            case RESIZE_RIGHT: {
                return KeyboardShortcuts.keyStroke((int)39, (int)576);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private EntityPanel.PanelState detailPanelState = EntityPanel.PanelState.EMBEDDED;
        private double splitPaneResizeWeight = 0.5;
        private boolean includeDetailTabbedPane = true;
        private boolean includeDetailControls = (Boolean)INCLUDE_DETAIL_CONTROLS.get();

        private DefaultBuilder() {
        }

        @Override
        public Builder detailPanelState(EntityPanel.PanelState detailPanelState) {
            this.detailPanelState = Objects.requireNonNull(detailPanelState);
            return this;
        }

        @Override
        public Builder splitPaneResizeWeight(double splitPaneResizeWeight) {
            this.splitPaneResizeWeight = splitPaneResizeWeight;
            return this;
        }

        @Override
        public Builder includeDetailTabbedPane(boolean includeDetailTabbedPane) {
            this.includeDetailTabbedPane = includeDetailTabbedPane;
            return this;
        }

        @Override
        public Builder includeDetailControls(boolean includeDetailControls) {
            this.includeDetailControls = includeDetailControls;
            return this;
        }

        @Override
        public Builder keyStroke(KeyboardShortcut keyboardShortcut, KeyStroke keyStroke) {
            this.keyboardShortcuts.keyStroke((Enum)keyboardShortcut).set((Object)keyStroke);
            return this;
        }

        @Override
        public TabbedPanelLayout build() {
            return new TabbedPanelLayout(this);
        }
    }

    private final class TabbedDetailController
    implements EntityPanel.DetailController {
        private final Value<EntityPanel.PanelState> panelState = Value.value((Object)((Object)EntityPanel.PanelState.EMBEDDED), (Object)((Object)EntityPanel.PanelState.EMBEDDED));

        private TabbedDetailController() {
            this.panelState.addListener(this::updateDetailState);
        }

        @Override
        public void select(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            if (TabbedPanelLayout.this.detailPanelTabbedPane != null) {
                TabbedPanelLayout.this.detailPanelTabbedPane.setFocusable(true);
                TabbedPanelLayout.this.detailPanelTabbedPane.setSelectedComponent(detailPanel);
                TabbedPanelLayout.this.detailPanelTabbedPane.setFocusable(false);
            }
            this.activateDetailModelLink((SwingEntityModel)detailPanel.model());
        }

        @Override
        public Value<EntityPanel.PanelState> panelState(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            return this.panelState;
        }

        private void updateDetailState() {
            TabbedPanelLayout.this.selectedDetailPanel().ifPresent(selectedDetailPanel -> {
                if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                    selectedDetailPanel.initialize();
                }
                Object selectedDetailModel = selectedDetailPanel.model();
                if (TabbedPanelLayout.this.entityPanel.model().containsDetailModel(selectedDetailModel)) {
                    TabbedPanelLayout.this.entityPanel.model().detailModelLink(selectedDetailModel).active().set((Object)this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.HIDDEN));
                }
            });
            if (this.previousPanelState() == EntityPanel.PanelState.WINDOW) {
                this.disposeDetailWindow();
            }
            if (this.panelState.isEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                TabbedPanelLayout.this.detailPanelSplitPane.setRightComponent(TabbedPanelLayout.this.detailPanelTabbedPane);
            } else if (this.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                TabbedPanelLayout.this.detailPanelSplitPane.setRightComponent(null);
            } else {
                this.displayDetailWindow();
            }
            TabbedPanelLayout.this.entityPanel.revalidate();
        }

        private EntityPanel.PanelState previousPanelState() {
            if (TabbedPanelLayout.this.detailPanelTabbedPane == null) {
                throw new IllegalStateException("No tabbed detail pane available");
            }
            if (TabbedPanelLayout.this.detailPanelWindow != null) {
                return EntityPanel.PanelState.WINDOW;
            }
            if (TabbedPanelLayout.this.detailPanelTabbedPane.isShowing()) {
                return EntityPanel.PanelState.EMBEDDED;
            }
            return EntityPanel.PanelState.HIDDEN;
        }

        private void activateDetailModelLink(SwingEntityModel detailModel) {
            Object model = TabbedPanelLayout.this.entityPanel.model();
            if (model.containsDetailModel((DefaultEntityModel)detailModel)) {
                model.activeDetailModels().stream().filter(activeDetailModel -> activeDetailModel != detailModel).forEach(activeDetailModel -> model.detailModelLink((DefaultEntityModel)activeDetailModel).active().set((Object)false));
                model.detailModelLink((DefaultEntityModel)detailModel).active().set((Object)true);
            }
        }

        private Optional<Control> toggleDetailControl() {
            if (TabbedPanelLayout.this.includeDetailPanelControls && !TabbedPanelLayout.this.entityPanel.detailPanels().isEmpty()) {
                return Optional.of(this.createToggleDetailControl());
            }
            return Optional.empty();
        }

        private Optional<Controls> detailControls() {
            if (TabbedPanelLayout.this.includeDetailPanelControls && !TabbedPanelLayout.this.entityPanel.detailPanels().isEmpty()) {
                return Optional.of(this.createDetailControls());
            }
            return Optional.empty();
        }

        private Control createToggleDetailControl() {
            return Control.builder(this::toggleDetailState).smallIcon((Icon)FrameworkIcons.instance().detail()).description(MESSAGES.getString("toggle_detail")).build();
        }

        private void toggleDetailState() {
            this.panelState.map(EntityPanel.PANEL_STATE_MAPPER);
        }

        private Controls createDetailControls() {
            Controls.Builder controls = (Controls.Builder)((Controls.Builder)Controls.builder().name(MESSAGES.getString(TabbedPanelLayout.DETAIL_TABLES))).smallIcon((Icon)FrameworkIcons.instance().detail());
            TabbedPanelLayout.this.entityPanel.detailPanels().forEach(detailPanel -> controls.control(Control.builder((Control.Command)new ActivateDetailPanel((EntityPanel)detailPanel)).name((String)detailPanel.caption().get())));
            return (Controls)controls.build();
        }

        private void displayDetailWindow() {
            Window parent = Utilities.parentWindow((Component)TabbedPanelLayout.this.entityPanel);
            if (parent != null) {
                Dimension parentSize = parent.getSize();
                Dimension size = this.detailWindowSize(parentSize);
                Point parentLocation = parent.getLocation();
                int detailWindowX = parentLocation.x + (parentSize.width - size.width);
                int detailWindowY = parentLocation.y + (parentSize.height - size.height) - 38;
                TabbedPanelLayout.this.detailPanelWindow = this.createDetailWindow();
                TabbedPanelLayout.this.detailPanelWindow.setSize(size);
                TabbedPanelLayout.this.detailPanelWindow.setLocation(new Point(detailWindowX, detailWindowY));
                TabbedPanelLayout.this.detailPanelWindow.setVisible(true);
            }
        }

        private void disposeDetailWindow() {
            if (TabbedPanelLayout.this.detailPanelWindow != null) {
                TabbedPanelLayout.this.detailPanelWindow.setVisible(false);
                TabbedPanelLayout.this.detailPanelWindow.dispose();
                TabbedPanelLayout.this.detailPanelWindow = null;
            }
        }

        private Dimension detailWindowSize(Dimension parentSize) {
            int detailWindowWidth = (int)((double)parentSize.width * 0.66);
            int detailWindowHeight = TabbedPanelLayout.this.entityPanel.containsEditPanel() ? (int)((double)parentSize.height * 0.66) : parentSize.height;
            return new Dimension(detailWindowWidth, detailWindowHeight);
        }

        private Window createDetailWindow() {
            if (((Boolean)EntityPanel.USE_FRAME_PANEL_DISPLAY.get()).booleanValue()) {
                return Windows.frame((JComponent)this.createEmptyBorderBasePanel(TabbedPanelLayout.this.detailPanelTabbedPane)).title((String)TabbedPanelLayout.this.entityPanel.caption().get() + " - " + MESSAGES.getString(TabbedPanelLayout.DETAIL_TABLES)).defaultCloseOperation(2).onClosed(windowEvent -> {
                    if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                        this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                    }
                }).build();
            }
            return ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.createEmptyBorderBasePanel(TabbedPanelLayout.this.detailPanelTabbedPane)).owner((Component)TabbedPanelLayout.this.entityPanel)).title((String)TabbedPanelLayout.this.entityPanel.caption().get() + " - " + MESSAGES.getString(TabbedPanelLayout.DETAIL_TABLES))).modal(false).onClosed(e -> {
                if (this.panelState.isNotEqualTo((Object)EntityPanel.PanelState.EMBEDDED)) {
                    this.panelState.set((Object)EntityPanel.PanelState.HIDDEN);
                }
            }).build();
        }

        private JPanel createEmptyBorderBasePanel(JComponent component) {
            int gap = (Integer)Layouts.GAP.get();
            return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(component).border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).build();
        }

        private final class ActivateDetailPanel
        implements Control.Command {
            private final EntityPanel detailPanel;

            private ActivateDetailPanel(EntityPanel detailPanel) {
                this.detailPanel = detailPanel;
            }

            public void execute() {
                if (TabbedDetailController.this.panelState.isEqualTo((Object)EntityPanel.PanelState.HIDDEN)) {
                    TabbedDetailController.this.panelState.set((Object)EntityPanel.PanelState.EMBEDDED);
                }
                this.detailPanel.activate();
            }
        }
    }

    public static interface Builder {
        public Builder detailPanelState(EntityPanel.PanelState var1);

        public Builder splitPaneResizeWeight(double var1);

        public Builder includeDetailTabbedPane(boolean var1);

        public Builder includeDetailControls(boolean var1);

        public Builder keyStroke(KeyboardShortcut var1, KeyStroke var2);

        public TabbedPanelLayout build();
    }

    public static enum KeyboardShortcut {
        RESIZE_RIGHT,
        RESIZE_LEFT;

    }

    private static final class ResizeHorizontally
    extends AbstractAction {
        private final EntityPanel panel;
        private final EntityPanel.Direction direction;

        private ResizeHorizontally(EntityPanel panel, EntityPanel.Direction direction) {
            super("Resize " + direction);
            this.panel = panel;
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.panel.parentPanel().ifPresent(parentPanel -> ResizeHorizontally.resizePanel(parentPanel, this.direction));
        }

        private static void resizePanel(EntityPanel panel, EntityPanel.Direction direction) {
            TabbedPanelLayout detailPanelLayout = (TabbedPanelLayout)panel.panelLayout();
            JSplitPane splitPane = detailPanelLayout.detailPanelSplitPane;
            switch (Objects.requireNonNull(direction)) {
                case RIGHT: {
                    if (splitPane == null) break;
                    splitPane.setDividerLocation(Math.min(splitPane.getDividerLocation() + 30, splitPane.getMaximumDividerLocation()));
                    break;
                }
                case LEFT: {
                    if (splitPane == null) break;
                    splitPane.setDividerLocation(Math.max(splitPane.getDividerLocation() - 30, 0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Undefined resize direction: " + direction);
                }
            }
        }
    }

    private final class TabbedPaneMouseReleasedListener
    extends MouseAdapter {
        private TabbedPaneMouseReleasedListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TabbedPanelLayout.this.selectedDetailPanel().ifPresent(selectedDetailPanel -> {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    TabbedPanelLayout.this.detailController.panelState((EntityPanel)selectedDetailPanel).map(panelState -> panelState == EntityPanel.PanelState.WINDOW ? EntityPanel.PanelState.EMBEDDED : EntityPanel.PanelState.WINDOW);
                } else if (e.getButton() == 2) {
                    TabbedPanelLayout.this.detailController.panelState((EntityPanel)selectedDetailPanel).map(panelState -> panelState == EntityPanel.PanelState.EMBEDDED ? EntityPanel.PanelState.HIDDEN : EntityPanel.PanelState.EMBEDDED);
                }
            });
        }
    }
}

