/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.ui.EntityApplicationPanel;
import is.codion.swing.framework.ui.EntityPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedApplicationLayout
implements EntityApplicationPanel.ApplicationLayout {
    public static final PropertyValue<Integer> TAB_PLACEMENT = Configuration.integerValue((String)"is.codion.swing.framework.ui.TabbedApplicationLayout.tabPlacement", (int)1);
    private final JTabbedPane applicationTabPane = (JTabbedPane)((TabbedPaneBuilder)Components.tabbedPane().tabPlacement(((Integer)TAB_PLACEMENT.get()).intValue()).focusable(false)).changeListener((ChangeListener)new InitializeSelectedPanelListener()).build();

    @Override
    public void layout(EntityApplicationPanel<?> applicationPanel) {
        Objects.requireNonNull(applicationPanel);
        applicationPanel.entityPanels().forEach(this::addTab);
        applicationPanel.setBorder(BorderFactory.createEmptyBorder(0, (Integer)Layouts.GAP.get(), 0, (Integer)Layouts.GAP.get()));
        applicationPanel.setLayout(new BorderLayout());
        applicationPanel.add((Component)Components.borderLayoutPanel((BorderLayout)new BorderLayout()).centerComponent((JComponent)this.applicationTabPane).build(), "Center");
    }

    @Override
    public final void select(EntityPanel entityPanel) {
        Objects.requireNonNull(entityPanel);
        if (this.applicationTabPane.indexOfComponent(entityPanel) != -1) {
            this.applicationTabPane.setSelectedComponent(entityPanel);
        }
    }

    public final JTabbedPane applicationTabPane() {
        return this.applicationTabPane;
    }

    private void addTab(EntityPanel entityPanel) {
        this.applicationTabPane.addTab((String)entityPanel.caption().get(), entityPanel);
        this.applicationTabPane.setToolTipTextAt(this.applicationTabPane.getTabCount() - 1, entityPanel.getDescription());
    }

    private final class InitializeSelectedPanelListener
    implements ChangeListener {
        private InitializeSelectedPanelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (TabbedApplicationLayout.this.applicationTabPane.getTabCount() > 0) {
                ((EntityPanel)TabbedApplicationLayout.this.applicationTabPane.getSelectedComponent()).activate();
            }
        }
    }
}

