/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.text.TextFieldPanel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.DialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponents;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityDialogs {
    public static <T> EditDialogBuilder<T> editDialog(SwingEntityEditModel editModel, Attribute<T> attribute) {
        return new DefaultEntityEditDialogBuilder<T>(editModel, attribute);
    }

    public static SelectionDialogBuilder selectionDialog(SwingEntityTableModel tableModel) {
        return new DefaultSelectionDialogBuilder(tableModel);
    }

    private static final class DefaultEntityEditDialogBuilder<T>
    extends AbstractDialogBuilder<EditDialogBuilder<T>>
    implements EditDialogBuilder<T> {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultEntityEditDialogBuilder.class);
        private final SwingEntityEditModel editModel;
        private final Attribute<T> attribute;
        private EntityComponentFactory<T, Attribute<T>, ?> componentFactory = new EditEntityComponentFactory();
        private Consumer<ValidationException> onValidationException = new DefaultValidationExceptionHandler();
        private Consumer<Exception> onException = new DefaultExceptionHandler();
        private EditDialogBuilder.Updater<SwingEntityEditModel> updater = new DefaultUpdater();

        private DefaultEntityEditDialogBuilder(SwingEntityEditModel editModel, Attribute<T> attribute) {
            this.editModel = Objects.requireNonNull(editModel);
            this.attribute = Objects.requireNonNull(attribute);
        }

        @Override
        public EditDialogBuilder<T> componentFactory(EntityComponentFactory<T, Attribute<T>, ?> componentFactory) {
            this.componentFactory = componentFactory == null ? new EditEntityComponentFactory() : componentFactory;
            return this;
        }

        @Override
        public EditDialogBuilder<T> onValidationException(Consumer<ValidationException> onValidationException) {
            this.onValidationException = Objects.requireNonNull(onValidationException);
            return this;
        }

        @Override
        public EditDialogBuilder<T> onException(Consumer<Exception> onException) {
            this.onException = Objects.requireNonNull(onException);
            return this;
        }

        @Override
        public <E extends SwingEntityEditModel> EditDialogBuilder<T> updater(EditDialogBuilder.Updater<E> updater) {
            this.updater = Objects.requireNonNull(updater);
            return this;
        }

        @Override
        public void edit(Entity entity) {
            this.edit(Collections.singleton(Objects.requireNonNull(entity)));
        }

        @Override
        public void edit(Collection<? extends Entity> entities) {
            Set entityTypes = Objects.requireNonNull(entities).stream().map(Entity::entityType).collect(Collectors.toSet());
            if (entityTypes.isEmpty()) {
                return;
            }
            if (entityTypes.size() > 1) {
                throw new IllegalArgumentException("All entities must be of the same type when editing");
            }
            AttributeDefinition attributeDefinition = this.editModel.entityDefinition().attributes().definition(this.attribute);
            Collection selectedEntities = entities.stream().map(Entity::copy).collect(Collectors.toList());
            Collection values = Entity.distinct(this.attribute, (Collection)selectedEntities);
            T initialValue = values.size() == 1 ? (T)values.iterator().next() : null;
            ComponentValue<Object, JComponent> componentValue = this.editSelectedComponentValue(this.attribute, initialValue);
            InputValidator<Object> inputValidator = new InputValidator<Object>(attributeDefinition, componentValue);
            boolean updatePerformed = false;
            while (!updatePerformed) {
                Object newValue = ((InputDialogBuilder)((InputDialogBuilder)((InputDialogBuilder)Dialogs.inputDialog(componentValue).owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).title(FrameworkMessages.edit())).caption(attributeDefinition.caption()).inputValidator(inputValidator).show();
                selectedEntities.forEach(entity -> entity.put(this.attribute, newValue));
                updatePerformed = this.update(selectedEntities.stream().filter(Entity::modified).collect(Collectors.toList()));
            }
        }

        private ComponentValue<T, ? extends JComponent> editSelectedComponentValue(Attribute<T> attribute, T initialValue) {
            if (this.componentFactory == null) {
                EditEntityComponentFactory entityComponentFactory = new EditEntityComponentFactory();
                return entityComponentFactory.componentValue(attribute, this.editModel, initialValue);
            }
            return this.componentFactory.componentValue(attribute, this.editModel, initialValue);
        }

        private boolean update(Collection<Entity> entities) {
            try {
                this.updater.update(this.editModel, entities);
                return true;
            }
            catch (CancelException cancelException) {
            }
            catch (ValidationException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                this.onValidationException.accept(e);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.onException.accept(e);
            }
            return false;
        }

        private final class DefaultValidationExceptionHandler
        implements Consumer<ValidationException> {
            private DefaultValidationExceptionHandler() {
            }

            @Override
            public void accept(ValidationException exception) {
                Objects.requireNonNull(exception);
                String title = DefaultEntityEditDialogBuilder.this.editModel.entityDefinition().attributes().definition(exception.attribute()).caption();
                JOptionPane.showMessageDialog(DefaultEntityEditDialogBuilder.this.owner, exception.getMessage(), title, 0);
            }
        }

        private final class DefaultExceptionHandler
        implements Consumer<Exception> {
            private DefaultExceptionHandler() {
            }

            @Override
            public void accept(Exception exception) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    focusOwner = DefaultEntityEditDialogBuilder.this.owner;
                }
                Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
            }
        }

        private static final class DefaultUpdater
        implements EditDialogBuilder.Updater<SwingEntityEditModel> {
            private DefaultUpdater() {
            }

            @Override
            public void update(SwingEntityEditModel editModel, Collection<Entity> entities) throws ValidationException, DatabaseException {
                editModel.update(entities);
            }
        }

        private static final class InputValidator<T>
        implements Predicate<T> {
            private final AttributeDefinition<T> attributeDefinition;
            private final ComponentValue<T, ?> componentValue;

            private InputValidator(AttributeDefinition<T> attributeDefinition, ComponentValue<T, ?> componentValue) {
                this.attributeDefinition = attributeDefinition;
                this.componentValue = componentValue;
            }

            @Override
            public boolean test(T value) {
                if (value == null && !this.attributeDefinition.nullable()) {
                    return false;
                }
                try {
                    this.componentValue.validate(value);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                return true;
            }
        }
    }

    private static final class DefaultSelectionDialogBuilder
    extends AbstractDialogBuilder<SelectionDialogBuilder>
    implements SelectionDialogBuilder {
        private final SwingEntityTableModel tableModel;
        private Dimension preferredSize;

        private DefaultSelectionDialogBuilder(SwingEntityTableModel tableModel) {
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        @Override
        public SelectionDialogBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize = Objects.requireNonNull(preferredSize);
            return this;
        }

        @Override
        public List<Entity> select() {
            return new EntitySelectionDialog(this.tableModel, this.owner, this.locationRelativeTo, (ValueObserver<String>)this.titleProvider, this.icon, this.preferredSize, false).selectEntities();
        }

        @Override
        public Optional<Entity> selectSingle() {
            List<Entity> entities = new EntitySelectionDialog(this.tableModel, this.owner, this.locationRelativeTo, (ValueObserver<String>)this.titleProvider, this.icon, this.preferredSize, true).selectEntities();
            return entities.isEmpty() ? Optional.empty() : Optional.of(entities.get(0));
        }
    }

    private static final class EntitySelectionDialog {
        private final JDialog dialog;
        private final List<Entity> selectedEntities = new ArrayList<Entity>();
        private final SwingEntityTableModel tableModel;
        private final EntityTablePanel entityTablePanel;
        private final Control okControl = Control.builder(this::ok).name(Messages.ok()).mnemonic(Messages.okMnemonic()).build();
        private final Control cancelControl;
        private final Control searchControl = Control.builder(this::search).name(FrameworkMessages.search()).mnemonic(FrameworkMessages.searchMnemonic()).build();

        private EntitySelectionDialog(SwingEntityTableModel tableModel, Window owner, Component locationRelativeTo, ValueObserver<String> titleObserver, ImageIcon icon, Dimension preferredSize, boolean singleSelection) {
            this.dialog = new JDialog(owner, titleObserver == null ? null : (String)titleObserver.get());
            if (titleObserver != null) {
                titleObserver.addDataListener(this.dialog::setTitle);
            }
            if (icon != null) {
                this.dialog.setIconImage(icon.getImage());
            }
            this.dialog.setDefaultCloseOperation(2);
            this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
            this.tableModel.editModel().readOnly().set((Object)true);
            this.entityTablePanel = this.createTablePanel(tableModel, preferredSize, singleSelection);
            this.cancelControl = Control.builder(this.dialog::dispose).name(Messages.cancel()).mnemonic(Messages.cancelMnemonic()).build();
            KeyEvents.builder((int)27).condition(1).action((Action)this.cancelControl).enable(new JComponent[]{this.dialog.getRootPane()});
            JButton okButton = (JButton)Components.button((Control)this.okControl).build();
            JPanel buttonPanel = (JPanel)Components.flowLayoutPanel((int)2).add((JComponent)okButton).add(Components.button((Control)this.cancelControl).build()).add(Components.button((Control)this.searchControl).build()).build();
            this.dialog.getRootPane().setDefaultButton(okButton);
            this.dialog.setLayout(new BorderLayout());
            this.dialog.add((Component)this.entityTablePanel, "Center");
            this.dialog.add((Component)buttonPanel, "South");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(locationRelativeTo);
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
        }

        private EntityTablePanel createTablePanel(SwingEntityTableModel tableModel, Dimension preferredSize, boolean singleSelection) {
            EntityTablePanel tablePanel = new EntityTablePanel(tableModel);
            tablePanel.initialize();
            tablePanel.table().addDoubleClickListener(mouseEvent -> {
                if (!tableModel.selectionModel().isSelectionEmpty()) {
                    this.okControl.actionPerformed(null);
                }
            });
            tablePanel.conditionPanelVisible().set((Object)true);
            tablePanel.table().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
            tablePanel.table().setSelectionMode(singleSelection ? 0 : 2);
            if (preferredSize != null) {
                tablePanel.setPreferredSize(preferredSize);
            }
            return tablePanel;
        }

        private void ok() {
            this.selectedEntities.addAll(this.tableModel.selectionModel().getSelectedItems());
            this.dialog.dispose();
        }

        private void search() {
            this.tableModel.refresh();
            if (this.tableModel.getRowCount() > 0) {
                this.tableModel.selectionModel().setSelectedIndexes(Collections.singletonList(0));
                this.entityTablePanel.table().requestFocusInWindow();
            } else {
                JOptionPane.showMessageDialog(Utilities.parentWindow((Component)this.entityTablePanel), FrameworkMessages.noResultsFound());
            }
        }

        private List<Entity> selectEntities() {
            this.dialog.setVisible(true);
            return this.selectedEntities;
        }
    }

    private static final class EditEntityComponentFactory<T, A extends Attribute<T>, C extends JComponent>
    extends DefaultEntityComponentFactory<T, A, C> {
        private static final int TEXT_INPUT_PANEL_COLUMNS = 20;

        private EditEntityComponentFactory() {
        }

        @Override
        public ComponentValue<T, C> componentValue(A attribute, SwingEntityEditModel editModel, T initialValue) {
            AttributeDefinition attributeDefinition = editModel.entityDefinition().attributes().definition(attribute);
            if (attributeDefinition.items().isEmpty() && attribute.type().isString()) {
                return ((TextFieldPanel.Builder)new EntityComponents(editModel.entityDefinition()).textFieldPanel((Attribute<String>)attribute).initialValue((Object)((String)initialValue))).columns(20).buildValue();
            }
            return super.componentValue(attribute, editModel, initialValue);
        }
    }

    public static interface SelectionDialogBuilder
    extends DialogBuilder<SelectionDialogBuilder> {
        public SelectionDialogBuilder preferredSize(Dimension var1);

        public List<Entity> select();

        public Optional<Entity> selectSingle();
    }

    public static interface EditDialogBuilder<T>
    extends DialogBuilder<EditDialogBuilder<T>> {
        public EditDialogBuilder<T> componentFactory(EntityComponentFactory<T, Attribute<T>, ?> var1);

        public EditDialogBuilder<T> onValidationException(Consumer<ValidationException> var1);

        public EditDialogBuilder<T> onException(Consumer<Exception> var1);

        public <E extends SwingEntityEditModel> EditDialogBuilder<T> updater(Updater<E> var1);

        public void edit(Entity var1);

        public void edit(Collection<? extends Entity> var1);

        public static interface Updater<E extends SwingEntityEditModel> {
            public void update(E var1, Collection<Entity> var2) throws ValidationException, DatabaseException;
        }
    }
}

