/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityEditPanel
extends EntityEditComponentPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityEditPanel.class);
    private static final ResourceBundle TABLE_PANEL_MESSAGES = ResourceBundle.getBundle(EntityTablePanel.class.getName());
    private static final Confirmer DEFAULT_INSERT_CONFIRMER = new InsertConfirmer();
    private static final Confirmer DEFAULT_UPDATE_CONFIRMER = new UpdateConfirmer();
    private static final Confirmer DEFAULT_DELETE_CONFIRMER = new DeleteConfirmer();
    public static final PropertyValue<Boolean> USE_FOCUS_ACTIVATION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.useFocusActivation", (boolean)true);
    public static final PropertyValue<Boolean> USE_SAVE_CAPTION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.useSaveCaption", (boolean)false);
    public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.includeEntityMenu", (boolean)true);
    private static final EditControl[] DEFAULT_EDIT_CONTROLS = new EditControl[]{EditControl.INSERT, EditControl.UPDATE, EditControl.DELETE, EditControl.CLEAR};
    private static final String ALT_PREFIX = " (ALT-";
    private static final State.Group ACTIVE_STATE_GROUP = State.group((State[])new State[0]);
    private final Set<EditControl> editControls;
    private final Map<EditControl, Value<Control>> controls;
    private final State active = State.state(((Boolean)USE_FOCUS_ACTIVATION.get() == false ? 1 : 0) != 0);
    private final EnumMap<Confirmer.Action, Value<Confirmer>> confirmers;
    private final State clearAfterInsert = State.state((boolean)true);
    private final State requestFocusAfterInsert = State.state((boolean)true);
    private final Value<ReferentialIntegrityErrorHandling> referentialIntegrityErrorHandling = Value.value((Object)((Object)((ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get()))), (Object)((Object)((ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get()))));
    private boolean initialized = false;

    public EntityEditPanel(SwingEntityEditModel editModel) {
        this(editModel, DEFAULT_EDIT_CONTROLS);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EntityComponents entityComponents) {
        this(editModel, entityComponents, DEFAULT_EDIT_CONTROLS);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EditControl ... editControls) {
        this(editModel, new EntityComponents(editModel.entityDefinition()), editControls);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EntityComponents entityComponents, EditControl ... editControls) {
        super(editModel, entityComponents);
        if (((Boolean)USE_FOCUS_ACTIVATION.get()).booleanValue()) {
            ACTIVE_STATE_GROUP.add(this.active);
        }
        this.editControls = EntityEditPanel.validateControlCodes(editControls);
        this.controls = this.createControlsMap();
        this.confirmers = EntityEditPanel.createConfirmersMap();
        if (((Boolean)editModel.exists().not().get()).booleanValue()) {
            editModel.setDefaults();
        }
    }

    @Override
    public final String toString() {
        return this.editModel().toString();
    }

    public final State active() {
        return this.active;
    }

    public final void clearAndRequestFocus() {
        this.editModel().setDefaults();
        this.requestInitialFocus();
    }

    public final State clearAfterInsert() {
        return this.clearAfterInsert;
    }

    public final State requestFocusAfterInsert() {
        return this.requestFocusAfterInsert;
    }

    public final Value<ReferentialIntegrityErrorHandling> referentialIntegrityErrorHandling() {
        return this.referentialIntegrityErrorHandling;
    }

    public final Value<Confirmer> confirmer(Confirmer.Action action) {
        return this.confirmers.get((Object)Objects.requireNonNull(action));
    }

    public final Value<Control> control(EditControl editControl) {
        return this.controls.get((Object)editControl);
    }

    public final Controls controls() {
        if (!this.initialized()) {
            throw new IllegalStateException("Method must be called after the panel is initialized");
        }
        return this.createControls();
    }

    public final EntityEditPanel initialize() {
        if (!this.initialized) {
            try {
                this.setupStandardControls();
                this.setupControls();
                this.bindEvents();
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    public final boolean insertWithConfirmation() {
        if (this.confirmInsert()) {
            return this.insert();
        }
        return false;
    }

    public final boolean insert() {
        try {
            this.editModel().insert();
            if (((Boolean)this.clearAfterInsert.get()).booleanValue()) {
                this.editModel().setDefaults();
            }
            if (((Boolean)this.requestFocusAfterInsert.get()).booleanValue()) {
                this.requestAfterInsertFocus();
            }
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public final boolean deleteWithConfirmation() {
        if (this.confirmDelete()) {
            return this.delete();
        }
        return false;
    }

    public final boolean delete() {
        try {
            this.editModel().delete();
            this.requestInitialFocus();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean updateWithConfirmation() {
        if (this.confirmUpdate()) {
            return this.update();
        }
        return false;
    }

    public final boolean update() {
        try {
            this.editModel().update();
            this.requestAfterUpdateFocus();
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean initialized() {
        return this.initialized;
    }

    protected final boolean confirmInsert() {
        return ((Confirmer)this.confirmers.get((Object)Confirmer.Action.INSERT).get()).confirm(this);
    }

    protected final boolean confirmUpdate() {
        return ((Confirmer)this.confirmers.get((Object)Confirmer.Action.UPDATE).get()).confirm(this);
    }

    protected final boolean confirmDelete() {
        return ((Confirmer)this.confirmers.get((Object)Confirmer.Action.DELETE).get()).confirm(this);
    }

    @Override
    protected void onException(Throwable exception) {
        if (exception instanceof ValidationException) {
            this.onValidationException((ValidationException)exception);
        } else if (exception instanceof ReferentialIntegrityException) {
            this.onReferentialIntegrityException((ReferentialIntegrityException)exception);
        } else {
            super.onException(exception);
        }
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (this.referentialIntegrityErrorHandling.equalTo((Object)ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES)) {
            EntityDependenciesPanel.displayDependenciesDialog(Collections.singletonList(this.editModel().entity()), this.editModel().connectionProvider(), (JComponent)this, TABLE_PANEL_MESSAGES.getString("unknown_dependent_records"));
        } else {
            super.onException(exception);
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.editModel().entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
        this.requestComponentFocus(exception.attribute());
    }

    protected Controls createControls() {
        return Controls.controls((Control[])((Control[])Stream.of(EditControl.values()).map(this.controls::get).map(ValueObserver::optional).filter(Optional::isPresent).map(Optional::get).toArray(Control[]::new)));
    }

    protected void setupControls() {
    }

    protected abstract void initializeUI();

    private void setupStandardControls() {
        if (!((Boolean)this.editModel().readOnly().get()).booleanValue()) {
            this.setupEditControls();
        }
        if (this.editControls.contains((Object)EditControl.CLEAR)) {
            this.controls.get((Object)EditControl.CLEAR).mapNull(this::createClearControl);
        }
    }

    private void setupEditControls() {
        if (((Boolean)this.editModel().insertEnabled().get()).booleanValue() && this.editControls.contains((Object)EditControl.INSERT)) {
            this.controls.get((Object)EditControl.INSERT).mapNull(this::createInsertControl);
        }
        if (((Boolean)this.editModel().updateEnabled().get()).booleanValue() && this.editControls.contains((Object)EditControl.UPDATE)) {
            this.controls.get((Object)EditControl.UPDATE).mapNull(this::createUpdateControl);
        }
        if (((Boolean)this.editModel().deleteEnabled().get()).booleanValue() && this.editControls.contains((Object)EditControl.DELETE)) {
            this.controls.get((Object)EditControl.DELETE).mapNull(this::createDeleteControl);
        }
    }

    private Control createDeleteControl() {
        return Control.builder(this::deleteWithConfirmation).name(FrameworkMessages.delete()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().deleteEnabled(), this.editModel().exists()})).description(FrameworkMessages.deleteCurrentTip() + ALT_PREFIX + FrameworkMessages.deleteMnemonic() + ")").mnemonic(FrameworkMessages.deleteMnemonic()).smallIcon((Icon)FrameworkIcons.instance().delete()).build();
    }

    private Control createClearControl() {
        return Control.builder(this::clearAndRequestFocus).name(Messages.clear()).enabled((StateObserver)this.active).description(Messages.clearTip() + ALT_PREFIX + Messages.clearMnemonic() + ")").mnemonic(Messages.clearMnemonic()).smallIcon((Icon)FrameworkIcons.instance().clear()).build();
    }

    private Control createUpdateControl() {
        return Control.builder(this::updateWithConfirmation).name(FrameworkMessages.update()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().updateEnabled(), this.editModel().exists(), this.editModel().modified()})).description(FrameworkMessages.updateTip() + ALT_PREFIX + FrameworkMessages.updateMnemonic() + ")").mnemonic(FrameworkMessages.updateMnemonic()).smallIcon((Icon)FrameworkIcons.instance().update()).build();
    }

    private Control createInsertControl() {
        boolean useSaveCaption = (Boolean)USE_SAVE_CAPTION.get();
        char mnemonic = useSaveCaption ? FrameworkMessages.saveMnemonic() : FrameworkMessages.addMnemonic();
        String caption = useSaveCaption ? FrameworkMessages.save() : FrameworkMessages.add();
        return Control.builder(this::insertWithConfirmation).name(caption).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().insertEnabled()})).description(FrameworkMessages.addTip() + ALT_PREFIX + mnemonic + ")").mnemonic(mnemonic).smallIcon((Icon)FrameworkIcons.instance().add()).build();
    }

    private void bindEvents() {
        if (((Boolean)INCLUDE_ENTITY_MENU.get()).booleanValue()) {
            KeyEvents.builder((int)86).modifiers(640).condition(1).action((Action)Control.control(this::showEntityMenu)).enable(new JComponent[]{this});
        }
        this.editModel().addConfirmOverwriteListener(confirmationState -> {
            int result = JOptionPane.showConfirmDialog(Utilities.parentWindow((Component)this), FrameworkMessages.unsavedDataWarning(), FrameworkMessages.unsavedDataWarningTitle(), 0, 2);
            confirmationState.set((Object)(result == 0 ? 1 : 0));
        });
    }

    private void showEntityMenu() {
        new EntityPopupMenu(this.editModel().entity(), this.editModel().connectionProvider().connection()).show(this, 0, 0);
    }

    private Map<EditControl, Value<Control>> createControlsMap() {
        Value.Validator controlValueValidator = control -> this.throwIfInitialized();
        return Collections.unmodifiableMap(Stream.of(EditControl.values()).collect(Collectors.toMap(Function.identity(), controlCode -> {
            Value value = Value.value();
            value.addValidator(controlValueValidator);
            return value;
        })));
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private static EnumMap<Confirmer.Action, Value<Confirmer>> createConfirmersMap() {
        EnumMap<Confirmer.Action, Value<Confirmer>> enumMap = new EnumMap<Confirmer.Action, Value<Confirmer>>(Confirmer.Action.class);
        enumMap.put(Confirmer.Action.INSERT, Value.value((Object)DEFAULT_INSERT_CONFIRMER, (Object)DEFAULT_INSERT_CONFIRMER));
        enumMap.put(Confirmer.Action.UPDATE, Value.value((Object)DEFAULT_UPDATE_CONFIRMER, (Object)DEFAULT_UPDATE_CONFIRMER));
        enumMap.put(Confirmer.Action.DELETE, Value.value((Object)DEFAULT_DELETE_CONFIRMER, (Object)DEFAULT_DELETE_CONFIRMER));
        return enumMap;
    }

    private static Set<EditControl> validateControlCodes(EditControl[] editControls) {
        if (editControls == null) {
            return Collections.emptySet();
        }
        for (EditControl editControl : editControls) {
            Objects.requireNonNull(editControl, "controlCode");
        }
        return new LinkedHashSet<EditControl>(Arrays.asList(editControls));
    }

    public static enum EditControl {
        INSERT,
        UPDATE,
        DELETE,
        CLEAR;

    }

    public static interface Confirmer {
        public boolean confirm(JComponent var1);

        default public boolean confirm(JComponent dialogOwner, String message, String title) {
            return JOptionPane.showConfirmDialog(dialogOwner, message, title, 2) == 0;
        }

        public static enum Action {
            INSERT,
            UPDATE,
            DELETE;

        }
    }

    private static final class InsertConfirmer
    implements Confirmer {
        private InsertConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return true;
        }
    }

    private static final class UpdateConfirmer
    implements Confirmer {
        private UpdateConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmUpdate(), FrameworkMessages.update());
        }
    }

    private static final class DeleteConfirmer
    implements Confirmer {
        private DeleteConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete(), FrameworkMessages.delete());
        }
    }
}

