/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.combobox.ItemComboBoxBuilder;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.component.slider.SliderBuilder;
import is.codion.swing.common.ui.component.spinner.ItemSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.ListSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.text.MaskedTextFieldBuilder;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.text.TemporalFieldPanel;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.text.TextFieldPanel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityComboBoxPanel;
import is.codion.swing.framework.ui.component.EntitySearchField;
import is.codion.swing.framework.ui.component.EntitySearchFieldPanel;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.BoundedRangeModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerListModel;

public class EntityComponents {
    private final EntityDefinition entityDefinition;

    public EntityComponents(EntityDefinition entityDefinition) {
        this.entityDefinition = Objects.requireNonNull(entityDefinition);
    }

    public final EntityDefinition entityDefinition() {
        return this.entityDefinition;
    }

    public boolean supports(Attribute<?> attribute) {
        Objects.requireNonNull(attribute);
        if (attribute instanceof ForeignKey) {
            return false;
        }
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        if (!attributeDefinition.items().isEmpty()) {
            return true;
        }
        Attribute.Type type = attribute.type();
        return type.isLocalTime() || type.isLocalDate() || type.isLocalDateTime() || type.isOffsetDateTime() || type.isString() || type.isCharacter() || type.isBoolean() || type.isShort() || type.isInteger() || type.isLong() || type.isDouble() || type.isBigDecimal() || type.isEnum();
    }

    public <T, C extends JComponent, B extends ComponentBuilder<T, C, B>> ComponentBuilder<T, C, B> component(Attribute<T> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        if (!attributeDefinition.items().isEmpty()) {
            return this.itemComboBox(attribute);
        }
        Attribute.Type type = attribute.type();
        if (type.isTemporal()) {
            return this.temporalField(attribute);
        }
        if (type.isString() || type.isCharacter()) {
            return this.textField(attribute);
        }
        if (type.isBoolean()) {
            return this.checkBox(attribute);
        }
        if (type.isShort()) {
            return this.shortField(attribute);
        }
        if (type.isInteger()) {
            return this.integerField(attribute);
        }
        if (type.isLong()) {
            return this.longField(attribute);
        }
        if (type.isDouble()) {
            return this.doubleField(attribute);
        }
        if (type.isBigDecimal()) {
            return this.bigDecimalField(attribute);
        }
        if (type.isEnum()) {
            return this.comboBox(attribute, (ComboBoxModel<T>)EntityComponents.createEnumComboBoxModel(attribute, attributeDefinition.nullable()));
        }
        throw new IllegalArgumentException("No input component available for attribute: " + attribute + " (type: " + type.valueClass() + ")");
    }

    public final CheckBoxBuilder checkBox(Attribute<Boolean> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)Components.checkBox().toolTipText(attributeDefinition.description())).nullable(attributeDefinition.nullable()).text(attributeDefinition.caption())).includeText(false);
    }

    public final <B extends ButtonBuilder<Boolean, JToggleButton, B>> ButtonBuilder<Boolean, JToggleButton, B> toggleButton(Attribute<Boolean> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return ((ToggleButtonBuilder)((ToggleButtonBuilder)Components.toggleButton().toolTipText(attributeDefinition.description())).text(attributeDefinition.caption())).includeText(false);
    }

    public final ItemComboBoxBuilder<Boolean> booleanComboBox(Attribute<Boolean> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (ItemComboBoxBuilder)Components.booleanComboBox((ItemComboBoxModel)ItemComboBoxModel.booleanItemComboBoxModel()).toolTipText(attributeDefinition.description());
    }

    public final <B extends ComboBoxBuilder<Entity, EntityComboBox, B>> ComboBoxBuilder<Entity, EntityComboBox, B> foreignKeyComboBox(ForeignKey foreignKey, EntityComboBoxModel comboBoxModel) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition.foreignKeys().definition(foreignKey);
        return (ComboBoxBuilder)EntityComboBox.builder(comboBoxModel).toolTipText(foreignKeyDefinition.description());
    }

    public final EntityComboBoxPanel.Builder foreignKeyComboBoxPanel(ForeignKey foreignKey, EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanelSupplier) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition.foreignKeys().definition(foreignKey);
        return (EntityComboBoxPanel.Builder)EntityComboBoxPanel.builder(comboBoxModel, editPanelSupplier).toolTipText(foreignKeyDefinition.description());
    }

    public final EntitySearchField.Builder foreignKeySearchField(ForeignKey foreignKey, EntitySearchModel searchModel) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition.foreignKeys().definition(foreignKey);
        return (EntitySearchField.Builder)EntitySearchField.builder(searchModel).toolTipText(foreignKeyDefinition.description() == null ? searchModel.description() : foreignKeyDefinition.description());
    }

    public final EntitySearchFieldPanel.Builder foreignKeySearchFieldPanel(ForeignKey foreignKey, EntitySearchModel searchModel, Supplier<EntityEditPanel> editPanelSupplier) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition.foreignKeys().definition(foreignKey);
        return (EntitySearchFieldPanel.Builder)EntitySearchFieldPanel.builder(searchModel, editPanelSupplier).toolTipText(foreignKeyDefinition.description());
    }

    public final <B extends TextFieldBuilder<Entity, JTextField, B>> TextFieldBuilder<Entity, JTextField, B> foreignKeyTextField(ForeignKey foreignKey) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition.foreignKeys().definition(foreignKey);
        return (TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)Components.textField(Entity.class).toolTipText(foreignKeyDefinition.description())).format((Format)new EntityReadOnlyFormat()).editable(false)).focusable(false);
    }

    public final LabelBuilder<Entity> foreignKeyLabel(ForeignKey foreignKey) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition.foreignKeys().definition(foreignKey);
        return (LabelBuilder)Components.label().toolTipText(foreignKeyDefinition.description());
    }

    public final <T> ItemComboBoxBuilder<T> itemComboBox(Attribute<T> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        if (attributeDefinition.items().isEmpty()) {
            throw new IllegalArgumentException("Attribute '" + attributeDefinition.attribute() + "' is not a item based attribute");
        }
        return ((ItemComboBoxBuilder)Components.itemComboBox((List)attributeDefinition.items()).toolTipText(attributeDefinition.description())).nullable(attributeDefinition.nullable());
    }

    public final <T, C extends JComboBox<T>, B extends ComboBoxBuilder<T, C, B>> ComboBoxBuilder<T, C, B> comboBox(Attribute<T> attribute, ComboBoxModel<T> comboBoxModel) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (ComboBoxBuilder)Components.comboBox(comboBoxModel).toolTipText(attributeDefinition.description());
    }

    public final <T extends Temporal> TemporalFieldPanel.Builder<T> temporalFieldPanel(Attribute<T> attribute) {
        return this.temporalFieldPanel(attribute, this.entityDefinition.attributes().definition(attribute).dateTimePattern());
    }

    public final <T extends Temporal> TemporalFieldPanel.Builder<T> temporalFieldPanel(Attribute<T> attribute, String dateTimePattern) {
        return ((TemporalFieldPanel.Builder)Components.temporalFieldPanel((Class)attribute.type().valueClass(), (String)dateTimePattern).toolTipText(this.entityDefinition.attributes().definition(attribute).description())).calendarIcon(FrameworkIcons.instance().calendar());
    }

    public final TextFieldPanel.Builder textFieldPanel(Attribute<String> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return ((TextFieldPanel.Builder)Components.textFieldPanel().toolTipText(attributeDefinition.description())).maximumLength(attributeDefinition.maximumLength()).dialogTitle(attributeDefinition.caption()).buttonIcon(FrameworkIcons.instance().editText());
    }

    public final TextAreaBuilder textArea(Attribute<String> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        if (!attribute.type().isString()) {
            throw new IllegalArgumentException("Cannot create a text area for a non-string attribute");
        }
        return (TextAreaBuilder)((TextAreaBuilder)Components.textArea().toolTipText(attributeDefinition.description())).maximumLength(attributeDefinition.maximumLength());
    }

    public final <T, C extends JTextField, B extends TextFieldBuilder<T, C, B>> TextFieldBuilder<T, C, B> textField(Attribute<T> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        if (attribute.type().isTemporal()) {
            return this.temporalField(attribute);
        }
        return (TextFieldBuilder)((TextFieldBuilder)Components.textField((Class)attribute.type().valueClass()).format(attributeDefinition.format()).maximumLength(attributeDefinition.maximumLength())).toolTipText(attributeDefinition.description());
    }

    public final <T extends Temporal> TemporalField.Builder<T> temporalField(Attribute<T> attribute) {
        return this.temporalField(attribute, this.entityDefinition.attributes().definition(attribute).dateTimePattern());
    }

    public final <T extends Temporal> TemporalField.Builder<T> temporalField(Attribute<T> attribute, String dateTimePattern) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return ((TemporalField.Builder)Components.temporalField((Class)attributeDefinition.attribute().type().valueClass(), (String)dateTimePattern).toolTipText(attributeDefinition.description())).calendarIcon(FrameworkIcons.instance().calendar());
    }

    public final NumberField.Builder<Short> shortField(Attribute<Short> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberField.Builder)((NumberField.Builder)Components.shortField().format(attributeDefinition.format())).minimumValue(attributeDefinition.minimumValue()).maximumValue(attributeDefinition.maximumValue()).toolTipText(attributeDefinition.description());
    }

    public final NumberField.Builder<Integer> integerField(Attribute<Integer> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberField.Builder)((NumberField.Builder)Components.integerField().format(attributeDefinition.format())).minimumValue(attributeDefinition.minimumValue()).maximumValue(attributeDefinition.maximumValue()).toolTipText(attributeDefinition.description());
    }

    public final NumberField.Builder<Long> longField(Attribute<Long> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberField.Builder)((NumberField.Builder)Components.longField().format(attributeDefinition.format())).minimumValue(attributeDefinition.minimumValue()).maximumValue(attributeDefinition.maximumValue()).toolTipText(attributeDefinition.description());
    }

    public final NumberField.Builder<Double> doubleField(Attribute<Double> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberField.Builder)((NumberField.Builder)Components.doubleField().format(attributeDefinition.format())).minimumValue(attributeDefinition.minimumValue()).maximumValue(attributeDefinition.maximumValue()).maximumFractionDigits(attributeDefinition.maximumFractionDigits()).toolTipText(attributeDefinition.description());
    }

    public final NumberField.Builder<BigDecimal> bigDecimalField(Attribute<BigDecimal> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberField.Builder)((NumberField.Builder)Components.bigDecimalField().format(attributeDefinition.format())).minimumValue(attributeDefinition.minimumValue()).maximumValue(attributeDefinition.maximumValue()).maximumFractionDigits(attributeDefinition.maximumFractionDigits()).toolTipText(attributeDefinition.description());
    }

    public final SliderBuilder slider(Attribute<Integer> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        DefaultBoundedRangeModel boundedRangeModel = new DefaultBoundedRangeModel();
        boundedRangeModel.setMinimum(attributeDefinition.minimumValue().intValue());
        boundedRangeModel.setMaximum(attributeDefinition.maximumValue().intValue());
        return this.slider(attribute, boundedRangeModel);
    }

    public final SliderBuilder slider(Attribute<Integer> attribute, BoundedRangeModel boundedRangeModel) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (SliderBuilder)Components.slider((BoundedRangeModel)boundedRangeModel).toolTipText(attributeDefinition.description());
    }

    public final NumberSpinnerBuilder<Integer> integerSpinner(Attribute<Integer> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberSpinnerBuilder)Components.integerSpinner().minimum((Number)attributeDefinition.minimumValue().intValue()).maximum((Number)attributeDefinition.maximumValue().intValue()).toolTipText(attributeDefinition.description());
    }

    public final NumberSpinnerBuilder<Double> doubleSpinner(Attribute<Double> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (NumberSpinnerBuilder)Components.doubleSpinner().minimum((Number)attributeDefinition.minimumValue().doubleValue()).maximum((Number)attributeDefinition.maximumValue().doubleValue()).toolTipText(attributeDefinition.description());
    }

    public final <T> ListSpinnerBuilder<T> listSpinner(Attribute<T> attribute, SpinnerListModel listModel) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (ListSpinnerBuilder)Components.listSpinner((SpinnerListModel)listModel).toolTipText(attributeDefinition.description());
    }

    public final <T> ItemSpinnerBuilder<T> itemSpinner(Attribute<T> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        if (attributeDefinition.items().isEmpty()) {
            throw new IllegalArgumentException("Attribute '" + attributeDefinition.attribute() + "' is not a item based attribute");
        }
        return (ItemSpinnerBuilder)Components.itemSpinner((SpinnerListModel)new SpinnerListModel(attributeDefinition.items())).toolTipText(attributeDefinition.description());
    }

    public final MaskedTextFieldBuilder maskedTextField(Attribute<String> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
        return (MaskedTextFieldBuilder)Components.maskedTextField().toolTipText(attributeDefinition.description());
    }

    private static <T> FilteredComboBoxModel<T> createEnumComboBoxModel(Attribute<T> attribute, boolean nullable) {
        FilteredComboBoxModel comboBoxModel = new FilteredComboBoxModel();
        List enumConstants = Arrays.asList(attribute.type().valueClass().getEnumConstants());
        comboBoxModel.refresher().itemSupplier().set(() -> enumConstants);
        comboBoxModel.includeNull().set((Object)nullable);
        comboBoxModel.refresh();
        return comboBoxModel;
    }

    private static final class EntityReadOnlyFormat
    extends Format {
        private static final long serialVersionUID = 1L;

        private EntityReadOnlyFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(obj == null ? "" : obj.toString());
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

