/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.i18n.Messages;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntitySearchField;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

final class EntityControls {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityControls.class.getName());

    private EntityControls() {
    }

    static Control createAddControl(EntityComboBox comboBox, Supplier<EntityEditPanel> editPanelSupplier, KeyStroke keyStroke) {
        return EntityControls.createAddControl(new AddEntityCommand(Objects.requireNonNull(comboBox), Objects.requireNonNull(editPanelSupplier)), comboBox, keyStroke);
    }

    static Control createAddControl(EntitySearchField searchField, Supplier<EntityEditPanel> editPanelSupplier, KeyStroke keyStroke) {
        return EntityControls.createAddControl(new AddEntityCommand(Objects.requireNonNull(searchField), Objects.requireNonNull(editPanelSupplier)), (JComponent)((Object)searchField), keyStroke);
    }

    static Control createEditControl(EntityComboBox comboBox, Supplier<EntityEditPanel> editPanelSupplier, KeyStroke keyStroke) {
        return EntityControls.createEditControl(new EditEntityCommand(Objects.requireNonNull(comboBox), Objects.requireNonNull(editPanelSupplier)), comboBox, comboBox.getModel().selectionEmpty().not(), keyStroke);
    }

    static Control createEditControl(EntitySearchField searchField, Supplier<EntityEditPanel> editPanelSupplier, KeyStroke keyStroke) {
        return EntityControls.createEditControl(new EditEntityCommand(Objects.requireNonNull(searchField), Objects.requireNonNull(editPanelSupplier)), (JComponent)((Object)searchField), searchField.model().selectionEmpty().not(), keyStroke);
    }

    static String validateButtonLocation(String buttonLocation) {
        Objects.requireNonNull(buttonLocation);
        if (!buttonLocation.equals("West") && !buttonLocation.equals("East")) {
            throw new IllegalArgumentException("Button location must be BorderLayout.WEST or BorderLayout.EAST");
        }
        return buttonLocation;
    }

    static JPanel createButtonPanel(JComponent centerComponent, boolean buttonFocusable, String borderLayoutConstraints, Action ... buttonActions) {
        Dimension preferredSize = centerComponent.getPreferredSize();
        return (JPanel)Components.panel((LayoutManager)new BorderLayout()).add(centerComponent, (Object)"Center").add(Components.buttonPanel((Action[])buttonActions).buttonsFocusable(buttonFocusable).preferredButtonSize(new Dimension(preferredSize.height, preferredSize.height)).buttonGap(0).build(), (Object)borderLayoutConstraints).build();
    }

    static String defaultButtonLocation() {
        return ComponentOrientation.getOrientation(Locale.getDefault()) == ComponentOrientation.LEFT_TO_RIGHT ? "East" : "West";
    }

    private static Control createAddControl(AddEntityCommand addEntityCommand, JComponent component, KeyStroke keyStroke) {
        Control control = Control.builder((Control.Command)addEntityCommand).smallIcon((Icon)FrameworkIcons.instance().add()).description(MESSAGES.getString("add_new")).enabled((StateObserver)EntityControls.createComponentEnabledState(component)).build();
        KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{component});
        return control;
    }

    private static Control createEditControl(EditEntityCommand editEntityCommand, JComponent component, StateObserver selectionNonEmptyState, KeyStroke keyStroke) {
        Control control = Control.builder((Control.Command)editEntityCommand).smallIcon((Icon)FrameworkIcons.instance().edit()).description(MESSAGES.getString("edit_selected")).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{EntityControls.createComponentEnabledState(component), selectionNonEmptyState})).build();
        KeyEvents.builder((KeyStroke)keyStroke).action((Action)control).enable(new JComponent[]{component});
        return control;
    }

    private static State createComponentEnabledState(JComponent component) {
        State componentEnabledState = State.state((boolean)component.isEnabled());
        component.addPropertyChangeListener("enabled", changeEvent -> componentEnabledState.set((Object)((Boolean)changeEvent.getNewValue())));
        return componentEnabledState;
    }

    private static final class AddEntityCommand
    implements Control.Command {
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private final JComponent component;
        private final EntityConnectionProvider connectionProvider;
        private final Consumer<List<Entity>> onInsert;
        private final List<Entity> insertedEntities = new ArrayList<Entity>();
        private final Consumer<Collection<Entity>> populateInsertedEntities = new PopulateInsertedEntities();

        private AddEntityCommand(EntityComboBox comboBox, Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = editPanelSupplier;
            this.component = comboBox;
            this.connectionProvider = comboBox.getModel().connectionProvider();
            this.onInsert = new EntityComboBoxOnInsert();
        }

        private AddEntityCommand(EntitySearchField searchField, Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = editPanelSupplier;
            this.component = searchField;
            this.connectionProvider = searchField.model().connectionProvider();
            this.onInsert = new EntitySearchFieldOnInsert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            EntityEditPanel editPanel = this.initializeEditPanel();
            editPanel.editModel().setDefaults();
            State cancelled = State.state();
            Value invalidAttribute = Value.value();
            JDialog dialog = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog((JComponent)editPanel).owner((Component)this.component)).title(this.connectionProvider.entities().definition(editPanel.editModel().entityType()).caption())).onShown(d -> invalidAttribute.optional().ifPresent(editPanel::requestComponentFocus))).onCancel(() -> cancelled.set((Object)true)).build();
            try {
                boolean successfulInsert = false;
                while (!successfulInsert) {
                    dialog.setVisible(true);
                    if (((Boolean)cancelled.get()).booleanValue()) {
                        return;
                    }
                    successfulInsert = this.insert((SwingEntityEditModel)editPanel.editModel(), (Value<Attribute<?>>)invalidAttribute);
                    if (!successfulInsert || this.insertedEntities.isEmpty()) continue;
                    this.onInsert.accept(this.insertedEntities);
                }
            }
            finally {
                this.insertedEntities.clear();
            }
        }

        private EntityEditPanel initializeEditPanel() {
            EntityEditPanel editPanel = this.editPanelSupplier.get().initialize();
            editPanel.setBorder(Borders.emptyBorder());
            editPanel.editModel().addAfterInsertListener(this.populateInsertedEntities);
            return editPanel;
        }

        private boolean insert(SwingEntityEditModel editModel, Value<Attribute<?>> attributeWithInvalidValue) {
            try {
                editModel.insert();
                return true;
            }
            catch (ValidationException e) {
                attributeWithInvalidValue.set((Object)e.attribute());
                JOptionPane.showMessageDialog(this.component, e.getMessage(), Messages.error(), 0);
            }
            catch (Exception e) {
                Dialogs.displayExceptionDialog((Throwable)e, (Window)Utilities.parentWindow((Component)this.component));
            }
            return false;
        }

        private final class PopulateInsertedEntities
        implements Consumer<Collection<Entity>> {
            private PopulateInsertedEntities() {
            }

            @Override
            public void accept(Collection<Entity> inserted) {
                AddEntityCommand.this.insertedEntities.clear();
                AddEntityCommand.this.insertedEntities.addAll(inserted);
            }
        }

        private class EntityComboBoxOnInsert
        implements Consumer<List<Entity>> {
            private EntityComboBoxOnInsert() {
            }

            @Override
            public void accept(List<Entity> inserted) {
                EntityComboBoxModel comboBoxModel = ((EntityComboBox)AddEntityCommand.this.component).getModel();
                Entity item = inserted.get(0);
                comboBoxModel.add((Object)item);
                comboBoxModel.setSelectedItem((Object)item);
            }
        }

        private class EntitySearchFieldOnInsert
        implements Consumer<List<Entity>> {
            private EntitySearchFieldOnInsert() {
            }

            @Override
            public void accept(List<Entity> inserted) {
                ((EntitySearchField)((Object)AddEntityCommand.this.component)).model().entities().set(inserted);
            }
        }
    }

    private static final class EditEntityCommand
    implements Control.Command {
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private final JComponent component;
        private final EntityConnectionProvider connectionProvider;
        private final Consumer<List<Entity>> onUpdate;
        private final List<Entity> updatedEntities = new ArrayList<Entity>();
        private final PopulateUpdatedEntities populateUpdatedEntities = new PopulateUpdatedEntities();
        private Entity entityToUpdate;

        private EditEntityCommand(EntityComboBox comboBox, Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = editPanelSupplier;
            this.component = comboBox;
            this.connectionProvider = comboBox.getModel().connectionProvider();
            this.onUpdate = new EntityComboBoxOnUpdate();
        }

        private EditEntityCommand(EntitySearchField searchField, Supplier<EntityEditPanel> editPanelSupplier) {
            this.editPanelSupplier = editPanelSupplier;
            this.component = searchField;
            this.connectionProvider = searchField.model().connectionProvider();
            this.onUpdate = new EntitySearchFieldOnUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            if (this.component instanceof EntityComboBox) {
                if (((EntityComboBox)this.component).isPopupVisible()) {
                    ((EntityComboBox)this.component).hidePopup();
                }
                this.entityToUpdate = (Entity)((EntityComboBox)this.component).getModel().selectedValue();
            } else {
                this.entityToUpdate = (Entity)((EntitySearchField)((Object)this.component)).model().entity().get();
            }
            EntityEditPanel editPanel = this.initializeEditPanel();
            editPanel.editModel().set(this.connectionProvider.connection().select(this.entityToUpdate.primaryKey()));
            State cancelled = State.state();
            Value invalidAttribute = Value.value();
            JDialog dialog = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog((JComponent)editPanel).owner((Component)this.component)).title(this.connectionProvider.entities().definition(editPanel.editModel().entityType()).caption())).okEnabled(editPanel.editModel().modified()).onShown(d -> invalidAttribute.optional().ifPresent(editPanel::requestComponentFocus))).onCancel(() -> cancelled.set((Object)true)).build();
            try {
                boolean successfulUpdate = false;
                while (!successfulUpdate) {
                    dialog.setVisible(true);
                    if (((Boolean)cancelled.get()).booleanValue()) {
                        return;
                    }
                    successfulUpdate = this.update((SwingEntityEditModel)editPanel.editModel(), (Value<Attribute<?>>)invalidAttribute);
                    if (!successfulUpdate || this.updatedEntities.isEmpty()) continue;
                    this.onUpdate.accept(this.updatedEntities);
                }
            }
            finally {
                this.entityToUpdate = null;
                this.updatedEntities.clear();
            }
        }

        private EntityEditPanel initializeEditPanel() {
            EntityEditPanel editPanel = this.editPanelSupplier.get().initialize();
            editPanel.setBorder(Borders.emptyBorder());
            editPanel.editModel().addAfterUpdateListener((Consumer)this.populateUpdatedEntities);
            return editPanel;
        }

        private boolean update(SwingEntityEditModel editModel, Value<Attribute<?>> attributeWithInvalidValue) {
            try {
                if (((Boolean)editModel.modified().get()).booleanValue()) {
                    editModel.update();
                }
                return true;
            }
            catch (ValidationException e) {
                attributeWithInvalidValue.set((Object)e.attribute());
                JOptionPane.showMessageDialog(this.component, e.getMessage(), Messages.error(), 0);
            }
            catch (Exception e) {
                Dialogs.displayExceptionDialog((Throwable)e, (Window)Utilities.parentWindow((Component)this.component));
            }
            return false;
        }

        private final class PopulateUpdatedEntities
        implements Consumer<Map<Entity.Key, Entity>> {
            private PopulateUpdatedEntities() {
            }

            @Override
            public void accept(Map<Entity.Key, Entity> updated) {
                EditEntityCommand.this.updatedEntities.clear();
                EditEntityCommand.this.updatedEntities.addAll(updated.values());
            }
        }

        private final class EntityComboBoxOnUpdate
        implements Consumer<List<Entity>> {
            private EntityComboBoxOnUpdate() {
            }

            @Override
            public void accept(List<Entity> updated) {
                EntityComboBoxModel comboBoxModel = ((EntityComboBox)EditEntityCommand.this.component).getModel();
                Entity item = updated.get(0);
                comboBoxModel.replace((Object)EditEntityCommand.this.entityToUpdate, (Object)item);
                comboBoxModel.setSelectedItem((Object)item);
            }
        }

        private final class EntitySearchFieldOnUpdate
        implements Consumer<List<Entity>> {
            private EntitySearchFieldOnUpdate() {
            }

            @Override
            public void accept(List<Entity> updated) {
                ((EntitySearchField)((Object)EditEntityCommand.this.component)).model().entities().set(updated);
            }
        }
    }
}

