/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.NullOrEmpty;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.model.EntityEditModel;
import is.codion.swing.common.ui.Colors;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public final class EntityComponentValidators {
    private EntityComponentValidators() {
    }

    public static <T> void addValidator(Attribute<T> attribute, JTextComponent textComponent, EntityEditModel editModel) {
        EntityComponentValidators.addValidator(attribute, textComponent, editModel, textComponent.getToolTipText());
    }

    public static <T> void addFormattedValidator(Attribute<T> attribute, JTextComponent textComponent, EntityEditModel editModel) {
        EntityComponentValidators.addFormattedValidator(attribute, textComponent, editModel, textComponent.getToolTipText());
    }

    public static <T> void addValidator(Attribute<T> attribute, JTextComponent textComponent, EntityEditModel editModel, String defaultToolTip) {
        new TextValidator<T>(attribute, textComponent, editModel, defaultToolTip).validate();
    }

    public static <T> void addFormattedValidator(Attribute<T> attribute, JTextComponent textComponent, EntityEditModel editModel, String defaultToolTip) {
        new FormattedTextValidator<T>(attribute, textComponent, editModel, defaultToolTip).validate();
    }

    private static class TextValidator<T>
    extends DefaultValidator<T> {
        protected Color backgroundColor;
        protected Color inactiveBackgroundColor;
        protected Color invalidBackgroundColor;

        protected TextValidator(Attribute<T> attribute, JTextComponent textComponent, EntityEditModel editModel, String defaultToolTip) {
            super(attribute, textComponent, editModel, defaultToolTip);
            editModel.value(attribute).addListener(this::validate);
            this.configureColors();
            textComponent.addPropertyChangeListener("UI", event -> this.configureColors());
        }

        protected void validate() {
            JComponent component = this.component();
            boolean enabled = component.isEnabled();
            boolean stringValid = this.valid();
            String validationMessage = this.validationMessage();
            if (stringValid && validationMessage == null) {
                component.setBackground(enabled ? this.backgroundColor : this.inactiveBackgroundColor);
            } else {
                component.setBackground(this.invalidBackgroundColor);
            }
            this.setToolTipText(validationMessage);
        }

        protected boolean valid() {
            return !this.isNull() || this.nullable();
        }

        private void configureColors() {
            this.backgroundColor = UIManager.getColor("TextField.background");
            this.inactiveBackgroundColor = UIManager.getColor("TextField.inactiveBackground");
            this.invalidBackgroundColor = Colors.darker((Color)this.backgroundColor);
            this.validate();
        }
    }

    private static final class FormattedTextValidator<T>
    extends TextValidator<T> {
        private final String maskString;

        private FormattedTextValidator(Attribute<T> attribute, JTextComponent textComponent, EntityEditModel editModel, String defaultToolTip) {
            super(attribute, textComponent, editModel, defaultToolTip);
            this.maskString = textComponent.getText();
        }

        @Override
        protected boolean valid() {
            boolean stringEqualsMask = ((JTextComponent)this.component()).getText().equals(this.maskString);
            return !this.isNull() || stringEqualsMask && this.nullable();
        }
    }

    private static class DefaultValidator<T> {
        private final Attribute<T> attribute;
        private final JComponent component;
        private final EntityEditModel editModel;
        private final String defaultToolTip;

        private DefaultValidator(Attribute<T> attribute, JComponent component, EntityEditModel editModel, String defaultToolTip) {
            this.attribute = attribute;
            this.component = component;
            this.editModel = editModel;
            this.defaultToolTip = defaultToolTip;
        }

        protected final String validationMessage() {
            try {
                this.editModel.validate(this.attribute);
                return null;
            }
            catch (ValidationException e) {
                return e.getMessage();
            }
        }

        protected boolean nullable() {
            return this.editModel.nullable(this.attribute);
        }

        protected boolean isNull() {
            return (Boolean)this.editModel.isNull(this.attribute).get();
        }

        protected final JComponent component() {
            return this.component;
        }

        protected void setToolTipText(String validationMessage) {
            if (validationMessage == null) {
                this.component.setToolTipText(this.defaultToolTip);
            } else if (NullOrEmpty.nullOrEmpty((String)this.defaultToolTip)) {
                this.component.setToolTipText(validationMessage);
            } else {
                this.component.setToolTipText(validationMessage + ": " + this.defaultToolTip);
            }
        }
    }
}

