/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.component.table.DefaultFilteredTableCellRendererBuilder;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import is.codion.swing.framework.model.SwingEntityTableModel;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Function;

final class EntityTableCellRendererBuilder
extends DefaultFilteredTableCellRendererBuilder<Entity, Attribute<?>> {
    EntityTableCellRendererBuilder(SwingEntityTableModel tableModel, Attribute<?> attribute) {
        this(Objects.requireNonNull(tableModel), tableModel.entityDefinition().attributes().definition(attribute));
    }

    private EntityTableCellRendererBuilder(SwingEntityTableModel tableModel, AttributeDefinition<?> attributeDefinition) {
        super((FilteredTableModel)Objects.requireNonNull(tableModel), (Object)Objects.requireNonNull(attributeDefinition).attribute(), attributeDefinition.attribute().type().valueClass(), attributeDefinition.attribute().type().isBoolean() && attributeDefinition.items().isEmpty());
        tableModel.entityDefinition().attributes().definition(attributeDefinition.attribute());
        this.displayValueProvider(new DefaultDisplayValueProvider(attributeDefinition));
        this.cellColorProvider(new EntityCellColorProvider(tableModel));
    }

    protected FilteredTableCellRenderer.Settings<Attribute<?>> settings(int leftPadding, int rightPadding, boolean alternateRowColoring) {
        return new EntitySettings(leftPadding, rightPadding, alternateRowColoring);
    }

    private static final class DefaultDisplayValueProvider
    implements Function<Object, Object> {
        private final AttributeDefinition<Object> objectAttributeDefinition;

        private DefaultDisplayValueProvider(AttributeDefinition<?> attributeDefinition) {
            this.objectAttributeDefinition = attributeDefinition;
        }

        @Override
        public Object apply(Object value) {
            return this.objectAttributeDefinition.string(value);
        }
    }

    private static final class EntityCellColorProvider
    implements FilteredTableCellRenderer.CellColorProvider<Attribute<?>> {
        private final SwingEntityTableModel tableModel;

        private EntityCellColorProvider(SwingEntityTableModel tableModel) {
            this.tableModel = tableModel;
        }

        public Color backgroundColor(int row, Attribute<?> columnIdentifier, Object cellValue, boolean selected) {
            return this.tableModel.backgroundColor(row, columnIdentifier);
        }

        public Color foregroundColor(int row, Attribute<?> columnIdentifier, Object cellValue, boolean selected) {
            return this.tableModel.foregroundColor(row, columnIdentifier);
        }
    }

    private static final class EntitySettings
    extends FilteredTableCellRenderer.Settings<Attribute<?>> {
        private Color backgroundColorDoubleShade;
        private Color backgroundColorAlternateDoubleShade;

        private EntitySettings(int leftPadding, int rightPadding, boolean alternateRoColoring) {
            super(leftPadding, rightPadding, alternateRoColoring);
        }

        protected void updateColors() {
            super.updateColors();
            this.backgroundColorDoubleShade = Colors.darker((Color)this.backgroundColor(), (double)0.8);
            this.backgroundColorAlternateDoubleShade = Colors.darker((Color)this.backgroundColorAlternate(), (double)0.8);
        }

        protected Color backgroundColorShaded(FilteredTableModel<?, Attribute<?>> tableModel, int row, Attribute<?> columnIdentifier, Color cellBackgroundColor) {
            boolean showCondition;
            boolean conditionEnabled = ((SwingEntityTableModel)tableModel).conditionModel().enabled(columnIdentifier);
            boolean filterEnabled = tableModel.filterModel().enabled(columnIdentifier);
            boolean bl = showCondition = conditionEnabled || filterEnabled;
            if (showCondition) {
                return this.backgroundColorShaded(row, conditionEnabled && filterEnabled, cellBackgroundColor);
            }
            return cellBackgroundColor;
        }

        private Color backgroundColorShaded(int row, boolean doubleShading, Color cellBackgroundColor) {
            if (cellBackgroundColor != null) {
                return Colors.darker((Color)cellBackgroundColor, (double)0.9);
            }
            return this.alternateRowColor(row) ? (doubleShading ? this.backgroundColorDoubleShade : this.backgroundColorShaded()) : (doubleShading ? this.backgroundColorAlternateDoubleShade : this.backgroundColorAlternateShaded());
        }
    }
}

