/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.framework.ui.ComboBoxEnterPressedAction;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

final class EntityTableCellEditor<T>
extends AbstractCellEditor
implements TableCellEditor {
    private final Supplier<ComponentValue<T, ? extends JComponent>> inputComponentSupplier;
    private final Value<T> cellValue = Value.value();
    private JComponent component;

    EntityTableCellEditor(Supplier<ComponentValue<T, ? extends JComponent>> inputComponentSupplier) {
        this.inputComponentSupplier = Objects.requireNonNull(inputComponentSupplier);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.component == null) {
            this.component = this.createEditorComponent();
        }
        this.cellValue.set(value);
        return this.component;
    }

    @Override
    public Object getCellEditorValue() {
        return this.cellValue.get();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= 2;
        }
        return false;
    }

    private JComponent createEditorComponent() {
        ComponentValue<T, ? extends JComponent> componentValue = this.inputComponentSupplier.get();
        componentValue.link(this.cellValue);
        JComponent editorComponent = componentValue.component();
        if (editorComponent instanceof JCheckBox) {
            ((JCheckBox)editorComponent).setHorizontalAlignment(0);
        }
        if (editorComponent instanceof JComboBox) {
            new ComboBoxEnterPressedAction((JComboBox)editorComponent, (Action)Control.control(this::stopCellEditing));
        }
        return editorComponent;
    }
}

