/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Text;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.exception.RecordNotFoundException;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

final class EntityPopupMenu
extends JPopupMenu {
    private static final int MAXIMUM_VALUE_LENGTH = 42;

    EntityPopupMenu(Entity entity, EntityConnection connection) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(connection);
        EntityPopupMenu.populateEntityMenu(this, entity, connection, new HashSet<Entity.Key>());
    }

    private static void populateEntityMenu(JComponent rootMenu, Entity entity, EntityConnection connection, Set<Entity.Key> visitedKeys) {
        EntityPopupMenu.populatePrimaryKeyMenu(rootMenu, entity, new ArrayList(entity.definition().primaryKey().columnDefinitions()));
        EntityPopupMenu.populateForeignKeyMenu(rootMenu, entity, connection, new ArrayList<ForeignKeyDefinition>(entity.definition().foreignKeys().definitions()), visitedKeys);
        EntityPopupMenu.populateValueMenu(rootMenu, entity, new ArrayList(entity.definition().attributes().definitions()));
    }

    private static void populatePrimaryKeyMenu(JComponent rootMenu, Entity entity, List<ColumnDefinition<?>> primaryKeyColumns) {
        Text.collate(primaryKeyColumns);
        for (ColumnDefinition<?> primaryKeyColumn : primaryKeyColumns) {
            JMenuItem menuItem = new JMenuItem("[PK] " + primaryKeyColumn.attribute() + " [" + primaryKeyColumn.attribute().type().valueClass().getSimpleName() + "]: " + EntityPopupMenu.createValueString(entity, primaryKeyColumn));
            menuItem.addActionListener((ActionListener)Control.control(() -> Utilities.setClipboard((String)entity.string((Attribute)primaryKeyColumn.attribute()))));
            EntityPopupMenu.setInvalidModified(menuItem, true, entity.modified((Attribute)primaryKeyColumn.attribute()));
            menuItem.setToolTipText(primaryKeyColumn.attribute().name());
            rootMenu.add(menuItem);
        }
    }

    private static void populateForeignKeyMenu(JComponent rootMenu, Entity entity, EntityConnection connection, List<ForeignKeyDefinition> fkDefinitions, Set<Entity.Key> visitedKeys) {
        if (!visitedKeys.contains(entity.primaryKey())) {
            visitedKeys.add(entity.primaryKey());
            Text.collate(fkDefinitions);
            EntityDefinition definition = entity.definition();
            EntityValidator validator = definition.validator();
            for (ForeignKeyDefinition fkDefinition : fkDefinitions) {
                ForeignKey foreignKey = fkDefinition.attribute();
                StringBuilder captionBuilder = new StringBuilder("[FK] ").append(fkDefinition.caption()).append(": ");
                Entity.Key referencedKey = entity.referencedKey(foreignKey);
                if (referencedKey == null) {
                    JMenuItem menuItem = new JMenuItem(captionBuilder.append(EntityPopupMenu.createValueString(entity, fkDefinition)).toString());
                    EntityPopupMenu.setInvalidModified(menuItem, EntityPopupMenu.valid(validator, entity, foreignKey), entity.modified((Attribute)foreignKey));
                    menuItem.setToolTipText(EntityPopupMenu.foreignKeyAttributeNames(foreignKey));
                    rootMenu.add(menuItem);
                    continue;
                }
                if (visitedKeys.contains(referencedKey)) continue;
                Entity referencedEntity = EntityPopupMenu.selectEntity(referencedKey, connection);
                entity = entity.mutable() ? entity : entity.deepCopy();
                entity.put((Attribute)foreignKey, (Object)referencedEntity);
                JMenu foreignKeyMenu = new JMenu(captionBuilder.append(EntityPopupMenu.createValueString(entity, fkDefinition)).toString());
                EntityPopupMenu.setInvalidModified(foreignKeyMenu, EntityPopupMenu.valid(validator, entity, foreignKey), entity.modified((Attribute)foreignKey));
                foreignKeyMenu.setToolTipText(EntityPopupMenu.foreignKeyAttributeNames(foreignKey));
                EntityPopupMenu.populateEntityMenu(foreignKeyMenu, referencedEntity, connection, visitedKeys);
                rootMenu.add(foreignKeyMenu);
            }
        }
    }

    private static String foreignKeyAttributeNames(ForeignKey foreignKey) {
        return foreignKey.references().stream().map(reference -> reference.column().toString()).collect(Collectors.joining(", "));
    }

    private static void populateValueMenu(JComponent rootMenu, Entity entity, List<AttributeDefinition<?>> attributeDefinitions) {
        Text.collate(attributeDefinitions);
        EntityDefinition definition = entity.definition();
        EntityValidator validator = definition.validator();
        for (AttributeDefinition<?> attributeDefinition : attributeDefinitions) {
            boolean primaryKeyColumn = attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).primaryKey();
            if (primaryKeyColumn || attributeDefinition instanceof ForeignKeyDefinition) continue;
            JMenuItem menuItem = new JMenuItem(attributeDefinition.toString() + " [" + attributeDefinition.attribute().type().valueClass().getSimpleName() + (attributeDefinition.derived() ? "*" : "") + "]: " + EntityPopupMenu.createValueString(entity, attributeDefinition));
            menuItem.addActionListener((ActionListener)Control.control(() -> Utilities.setClipboard((String)entity.string(attributeDefinition.attribute()))));
            EntityPopupMenu.setInvalidModified(menuItem, EntityPopupMenu.valid(validator, entity, attributeDefinition.attribute()), entity.modified(attributeDefinition.attribute()));
            menuItem.setToolTipText(attributeDefinition.attribute().toString());
            rootMenu.add(menuItem);
        }
    }

    private static String createValueString(Entity entity, AttributeDefinition<?> attributeDefinition) {
        StringBuilder builder = new StringBuilder();
        if (entity.modified(attributeDefinition.attribute())) {
            builder.append(EntityPopupMenu.createValueString(entity.original(attributeDefinition.attribute()), attributeDefinition));
            builder.append(" \u2192 ");
        }
        builder.append(EntityPopupMenu.createValueString(entity.get(attributeDefinition.attribute()), attributeDefinition));
        return builder.toString();
    }

    private static String createValueString(Object value, AttributeDefinition<Object> attributeDefinition) {
        Object valueAsString;
        Object object = valueAsString = value == null ? "<null>" : attributeDefinition.string(value);
        if (((String)valueAsString).length() > 42) {
            valueAsString = ((String)valueAsString).substring(0, 42) + "...";
        }
        return valueAsString;
    }

    private static void setInvalidModified(JMenuItem menuItem, boolean valid, boolean modified) {
        Font currentFont = menuItem.getFont();
        if (!valid) {
            menuItem.setForeground(Color.RED);
            menuItem.setFont(new Font(currentFont.getName(), 1, currentFont.getSize()));
        }
        if (modified) {
            menuItem.setFont(new Font(currentFont.getName(), currentFont.getStyle() | 2, currentFont.getSize()));
        }
    }

    private static boolean valid(EntityValidator validator, Entity entity, Attribute<?> attribute) {
        try {
            validator.validate(entity, attribute);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private static Entity selectEntity(Entity.Key primaryKey, EntityConnection connection) {
        try {
            return connection.selectSingle(EntityConnection.Select.where((Condition)Condition.key((Entity.Key)primaryKey)).fetchDepth(0).build());
        }
        catch (RecordNotFoundException e) {
            return (Entity)ProxyBuilder.builder(Entity.class).delegate((Object)Entity.entity((Entity.Key)primaryKey)).method("toString", parameters -> primaryKey.toString() + " <RECORD NOT FOUND>").build();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}

