/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.event.Event;
import is.codion.common.i18n.Messages;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityType;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonType;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.KeyboardShortcuts;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPanelBuilder;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedPanelLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class EntityPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityPanel.class.getName());
    public static final PropertyValue<Boolean> USE_KEYBOARD_NAVIGATION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.useKeyboardNavigation", (boolean)true);
    public static final PropertyValue<Boolean> DISPOSE_EDIT_DIALOG_ON_ESCAPE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.disposeEditDialogOnEscape", (boolean)true);
    public static final PropertyValue<Boolean> INCLUDE_TOGGLE_EDIT_PANEL_CONTROL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeToggleEditPanelControl", (boolean)true);
    public static final PropertyValue<Boolean> INCLUDE_DETAIL_PANEL_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeDetailPanelControls", (boolean)true);
    public static final PropertyValue<Boolean> TOOLBAR_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.toolbarControls", (boolean)false);
    public static final PropertyValue<Boolean> USE_FRAME_PANEL_DISPLAY = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.useFramePanelDisplay", (boolean)false);
    public static final PropertyValue<String> CONTROL_PANEL_CONSTRAINTS = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityPanel.controlPanelConstraints", (String)"East");
    public static final PropertyValue<String> CONTROL_TOOLBAR_CONSTRAINTS = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityPanel.controlToolbarConstraints", (String)"West");
    public static final PropertyValue<Boolean> INCLUDE_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeControls", (boolean)true);
    public static final KeyboardShortcuts<KeyboardShortcut> KEYBOARD_SHORTCUTS = KeyboardShortcuts.keyboardShortcuts(KeyboardShortcut.class, EntityPanel::defaultKeyStroke);
    private final SwingEntityModel entityModel;
    private final List<EntityPanel> detailPanels = new ArrayList<EntityPanel>();
    private final EntityEditPanel editPanel;
    private final EntityTablePanel tablePanel;
    private final JPanel editControlPanel = new JPanel(Layouts.borderLayout());
    private final JPanel editControlTablePanel = new JPanel(Layouts.borderLayout());
    private final Event<EntityPanel> activateEvent = Event.event();
    private final PanelLayout panelLayout;
    private final DetailController detailController;
    private final Value<String> caption;
    private final Value<PanelState> editPanelState = Value.value((Object)((Object)PanelState.EMBEDDED), (Object)((Object)PanelState.EMBEDDED));
    private final Settings settings = new Settings();
    private String description;
    private EntityPanel parentPanel;
    private EntityPanel previousSiblingPanel;
    private EntityPanel nextSiblingPanel;
    private boolean disposeEditDialogOnEscape = (Boolean)DISPOSE_EDIT_DIALOG_ON_ESCAPE.get();
    private boolean initialized = false;

    public EntityPanel(SwingEntityModel entityModel) {
        this(Objects.requireNonNull(entityModel), TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, PanelLayout panelLayout) {
        this(Objects.requireNonNull(entityModel), null, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, panelLayout);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel) {
        this(Objects.requireNonNull(entityModel), editPanel, (PanelLayout)TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, PanelLayout panelLayout) {
        this(Objects.requireNonNull(entityModel), editPanel, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, panelLayout);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel) {
        this(entityModel, tablePanel, (PanelLayout)TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel, PanelLayout panelLayout) {
        this(entityModel, null, tablePanel, panelLayout);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel) {
        this(entityModel, editPanel, tablePanel, TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel, PanelLayout panelLayout) {
        Objects.requireNonNull(entityModel, "entityModel");
        this.setFocusCycleRoot(true);
        this.entityModel = entityModel;
        String defaultCaption = ((SwingEntityEditModel)entityModel.editModel()).entityDefinition().caption();
        this.caption = Value.value((Object)defaultCaption, (Object)defaultCaption);
        this.description = ((SwingEntityEditModel)entityModel.editModel()).entityDefinition().description();
        this.editPanel = editPanel;
        this.tablePanel = tablePanel;
        this.panelLayout = Objects.requireNonNull(panelLayout);
        this.detailController = panelLayout.detailController().orElse(new NullDetailController());
        this.editPanelState.addListener(this::updateEditPanelState);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.editControlPanel, this.editControlTablePanel, this.tablePanel, this.editPanel});
        if (this.detailPanels != null) {
            Utilities.updateUI(this.detailPanels);
        }
        if (this.panelLayout != null) {
            this.panelLayout.updateUI();
        }
    }

    public final <T extends SwingEntityModel> T model() {
        return (T)this.entityModel;
    }

    public final <T extends SwingEntityEditModel> T editModel() {
        return (T)((SwingEntityEditModel)this.entityModel.editModel());
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)((SwingEntityTableModel)this.entityModel.tableModel());
    }

    public final Optional<EntityPanel> parentPanel() {
        return Optional.ofNullable(this.parentPanel);
    }

    public final Settings configure() {
        this.throwIfInitialized();
        return this.settings;
    }

    public final <T extends DetailController> T detailController() {
        return (T)this.detailController;
    }

    public final void addDetailPanels(EntityPanel ... detailPanels) {
        Objects.requireNonNull(detailPanels, "detailPanels");
        for (EntityPanel detailPanel : detailPanels) {
            this.addDetailPanel(detailPanel);
        }
    }

    public final void addDetailPanel(EntityPanel detailPanel) {
        this.throwIfInitialized();
        if (this.detailPanels.contains(Objects.requireNonNull(detailPanel))) {
            throw new IllegalStateException("Panel already contains detail panel: " + detailPanel);
        }
        EntityPanel.addEntityPanelAndLinkSiblings(detailPanel, this.detailPanels);
        detailPanel.setParentPanel(this);
        detailPanel.addActivateListener(this.detailController::select);
    }

    public final <T extends EntityPanel> T initialize() {
        if (!this.initialized) {
            try {
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return (T)this;
    }

    public final <T extends EntityEditPanel> T editPanel() {
        if (this.editPanel == null) {
            throw new IllegalStateException("No edit panel available");
        }
        return (T)this.editPanel;
    }

    public final boolean containsEditPanel() {
        return this.editPanel != null;
    }

    public final <T extends EntityTablePanel> T tablePanel() {
        if (this.tablePanel == null) {
            throw new IllegalStateException("No table panel available");
        }
        return (T)this.tablePanel;
    }

    public final boolean containsTablePanel() {
        return this.tablePanel != null;
    }

    public final JPanel editControlPanel() {
        return this.editControlPanel;
    }

    public final Collection<EntityPanel> activeDetailPanels() {
        Collection activeDetailModels = this.entityModel.activeDetailModels();
        return this.detailPanels.stream().filter(detailPanel -> activeDetailModels.contains(detailPanel.entityModel)).collect(Collectors.toList());
    }

    public final <T extends EntityPanel> T detailPanel(EntityType entityType) {
        Objects.requireNonNull(entityType);
        for (EntityPanel detailPanel : this.detailPanels) {
            if (!detailPanel.entityModel.entityType().equals(entityType)) continue;
            return (T)detailPanel;
        }
        throw new IllegalArgumentException("Detail panel for entity: " + entityType + " not found in panel: " + this.getClass());
    }

    public final Collection<EntityPanel> detailPanels() {
        return Collections.unmodifiableCollection(this.detailPanels);
    }

    public final boolean containsDetailPanel(EntityType entityType) {
        Objects.requireNonNull(entityType);
        return this.detailPanels.stream().anyMatch(detailPanel -> detailPanel.entityModel.entityType().equals(entityType));
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + (String)this.caption.get();
    }

    public final Value<String> caption() {
        return this.caption;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void addActivateListener(Consumer<EntityPanel> listener) {
        this.activateEvent.addDataListener(listener);
    }

    public final void activate() {
        Window editPanelWindow;
        this.activateEvent.accept((Object)this);
        this.initialize();
        Window parentWindow = Utilities.parentWindow((Component)this);
        if (parentWindow != null) {
            parentWindow.toFront();
        }
        if ((editPanelWindow = Utilities.parentWindow((Component)this.editControlPanel)) != null) {
            editPanelWindow.toFront();
        }
        this.requestInitialFocus();
    }

    public final void displayException(Throwable exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    public final boolean isDisposeEditDialogOnEscape() {
        return this.disposeEditDialogOnEscape;
    }

    public final void setDisposeEditDialogOnEscape(boolean disposeEditDialogOnEscape) {
        this.disposeEditDialogOnEscape = disposeEditDialogOnEscape;
    }

    public final Value<PanelState> editPanelState() {
        return this.editPanelState;
    }

    public final void requestInitialFocus() {
        if (this.editPanel != null && this.editPanel.isShowing()) {
            this.editPanel.requestInitialFocus();
        } else if (this.tablePanel != null) {
            this.tablePanel.table().requestFocus();
        } else if (this.getComponentCount() > 0) {
            this.getComponents()[0].requestFocus();
        } else {
            this.requestFocus();
        }
    }

    public void savePreferences() {
        this.detailPanels.forEach(EntityPanel::savePreferences);
    }

    @Override
    public final void setFocusCycleRoot(boolean focusCycleRoot) {
        super.setFocusCycleRoot(focusCycleRoot);
    }

    public static Builder builder(EntityType entityType) {
        return new EntityPanelBuilder(SwingEntityModel.builder((EntityType)entityType));
    }

    public static Builder builder(SwingEntityModel.Builder modelBuilder) {
        return new EntityPanelBuilder(modelBuilder);
    }

    public static Builder builder(SwingEntityModel model) {
        return new EntityPanelBuilder(model);
    }

    protected void initializeUI() {
        this.setupToggleEditPanelControl();
        this.panelLayout().layout(this);
        if (this.containsTablePanel()) {
            this.initializeTablePanel();
        }
        if (this.containsEditPanel()) {
            this.initializeEditPanel();
            this.updateEditPanelState();
        }
        this.setupKeyboardActions();
    }

    protected JPanel createEditBasePanel(EntityEditPanel editPanel) {
        return (JPanel)Components.panel((LayoutManager)new FlowLayout(this.horizontalControlLayout() ? 1 : 3, 0, 0)).add((JComponent)editPanel).build();
    }

    protected JComponent createControlComponent(Controls controls) {
        if (Objects.requireNonNull(controls).empty()) {
            return null;
        }
        return this.settings.toolbarControls ? this.createControlToolbar(controls) : this.createControlPanel(controls);
    }

    protected Controls createControls() {
        Controls controls = Controls.controls();
        if (this.containsEditPanel()) {
            controls.addAll(((EntityEditPanel)this.editPanel()).controls());
        }
        if (this.containsTablePanel()) {
            controls.add((Action)this.createRefreshTableControl());
        }
        return controls;
    }

    protected final JPanel editControlTablePanel() {
        return this.editControlTablePanel;
    }

    protected final void setupKeyboardActions() {
        if (this.containsTablePanel()) {
            this.tablePanel.control(EntityTablePanel.TableControl.REQUEST_TABLE_FOCUS).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_TABLE_FOCUS).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.SELECT_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            this.tablePanel.control(EntityTablePanel.TableControl.SELECT_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this}));
            KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_SEARCH_FIELD_FOCUS).get())).action((Action)this.createRequestTableSearchFieldControl()).condition(1).enable(new JComponent[]{this});
            if (this.containsEditPanel()) {
                this.tablePanel.control(EntityTablePanel.TableControl.REQUEST_TABLE_FOCUS).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_TABLE_FOCUS).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.SELECT_CONDITION_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_CONDITION_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.TOGGLE_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
                this.tablePanel.control(EntityTablePanel.TableControl.SELECT_FILTER_PANEL).optional().ifPresent(control -> KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_FILTER_PANEL).get())).condition(1).action((Action)control).enable(new JComponent[]{this.editControlPanel}));
            }
        }
        if (this.containsEditPanel()) {
            KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.REQUEST_EDIT_PANEL_FOCUS).get())).condition(1).action((Action)this.createRequestEditPanelFocusControl()).enable(new JComponent[]{this});
            KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.SELECT_INPUT_FIELD).get())).condition(1).action((Action)this.createSelectInputComponentControl()).enable(new JComponent[]{this, this.editControlPanel});
            KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.TOGGLE_EDIT_PANEL).get())).condition(1).action((Action)this.createToggleEditPanelControl()).enable(new JComponent[]{this, this.editControlPanel});
        }
        if (this.settings.useKeyboardNavigation) {
            this.setupNavigation();
        }
    }

    protected final void setupNavigation() {
        KeyEvents.Builder navigateUp = KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_UP).get())).condition(1).action((Action)new Navigate(Direction.UP));
        KeyEvents.Builder navigateDown = KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_DOWN).get())).condition(1).action((Action)new Navigate(Direction.DOWN));
        KeyEvents.Builder navigateRight = KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_RIGHT).get())).condition(1).action((Action)new Navigate(Direction.RIGHT));
        KeyEvents.Builder navigateLeft = KeyEvents.builder((KeyStroke)((KeyStroke)this.settings.keyboardShortcuts.keyStroke((Enum)KeyboardShortcut.NAVIGATE_LEFT).get())).condition(1).action((Action)new Navigate(Direction.LEFT));
        navigateUp.enable(new JComponent[]{this});
        navigateDown.enable(new JComponent[]{this});
        navigateRight.enable(new JComponent[]{this});
        navigateLeft.enable(new JComponent[]{this});
        if (this.containsEditPanel()) {
            navigateUp.enable(new JComponent[]{this.editControlPanel});
            navigateDown.enable(new JComponent[]{this.editControlPanel});
            navigateRight.enable(new JComponent[]{this.editControlPanel});
            navigateLeft.enable(new JComponent[]{this.editControlPanel});
        }
    }

    protected final Control createSelectInputComponentControl() {
        return Control.control(this::selectInputComponent);
    }

    protected final Control createRequestEditPanelFocusControl() {
        return Control.control(this::requestEditPanelFocus);
    }

    protected final Control createRequestTableSearchFieldControl() {
        return Control.control(this.tablePanel.table().searchField()::requestFocusInWindow);
    }

    protected final Control createToggleEditPanelControl() {
        return Control.builder(this::toggleEditPanelState).smallIcon((Icon)FrameworkIcons.instance().editPanel()).description(MESSAGES.getString("toggle_edit")).build();
    }

    protected final Control createRefreshTableControl() {
        return Control.builder(() -> this.tableModel().refresh()).name(Messages.refresh()).enabled(this.editPanel == null ? null : this.editPanel.active()).description(Messages.refreshTip() + " (ALT-" + Messages.refreshMnemonic() + ")").mnemonic(Messages.refreshMnemonic()).smallIcon((Icon)FrameworkIcons.instance().refresh()).build();
    }

    protected final void initializeEditPanel() {
        JComponent controlComponent;
        this.editPanel.initialize();
        this.editControlPanel.setMinimumSize(new Dimension(0, 0));
        int gap = (Integer)Layouts.GAP.get();
        this.editControlPanel.setBorder(BorderFactory.createEmptyBorder(gap, 0, gap, 0));
        this.editControlPanel.add((Component)this.createEditBasePanel(this.editPanel), "Center");
        if (this.settings.includeControls && (controlComponent = this.createControlComponent(this.createControls())) != null) {
            this.editControlPanel.add((Component)controlComponent, this.settings.controlComponentConstraints);
        }
    }

    protected final void initializeTablePanel() {
        this.editControlTablePanel.add((Component)this.tablePanel, "Center");
        if (this.tablePanel.table().doubleClickAction().get() == null) {
            this.tablePanel.table().doubleClickAction().set((Object)Control.control((Control.Command)new ShowHiddenEditPanel()));
        }
        this.tablePanel.initialize();
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
    }

    final void setParentPanel(EntityPanel parentPanel) {
        if (this.parentPanel != null) {
            throw new IllegalStateException("Parent panel has already been set for " + this);
        }
        this.parentPanel = Objects.requireNonNull(parentPanel);
    }

    final void setPreviousSiblingPanel(EntityPanel previousSiblingPanel) {
        this.previousSiblingPanel = Objects.requireNonNull(previousSiblingPanel);
    }

    final void setNextSiblingPanel(EntityPanel nextSiblingPanel) {
        this.nextSiblingPanel = Objects.requireNonNull(nextSiblingPanel);
    }

    final <T extends PanelLayout> T panelLayout() {
        return (T)this.panelLayout;
    }

    static void addEntityPanelAndLinkSiblings(EntityPanel detailPanel, List<EntityPanel> entityPanels) {
        if (!entityPanels.isEmpty()) {
            EntityPanel leftSibling = entityPanels.get(entityPanels.size() - 1);
            detailPanel.setPreviousSiblingPanel(leftSibling);
            leftSibling.setNextSiblingPanel(detailPanel);
            EntityPanel firstPanel = entityPanels.get(0);
            detailPanel.setNextSiblingPanel(firstPanel);
            firstPanel.setPreviousSiblingPanel(detailPanel);
        }
        entityPanels.add(detailPanel);
    }

    private JToolBar createControlToolbar(Controls controls) {
        return (JToolBar)((ToolBarBuilder)Components.toolBar((Controls)controls).orientation(this.horizontalControlLayout() ? 0 : 1)).build();
    }

    private JPanel createControlPanel(Controls controls) {
        if (this.horizontalControlLayout()) {
            return (JPanel)Components.flowLayoutPanel((int)1).add(((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).toggleButtonType(ToggleButtonType.CHECKBOX)).build()).build();
        }
        return (JPanel)Components.borderLayoutPanel().northComponent(((ButtonPanelBuilder)((ButtonPanelBuilder)((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).orientation(1)).buttonBuilder(ButtonBuilder.builder().horizontalAlignment(10))).toggleButtonType(ToggleButtonType.CHECKBOX)).build()).build();
    }

    private boolean horizontalControlLayout() {
        return this.settings.controlComponentConstraints.equals("South") || this.settings.controlComponentConstraints.equals("North");
    }

    private void setupToggleEditPanelControl() {
        if (this.containsTablePanel() && this.containsEditPanel() && this.settings.includeToggleEditPanelControl) {
            this.tablePanel.configure().addToolBarControls((Controls)Controls.builder().control(this.createToggleEditPanelControl()).build());
        }
    }

    private void requestEditPanelFocus() {
        if (this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
        ((EntityEditComponentPanel)this.editPanel()).requestInitialFocus();
    }

    private void selectInputComponent() {
        if (this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
        ((EntityEditComponentPanel)this.editPanel()).selectInputComponent();
    }

    private void updateEditPanelState() {
        Window editPanelWindow;
        if (this.editPanelState.notEqualTo((Object)PanelState.WINDOW) && (editPanelWindow = Utilities.parentWindow((Component)this.editControlPanel)) != null) {
            editPanelWindow.dispose();
        }
        if (this.editPanelState.equalTo((Object)PanelState.EMBEDDED)) {
            this.editControlTablePanel.add((Component)this.editControlPanel, "North");
        } else if (this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
            this.editControlTablePanel.remove(this.editControlPanel);
        } else {
            this.createEditWindow().setVisible(true);
        }
        this.requestInitialFocus();
        this.revalidate();
    }

    private void toggleEditPanelState() {
        if (this.editPanelState.equalTo((Object)PanelState.WINDOW)) {
            this.editPanelState.set((Object)PanelState.HIDDEN);
        } else if (this.editPanelState.equalTo((Object)PanelState.EMBEDDED)) {
            this.editPanelState.set((Object)PanelState.WINDOW);
        } else {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
    }

    private Window createEditWindow() {
        int gap = (Integer)Layouts.GAP.get();
        JPanel basePanel = (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).centerComponent((JComponent)this.editControlPanel).build();
        if (((Boolean)USE_FRAME_PANEL_DISPLAY.get()).booleanValue()) {
            return Windows.frame((JComponent)basePanel).locationRelativeTo((Component)this).title((String)this.caption.get()).defaultCloseOperation(2).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).build();
        }
        return ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)basePanel).owner((Component)this)).title((String)this.caption.get())).modal(false).disposeOnEscape(this.disposeEditDialogOnEscape).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).build();
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private static KeyStroke defaultKeyStroke(KeyboardShortcut shortcut) {
        switch (shortcut) {
            case REQUEST_TABLE_FOCUS: {
                return KeyboardShortcuts.keyStroke((int)84, (int)128);
            }
            case TOGGLE_CONDITION_PANEL: {
                return KeyboardShortcuts.keyStroke((int)83, (int)640);
            }
            case SELECT_CONDITION_PANEL: {
                return KeyboardShortcuts.keyStroke((int)83, (int)128);
            }
            case TOGGLE_FILTER_PANEL: {
                return KeyboardShortcuts.keyStroke((int)70, (int)640);
            }
            case SELECT_FILTER_PANEL: {
                return KeyboardShortcuts.keyStroke((int)70, (int)192);
            }
            case REQUEST_SEARCH_FIELD_FOCUS: {
                return KeyboardShortcuts.keyStroke((int)70, (int)128);
            }
            case REQUEST_EDIT_PANEL_FOCUS: {
                return KeyboardShortcuts.keyStroke((int)69, (int)128);
            }
            case SELECT_INPUT_FIELD: {
                return KeyboardShortcuts.keyStroke((int)73, (int)128);
            }
            case TOGGLE_EDIT_PANEL: {
                return KeyboardShortcuts.keyStroke((int)69, (int)640);
            }
            case NAVIGATE_UP: {
                return KeyboardShortcuts.keyStroke((int)38, (int)640);
            }
            case NAVIGATE_DOWN: {
                return KeyboardShortcuts.keyStroke((int)40, (int)640);
            }
            case NAVIGATE_RIGHT: {
                return KeyboardShortcuts.keyStroke((int)39, (int)640);
            }
            case NAVIGATE_LEFT: {
                return KeyboardShortcuts.keyStroke((int)37, (int)640);
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        if (((Boolean)EntityEditPanel.USE_FOCUS_ACTIVATION.get()).booleanValue()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new FocusActivationListener());
        }
    }

    public static interface PanelLayout {
        default public void updateUI() {
        }

        public void layout(EntityPanel var1);

        default public <T extends DetailController> Optional<T> detailController() {
            return Optional.empty();
        }
    }

    public static enum PanelState {
        WINDOW,
        EMBEDDED,
        HIDDEN;

    }

    public final class Settings {
        private final KeyboardShortcuts<KeyboardShortcut> keyboardShortcuts = KEYBOARD_SHORTCUTS.copy();
        private boolean toolbarControls = (Boolean)TOOLBAR_CONTROLS.get();
        private boolean includeToggleEditPanelControl = (Boolean)INCLUDE_TOGGLE_EDIT_PANEL_CONTROL.get();
        private String controlComponentConstraints = (Boolean)TOOLBAR_CONTROLS.get() != false ? (String)CONTROL_TOOLBAR_CONSTRAINTS.get() : (String)CONTROL_PANEL_CONSTRAINTS.get();
        private boolean includeControls = (Boolean)INCLUDE_CONTROLS.get();
        private boolean useKeyboardNavigation = (Boolean)USE_KEYBOARD_NAVIGATION.get();

        private Settings() {
            Value.Validator keyboardShortcutValidator = keystroke -> EntityPanel.this.throwIfInitialized();
            Stream.of(KeyboardShortcut.values()).forEach(keyboardShortcut -> this.keyboardShortcuts.keyStroke((Enum)keyboardShortcut).addValidator(keyboardShortcutValidator));
        }

        public Settings toolbarControls(boolean toolbarControls) {
            EntityPanel.this.throwIfInitialized();
            this.toolbarControls = toolbarControls;
            return this;
        }

        public Settings controlComponentConstraints(String controlComponentConstraints) {
            EntityPanel.this.throwIfInitialized();
            switch (Objects.requireNonNull(controlComponentConstraints)) {
                case "South": 
                case "North": 
                case "East": 
                case "West": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Control component constraints must be one of BorderLayout.SOUTH, NORTH, EAST or WEST");
                }
            }
            this.controlComponentConstraints = controlComponentConstraints;
            return this;
        }

        public Settings includeToggleEditPanelControl(boolean includeToggleEditPanelControl) {
            EntityPanel.this.throwIfInitialized();
            this.includeToggleEditPanelControl = includeToggleEditPanelControl;
            return this;
        }

        public Settings includeControls(boolean includeControls) {
            EntityPanel.this.throwIfInitialized();
            this.includeControls = includeControls;
            return this;
        }

        public Settings useKeyboardNavigation(boolean useKeyboardNavigation) {
            EntityPanel.this.throwIfInitialized();
            this.useKeyboardNavigation = useKeyboardNavigation;
            return this;
        }

        public Value<KeyStroke> keyStroke(KeyboardShortcut shortcut) {
            return this.keyboardShortcuts.keyStroke((Enum)shortcut);
        }
    }

    private static final class NullDetailController
    implements DetailController {
        private final Value<PanelState> panelState = Value.value((Object)((Object)PanelState.HIDDEN));

        private NullDetailController() {
            this.panelState.addValidator(value -> {
                if (value != PanelState.HIDDEN) {
                    throw new IllegalArgumentException("No detail controller available, can not set the detail panel state");
                }
            });
        }

        @Override
        public void select(EntityPanel entityPanel) {
        }

        @Override
        public Value<PanelState> panelState(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            return this.panelState;
        }
    }

    public static interface DetailController
    extends Selector {
        public Value<PanelState> panelState(EntityPanel var1);
    }

    public static enum KeyboardShortcut {
        REQUEST_TABLE_FOCUS,
        TOGGLE_CONDITION_PANEL,
        SELECT_CONDITION_PANEL,
        TOGGLE_FILTER_PANEL,
        SELECT_FILTER_PANEL,
        REQUEST_SEARCH_FIELD_FOCUS,
        REQUEST_EDIT_PANEL_FOCUS,
        SELECT_INPUT_FIELD,
        TOGGLE_EDIT_PANEL,
        NAVIGATE_UP,
        NAVIGATE_DOWN,
        NAVIGATE_RIGHT,
        NAVIGATE_LEFT;

    }

    private final class Navigate
    extends AbstractAction {
        private final Direction direction;

        private Navigate(Direction direction) {
            super("Navigate " + direction);
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.direction) {
                case LEFT: {
                    if (EntityPanel.this.previousSiblingPanel == null) break;
                    EntityPanel.this.previousSiblingPanel.activate();
                    break;
                }
                case RIGHT: {
                    if (EntityPanel.this.nextSiblingPanel == null) break;
                    EntityPanel.this.nextSiblingPanel.activate();
                    break;
                }
                case UP: {
                    if (EntityPanel.this.parentPanel == null) break;
                    EntityPanel.this.parentPanel.activate();
                    break;
                }
                case DOWN: {
                    this.activeDetailPanel().ifPresent(EntityPanel::activate);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown direction: " + this.direction);
                }
            }
        }

        private Optional<EntityPanel> activeDetailPanel() {
            Collection<EntityPanel> activeDetailPanels = EntityPanel.this.activeDetailPanels();
            if (!activeDetailPanels.isEmpty()) {
                return Optional.of(activeDetailPanels.iterator().next());
            }
            return Optional.empty();
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        RIGHT,
        LEFT;

    }

    private final class ShowHiddenEditPanel
    implements Control.Command {
        private ShowHiddenEditPanel() {
        }

        public void execute() {
            if (EntityPanel.this.containsEditPanel() && EntityPanel.this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
                EntityPanel.this.editPanelState.set((Object)PanelState.WINDOW);
            }
        }
    }

    private static class FocusActivationListener
    implements PropertyChangeListener {
        private FocusActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            Component focusedComponent = (Component)changeEvent.getNewValue();
            EntityPanel entityPanelParent = (EntityPanel)Utilities.parentOfType(EntityPanel.class, (Component)focusedComponent);
            if (entityPanelParent != null) {
                if (entityPanelParent.containsEditPanel()) {
                    ((EntityEditPanel)entityPanelParent.editPanel()).active().set((Object)true);
                }
            } else {
                EntityEditPanel editPanelParent = (EntityEditPanel)Utilities.parentOfType(EntityEditPanel.class, (Component)focusedComponent);
                if (editPanelParent != null) {
                    editPanelParent.active().set((Object)true);
                }
            }
        }
    }

    public static interface Builder {
        public EntityType entityType();

        public Builder caption(String var1);

        public Optional<String> caption();

        public Builder detailPanelBuilder(Builder var1);

        public Builder refreshWhenInitialized(boolean var1);

        public Builder conditionPanelVisible(boolean var1);

        public Builder filterPanelVisible(boolean var1);

        public Builder panelLayout(PanelLayout var1);

        public Builder preferredSize(Dimension var1);

        public Builder panelClass(Class<? extends EntityPanel> var1);

        public Builder editPanelClass(Class<? extends EntityEditPanel> var1);

        public Builder tablePanelClass(Class<? extends EntityTablePanel> var1);

        public Builder onBuildPanel(Consumer<EntityPanel> var1);

        public Builder onBuildEditPanel(Consumer<EntityEditPanel> var1);

        public Builder onBuildTablePanel(Consumer<EntityTablePanel> var1);

        public EntityPanel buildPanel();

        public EntityPanel buildPanel(EntityConnectionProvider var1);

        public EntityPanel buildPanel(SwingEntityModel var1);

        public EntityEditPanel buildEditPanel(EntityConnectionProvider var1);

        public EntityTablePanel buildTablePanel(EntityConnectionProvider var1);
    }

    public static interface Selector {
        public void select(EntityPanel var1);
    }
}

