/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.swing.common.ui.TransferFocusOnEnter;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityComboBox;
import is.codion.swing.framework.ui.component.EntityControls;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class EntityComboBoxPanel
extends JPanel {
    private final EntityComboBox comboBox;

    private EntityComboBoxPanel(DefaultBuilder builder) {
        this.comboBox = builder.createComboBox();
        ArrayList<Control> actions = new ArrayList<Control>();
        if (builder.add) {
            actions.add(EntityControls.createAddControl(this.comboBox, builder.editPanelSupplier));
        }
        if (builder.edit) {
            actions.add(EntityControls.createEditControl(this.comboBox, builder.editPanelSupplier));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)EntityControls.createButtonPanel(this.comboBox, builder.buttonsFocusable, builder.buttonLocation, actions.toArray(new Action[0])), "Center");
        this.addFocusListener(new InputFocusAdapter(this.comboBox));
    }

    public EntityComboBox comboBox() {
        return this.comboBox;
    }

    public static ComponentBuilder<Entity, EntityComboBoxPanel, Builder> builder(EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanelSupplier) {
        return new DefaultBuilder(comboBoxModel, editPanelSupplier, null);
    }

    public static ComponentBuilder<Entity, EntityComboBoxPanel, Builder> builder(EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanelSupplier, Value<Entity> linkedValue) {
        return new DefaultBuilder(comboBoxModel, editPanelSupplier, Objects.requireNonNull(linkedValue));
    }

    private static final class DefaultBuilder
    extends AbstractComponentBuilder<Entity, EntityComboBoxPanel, Builder>
    implements Builder {
        private final ComboBoxBuilder<Entity, EntityComboBox, ?> entityComboBoxBuilder;
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private boolean add;
        private boolean edit;
        private boolean buttonsFocusable;
        private String buttonLocation = EntityControls.defaultButtonLocation();

        private DefaultBuilder(EntityComboBoxModel comboBoxModel, Supplier<EntityEditPanel> editPanelSupplier, Value<Entity> linkedValue) {
            super(linkedValue);
            this.entityComboBoxBuilder = EntityComboBox.builder(comboBoxModel);
            this.editPanelSupplier = Objects.requireNonNull(editPanelSupplier);
        }

        @Override
        public Builder add(boolean add) {
            this.add = add;
            return this;
        }

        @Override
        public Builder edit(boolean edit) {
            this.edit = edit;
            return this;
        }

        @Override
        public Builder buttonsFocusable(boolean buttonsFocusable) {
            this.buttonsFocusable = buttonsFocusable;
            return this;
        }

        @Override
        public Builder buttonLocation(String buttonLocation) {
            this.buttonLocation = EntityControls.validateButtonLocation(buttonLocation);
            return this;
        }

        protected EntityComboBoxPanel createComponent() {
            return new EntityComboBoxPanel(this);
        }

        protected ComponentValue<Entity, EntityComboBoxPanel> createComponentValue(EntityComboBoxPanel component) {
            return new EntityComboBoxPanelValue(component);
        }

        protected void enableTransferFocusOnEnter(EntityComboBoxPanel component) {
            TransferFocusOnEnter.enable((JComponent)component.comboBox());
        }

        protected void setInitialValue(EntityComboBoxPanel component, Entity initialValue) {
            component.comboBox.setSelectedItem(initialValue);
        }

        private EntityComboBox createComboBox() {
            return (EntityComboBox)((ComboBoxBuilder)this.entityComboBoxBuilder.clear()).build();
        }

        private static class EntityComboBoxPanelValue
        extends AbstractComponentValue<Entity, EntityComboBoxPanel> {
            private EntityComboBoxPanelValue(EntityComboBoxPanel component) {
                super((JComponent)component);
                component.comboBox.getModel().addSelectionListener(entity -> this.notifyListeners());
            }

            protected Entity getComponentValue() {
                return (Entity)((EntityComboBoxPanel)this.component()).comboBox.getModel().selectedValue();
            }

            protected void setComponentValue(Entity entity) {
                ((EntityComboBoxPanel)this.component()).comboBox.setSelectedItem(entity);
            }
        }
    }

    private static final class InputFocusAdapter
    extends FocusAdapter {
        private final EntityComboBox comboBox;

        private InputFocusAdapter(EntityComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.comboBox.requestFocusInWindow();
        }
    }

    public static interface Builder
    extends ComponentBuilder<Entity, EntityComboBoxPanel, Builder> {
        public Builder add(boolean var1);

        public Builder edit(boolean var1);

        public Builder buttonsFocusable(boolean var1);

        public Builder buttonLocation(String var1);

        public EntityComboBoxPanel build();
    }
}

