/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.event.Event;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityType;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonType;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.model.SwingEntityModel;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPanelBuilder;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.TabbedPanelLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EntityPanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityPanel.class.getName());
    public static final PropertyValue<Boolean> USE_KEYBOARD_NAVIGATION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.useKeyboardNavigation", (boolean)true);
    public static final PropertyValue<Boolean> DISPOSE_EDIT_DIALOG_ON_ESCAPE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.disposeEditDialogOnEscape", (boolean)true);
    public static final PropertyValue<Boolean> INCLUDE_TOGGLE_EDIT_PANEL_CONTROL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeToggleEditPanelControl", (boolean)true);
    public static final PropertyValue<Boolean> INCLUDE_DETAIL_PANEL_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.includeDetailPanelControls", (boolean)true);
    public static final PropertyValue<Boolean> TOOLBAR_CONTROLS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.toolbarControls", (boolean)false);
    public static final PropertyValue<Boolean> USE_FRAME_PANEL_DISPLAY = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityPanel.useFramePanelDisplay", (boolean)false);
    public static final PropertyValue<String> CONTROL_PANEL_CONSTRAINTS = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityPanel.controlPanelConstraints", (String)"East");
    public static final PropertyValue<String> CONTROL_TOOLBAR_CONSTRAINTS = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityPanel.controlToolbarConstraints", (String)"West");
    private final SwingEntityModel entityModel;
    private final List<EntityPanel> detailPanels = new ArrayList<EntityPanel>();
    private final EntityEditPanel editPanel;
    private final EntityTablePanel tablePanel;
    private final JPanel editControlPanel = new JPanel(Layouts.borderLayout());
    private final JPanel editControlTablePanel = new JPanel(Layouts.borderLayout());
    private final Event<EntityPanel> activateEvent = Event.event();
    private final PanelLayout panelLayout;
    private final DetailController detailController;
    private final Value<String> caption;
    private final Value<PanelState> editPanelState = Value.value((Object)((Object)PanelState.EMBEDDED), (Object)((Object)PanelState.EMBEDDED));
    private String description;
    private EntityPanel parentPanel;
    private EntityPanel previousSiblingPanel;
    private EntityPanel nextSiblingPanel;
    private boolean toolbarControls = (Boolean)TOOLBAR_CONTROLS.get();
    private String controlsComponentConstraints = (Boolean)TOOLBAR_CONTROLS.get() != false ? (String)CONTROL_TOOLBAR_CONSTRAINTS.get() : (String)CONTROL_PANEL_CONSTRAINTS.get();
    private boolean includeControls = true;
    private boolean includeToggleEditPanelControl = (Boolean)INCLUDE_TOGGLE_EDIT_PANEL_CONTROL.get();
    private boolean disposeEditDialogOnEscape = (Boolean)DISPOSE_EDIT_DIALOG_ON_ESCAPE.get();
    private boolean useKeyboardNavigation = (Boolean)USE_KEYBOARD_NAVIGATION.get();
    private boolean initialized = false;

    public EntityPanel(SwingEntityModel entityModel) {
        this(Objects.requireNonNull(entityModel), TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, PanelLayout panelLayout) {
        this(Objects.requireNonNull(entityModel), null, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, panelLayout);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel) {
        this(Objects.requireNonNull(entityModel), editPanel, (PanelLayout)TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, PanelLayout panelLayout) {
        this(Objects.requireNonNull(entityModel), editPanel, entityModel.containsTableModel() ? new EntityTablePanel((SwingEntityTableModel)entityModel.tableModel()) : null, panelLayout);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel) {
        this(entityModel, tablePanel, (PanelLayout)TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, EntityTablePanel tablePanel, PanelLayout panelLayout) {
        this(entityModel, null, tablePanel, panelLayout);
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel) {
        this(entityModel, editPanel, tablePanel, TabbedPanelLayout.builder().build());
    }

    public EntityPanel(SwingEntityModel entityModel, EntityEditPanel editPanel, EntityTablePanel tablePanel, PanelLayout panelLayout) {
        Objects.requireNonNull(entityModel, "entityModel");
        this.setFocusCycleRoot(true);
        this.entityModel = entityModel;
        String defaultCaption = ((SwingEntityEditModel)entityModel.editModel()).entityDefinition().caption();
        this.caption = Value.value((Object)defaultCaption, (Object)defaultCaption);
        this.description = ((SwingEntityEditModel)entityModel.editModel()).entityDefinition().description();
        this.editPanel = editPanel;
        this.tablePanel = tablePanel;
        this.panelLayout = Objects.requireNonNull(panelLayout);
        this.detailController = panelLayout.detailController().orElse(new NullDetailController());
        this.editPanelState.addListener(this::updateEditPanelState);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.editControlPanel, this.editControlTablePanel, this.tablePanel, this.editPanel});
        if (this.detailPanels != null) {
            Utilities.updateUI(this.detailPanels);
        }
        if (this.panelLayout != null) {
            this.panelLayout.updateUI();
        }
    }

    public final <T extends SwingEntityModel> T model() {
        return (T)this.entityModel;
    }

    public final <T extends SwingEntityEditModel> T editModel() {
        return (T)((SwingEntityEditModel)this.entityModel.editModel());
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)((SwingEntityTableModel)this.entityModel.tableModel());
    }

    public final Optional<EntityPanel> parentPanel() {
        return Optional.ofNullable(this.parentPanel);
    }

    public final <T extends DetailController> T detailController() {
        return (T)this.detailController;
    }

    public final boolean isToolbarControls() {
        return this.toolbarControls;
    }

    public final void setToolbarControls(boolean toolbarControls) {
        this.checkIfInitialized();
        this.toolbarControls = toolbarControls;
    }

    public final String getControlsComponentConstraints() {
        return this.controlsComponentConstraints;
    }

    public final void setControlsComponentConstraints(String controlsComponentConstraints) {
        this.checkIfInitialized();
        switch (Objects.requireNonNull(controlsComponentConstraints)) {
            case "South": 
            case "North": 
            case "East": 
            case "West": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Controls component constraint must be one of BorderLayout.SOUTH, NORTH, EAST or WEST");
            }
        }
        this.controlsComponentConstraints = controlsComponentConstraints;
    }

    public final void addDetailPanels(EntityPanel ... detailPanels) {
        Objects.requireNonNull(detailPanels, "detailPanels");
        for (EntityPanel detailPanel : detailPanels) {
            this.addDetailPanel(detailPanel);
        }
    }

    public final void addDetailPanel(EntityPanel detailPanel) {
        this.checkIfInitialized();
        if (this.detailPanels.contains(Objects.requireNonNull(detailPanel))) {
            throw new IllegalStateException("Panel already contains detail panel: " + detailPanel);
        }
        EntityPanel.addEntityPanelAndLinkSiblings(detailPanel, this.detailPanels);
        detailPanel.setParentPanel(this);
        detailPanel.addActivateListener(this.detailController::select);
    }

    public final <T extends EntityPanel> T initialize() {
        if (!this.initialized) {
            try {
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return (T)this;
    }

    public final <T extends EntityEditPanel> T editPanel() {
        return (T)this.editPanel;
    }

    public final boolean containsEditPanel() {
        return this.editPanel != null;
    }

    public final <T extends EntityTablePanel> T tablePanel() {
        return (T)this.tablePanel;
    }

    public final boolean containsTablePanel() {
        return this.tablePanel != null;
    }

    public final JPanel editControlPanel() {
        return this.editControlPanel;
    }

    public final Collection<EntityPanel> activeDetailPanels() {
        Collection activeDetailModels = this.entityModel.activeDetailModels();
        return this.detailPanels.stream().filter(detailPanel -> activeDetailModels.contains(detailPanel.entityModel)).collect(Collectors.toList());
    }

    public final <T extends EntityPanel> T detailPanel(EntityType entityType) {
        Objects.requireNonNull(entityType);
        for (EntityPanel detailPanel : this.detailPanels) {
            if (!detailPanel.entityModel.entityType().equals(entityType)) continue;
            return (T)detailPanel;
        }
        throw new IllegalArgumentException("Detail panel for entity: " + entityType + " not found in panel: " + this.getClass());
    }

    public final Collection<EntityPanel> detailPanels() {
        return Collections.unmodifiableCollection(this.detailPanels);
    }

    public final boolean containsDetailPanel(EntityType entityType) {
        Objects.requireNonNull(entityType);
        return this.detailPanels.stream().anyMatch(detailPanel -> detailPanel.entityModel.entityType().equals(entityType));
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + (String)this.caption.get();
    }

    public final Value<String> caption() {
        return this.caption;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void addActivateListener(Consumer<EntityPanel> listener) {
        this.activateEvent.addDataListener(listener);
    }

    public final void activate() {
        Window editPanelWindow;
        this.activateEvent.accept((Object)this);
        this.initialize();
        Window parentWindow = Utilities.parentWindow((Component)this);
        if (parentWindow != null) {
            parentWindow.toFront();
        }
        if ((editPanelWindow = Utilities.parentWindow((Component)this.editControlPanel)) != null) {
            editPanelWindow.toFront();
        }
        this.requestInitialFocus();
    }

    public final void displayException(Throwable exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    public final boolean isIncludeToggleEditPanelControl() {
        return this.includeToggleEditPanelControl;
    }

    public final void setIncludeToggleEditPanelControl(boolean includeToggleEditPanelControl) {
        this.checkIfInitialized();
        this.includeToggleEditPanelControl = includeToggleEditPanelControl;
    }

    public final boolean isIncludeControls() {
        return this.includeControls;
    }

    public final void setIncludeControls(boolean includeControls) {
        this.checkIfInitialized();
        this.includeControls = includeControls;
    }

    public final boolean isDisposeEditDialogOnEscape() {
        return this.disposeEditDialogOnEscape;
    }

    public final void setDisposeEditDialogOnEscape(boolean disposeEditDialogOnEscape) {
        this.disposeEditDialogOnEscape = disposeEditDialogOnEscape;
    }

    public final boolean isUseKeyboardNavigation() {
        return this.useKeyboardNavigation;
    }

    public final void setUseKeyboardNavigation(boolean useKeyboardNavigation) {
        this.checkIfInitialized();
        this.useKeyboardNavigation = useKeyboardNavigation;
    }

    public final Value<PanelState> editPanelState() {
        return this.editPanelState;
    }

    public final void requestInitialFocus() {
        if (this.editPanel != null && this.editPanel.isShowing()) {
            this.editPanel.requestInitialFocus();
        } else if (this.tablePanel != null) {
            this.tablePanel.table().requestFocus();
        } else if (this.getComponentCount() > 0) {
            this.getComponents()[0].requestFocus();
        } else {
            this.requestFocus();
        }
    }

    public void savePreferences() {
        this.detailPanels.forEach(EntityPanel::savePreferences);
    }

    @Override
    public final void setFocusCycleRoot(boolean focusCycleRoot) {
        super.setFocusCycleRoot(focusCycleRoot);
    }

    public static Builder builder(EntityType entityType) {
        return new EntityPanelBuilder(SwingEntityModel.builder((EntityType)entityType));
    }

    public static Builder builder(SwingEntityModel.Builder modelBuilder) {
        return new EntityPanelBuilder(modelBuilder);
    }

    public static Builder builder(SwingEntityModel model) {
        return new EntityPanelBuilder(model);
    }

    protected void initializeUI() {
        this.setupToggleEditPanelControl();
        this.panelLayout.layout(this);
        if (this.containsTablePanel()) {
            this.initializeTablePanel();
        }
        if (this.containsEditPanel()) {
            this.initializeEditPanel();
            this.updateEditPanelState();
        }
        this.setupKeyboardActions();
    }

    protected JPanel createEditBasePanel(EntityEditPanel editPanel) {
        int alignment = this.controlsComponentConstraints.equals("South") || this.controlsComponentConstraints.equals("North") ? 1 : 3;
        return (JPanel)Components.panel((LayoutManager)new FlowLayout(alignment, 0, 0)).add((JComponent)editPanel).build();
    }

    protected JComponent createControlsComponent() {
        boolean horizontalLayout;
        Controls controls = this.editPanel.controls();
        this.tablePanel.control(EntityTablePanel.ControlCode.REFRESH).ifPresent(arg_0 -> ((Controls)controls).add(arg_0));
        if (controls.empty()) {
            return null;
        }
        boolean bl = horizontalLayout = this.controlsComponentConstraints.equals("South") || this.controlsComponentConstraints.equals("North");
        if (this.toolbarControls) {
            return ((ToolBarBuilder)Components.toolBar((Controls)controls).orientation(horizontalLayout ? 0 : 1)).build();
        }
        if (horizontalLayout) {
            return Components.flowLayoutPanel((int)1).add(((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).toggleButtonType(ToggleButtonType.CHECKBOX)).build()).build();
        }
        return Components.borderLayoutPanel().northComponent(((ButtonPanelBuilder)((ButtonPanelBuilder)((ButtonPanelBuilder)Components.buttonPanel((Controls)controls).orientation(1)).buttonBuilder(ButtonBuilder.builder().horizontalAlignment(10))).toggleButtonType(ToggleButtonType.CHECKBOX)).build()).build();
    }

    protected final JPanel editControlTablePanel() {
        return this.editControlTablePanel;
    }

    protected final void setupKeyboardActions() {
        if (this.containsTablePanel()) {
            this.tablePanel.control(EntityTablePanel.ControlCode.REQUEST_TABLE_FOCUS).ifPresent(control -> KeyEvents.builder((int)84).modifiers(128).condition(1).action((Action)control).enable((JComponent)this));
            this.tablePanel.control(EntityTablePanel.ControlCode.TOGGLE_CONDITION_PANEL).ifPresent(control -> KeyEvents.builder((int)83).modifiers(640).condition(1).action((Action)control).enable((JComponent)this));
            this.tablePanel.control(EntityTablePanel.ControlCode.SELECT_CONDITION_PANEL).ifPresent(control -> KeyEvents.builder((int)83).modifiers(128).condition(1).action((Action)control).enable((JComponent)this));
            this.tablePanel.control(EntityTablePanel.ControlCode.TOGGLE_FILTER_PANEL).ifPresent(control -> KeyEvents.builder((int)70).modifiers(640).condition(1).action((Action)control).enable((JComponent)this));
            this.tablePanel.control(EntityTablePanel.ControlCode.SELECT_FILTER_PANEL).ifPresent(control -> KeyEvents.builder((int)70).modifiers(192).condition(1).action((Action)control).enable((JComponent)this));
            KeyEvents.builder((int)70).modifiers(128).action((Action)Control.control(this.tablePanel.table().searchField()::requestFocusInWindow)).condition(1).enable((JComponent)this);
            if (this.containsEditPanel()) {
                this.tablePanel.control(EntityTablePanel.ControlCode.REQUEST_TABLE_FOCUS).ifPresent(control -> KeyEvents.builder((int)84).modifiers(128).condition(1).action((Action)control).enable((JComponent)this.editControlPanel));
                this.tablePanel.control(EntityTablePanel.ControlCode.TOGGLE_CONDITION_PANEL).ifPresent(control -> KeyEvents.builder((int)83).modifiers(640).condition(1).action((Action)control).enable((JComponent)this.editControlPanel));
                this.tablePanel.control(EntityTablePanel.ControlCode.SELECT_CONDITION_PANEL).ifPresent(control -> KeyEvents.builder((int)83).modifiers(128).condition(1).action((Action)control).enable((JComponent)this.editControlPanel));
                this.tablePanel.control(EntityTablePanel.ControlCode.TOGGLE_FILTER_PANEL).ifPresent(control -> KeyEvents.builder((int)70).modifiers(640).condition(1).action((Action)control).enable((JComponent)this.editControlPanel));
                this.tablePanel.control(EntityTablePanel.ControlCode.SELECT_FILTER_PANEL).ifPresent(control -> KeyEvents.builder((int)70).modifiers(192).condition(1).action((Action)control).enable((JComponent)this.editControlPanel));
            }
        }
        if (this.containsEditPanel()) {
            Control selectEditPanel = Control.control(this::selectEditPanel);
            Control selectInputComponent = Control.control(this::selectInputComponent);
            KeyEvents.builder((int)69).modifiers(128).condition(1).action((Action)selectEditPanel).enable((JComponent)this);
            KeyEvents.builder((int)73).modifiers(128).condition(1).action((Action)selectInputComponent).enable((JComponent)this);
            KeyEvents.builder((int)73).modifiers(128).condition(1).action((Action)selectInputComponent).enable((JComponent)this.editControlPanel);
            ToggleEditPanel toggleEditPanel = new ToggleEditPanel(this);
            KeyEvents.builder((int)69).modifiers(640).condition(1).action((Action)toggleEditPanel).enable((JComponent)this);
            KeyEvents.builder((int)69).modifiers(640).condition(1).action((Action)toggleEditPanel).enable((JComponent)this.editControlPanel);
        }
        if (this.useKeyboardNavigation) {
            this.setupNavigation();
        }
    }

    protected final void setupNavigation() {
        KeyEvents.builder((int)38).modifiers(640).condition(1).action((Action)new Navigate(Direction.UP)).enable((JComponent)this);
        KeyEvents.builder((int)40).modifiers(640).condition(1).action((Action)new Navigate(Direction.DOWN)).enable((JComponent)this);
        KeyEvents.builder((int)39).modifiers(640).condition(1).action((Action)new Navigate(Direction.RIGHT)).enable((JComponent)this);
        KeyEvents.builder((int)37).modifiers(640).condition(1).action((Action)new Navigate(Direction.LEFT)).enable((JComponent)this);
        if (this.containsEditPanel()) {
            KeyEvents.builder((int)38).modifiers(640).condition(1).action((Action)new Navigate(Direction.UP)).enable((JComponent)this.editControlPanel);
            KeyEvents.builder((int)40).modifiers(640).condition(1).action((Action)new Navigate(Direction.DOWN)).enable((JComponent)this.editControlPanel);
            KeyEvents.builder((int)39).modifiers(640).condition(1).action((Action)new Navigate(Direction.RIGHT)).enable((JComponent)this.editControlPanel);
            KeyEvents.builder((int)37).modifiers(640).condition(1).action((Action)new Navigate(Direction.LEFT)).enable((JComponent)this.editControlPanel);
        }
    }

    protected final void initializeEditPanel() {
        JComponent controlsComponent;
        this.editPanel.initialize();
        this.editControlPanel.setMinimumSize(new Dimension(0, 0));
        int gap = (Integer)Layouts.GAP.get();
        this.editControlPanel.setBorder(BorderFactory.createEmptyBorder(gap, 0, gap, 0));
        this.editControlPanel.add((Component)this.createEditBasePanel(this.editPanel), "Center");
        if (this.includeControls && (controlsComponent = this.createControlsComponent()) != null) {
            this.editControlPanel.add((Component)controlsComponent, this.controlsComponentConstraints);
        }
    }

    protected final void initializeTablePanel() {
        this.editControlTablePanel.add((Component)this.tablePanel, "Center");
        if (this.tablePanel.table().doubleClickAction().get() == null) {
            this.tablePanel.table().doubleClickAction().set((Object)Control.control((Control.Command)new ShowHiddenEditPanel()));
        }
        this.tablePanel.initialize();
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
    }

    final void setParentPanel(EntityPanel parentPanel) {
        if (this.parentPanel != null) {
            throw new IllegalStateException("Parent panel has already been set for " + this);
        }
        this.parentPanel = Objects.requireNonNull(parentPanel);
    }

    final void setPreviousSiblingPanel(EntityPanel previousSiblingPanel) {
        this.previousSiblingPanel = Objects.requireNonNull(previousSiblingPanel);
    }

    final void setNextSiblingPanel(EntityPanel nextSiblingPanel) {
        this.nextSiblingPanel = Objects.requireNonNull(nextSiblingPanel);
    }

    final <T extends PanelLayout> T panelLayout() {
        return (T)this.panelLayout;
    }

    static void addEntityPanelAndLinkSiblings(EntityPanel detailPanel, List<EntityPanel> entityPanels) {
        if (!entityPanels.isEmpty()) {
            EntityPanel leftSibling = entityPanels.get(entityPanels.size() - 1);
            detailPanel.setPreviousSiblingPanel(leftSibling);
            leftSibling.setNextSiblingPanel(detailPanel);
            EntityPanel firstPanel = entityPanels.get(0);
            detailPanel.setNextSiblingPanel(firstPanel);
            firstPanel.setPreviousSiblingPanel(detailPanel);
        }
        entityPanels.add(detailPanel);
    }

    private void setupToggleEditPanelControl() {
        if (this.containsTablePanel() && this.containsEditPanel() && this.includeToggleEditPanelControl) {
            this.tablePanel.addToolBarControls(Controls.builder().control(this.createToggleEditPanelControl()).build());
        }
    }

    private Control createToggleEditPanelControl() {
        return Control.builder(this::toggleEditPanelState).smallIcon((Icon)FrameworkIcons.instance().editPanel()).description(MESSAGES.getString("toggle_edit")).build();
    }

    private void selectEditPanel() {
        if (this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
        ((EntityEditComponentPanel)this.editPanel()).requestInitialFocus();
    }

    private void selectInputComponent() {
        if (this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
        ((EntityEditComponentPanel)this.editPanel()).selectInputComponent();
    }

    private void updateEditPanelState() {
        Window editPanelWindow;
        if (this.editPanelState.notEqualTo((Object)PanelState.WINDOW) && (editPanelWindow = Utilities.parentWindow((Component)this.editControlPanel)) != null) {
            editPanelWindow.dispose();
        }
        if (this.editPanelState.equalTo((Object)PanelState.EMBEDDED)) {
            this.editControlTablePanel.add((Component)this.editControlPanel, "North");
        } else if (this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
            this.editControlTablePanel.remove(this.editControlPanel);
        } else {
            this.createEditWindow().setVisible(true);
        }
        this.requestInitialFocus();
        this.revalidate();
    }

    private void toggleEditPanelState() {
        if (this.editPanelState.equalTo((Object)PanelState.WINDOW)) {
            this.editPanelState.set((Object)PanelState.HIDDEN);
        } else if (this.editPanelState.equalTo((Object)PanelState.EMBEDDED)) {
            this.editPanelState.set((Object)PanelState.WINDOW);
        } else {
            this.editPanelState.set((Object)PanelState.EMBEDDED);
        }
    }

    private Window createEditWindow() {
        int gap = (Integer)Layouts.GAP.get();
        JPanel basePanel = (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).centerComponent((JComponent)this.editControlPanel).build();
        if (((Boolean)USE_FRAME_PANEL_DISPLAY.get()).booleanValue()) {
            return Windows.frame((JComponent)basePanel).locationRelativeTo((Component)this).title((String)this.caption.get()).defaultCloseOperation(2).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).build();
        }
        return ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)basePanel).owner((Component)this)).title((String)this.caption.get())).modal(false).disposeOnEscape(this.disposeEditDialogOnEscape).onClosed(windowEvent -> this.editPanelState.set((Object)PanelState.HIDDEN)).build();
    }

    private void checkIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    static {
        if (((Boolean)EntityEditPanel.USE_FOCUS_ACTIVATION.get()).booleanValue()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new FocusActivationListener());
        }
    }

    public static interface PanelLayout {
        default public void updateUI() {
        }

        public void layout(EntityPanel var1);

        default public <T extends DetailController> Optional<T> detailController() {
            return Optional.empty();
        }
    }

    public static enum PanelState {
        WINDOW,
        EMBEDDED,
        HIDDEN;

    }

    private static final class NullDetailController
    implements DetailController {
        private final Value<PanelState> panelState = Value.value((Object)((Object)PanelState.HIDDEN));

        private NullDetailController() {
            this.panelState.addValidator(value -> {
                if (value != PanelState.HIDDEN) {
                    throw new IllegalArgumentException("No detail controller available, can not set the detail panel state");
                }
            });
        }

        @Override
        public void select(EntityPanel entityPanel) {
        }

        @Override
        public Value<PanelState> panelState(EntityPanel detailPanel) {
            Objects.requireNonNull(detailPanel);
            return this.panelState;
        }
    }

    public static interface DetailController
    extends Selector {
        public Value<PanelState> panelState(EntityPanel var1);
    }

    private static final class ToggleEditPanel
    extends AbstractAction {
        private final EntityPanel panel;

        private ToggleEditPanel(EntityPanel panel) {
            super("ToggleEditPanelState");
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.panel.toggleEditPanelState();
        }
    }

    private final class Navigate
    extends AbstractAction {
        private final Direction direction;

        private Navigate(Direction direction) {
            super("Navigate " + direction);
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.direction) {
                case LEFT: {
                    if (EntityPanel.this.previousSiblingPanel == null) break;
                    EntityPanel.this.previousSiblingPanel.activate();
                    break;
                }
                case RIGHT: {
                    if (EntityPanel.this.nextSiblingPanel == null) break;
                    EntityPanel.this.nextSiblingPanel.activate();
                    break;
                }
                case UP: {
                    if (EntityPanel.this.parentPanel == null) break;
                    EntityPanel.this.parentPanel.activate();
                    break;
                }
                case DOWN: {
                    this.activeDetailPanel().ifPresent(EntityPanel::activate);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown direction: " + this.direction);
                }
            }
        }

        private Optional<EntityPanel> activeDetailPanel() {
            Collection<EntityPanel> activeDetailPanels = EntityPanel.this.activeDetailPanels();
            if (!activeDetailPanels.isEmpty()) {
                return Optional.of(activeDetailPanels.iterator().next());
            }
            return Optional.empty();
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        RIGHT,
        LEFT;

    }

    private final class ShowHiddenEditPanel
    implements Control.Command {
        private ShowHiddenEditPanel() {
        }

        public void perform() {
            if (EntityPanel.this.containsEditPanel() && EntityPanel.this.editPanelState.equalTo((Object)PanelState.HIDDEN)) {
                EntityPanel.this.editPanelState.set((Object)PanelState.WINDOW);
            }
        }
    }

    private static class FocusActivationListener
    implements PropertyChangeListener {
        private FocusActivationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            Component focusedComponent = (Component)changeEvent.getNewValue();
            EntityPanel entityPanelParent = (EntityPanel)Utilities.parentOfType(EntityPanel.class, (Component)focusedComponent);
            if (entityPanelParent != null) {
                if (entityPanelParent.editPanel() != null) {
                    ((EntityEditPanel)entityPanelParent.editPanel()).active().set((Object)true);
                }
            } else {
                EntityEditPanel editPanelParent = (EntityEditPanel)Utilities.parentOfType(EntityEditPanel.class, (Component)focusedComponent);
                if (editPanelParent != null) {
                    editPanelParent.active().set((Object)true);
                }
            }
        }
    }

    public static interface Builder {
        public EntityType entityType();

        public Builder caption(String var1);

        public Optional<String> caption();

        public Builder detailPanelBuilder(Builder var1);

        public Builder refreshWhenInitialized(boolean var1);

        public Builder conditionPanelVisible(boolean var1);

        public Builder filterPanelVisible(boolean var1);

        public Builder panelLayout(PanelLayout var1);

        public Builder preferredSize(Dimension var1);

        public Builder panelClass(Class<? extends EntityPanel> var1);

        public Builder editPanelClass(Class<? extends EntityEditPanel> var1);

        public Builder tablePanelClass(Class<? extends EntityTablePanel> var1);

        public Builder onBuildPanel(Consumer<EntityPanel> var1);

        public Builder onBuildEditPanel(Consumer<EntityEditPanel> var1);

        public Builder onBuildTablePanel(Consumer<EntityTablePanel> var1);

        public EntityPanel buildPanel();

        public EntityPanel buildPanel(EntityConnectionProvider var1);

        public EntityPanel buildPanel(SwingEntityModel var1);

        public EntityEditPanel buildEditPanel(EntityConnectionProvider var1);

        public EntityTablePanel buildTablePanel(EntityConnectionProvider var1);
    }

    public static interface Selector {
        public void select(EntityPanel var1);
    }
}

