/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.ui.Cursors;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.framework.model.SwingEntityEditModel;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityEditComponentPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.EntityTablePanel;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.EntityComponents;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityEditPanel
extends EntityEditComponentPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityEditPanel.class);
    private static final ResourceBundle TABLE_PANEL_MESSAGES = ResourceBundle.getBundle(EntityTablePanel.class.getName());
    private static final Confirmer DEFAULT_INSERT_CONFIRMER = new InsertConfirmer();
    private static final Confirmer DEFAULT_UPDATE_CONFIRMER = new UpdateConfirmer();
    private static final Confirmer DEFAULT_DELETE_CONFIRMER = new DeleteConfirmer();
    public static final PropertyValue<Boolean> USE_FOCUS_ACTIVATION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.useFocusActivation", (boolean)true);
    public static final PropertyValue<Boolean> USE_SAVE_CAPTION = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.useSaveCaption", (boolean)false);
    public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityEditPanel.includeEntityMenu", (boolean)true);
    private static final ControlCode[] DEFAULT_CONTROL_CODES = new ControlCode[]{ControlCode.INSERT, ControlCode.UPDATE, ControlCode.DELETE, ControlCode.CLEAR, ControlCode.REFRESH};
    private static final Control NULL_CONTROL = Control.control(() -> {});
    private static final String ALT_PREFIX = " (ALT-";
    private static final State.Group ACTIVE_STATE_GROUP = State.group((State[])new State[0]);
    private final Set<ControlCode> controlCodes;
    private final Map<ControlCode, Control> standardControls = new EnumMap<ControlCode, Control>(ControlCode.class);
    private final State active = State.state(((Boolean)USE_FOCUS_ACTIVATION.get() == false ? 1 : 0) != 0);
    private final EnumMap<Confirmer.Action, Confirmer> confirmers = new EnumMap(Confirmer.Action.class);
    private final State clearAfterInsert = State.state((boolean)true);
    private final State requestFocusAfterInsert = State.state((boolean)true);
    private final Value<ReferentialIntegrityErrorHandling> referentialIntegrityErrorHandling = Value.value((Object)((Object)((ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get()))), (Object)((Object)((ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get()))));
    private Controls controls;
    private boolean initialized = false;

    public EntityEditPanel(SwingEntityEditModel editModel) {
        this(editModel, DEFAULT_CONTROL_CODES);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EntityComponents entityComponents) {
        this(editModel, entityComponents, DEFAULT_CONTROL_CODES);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, ControlCode ... controlCodes) {
        this(editModel, new EntityComponents(editModel.entityDefinition()), controlCodes);
    }

    public EntityEditPanel(SwingEntityEditModel editModel, EntityComponents entityComponents, ControlCode ... controlCodes) {
        super(editModel, entityComponents);
        if (((Boolean)USE_FOCUS_ACTIVATION.get()).booleanValue()) {
            ACTIVE_STATE_GROUP.add(this.active);
        }
        this.controlCodes = EntityEditPanel.validateControlCodes(controlCodes);
        if (((Boolean)editModel.exists().not().get()).booleanValue()) {
            editModel.setDefaults();
        }
    }

    @Override
    public final String toString() {
        return this.editModel().toString();
    }

    public final State active() {
        return this.active;
    }

    public final void clearAndRequestFocus() {
        this.editModel().setDefaults();
        this.requestInitialFocus();
    }

    public final State clearAfterInsert() {
        return this.clearAfterInsert;
    }

    public final State requestFocusAfterInsert() {
        return this.requestFocusAfterInsert;
    }

    public final Value<ReferentialIntegrityErrorHandling> referentialIntegrityErrorHandling() {
        return this.referentialIntegrityErrorHandling;
    }

    public final void setConfirmer(Confirmer.Action action, Confirmer confirmer) {
        this.confirmers.put(Objects.requireNonNull(action), confirmer);
    }

    public final boolean containsControl(ControlCode controlCode) {
        Control control = this.standardControls.get((Object)Objects.requireNonNull(controlCode));
        return control != null && control != NULL_CONTROL;
    }

    public final Control control(ControlCode controlCode) {
        if (!this.containsControl(controlCode)) {
            throw new IllegalArgumentException(controlCode + " control not available in panel: " + this);
        }
        return this.standardControls.get((Object)controlCode);
    }

    public final Controls controls() {
        if (!this.initialized()) {
            throw new IllegalStateException("Method must be called after the panel is initialized");
        }
        if (this.controls == null) {
            this.controls = this.createControls();
        }
        return this.controls;
    }

    public final EntityEditPanel initialize() {
        if (!this.initialized) {
            try {
                this.setupControls();
                this.bindEvents();
                this.initializeUI();
            }
            finally {
                this.initialized = true;
            }
        }
        return this;
    }

    public final boolean insertWithConfirmation() {
        if (this.confirmInsert()) {
            return this.insert();
        }
        return false;
    }

    public final boolean insert() {
        this.beforeInsert();
        try {
            this.editModel().insert();
            if (((Boolean)this.clearAfterInsert.get()).booleanValue()) {
                this.editModel().setDefaults();
            }
            if (((Boolean)this.requestFocusAfterInsert.get()).booleanValue()) {
                this.requestAfterInsertFocus();
            }
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onValidationException(e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e);
        }
        return false;
    }

    public final boolean deleteWithConfirmation() {
        if (this.confirmDelete()) {
            return this.delete();
        }
        return false;
    }

    public final boolean delete() {
        this.beforeDelete();
        try {
            this.editModel().delete();
            this.requestInitialFocus();
            return true;
        }
        catch (ReferentialIntegrityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onReferentialIntegrityException(e);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean updateWithConfirmation() {
        if (this.confirmUpdate()) {
            return this.update();
        }
        return false;
    }

    public final boolean update() {
        this.beforeUpdate();
        try {
            this.editModel().update();
            this.requestAfterUpdateFocus();
            return true;
        }
        catch (ValidationException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.onValidationException(e);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            this.onException(ex);
        }
        return false;
    }

    public final boolean initialized() {
        return this.initialized;
    }

    protected void beforeInsert() {
    }

    protected void beforeUpdate() {
    }

    protected void beforeDelete() {
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (this.referentialIntegrityErrorHandling.equalTo((Object)ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES)) {
            EntityDependenciesPanel.displayDependenciesDialog(Collections.singletonList(this.editModel().entity()), this.editModel().connectionProvider(), (JComponent)this, TABLE_PANEL_MESSAGES.getString("unknown_dependent_records"));
        } else {
            this.onException(exception);
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.editModel().entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
        this.requestComponentFocus(exception.attribute());
    }

    protected final void setControl(ControlCode controlCode, Control control) {
        Objects.requireNonNull(controlCode);
        if (this.initialized()) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
        this.standardControls.put(controlCode, control == null ? NULL_CONTROL : control);
    }

    protected Controls createControls() {
        return Controls.controls((Control[])((Control[])this.controlCodes.stream().filter(this::containsControl).map(this.standardControls::get).toArray(Control[]::new)));
    }

    protected abstract void initializeUI();

    private void setupControls() {
        if (!((Boolean)this.editModel().readOnly().get()).booleanValue()) {
            this.setupEditControls();
        }
        if (this.controlCodes.contains((Object)ControlCode.CLEAR)) {
            this.standardControls.putIfAbsent(ControlCode.CLEAR, this.createClearControl());
        }
        if (this.controlCodes.contains((Object)ControlCode.REFRESH)) {
            this.standardControls.putIfAbsent(ControlCode.REFRESH, this.createRefreshControl());
        }
    }

    private void setupEditControls() {
        if (((Boolean)this.editModel().insertEnabled().get()).booleanValue() && this.controlCodes.contains((Object)ControlCode.INSERT)) {
            this.standardControls.putIfAbsent(ControlCode.INSERT, this.createInsertControl());
        }
        if (((Boolean)this.editModel().updateEnabled().get()).booleanValue() && this.controlCodes.contains((Object)ControlCode.UPDATE)) {
            this.standardControls.putIfAbsent(ControlCode.UPDATE, this.createUpdateControl());
        }
        if (((Boolean)this.editModel().deleteEnabled().get()).booleanValue() && this.controlCodes.contains((Object)ControlCode.DELETE)) {
            this.standardControls.putIfAbsent(ControlCode.DELETE, this.createDeleteControl());
        }
    }

    private Control createRefreshControl() {
        return Control.builder(() -> this.editModel().refresh()).name(FrameworkMessages.refresh()).enabled((StateObserver)this.active).description(FrameworkMessages.refreshTip() + ALT_PREFIX + FrameworkMessages.refreshMnemonic() + ")").mnemonic(FrameworkMessages.refreshMnemonic()).smallIcon((Icon)FrameworkIcons.instance().refresh()).build();
    }

    private Control createDeleteControl() {
        return Control.builder(this::deleteWithConfirmation).name(FrameworkMessages.delete()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().deleteEnabled(), this.editModel().exists()})).description(FrameworkMessages.deleteCurrentTip() + ALT_PREFIX + FrameworkMessages.deleteMnemonic() + ")").mnemonic(FrameworkMessages.deleteMnemonic()).smallIcon((Icon)FrameworkIcons.instance().delete()).build();
    }

    private Control createClearControl() {
        return Control.builder(this::clearAndRequestFocus).name(Messages.clear()).enabled((StateObserver)this.active).description(Messages.clearTip() + ALT_PREFIX + Messages.clearMnemonic() + ")").mnemonic(Messages.clearMnemonic()).smallIcon((Icon)FrameworkIcons.instance().clear()).build();
    }

    private Control createUpdateControl() {
        return Control.builder(this::updateWithConfirmation).name(FrameworkMessages.update()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().updateEnabled(), this.editModel().exists(), this.editModel().modified()})).description(FrameworkMessages.updateTip() + ALT_PREFIX + FrameworkMessages.updateMnemonic() + ")").mnemonic(FrameworkMessages.updateMnemonic()).smallIcon((Icon)FrameworkIcons.instance().update()).build();
    }

    private Control createInsertControl() {
        boolean useSaveCaption = (Boolean)USE_SAVE_CAPTION.get();
        char mnemonic = useSaveCaption ? FrameworkMessages.saveMnemonic() : FrameworkMessages.addMnemonic();
        String caption = useSaveCaption ? FrameworkMessages.save() : FrameworkMessages.add();
        return Control.builder(this::insertWithConfirmation).name(caption).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.active, this.editModel().insertEnabled()})).description(FrameworkMessages.addTip() + ALT_PREFIX + mnemonic + ")").mnemonic(mnemonic).smallIcon((Icon)FrameworkIcons.instance().add()).build();
    }

    private void bindEvents() {
        if (((Boolean)INCLUDE_ENTITY_MENU.get()).booleanValue()) {
            KeyEvents.builder((int)86).modifiers(640).condition(1).action((Action)Control.control(this::showEntityMenu)).enable((JComponent)this);
        }
        this.editModel().refreshing().addDataListener(this::onRefreshingChanged);
        this.editModel().addConfirmOverwriteListener(confirmationState -> {
            int result = JOptionPane.showConfirmDialog(Utilities.parentWindow((Component)this), FrameworkMessages.unsavedDataWarning(), FrameworkMessages.unsavedDataWarningTitle(), 0, 2);
            confirmationState.set((Object)(result == 0 ? 1 : 0));
        });
    }

    private boolean confirmInsert() {
        return this.confirmers.getOrDefault((Object)Confirmer.Action.INSERT, DEFAULT_INSERT_CONFIRMER).confirm(this);
    }

    private boolean confirmDelete() {
        return this.confirmers.getOrDefault((Object)Confirmer.Action.DELETE, DEFAULT_DELETE_CONFIRMER).confirm(this);
    }

    private boolean confirmUpdate() {
        return this.confirmers.getOrDefault((Object)Confirmer.Action.UPDATE, DEFAULT_UPDATE_CONFIRMER).confirm(this);
    }

    private void onRefreshingChanged(boolean refreshing) {
        if (refreshing) {
            this.setCursor(Cursors.WAIT);
        } else {
            this.setCursor(Cursors.DEFAULT);
        }
    }

    private void showEntityMenu() {
        new EntityPopupMenu(this.editModel().entity(), this.editModel().connectionProvider().connection()).show(this, 0, 0);
    }

    private static Set<ControlCode> validateControlCodes(ControlCode[] controlCodes) {
        if (controlCodes == null) {
            return Collections.emptySet();
        }
        for (ControlCode controlCode : controlCodes) {
            Objects.requireNonNull(controlCode, "controlCode");
        }
        return new LinkedHashSet<ControlCode>(Arrays.asList(controlCodes));
    }

    public static enum ControlCode {
        INSERT,
        UPDATE,
        DELETE,
        REFRESH,
        CLEAR;

    }

    public static interface Confirmer {
        public boolean confirm(JComponent var1);

        default public boolean confirm(JComponent dialogOwner, String message, String title) {
            return JOptionPane.showConfirmDialog(dialogOwner, message, title, 2) == 0;
        }

        public static enum Action {
            INSERT,
            UPDATE,
            DELETE;

        }
    }

    private static final class InsertConfirmer
    implements Confirmer {
        private InsertConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return true;
        }
    }

    private static final class UpdateConfirmer
    implements Confirmer {
        private UpdateConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmUpdate(), FrameworkMessages.update());
        }
    }

    private static final class DeleteConfirmer
    implements Confirmer {
        private DeleteConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDelete(), FrameworkMessages.delete());
        }
    }
}

