/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.common.ui.TransferFocusOnEnter;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.component.EntityControls;
import is.codion.swing.framework.ui.component.EntitySearchField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class EntitySearchFieldPanel
extends JPanel {
    private final EntitySearchField searchField;

    private EntitySearchFieldPanel(DefaultBuilder builder) {
        this.searchField = builder.createSearchField();
        ArrayList<Control> actions = new ArrayList<Control>();
        if (builder.add) {
            actions.add(EntityControls.createAddControl(this.searchField, builder.editPanelSupplier));
        }
        if (builder.edit) {
            actions.add(EntityControls.createEditControl(this.searchField, builder.editPanelSupplier));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)EntityControls.createButtonPanel((JComponent)((Object)this.searchField), builder.buttonsFocusable, builder.buttonLocation, actions.toArray(new Action[0])), "Center");
        this.addFocusListener(new InputFocusAdapter(this.searchField));
    }

    public EntitySearchField searchField() {
        return this.searchField;
    }

    public static ComponentBuilder<Entity, EntitySearchFieldPanel, Builder> builder(EntitySearchModel entitySearchModel, Supplier<EntityEditPanel> editPanelSupplier) {
        return new DefaultBuilder(entitySearchModel, editPanelSupplier, null);
    }

    public static ComponentBuilder<Entity, EntitySearchFieldPanel, Builder> builder(EntitySearchModel entitySearchModel, Supplier<EntityEditPanel> editPanelSupplier, Value<Entity> linkedValue) {
        return new DefaultBuilder(entitySearchModel, editPanelSupplier, Objects.requireNonNull(linkedValue));
    }

    private static final class DefaultBuilder
    extends AbstractComponentBuilder<Entity, EntitySearchFieldPanel, Builder>
    implements Builder {
        private final EntitySearchField.Builder searchFieldBuilder;
        private final Supplier<EntityEditPanel> editPanelSupplier;
        private boolean add;
        private boolean edit;
        private boolean buttonsFocusable;
        private String buttonLocation = EntityControls.defaultButtonLocation();

        private DefaultBuilder(EntitySearchModel searchModel, Supplier<EntityEditPanel> editPanelSupplier, Value<Entity> linkedValue) {
            super(linkedValue);
            this.searchFieldBuilder = EntitySearchField.builder(searchModel);
            this.editPanelSupplier = Objects.requireNonNull(editPanelSupplier);
        }

        @Override
        public Builder add(boolean add) {
            this.add = add;
            return this;
        }

        @Override
        public Builder edit(boolean edit) {
            this.edit = edit;
            return this;
        }

        @Override
        public Builder buttonsFocusable(boolean buttonsFocusable) {
            this.buttonsFocusable = buttonsFocusable;
            return this;
        }

        @Override
        public Builder buttonLocation(String buttonLocation) {
            this.buttonLocation = EntityControls.validateButtonLocation(buttonLocation);
            return this;
        }

        @Override
        public Builder columns(int columns) {
            this.searchFieldBuilder.columns(columns);
            return this;
        }

        @Override
        public Builder upperCase(boolean upperCase) {
            this.searchFieldBuilder.upperCase(upperCase);
            return this;
        }

        @Override
        public Builder lowerCase(boolean lowerCase) {
            this.searchFieldBuilder.lowerCase(lowerCase);
            return this;
        }

        @Override
        public Builder searchHintEnabled(boolean searchHintEnabled) {
            this.searchFieldBuilder.searchHintEnabled(searchHintEnabled);
            return this;
        }

        @Override
        public Builder searchOnFocusLost(boolean searchOnFocusLost) {
            this.searchFieldBuilder.searchOnFocusLost(searchOnFocusLost);
            return this;
        }

        @Override
        public Builder selectAllOnFocusGained(boolean selectAllOnFocusGained) {
            this.searchFieldBuilder.selectAllOnFocusGained(selectAllOnFocusGained);
            return this;
        }

        @Override
        public Builder searchIndicator(EntitySearchField.SearchIndicator searchIndicator) {
            this.searchFieldBuilder.searchIndicator(searchIndicator);
            return this;
        }

        @Override
        public Builder selectorFactory(Function<EntitySearchModel, EntitySearchField.Selector> selectorFactory) {
            this.searchFieldBuilder.selectorFactory(selectorFactory);
            return this;
        }

        @Override
        public Builder limit(int limit) {
            this.searchFieldBuilder.limit(limit);
            return this;
        }

        protected EntitySearchFieldPanel createComponent() {
            return new EntitySearchFieldPanel(this);
        }

        protected ComponentValue<Entity, EntitySearchFieldPanel> createComponentValue(EntitySearchFieldPanel component) {
            return new EntitySearchFieldPanelValue(component);
        }

        protected void enableTransferFocusOnEnter(EntitySearchFieldPanel component) {
            TransferFocusOnEnter.enable((JComponent)((Object)component.searchField()));
        }

        protected void setInitialValue(EntitySearchFieldPanel component, Entity initialValue) {
            component.searchField.model().entity().set((Object)initialValue);
        }

        private EntitySearchField createSearchField() {
            return (EntitySearchField)((Object)((EntitySearchField.Builder)this.searchFieldBuilder.clear()).build());
        }

        private static class EntitySearchFieldPanelValue
        extends AbstractComponentValue<Entity, EntitySearchFieldPanel> {
            private EntitySearchFieldPanelValue(EntitySearchFieldPanel component) {
                super((JComponent)component);
                component.searchField.model().entity().addListener(() -> this.notifyListeners());
            }

            protected Entity getComponentValue() {
                return (Entity)((EntitySearchFieldPanel)this.component()).searchField.model().entity().get();
            }

            protected void setComponentValue(Entity entity) {
                ((EntitySearchFieldPanel)this.component()).searchField.model().entity().set((Object)entity);
            }
        }
    }

    private static final class InputFocusAdapter
    extends FocusAdapter {
        private final EntitySearchField searchField;

        private InputFocusAdapter(EntitySearchField searchField) {
            this.searchField = searchField;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.searchField.requestFocusInWindow();
        }
    }

    public static interface Builder
    extends ComponentBuilder<Entity, EntitySearchFieldPanel, Builder> {
        public Builder add(boolean var1);

        public Builder edit(boolean var1);

        public Builder buttonsFocusable(boolean var1);

        public Builder buttonLocation(String var1);

        public Builder columns(int var1);

        public Builder upperCase(boolean var1);

        public Builder lowerCase(boolean var1);

        public Builder searchHintEnabled(boolean var1);

        public Builder searchOnFocusLost(boolean var1);

        public Builder selectAllOnFocusGained(boolean var1);

        public Builder searchIndicator(EntitySearchField.SearchIndicator var1);

        public Builder selectorFactory(Function<EntitySearchModel, EntitySearchField.Selector> var1);

        public Builder limit(int var1);

        public EntitySearchFieldPanel build();
    }
}

