/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui.component;

import is.codion.common.Configuration;
import is.codion.common.NullOrEmpty;
import is.codion.common.i18n.Messages;
import is.codion.common.item.Item;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.model.worker.ProgressWorker;
import is.codion.swing.common.ui.Colors;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.SwingMessages;
import is.codion.swing.common.ui.TransferFocusOnEnter;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.WaitCursor;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.component.text.HintTextField;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TextComponents;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.EntityTableCellRenderer;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class EntitySearchField
extends HintTextField {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntitySearchField.class.getName());
    public static final PropertyValue<SearchIndicator> SEARCH_INDICATOR = Configuration.enumValue((String)"is.codion.swing.framework.ui.component.EntitySearchField.searchIndicator", SearchIndicator.class, (Enum)SearchIndicator.WAIT_CURSOR);
    private final EntitySearchModel model;
    private final Action transferFocusAction = TransferFocusOnEnter.forwardAction();
    private final Action transferFocusBackwardAction = TransferFocusOnEnter.backwardAction();
    private final State searchOnFocusLost = State.state((boolean)true);
    private final State searching = State.state();
    private SettingsPanel settingsPanel;
    private SingleSelectionValue singleSelectionValue;
    private MultiSelectionValue multiSelectionValue;
    private Function<EntitySearchModel, Selector> selectorFactory;
    private ProgressWorker<List<Entity>, ?> searchWorker;
    private SearchIndicator searchIndicator = (SearchIndicator)((Object)SEARCH_INDICATOR.get());
    private Consumer<Boolean> searchIndicatorListener;
    private Color backgroundColor;
    private Color invalidBackgroundColor;

    private EntitySearchField(DefaultEntitySearchFieldBuilder builder) {
        super(builder.searchHintEnabled ? Messages.search() + "..." : null);
        this.model = Objects.requireNonNull(builder.searchModel);
        this.setColumns(builder.columns);
        if (builder.upperCase) {
            TextComponents.upperCase((Document)this.getDocument());
        }
        if (builder.lowerCase) {
            TextComponents.lowerCase((Document)this.getDocument());
        }
        this.searchOnFocusLost.set((Object)builder.searchOnFocusLost);
        this.setSearchIndicator(builder.searchIndicator);
        this.selectorFactory = builder.selectorFactory;
        if (builder.selectAllOnFocusGained) {
            TextComponents.selectAllOnFocusGained((JTextComponent)((Object)this));
        }
        this.setToolTipText(this.model.description());
        this.setComponentPopupMenu(this.createPopupMenu());
        this.configureColors();
        this.bindEvents();
    }

    public void updateUI() {
        super.updateUI();
        if (this.model != null) {
            this.configureColors();
        }
        if (this.searchIndicatorListener instanceof ProgressBarWhileSearching) {
            ((ProgressBarWhileSearching)this.searchIndicatorListener).progressBar.updateUI();
        }
    }

    public EntitySearchModel model() {
        return this.model;
    }

    public void setTransferFocusOnEnter(boolean transferFocusOnEnter) {
        KeyEvents.Builder transferForward = KeyEvents.builder((int)10).condition(0).action(this.transferFocusAction);
        KeyEvents.Builder transferBackward = KeyEvents.builder((int)10).condition(0).modifiers(64).action(this.transferFocusBackwardAction);
        if (transferFocusOnEnter) {
            transferForward.enable((JComponent)((Object)this));
            transferBackward.enable((JComponent)((Object)this));
        } else {
            transferForward.disable((JComponent)((Object)this));
            transferBackward.disable((JComponent)((Object)this));
        }
    }

    public void setSearchIndicator(SearchIndicator searchIndicator) {
        this.searchIndicator = Objects.requireNonNull(searchIndicator);
        this.updateSearchIndicator();
    }

    public void setSelectorFactory(Function<EntitySearchModel, Selector> selectorFactory) {
        this.selectorFactory = Objects.requireNonNull(selectorFactory);
    }

    public State searchOnFocusLost() {
        return this.searchOnFocusLost;
    }

    public ComponentValue<Entity, EntitySearchField> singleSelectionValue() {
        if (this.singleSelectionValue == null) {
            this.singleSelectionValue = new SingleSelectionValue(this);
        }
        return this.singleSelectionValue;
    }

    public ComponentValue<Collection<Entity>, EntitySearchField> multiSelectionValue() {
        if (this.multiSelectionValue == null) {
            this.multiSelectionValue = new MultiSelectionValue(this);
        }
        return this.multiSelectionValue;
    }

    public static Builder builder(EntityType entityType, EntityConnectionProvider connectionProvider) {
        return new DefaultEntitySearchFieldBuilder(EntitySearchModel.builder((EntityType)entityType, (EntityConnectionProvider)connectionProvider).build());
    }

    public static Builder builder(EntitySearchModel searchModel) {
        return new DefaultEntitySearchFieldBuilder(Objects.requireNonNull(searchModel));
    }

    private void bindEvents() {
        new SearchStringValue((JTextField)((Object)this)).link(this.model.searchString());
        this.model.searchString().addDataListener(searchString -> this.updateColors());
        this.model.entities().addListener(() -> this.setCaretPosition(0));
        this.updateSearchIndicator();
        this.addFocusListener(new SearchFocusListener());
        this.addKeyListener(new EnterEscapeListener());
        Utilities.linkToEnabledState((StateObserver)this.model.searchStringModified().not(), (Action[])new Action[]{this.transferFocusAction, this.transferFocusBackwardAction});
    }

    private void updateSearchIndicator() {
        if (this.searchIndicatorListener != null) {
            this.searching.removeDataListener(this.searchIndicatorListener);
        }
        this.searchIndicatorListener = this.createSearchIndicatorListener();
        this.searching.addDataListener(this.searchIndicatorListener);
    }

    private Consumer<Boolean> createSearchIndicatorListener() {
        switch (this.searchIndicator) {
            case WAIT_CURSOR: {
                return new WaitCursorWhileSearching();
            }
            case PROGRESS_BAR: {
                return new ProgressBarWhileSearching();
            }
        }
        throw new IllegalArgumentException("Unknown search indicator: " + this.searchIndicator);
    }

    private void configureColors() {
        this.backgroundColor = UIManager.getColor("TextField.background");
        this.invalidBackgroundColor = Colors.darker((Color)this.backgroundColor);
        this.updateColors();
    }

    private void updateColors() {
        boolean validBackground = (Boolean)this.model.searchStringModified().get() == false;
        this.setBackground(validBackground ? this.backgroundColor : this.invalidBackgroundColor);
    }

    private void performSearch(boolean promptUser) {
        if (NullOrEmpty.nullOrEmpty((String)((String)this.model.searchString().get()))) {
            this.model.entities().set(null);
        } else if (((Boolean)this.model.searchStringModified().get()).booleanValue()) {
            this.cancelCurrentSearch();
            this.searching.set((Object)true);
            this.searchWorker = ProgressWorker.builder(() -> ((EntitySearchModel)this.model).search()).onResult(searchResult -> this.handleResult((List<Entity>)searchResult, promptUser)).onException(this::handleException).onCancelled(this::handleCancel).onInterrupted(this::handleInterrupted).execute();
        }
    }

    private void cancelCurrentSearch() {
        ProgressWorker<List<Entity>, ?> currentWorker = this.searchWorker;
        if (currentWorker != null) {
            currentWorker.cancel(true);
        }
    }

    private void handleResult(List<Entity> searchResult, boolean promptUser) {
        this.endSearch();
        if (searchResult.size() == 1) {
            this.model.entities().set(searchResult);
        } else if (promptUser) {
            this.promptUser(searchResult);
        }
        this.selectAll();
        this.updateColors();
    }

    private void promptUser(List<Entity> searchResult) {
        if (searchResult.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), FrameworkMessages.noResultsFound(), SwingMessages.get((String)"OptionPane.messageDialogTitle"), 1);
        } else {
            this.selectorFactory.apply(this.model).select((JComponent)((Object)this), searchResult);
        }
    }

    private void handleException(Throwable exception) {
        this.endSearch();
        this.updateColors();
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)((Object)this)));
    }

    private void handleCancel() {
        this.endSearch();
    }

    private void handleInterrupted() {
        this.endSearch();
        Thread.currentThread().interrupt();
    }

    private void endSearch() {
        this.searchWorker = null;
        this.searching.set((Object)false);
    }

    private JPopupMenu createPopupMenu() {
        return Components.menu((Controls)Controls.controls((Control[])new Control[]{Control.builder(() -> ((ComponentDialogBuilder)((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.settingsPanel()).owner((Component)((Object)this))).title(FrameworkMessages.settings())).icon(FrameworkIcons.instance().settings())).show()).name(FrameworkMessages.settings()).smallIcon((Icon)FrameworkIcons.instance().settings()).build()})).createPopupMenu();
    }

    private SettingsPanel settingsPanel() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new SettingsPanel(this.model);
        }
        return this.settingsPanel;
    }

    public static ListSelector listSelector(EntitySearchModel searchModel) {
        return new DefaultListSelector(searchModel);
    }

    public static TableSelector tableSelector(EntitySearchModel searchModel) {
        return new DefaultTableSelector(searchModel);
    }

    private static void initializeResultLimitMessage(JLabel label, int limit, int resultSize) {
        boolean resultLimitReached;
        boolean bl = resultLimitReached = limit == resultSize;
        if (resultLimitReached) {
            label.setText(MessageFormat.format(MESSAGES.getString("result_limited"), limit));
            label.setVisible(true);
        }
        label.setVisible(resultLimitReached);
    }

    private static final class DefaultEntitySearchFieldBuilder
    extends AbstractComponentBuilder<Entity, EntitySearchField, Builder>
    implements Builder {
        private final EntitySearchModel searchModel;
        private int columns = (Integer)TextFieldBuilder.DEFAULT_TEXT_FIELD_COLUMNS.get();
        private boolean upperCase;
        private boolean lowerCase;
        private boolean searchHintEnabled = true;
        private boolean searchOnFocusLost = true;
        private boolean selectAllOnFocusGained = true;
        private SearchIndicator searchIndicator = (SearchIndicator)((Object)SEARCH_INDICATOR.get());
        private Function<EntitySearchModel, Selector> selectorFactory = new ListSelectorFactory();

        private DefaultEntitySearchFieldBuilder(EntitySearchModel searchModel) {
            this.searchModel = searchModel;
        }

        @Override
        public Builder columns(int columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public Builder upperCase(boolean upperCase) {
            if (upperCase && this.lowerCase) {
                throw new IllegalArgumentException("Field is already lowercase");
            }
            this.upperCase = upperCase;
            return this;
        }

        @Override
        public Builder lowerCase(boolean lowerCase) {
            if (lowerCase && this.upperCase) {
                throw new IllegalArgumentException("Field is already uppercase");
            }
            this.lowerCase = lowerCase;
            return this;
        }

        @Override
        public Builder searchHintEnabled(boolean searchHintEnabled) {
            this.searchHintEnabled = searchHintEnabled;
            return this;
        }

        @Override
        public Builder searchOnFocusLost(boolean searchOnFocusLost) {
            this.searchOnFocusLost = searchOnFocusLost;
            return this;
        }

        @Override
        public Builder selectAllOnFocusGained(boolean selectAllOnFocusGained) {
            this.selectAllOnFocusGained = selectAllOnFocusGained;
            return this;
        }

        @Override
        public Builder searchIndicator(SearchIndicator searchIndicator) {
            this.searchIndicator = Objects.requireNonNull(searchIndicator);
            return this;
        }

        @Override
        public Builder selectorFactory(Function<EntitySearchModel, Selector> selectorFactory) {
            this.selectorFactory = Objects.requireNonNull(selectorFactory);
            return this;
        }

        @Override
        public Builder limit(int limit) {
            this.searchModel.limit().set((Object)limit);
            return this;
        }

        protected EntitySearchField createComponent() {
            return new EntitySearchField(this);
        }

        protected ComponentValue<Entity, EntitySearchField> createComponentValue(EntitySearchField component) {
            return component.singleSelectionValue();
        }

        protected void setInitialValue(EntitySearchField component, Entity initialValue) {
            component.model().entity().set((Object)initialValue);
        }

        protected void enableTransferFocusOnEnter(EntitySearchField component) {
            component.setTransferFocusOnEnter(true);
        }

        private static final class ListSelectorFactory
        implements Function<EntitySearchModel, Selector> {
            private ListSelectorFactory() {
            }

            @Override
            public Selector apply(EntitySearchModel searchModel) {
                return new DefaultListSelector(searchModel);
            }
        }
    }

    public static enum SearchIndicator {
        WAIT_CURSOR,
        PROGRESS_BAR;

    }

    private final class ProgressBarWhileSearching
    implements Consumer<Boolean> {
        private final JProgressBar progressBar = Components.progressBar().indeterminate(true).string(MESSAGES.getString("searching") + "...").stringPainted(true).build();

        private ProgressBarWhileSearching() {
        }

        @Override
        public void accept(Boolean isSearching) {
            if (isSearching.booleanValue()) {
                EntitySearchField.this.setLayout(new BorderLayout());
                EntitySearchField.this.add(this.progressBar, "Center");
            } else {
                EntitySearchField.this.remove(this.progressBar);
                EntitySearchField.this.setLayout(null);
            }
            EntitySearchField.this.revalidate();
            EntitySearchField.this.repaint();
        }
    }

    private static final class SingleSelectionValue
    extends AbstractComponentValue<Entity, EntitySearchField> {
        private SingleSelectionValue(EntitySearchField searchField) {
            super((JComponent)((Object)searchField));
            searchField.model().entity().addListener(() -> this.notifyListeners());
        }

        protected Entity getComponentValue() {
            return (Entity)((EntitySearchField)((Object)this.component())).model().entity().get();
        }

        protected void setComponentValue(Entity value) {
            ((EntitySearchField)((Object)this.component())).model().entity().set((Object)value);
        }
    }

    private static final class MultiSelectionValue
    extends AbstractComponentValue<Collection<Entity>, EntitySearchField> {
        private MultiSelectionValue(EntitySearchField searchField) {
            super((JComponent)((Object)searchField));
            searchField.model().entities().addListener(() -> this.notifyListeners());
        }

        protected Collection<Entity> getComponentValue() {
            return (Collection)((EntitySearchField)((Object)this.component())).model().entities().get();
        }

        protected void setComponentValue(Collection<Entity> value) {
            ((EntitySearchField)((Object)this.component())).model().entities().set(value);
        }
    }

    private static final class SearchStringValue
    extends AbstractValue<String> {
        private final JTextField searchField;

        private SearchStringValue(JTextField searchField) {
            this.searchField = searchField;
            this.searchField.getDocument().addDocumentListener((DocumentListener)((DocumentAdapter)e -> this.notifyListeners()));
        }

        public String get() {
            return this.searchField.getText();
        }

        protected void setValue(String value) {
            this.searchField.setText(value);
        }
    }

    private final class SearchFocusListener
    implements FocusListener {
        private SearchFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            EntitySearchField.this.updateColors();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                if (EntitySearchField.this.getText().isEmpty()) {
                    EntitySearchField.this.model().entities().set(null);
                } else if (this.shouldPerformSearch()) {
                    EntitySearchField.this.performSearch(false);
                }
            }
            EntitySearchField.this.updateColors();
        }

        private boolean shouldPerformSearch() {
            return (Boolean)EntitySearchField.this.searchOnFocusLost.get() != false && (Boolean)EntitySearchField.this.searching.get() == false && (Boolean)EntitySearchField.this.model.searchStringModified().get() != false;
        }
    }

    private final class EnterEscapeListener
    extends KeyAdapter {
        private EnterEscapeListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (((Boolean)EntitySearchField.this.model.searchStringModified().get()).booleanValue()) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    EntitySearchField.this.performSearch(true);
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    EntitySearchField.this.model.reset();
                    EntitySearchField.this.selectAll();
                }
            }
        }
    }

    private final class WaitCursorWhileSearching
    implements Consumer<Boolean> {
        private WaitCursorWhileSearching() {
        }

        @Override
        public void accept(Boolean isSearching) {
            if (isSearching.booleanValue()) {
                WaitCursor.show((JComponent)((Object)EntitySearchField.this));
            } else {
                WaitCursor.hide((JComponent)((Object)EntitySearchField.this));
            }
        }
    }

    public static interface Selector {
        public void select(JComponent var1, List<Entity> var2);

        public void setPreferredSize(Dimension var1);
    }

    private static final class SettingsPanel
    extends JPanel {
        private SettingsPanel(EntitySearchModel searchModel) {
            this.initializeUI(searchModel);
        }

        private void initializeUI(EntitySearchModel searchModel) {
            this.setLayout(Layouts.borderLayout());
            this.setBorder(Borders.emptyBorder());
            this.add((Component)SettingsPanel.createSearchColumnPanel(searchModel), "Center");
            this.add((Component)SettingsPanel.createSouthPanel(searchModel), "South");
        }

        private static JPanel createSearchColumnPanel(EntitySearchModel searchModel) {
            CardLayout cardLayout = new CardLayout(5, 5);
            PanelBuilder columnBasePanelBuilder = Components.panel((LayoutManager)cardLayout);
            FilteredComboBoxModel columnComboBoxModel = new FilteredComboBoxModel();
            EntityDefinition definition = searchModel.connectionProvider().entities().definition(searchModel.entityType());
            for (Map.Entry entry : searchModel.settings().entrySet()) {
                columnComboBoxModel.add((Object)Item.item((Object)((Column)entry.getKey()), (String)definition.columns().definition((Column)entry.getKey()).caption()));
                columnBasePanelBuilder.add((JComponent)SettingsPanel.createSettingsPanel((EntitySearchModel.Settings)entry.getValue()), (Object)((Column)entry.getKey()).name());
            }
            JPanel columnBasePanel = (JPanel)columnBasePanelBuilder.build();
            if (columnComboBoxModel.getSize() > 0) {
                columnComboBoxModel.addSelectionListener(selected -> cardLayout.show(columnBasePanel, ((Column)selected.get()).name()));
                columnComboBoxModel.setSelectedItem(columnComboBoxModel.getElementAt(0));
            }
            return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border((Border)BorderFactory.createTitledBorder(MESSAGES.getString("search_columns")))).northComponent(Components.comboBox((ComboBoxModel)columnComboBoxModel).build()).centerComponent((JComponent)columnBasePanel).build();
        }

        private static JPanel createSouthPanel(EntitySearchModel searchModel) {
            PanelBuilder southPanelBuilder = Components.gridLayoutPanel((int)1, (int)0);
            if (!searchModel.singleSelection()) {
                southPanelBuilder.add((JComponent)SettingsPanel.createSeparatorPanel(searchModel));
            } else {
                southPanelBuilder.add((JComponent)new JLabel());
            }
            southPanelBuilder.add((JComponent)SettingsPanel.createLimitPanel(searchModel));
            return (JPanel)southPanelBuilder.build();
        }

        private static JPanel createSeparatorPanel(EntitySearchModel searchModel) {
            return (JPanel)Components.borderLayoutPanel().westComponent((JComponent)new JLabel(MESSAGES.getString("multiple_item_separator"))).centerComponent(((TextFieldBuilder)Components.textField((Value)searchModel.separator()).columns(1).maximumLength(1)).build()).build();
        }

        private static JPanel createLimitPanel(EntitySearchModel searchModel) {
            return (JPanel)Components.borderLayoutPanel().westComponent((JComponent)new JLabel(MESSAGES.getString("result_limit"))).centerComponent(((NumberField.Builder)Components.integerField((Value)searchModel.limit()).columns(4)).build()).build();
        }

        private static JPanel createSettingsPanel(EntitySearchModel.Settings settings) {
            return (JPanel)Components.gridLayoutPanel((int)3, (int)1).add(((CheckBoxBuilder)Components.checkBox((Value)settings.caseSensitive()).text(MESSAGES.getString("case_sensitive"))).build()).add(((CheckBoxBuilder)Components.checkBox((Value)settings.wildcardPrefix()).text(MESSAGES.getString("prefix_wildcard"))).build()).add(((CheckBoxBuilder)Components.checkBox((Value)settings.wildcardPostfix()).text(MESSAGES.getString("postfix_wildcard"))).build()).build();
        }
    }

    private static final class DefaultListSelector
    implements ListSelector {
        private final EntitySearchModel searchModel;
        private final DefaultListModel<Entity> listModel = new DefaultListModel();
        private final JList<Entity> list = new JList<Entity>(this.listModel);
        private final JScrollPane scrollPane = new JScrollPane(this.list);
        private final JPanel basePanel = new JPanel(Layouts.borderLayout());
        private final JLabel resultLimitLabel = (JLabel)Components.label().horizontalAlignment(4).build();
        private final Control selectControl;

        private DefaultListSelector(EntitySearchModel searchModel) {
            this.searchModel = Objects.requireNonNull(searchModel);
            this.selectControl = Control.builder((Control.Command)new SelectCommand(searchModel, this.list)).name(Messages.ok()).build();
            this.list.setSelectionMode(searchModel.singleSelection() ? 0 : 2);
            this.list.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        selectControl.actionPerformed(null);
                    }
                }
            });
            this.basePanel.add((Component)this.scrollPane, "Center");
            this.basePanel.add((Component)this.resultLimitLabel, "South");
            int gap = (Integer)Layouts.GAP.get();
            this.basePanel.setBorder(BorderFactory.createEmptyBorder(gap, gap, 0, gap));
        }

        @Override
        public JList<Entity> list() {
            return this.list;
        }

        @Override
        public void select(JComponent dialogOwner, List<Entity> entities) {
            Objects.requireNonNull(entities).forEach(this.listModel::addElement);
            this.list.scrollRectToVisible(this.list.getCellBounds(0, 0));
            EntitySearchField.initializeResultLimitMessage(this.resultLimitLabel, this.searchModel.limit().optional().orElse(-1), entities.size());
            ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog((JComponent)this.basePanel).owner((Component)dialogOwner)).title(MESSAGES.getString("select_entity"))).okAction((Action)this.selectControl).show();
            this.listModel.removeAllElements();
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            this.basePanel.setPreferredSize(preferredSize);
        }

        private static final class SelectCommand
        implements Control.Command {
            private final EntitySearchModel searchModel;
            private final JList<Entity> list;

            private SelectCommand(EntitySearchModel searchModel, JList<Entity> list) {
                this.searchModel = searchModel;
                this.list = list;
            }

            public void perform() {
                this.searchModel.entities().set(this.list.getSelectedValuesList());
                Utilities.disposeParentWindow(this.list);
            }
        }
    }

    private static final class DefaultTableSelector
    implements TableSelector {
        private final EntitySearchModel searchModel;
        private final FilteredTable<Entity, Attribute<?>> table;
        private final JScrollPane scrollPane;
        private final JPanel searchPanel = new JPanel(Layouts.borderLayout());
        private final JPanel basePanel = new JPanel(Layouts.borderLayout());
        private final JLabel resultLimitLabel = (JLabel)Components.label().horizontalAlignment(4).build();
        private final Control selectControl;

        private DefaultTableSelector(EntitySearchModel searchModel) {
            this.searchModel = Objects.requireNonNull(searchModel);
            SwingEntityTableModel tableModel = new SwingEntityTableModel(searchModel.entityType(), searchModel.connectionProvider()){

                protected Collection<Entity> refreshItems() {
                    return Collections.emptyList();
                }
            };
            this.selectControl = Control.builder((Control.Command)this.createSelectCommand(searchModel, tableModel)).name(Messages.ok()).build();
            this.table = (FilteredTable)FilteredTable.builder((FilteredTableModel)tableModel).autoResizeMode(4).selectionMode(searchModel.singleSelection() ? 0 : 2).doubleClickAction((Action)this.selectControl).build();
            KeyEvents.builder((int)10).condition(1).action((Action)this.selectControl).enable(this.table);
            KeyEvents.builder((int)10).action((Action)this.selectControl).enable((JComponent)this.table.searchField());
            KeyEvents.builder((int)70).modifiers(128).action((Action)Control.control(this.table.searchField()::requestFocusInWindow)).enable(this.table);
            tableModel.columnModel().columns().forEach(this::configureColumn);
            Collection searchColumns = searchModel.columns();
            tableModel.columnModel().setVisibleColumns((Object[])searchColumns.toArray(new Attribute[0]));
            tableModel.sortModel().setSortOrder((Object)((Attribute)searchColumns.iterator().next()), SortOrder.ASCENDING);
            this.scrollPane = new JScrollPane((Component)this.table);
            this.searchPanel.add((Component)this.table.searchField(), "West");
            this.searchPanel.add((Component)this.resultLimitLabel, "Center");
            this.basePanel.add((Component)this.scrollPane, "Center");
            this.basePanel.add((Component)this.searchPanel, "South");
            int gap = (Integer)Layouts.GAP.get();
            this.basePanel.setBorder(BorderFactory.createEmptyBorder(gap, gap, 0, gap));
        }

        @Override
        public FilteredTable<Entity, Attribute<?>> table() {
            return this.table;
        }

        @Override
        public void select(JComponent dialogOwner, List<Entity> entities) {
            this.table.getModel().addItemsAtSorted(0, (Collection)Objects.requireNonNull(entities));
            this.table.scrollRectToVisible(this.table.getCellRect(0, 0, true));
            EntitySearchField.initializeResultLimitMessage(this.resultLimitLabel, this.searchModel.limit().optional().orElse(-1), entities.size());
            ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog((JComponent)this.basePanel).owner((Component)dialogOwner)).title(MESSAGES.getString("select_entity"))).okAction((Action)this.selectControl).show();
            this.table.getModel().clear();
            this.table.searchField().setText("");
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            this.basePanel.setPreferredSize(preferredSize);
        }

        private Control.Command createSelectCommand(EntitySearchModel searchModel, SwingEntityTableModel tableModel) {
            return () -> {
                searchModel.entities().set((Collection)tableModel.selectionModel().getSelectedItems());
                Utilities.disposeParentWindow(this.table);
            };
        }

        private void configureColumn(FilteredTableColumn<Attribute<?>> column) {
            column.setCellRenderer((TableCellRenderer)EntityTableCellRenderer.builder((SwingEntityTableModel)this.table.getModel(), (Attribute)column.getIdentifier()).build());
        }
    }

    public static interface TableSelector
    extends Selector {
        public FilteredTable<Entity, Attribute<?>> table();
    }

    public static interface ListSelector
    extends Selector {
        public JList<Entity> list();
    }

    public static interface Builder
    extends ComponentBuilder<Entity, EntitySearchField, Builder> {
        public Builder columns(int var1);

        public Builder upperCase(boolean var1);

        public Builder lowerCase(boolean var1);

        public Builder searchHintEnabled(boolean var1);

        public Builder searchOnFocusLost(boolean var1);

        public Builder selectAllOnFocusGained(boolean var1);

        public Builder searchIndicator(SearchIndicator var1);

        public Builder selectorFactory(Function<EntitySearchModel, Selector> var1);

        public Builder limit(int var1);
    }
}

