/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.NullOrEmpty;
import is.codion.common.db.exception.ReferentialIntegrityException;
import is.codion.common.i18n.Messages;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSelectionModel;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.WaitCursor;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.ColumnConditionPanel;
import is.codion.swing.common.ui.component.table.ColumnSummaryPanel;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilteredTableCellRendererFactory;
import is.codion.swing.common.ui.component.table.FilteredTableColumnComponentPanel;
import is.codion.swing.common.ui.component.table.FilteredTableConditionPanel;
import is.codion.swing.common.ui.component.text.TemporalField;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.SelectionDialogBuilder;
import is.codion.swing.framework.model.SwingEntityTableModel;
import is.codion.swing.framework.ui.ComboBoxEnterPressedAction;
import is.codion.swing.framework.ui.EntityConditionPanelFactory;
import is.codion.swing.framework.ui.EntityDependenciesPanel;
import is.codion.swing.framework.ui.EntityDialogs;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPopupMenu;
import is.codion.swing.framework.ui.EntityTableCellEditor;
import is.codion.swing.framework.ui.EntityTableCellRenderer;
import is.codion.swing.framework.ui.ReferentialIntegrityErrorHandling;
import is.codion.swing.framework.ui.component.DefaultEntityComponentFactory;
import is.codion.swing.framework.ui.component.EntityComponentFactory;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTablePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTablePanel.class);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(EntityTablePanel.class.getName());
    public static final PropertyValue<Boolean> CONDITION_PANEL_VISIBLE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.conditionPanelVisible", (boolean)false);
    public static final PropertyValue<Boolean> FILTER_PANEL_VISIBLE = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.filterPanelVisible", (boolean)false);
    public static final PropertyValue<Boolean> INCLUDE_ENTITY_MENU = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeEntityMenu", (boolean)true);
    public static final PropertyValue<Boolean> INCLUDE_CLEAR_CONTROL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeClearControl", (boolean)false);
    public static final PropertyValue<Boolean> INCLUDE_FILTER_PANEL = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.includeFilterPanel", (boolean)false);
    public static final PropertyValue<Boolean> SHOW_REFRESH_PROGRESS_BAR = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityTablePanel.showRefreshProgressBar", (boolean)false);
    public static final PropertyValue<RefreshButtonVisible> REFRESH_BUTTON_VISIBLE = Configuration.enumValue((String)"is.codion.swing.framework.ui.EntityTablePanel.refreshButtonVisible", RefreshButtonVisible.class, (Enum)RefreshButtonVisible.WHEN_CONDITION_PANEL_IS_VISIBLE);
    public static final PropertyValue<ColumnSelection> COLUMN_SELECTION = Configuration.enumValue((String)"is.codion.swing.framework.ui.EntityTablePanel.columnSelection", ColumnSelection.class, (Enum)ColumnSelection.DIALOG);
    private static final int FONT_SIZE_TO_ROW_HEIGHT = 4;
    private static final Control NULL_CONTROL = Control.control(() -> {});
    private static final Function<SwingEntityTableModel, String> DEFAULT_STATUS_MESSAGE = new DefaultStatusMessage();
    private final State conditionPanelVisibleState = State.state((boolean)((Boolean)CONDITION_PANEL_VISIBLE.get()));
    private final State filterPanelVisibleState = State.state((boolean)((Boolean)FILTER_PANEL_VISIBLE.get()));
    private final State summaryPanelVisibleState = State.state();
    private final Map<ControlCode, Control> controls = new EnumMap<ControlCode, Control>(ControlCode.class);
    private final Map<Attribute<?>, EntityComponentFactory<?, ?, ?>> editComponentFactories = new HashMap();
    private final Map<Attribute<?>, EntityComponentFactory<?, ?, ?>> cellEditorComponentFactories = new HashMap();
    private final List<Controls> additionalPopupControls = new ArrayList<Controls>();
    private final List<Controls> additionalToolBarControls = new ArrayList<Controls>();
    private final ValueSet<Attribute<?>> editableAttributes;
    private final SwingEntityTableModel tableModel;
    private final EntityConditionPanelFactory conditionPanelFactory;
    private final FilteredTable<Entity, Attribute<?>> table;
    private final StatusPanel statusPanel;
    private final JPanel southPanel = new JPanel(new BorderLayout());
    private EntityEditPanel.Confirmer deleteConfirmer = new DeleteConfirmer();
    private JScrollPane tableScrollPane;
    private FilteredTableConditionPanel<Attribute<?>> conditionPanel;
    private JScrollPane conditionPanelScrollPane;
    private FilteredTableConditionPanel<Attribute<?>> filterPanel;
    private JScrollPane filterPanelScrollPane;
    private FilteredTableColumnComponentPanel<Attribute<?>, JPanel> summaryPanel;
    private JScrollPane summaryPanelScrollPane;
    private JPanel tablePanel;
    private JToolBar refreshButtonToolBar;
    private Control conditionRefreshControl;
    private JPanel searchFieldPanel;
    private JSplitPane southPanelSplitPane;
    private JToolBar southToolBar;
    private RefreshButtonVisible refreshButtonVisible = (RefreshButtonVisible)((Object)REFRESH_BUTTON_VISIBLE.get());
    private boolean includeSouthPanel = true;
    private boolean includeConditionPanel = true;
    private boolean includeFilterPanel = (Boolean)INCLUDE_FILTER_PANEL.get();
    private boolean includeClearControl = (Boolean)INCLUDE_CLEAR_CONTROL.get();
    private boolean includeSelectionModeControl = false;
    private ColumnSelection columnSelection = (ColumnSelection)((Object)COLUMN_SELECTION.get());
    private boolean includePopupMenu = true;
    private boolean initialized = false;
    private ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling = (ReferentialIntegrityErrorHandling)((Object)ReferentialIntegrityErrorHandling.REFERENTIAL_INTEGRITY_ERROR_HANDLING.get());

    public EntityTablePanel(SwingEntityTableModel tableModel) {
        this(Objects.requireNonNull(tableModel), new EntityConditionPanelFactory(tableModel.entityDefinition()));
    }

    public EntityTablePanel(SwingEntityTableModel tableModel, EntityConditionPanelFactory conditionPanelFactory) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.conditionPanelFactory = conditionPanelFactory;
        this.editableAttributes = ValueSet.valueSet(tableModel.entityDefinition().attributes().updatable().stream().map(AttributeDefinition::attribute).collect(Collectors.toSet()));
        this.editableAttributes.addValidator((Value.Validator)new EditMenuAttributeValidator());
        this.table = this.createTable();
        this.statusPanel = new StatusPanel();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI((JComponent[])new JComponent[]{this.tablePanel, this.table, this.statusPanel, this.conditionPanel, this.conditionPanelScrollPane, this.filterPanel, this.filterPanelScrollPane, this.summaryPanelScrollPane, this.summaryPanel, this.southPanel, this.refreshButtonToolBar, this.southToolBar, this.southPanelSplitPane, this.searchFieldPanel});
        if (this.tableScrollPane != null) {
            Utilities.updateUI((JComponent[])new JComponent[]{this.tableScrollPane, this.tableScrollPane.getViewport(), this.tableScrollPane.getHorizontalScrollBar(), this.tableScrollPane.getVerticalScrollBar()});
        }
    }

    public final FilteredTable<Entity, Attribute<?>> table() {
        return this.table;
    }

    public final <T extends SwingEntityTableModel> T tableModel() {
        return (T)this.tableModel;
    }

    public final FilteredTableConditionPanel<Attribute<?>> conditionPanel() {
        if (this.conditionPanel == null) {
            this.conditionPanel = this.createConditionPanel(this.conditionPanelFactory);
            if (this.conditionPanel == null) {
                throw new IllegalStateException("No condition panel is available");
            }
        }
        return this.conditionPanel;
    }

    public final ValueSet<Attribute<?>> editableAttributes() {
        return this.editableAttributes;
    }

    public final void addPopupMenuControls(Controls additionalPopupMenuControls) {
        this.throwIfInitialized();
        this.additionalPopupControls.add(Objects.requireNonNull(additionalPopupMenuControls));
    }

    public final void addToolBarControls(Controls additionalToolBarControls) {
        this.throwIfInitialized();
        this.additionalToolBarControls.add(Objects.requireNonNull(additionalToolBarControls));
    }

    public final void setIncludeSouthPanel(boolean includeSouthPanel) {
        this.throwIfInitialized();
        this.includeSouthPanel = includeSouthPanel;
    }

    public final void setIncludeConditionPanel(boolean includeConditionPanel) {
        this.throwIfInitialized();
        this.includeConditionPanel = includeConditionPanel;
    }

    public final void setIncludeFilterPanel(boolean includeFilterPanel) {
        this.throwIfInitialized();
        this.includeFilterPanel = includeFilterPanel;
    }

    public final void setIncludePopupMenu(boolean includePopupMenu) {
        this.throwIfInitialized();
        this.includePopupMenu = includePopupMenu;
    }

    public final void setIncludeClearControl(boolean includeClearControl) {
        this.throwIfInitialized();
        this.includeClearControl = includeClearControl;
    }

    public final void setIncludeSelectionModeControl(boolean includeSelectionModeControl) {
        this.throwIfInitialized();
        this.includeSelectionModeControl = includeSelectionModeControl;
    }

    public final void setColumnSelection(ColumnSelection columnSelection) {
        this.throwIfInitialized();
        this.columnSelection = Objects.requireNonNull(columnSelection);
    }

    public final RefreshButtonVisible getRefreshButtonVisible() {
        return this.refreshButtonVisible;
    }

    public final void setRefreshButtonVisible(RefreshButtonVisible refreshButtonVisible) {
        this.refreshButtonVisible = Objects.requireNonNull(refreshButtonVisible);
        if (this.refreshButtonToolBar == null) {
            this.refreshButtonToolBar = this.createRefreshButtonToolBar();
        }
        this.refreshButtonToolBar.setVisible(refreshButtonVisible == RefreshButtonVisible.ALWAYS || (Boolean)this.conditionPanelVisibleState.get() != false);
    }

    public final State conditionPanelVisible() {
        return this.conditionPanelVisibleState;
    }

    public final State filterPanelVisible() {
        return this.filterPanelVisibleState;
    }

    public final State summaryPanelVisible() {
        return this.summaryPanelVisibleState;
    }

    public final State showRefreshProgressBar() {
        return this.statusPanel.showRefreshProgressBar;
    }

    public final Value<Function<SwingEntityTableModel, String>> statusMessage() {
        return this.statusPanel.statusMessageFunction;
    }

    public final <T, A extends Attribute<T>, C extends JComponent> void setEditComponentFactory(A attribute, EntityComponentFactory<T, A, C> componentFactory) {
        this.tableModel().entityDefinition().attributes().definition(attribute);
        this.editComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
    }

    public final <T, A extends Attribute<T>, C extends JComponent> void setTableCellEditorFactory(A attribute, EntityComponentFactory<T, A, C> componentFactory) {
        this.tableModel().entityDefinition().attributes().definition(attribute);
        this.cellEditorComponentFactories.put(attribute, Objects.requireNonNull(componentFactory));
    }

    public final void toggleConditionPanel() {
        if (this.conditionPanel != null) {
            this.toggleConditionPanel(this.conditionPanelScrollPane, this.conditionPanel.advanced(), this.conditionPanelVisibleState);
        }
    }

    public final void toggleFilterPanel() {
        if (this.filterPanel != null) {
            this.toggleConditionPanel(this.filterPanelScrollPane, this.filterPanel.advanced(), this.filterPanelVisibleState);
        }
    }

    public final void selectConditionPanel() {
        if (this.includeConditionPanel) {
            EntityTablePanel.selectConditionPanel(this.conditionPanel, this.conditionPanelScrollPane, this.conditionPanelVisibleState, this.tableModel, this, FrameworkMessages.selectSearchField());
        }
    }

    public final void selectFilterPanel() {
        if (this.includeFilterPanel) {
            EntityTablePanel.selectConditionPanel(this.filterPanel, this.filterPanelScrollPane, this.filterPanelVisibleState, this.tableModel, this, FrameworkMessages.selectFilterField());
        }
    }

    public final void setReferentialIntegrityErrorHandling(ReferentialIntegrityErrorHandling referentialIntegrityErrorHandling) {
        this.referentialIntegrityErrorHandling = Objects.requireNonNull(referentialIntegrityErrorHandling);
    }

    public final void setDeleteConfirmer(EntityEditPanel.Confirmer deleteConfirmer) {
        this.deleteConfirmer = deleteConfirmer == null ? new DeleteConfirmer() : deleteConfirmer;
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.tableModel.entityType();
    }

    public final Optional<Control> control(ControlCode controlCode) {
        Control control = this.controls.get((Object)Objects.requireNonNull(controlCode));
        return control == NULL_CONTROL ? Optional.empty() : Optional.ofNullable(control);
    }

    public final <T> void editSelectedEntities(Attribute<T> attributeToEdit) {
        Objects.requireNonNull(attributeToEdit);
        if (!this.tableModel.selectionModel().isSelectionEmpty()) {
            ((EntityDialogs.EditDialogBuilder)EntityDialogs.editDialog(this.tableModel.editModel(), attributeToEdit).owner(this)).componentFactory(this.editComponentFactories.get(attributeToEdit)).edit(this.tableModel.selectionModel().getSelectedItems());
        }
    }

    public final void viewDependencies() {
        if (!this.tableModel.selectionModel().isSelectionEmpty()) {
            EntityDependenciesPanel.displayDependenciesDialog(this.tableModel.selectionModel().getSelectedItems(), this.tableModel.connectionProvider(), this);
        }
    }

    public final void deleteWithConfirmation() {
        block6: {
            try {
                if (!this.deleteConfirmer.confirm(this)) break block6;
                this.beforeDelete();
                WaitCursor.show((JComponent)this);
                try {
                    this.tableModel.deleteSelected();
                }
                finally {
                    WaitCursor.hide((JComponent)this);
                }
            }
            catch (ReferentialIntegrityException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                this.onReferentialIntegrityException(e);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.onException(e);
            }
        }
    }

    public final void printTable() throws PrinterException {
        this.table.print();
    }

    public final EntityTablePanel initialize() {
        if (!this.initialized) {
            WaitCursor.show((JComponent)this);
            try {
                this.setupComponents();
                this.setupControls();
                this.setupTable();
                this.layoutPanel(this.tablePanel, this.includeSouthPanel ? this.initializeSouthPanel() : null);
                this.setConditionPanelVisibleInternal((Boolean)this.conditionPanelVisibleState.get());
                this.setFilterPanelVisibleInternal((Boolean)this.filterPanelVisibleState.get());
                this.setSummaryPanelVisibleInternal((Boolean)this.summaryPanelVisibleState.get());
                this.bindEvents();
                this.setupKeyboardActions();
            }
            finally {
                this.initialized = true;
                WaitCursor.hide((JComponent)this);
            }
        }
        return this;
    }

    protected JPanel initializeSouthPanel() {
        this.searchFieldPanel = (JPanel)Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)this.table.searchField(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build();
        this.southPanelSplitPane = (JSplitPane)Components.splitPane().continuousLayout(true).resizeWeight(0.35).leftComponent((JComponent)this.searchFieldPanel).rightComponent((JComponent)this.statusPanel).build();
        this.southPanel.add((Component)this.southPanelSplitPane, "Center");
        this.southPanel.add((Component)this.refreshButtonToolBar, "West");
        this.southToolBar = this.createSouthToolBar();
        if (this.southToolBar != null) {
            this.southPanel.add((Component)this.southToolBar, "East");
        }
        return this.southPanel;
    }

    protected void setupKeyboardActions() {
        this.control(ControlCode.REQUEST_TABLE_FOCUS).ifPresent(control -> KeyEvents.builder((int)84).modifiers(128).condition(1).action((Action)control).enable((JComponent)this));
        this.control(ControlCode.SELECT_CONDITION_PANEL).ifPresent(control -> KeyEvents.builder((int)83).modifiers(128).condition(1).action((Action)control).enable((JComponent)this));
        this.control(ControlCode.TOGGLE_CONDITION_PANEL).ifPresent(control -> KeyEvents.builder((int)83).modifiers(640).condition(1).action((Action)control).enable((JComponent)this));
        this.control(ControlCode.TOGGLE_FILTER_PANEL).ifPresent(control -> KeyEvents.builder((int)70).modifiers(640).condition(1).action((Action)control).enable((JComponent)this));
        this.control(ControlCode.SELECT_FILTER_PANEL).ifPresent(control -> KeyEvents.builder((int)70).modifiers(192).condition(1).action((Action)control).enable((JComponent)this));
        this.control(ControlCode.PRINT).ifPresent(control -> KeyEvents.builder((int)80).modifiers(128).condition(1).action((Action)control).enable((JComponent)this));
    }

    protected final void setControl(ControlCode controlCode, Control control) {
        this.throwIfInitialized();
        this.controls.put(Objects.requireNonNull(controlCode), control == null ? NULL_CONTROL : control);
    }

    protected Controls createToolBarControls(List<Controls> additionalToolBarControls) {
        Objects.requireNonNull(additionalToolBarControls);
        Controls toolbarControls = Controls.controls();
        this.control(ControlCode.TOGGLE_SUMMARY_PANEL).ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        Control toggleConditionPanelControl = this.control(ControlCode.TOGGLE_CONDITION_PANEL).orElse(null);
        Control toggleFilterPanelControl = this.control(ControlCode.TOGGLE_FILTER_PANEL).orElse(null);
        if (toggleConditionPanelControl != null || toggleFilterPanelControl != null) {
            if (toggleConditionPanelControl != null) {
                toolbarControls.add((Action)toggleConditionPanelControl);
            }
            if (toggleFilterPanelControl != null) {
                toolbarControls.add((Action)toggleFilterPanelControl);
            }
            toolbarControls.addSeparator();
        }
        this.control(ControlCode.DELETE_SELECTED).ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        this.control(ControlCode.PRINT).ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        this.control(ControlCode.CLEAR_SELECTION).ifPresent(control -> {
            toolbarControls.add((Action)control);
            toolbarControls.addSeparator();
        });
        this.control(ControlCode.MOVE_SELECTION_UP).ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        this.control(ControlCode.MOVE_SELECTION_DOWN).ifPresent(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        additionalToolBarControls.forEach(additionalControls -> {
            toolbarControls.addSeparator();
            additionalControls.actions().forEach(arg_0 -> ((Controls)toolbarControls).add(arg_0));
        });
        return toolbarControls;
    }

    protected Controls createPopupMenuControls(List<Controls> additionalPopupMenuControls) {
        Controls columnControls;
        Controls printControls;
        Objects.requireNonNull(additionalPopupMenuControls);
        Controls popupControls = Controls.controls();
        this.control(ControlCode.REFRESH).ifPresent(arg_0 -> ((Controls)popupControls).add(arg_0));
        this.control(ControlCode.CLEAR).ifPresent(arg_0 -> ((Controls)popupControls).add(arg_0));
        if (popupControls.notEmpty()) {
            popupControls.addSeparator();
        }
        EntityTablePanel.addAdditionalControls(popupControls, additionalPopupMenuControls);
        State separatorRequired = State.state();
        this.control(ControlCode.EDIT_SELECTED).ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        this.control(ControlCode.DELETE_SELECTED).ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        if (((Boolean)separatorRequired.get()).booleanValue()) {
            popupControls.addSeparator();
            separatorRequired.set((Object)false);
        }
        this.control(ControlCode.VIEW_DEPENDENCIES).ifPresent(control -> {
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        if (((Boolean)separatorRequired.get()).booleanValue()) {
            popupControls.addSeparator();
            separatorRequired.set((Object)false);
        }
        if ((printControls = this.createPrintMenuControls()) != null && printControls.notEmpty()) {
            popupControls.add(printControls);
            separatorRequired.set((Object)true);
        }
        if ((columnControls = this.createColumnControls()).notEmpty()) {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            popupControls.add(columnControls);
            separatorRequired.set((Object)true);
        }
        this.control(ControlCode.SELECTION_MODE).ifPresent(control -> {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            popupControls.add((Action)control);
            separatorRequired.set((Object)true);
        });
        if (this.includeConditionPanel && this.conditionPanel != null) {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            this.addConditionControls(popupControls);
            separatorRequired.set((Object)true);
        }
        if (this.includeFilterPanel && this.filterPanel != null) {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            this.addFilterControls(popupControls);
            separatorRequired.set((Object)true);
        }
        this.control(ControlCode.COPY_TABLE_DATA).ifPresent(control -> {
            if (((Boolean)separatorRequired.get()).booleanValue()) {
                popupControls.addSeparator();
            }
            popupControls.add((Action)control);
        });
        return popupControls;
    }

    protected Controls createPrintMenuControls() {
        Controls.Builder builder = Controls.builder().name(Messages.print()).mnemonic(Messages.printMnemonic()).smallIcon((Icon)FrameworkIcons.instance().print());
        this.control(ControlCode.PRINT).ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        return builder.build();
    }

    protected TableCellRenderer createTableCellRenderer(Attribute<?> attribute) {
        return EntityTableCellRenderer.builder(this.tableModel, attribute).build();
    }

    protected TableCellEditor createTableCellEditor(Attribute<?> attribute) {
        AttributeDefinition attributeDefinition = this.tableModel.entityDefinition().attributes().definition(attribute);
        if (attribute instanceof ColumnDefinition && !((ColumnDefinition)attributeDefinition).updatable()) {
            return null;
        }
        if (this.nonUpdatableForeignKey(attribute)) {
            return null;
        }
        return new EntityTableCellEditor(() -> this.cellEditorComponentValue(attribute, null));
    }

    protected void layoutPanel(JPanel tablePanel, JPanel southPanel) {
        Objects.requireNonNull(tablePanel, "tablePanel");
        this.setLayout(new BorderLayout());
        this.add((Component)tablePanel, "Center");
        if (southPanel != null) {
            this.add((Component)southPanel, "South");
        }
    }

    protected JToolBar createSouthToolBar() {
        Controls toolbarControls = this.createToolBarControls(this.additionalToolBarControls);
        if (toolbarControls == null || toolbarControls.empty()) {
            return null;
        }
        return (JToolBar)((ToolBarBuilder)((ToolBarBuilder)Components.toolBar().controls(toolbarControls)).focusable(false)).floatable(false).rollover(true).build(toolBar -> Arrays.stream(toolBar.getComponents()).map(JComponent.class::cast).forEach(component -> component.setToolTipText(null)));
    }

    protected void beforeDelete() {
    }

    protected void onReferentialIntegrityException(ReferentialIntegrityException exception) {
        Objects.requireNonNull(exception);
        if (this.referentialIntegrityErrorHandling == ReferentialIntegrityErrorHandling.DISPLAY_DEPENDENCIES) {
            EntityDependenciesPanel.displayDependenciesDialog(this.tableModel.selectionModel().getSelectedItems(), this.tableModel.connectionProvider(), (JComponent)this, MESSAGES.getString("unknown_dependent_records"));
        } else {
            this.onException(exception);
        }
    }

    protected void onValidationException(ValidationException exception) {
        Objects.requireNonNull(exception);
        String title = this.tableModel.entities().definition(exception.attribute().entityType()).attributes().definition(exception.attribute()).caption();
        JOptionPane.showMessageDialog(this, exception.getMessage(), title, 0);
    }

    protected void onException(Throwable exception) {
        this.displayException(exception);
    }

    protected final void displayException(Throwable exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    private Controls createEditSelectedControls() {
        StateObserver selectionNotEmpty = this.tableModel.selectionModel().selectionNotEmpty();
        State updateEnabled = this.tableModel.editModel().updateEnabled();
        State.Combination updateMultipleEnabledOrSingleSelection = State.or((StateObserver[])new StateObserver[]{this.tableModel.editModel().updateMultipleEnabled(), this.tableModel.selectionModel().singleSelection()});
        State.Combination enabledState = State.and((StateObserver[])new StateObserver[]{selectionNotEmpty, updateEnabled, updateMultipleEnabledOrSingleSelection});
        Controls editControls = Controls.builder().name(FrameworkMessages.edit()).enabled((StateObserver)enabledState).smallIcon((Icon)FrameworkIcons.instance().edit()).description(FrameworkMessages.editSelectedTip()).build();
        ((Set)this.editableAttributes.get()).stream().map(attribute -> this.tableModel.entityDefinition().attributes().definition(attribute)).sorted(AttributeDefinition.definitionComparator()).forEach(arg_0 -> this.lambda$createEditSelectedControls$19(editControls, (StateObserver)enabledState, arg_0));
        return editControls;
    }

    private Control createViewDependenciesControl() {
        return Control.builder(this::viewDependencies).name(FrameworkMessages.dependencies()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).description(FrameworkMessages.dependenciesTip()).smallIcon((Icon)FrameworkIcons.instance().dependencies()).build();
    }

    private Control createDeleteSelectedControl() {
        return Control.builder(this::deleteWithConfirmation).name(FrameworkMessages.delete()).enabled((StateObserver)State.and((StateObserver[])new StateObserver[]{this.tableModel.editModel().deleteEnabled(), this.tableModel.selectionModel().selectionNotEmpty()})).description(FrameworkMessages.deleteSelectedTip()).smallIcon((Icon)FrameworkIcons.instance().delete()).build();
    }

    private Control createRefreshControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).refresh()).name(FrameworkMessages.refresh()).description(FrameworkMessages.refreshTip()).mnemonic(FrameworkMessages.refreshMnemonic()).smallIcon((Icon)FrameworkIcons.instance().refresh()).enabled(this.tableModel.refresher().observer().not()).build();
    }

    private Control createClearControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).clear()).name(Messages.clear()).description(Messages.clearTip()).mnemonic(Messages.clearMnemonic()).smallIcon((Icon)FrameworkIcons.instance().clear()).build();
    }

    private Control createToggleConditionPanelControl() {
        return Control.builder(this::toggleConditionPanel).smallIcon((Icon)FrameworkIcons.instance().search()).description(MESSAGES.getString("show_condition_panel")).build();
    }

    private Control createToggleFilterPanelControl() {
        return Control.builder(this::toggleFilterPanel).smallIcon((Icon)FrameworkIcons.instance().filter()).description(MESSAGES.getString("show_filter_panel")).build();
    }

    private Control createToggleSummaryPanelControl() {
        return ToggleControl.builder((State)this.summaryPanelVisibleState).smallIcon((Icon)FrameworkIcons.instance().summary()).description(MESSAGES.getString("toggle_summary_tip")).build();
    }

    private Control createClearSelectionControl() {
        return Control.builder(() -> this.tableModel.selectionModel().clearSelection()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).smallIcon((Icon)FrameworkIcons.instance().clearSelection()).description(MESSAGES.getString("clear_selection_tip")).build();
    }

    private Control createMoveSelectionDownControl() {
        return Control.builder(() -> ((FilteredTableSelectionModel)this.tableModel.selectionModel()).moveSelectionDown()).smallIcon((Icon)FrameworkIcons.instance().down()).description(MESSAGES.getString("selection_down_tip")).build();
    }

    private Control createMoveSelectionUpControl() {
        return Control.builder(() -> ((FilteredTableSelectionModel)this.tableModel.selectionModel()).moveSelectionUp()).smallIcon((Icon)FrameworkIcons.instance().up()).description(MESSAGES.getString("selection_up_tip")).build();
    }

    private Controls createColumnControls() {
        Controls.Builder builder = Controls.builder().name(MESSAGES.getString("columns"));
        this.control(ControlCode.SELECT_COLUMNS).ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(ControlCode.RESET_COLUMNS).ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        this.control(ControlCode.COLUMN_AUTO_RESIZE_MODE).ifPresent(arg_0 -> ((Controls.Builder)builder).control(arg_0));
        return builder.build();
    }

    private Control createConditionPanelControl() {
        return ToggleControl.builder((State)this.conditionPanelVisibleState).name(FrameworkMessages.show()).build();
    }

    private Control createFilterPanelControl() {
        return ToggleControl.builder((State)this.filterPanelVisibleState).name(FrameworkMessages.show()).build();
    }

    private Controls createCopyControls() {
        return Controls.builder().name(Messages.copy()).smallIcon((Icon)FrameworkIcons.instance().copy()).controls(new Control[]{this.createCopyCellControl(), this.createCopyTableRowsWithHeaderControl()}).build();
    }

    private Control createCopyCellControl() {
        return Control.builder(() -> this.table.copySelectedCell()).name(FrameworkMessages.copyCell()).enabled(this.tableModel.selectionModel().selectionNotEmpty()).build();
    }

    private Control createCopyTableRowsWithHeaderControl() {
        return Control.builder(() -> this.table.copyRowsAsTabDelimitedString()).name(FrameworkMessages.copyTableWithHeader()).build();
    }

    private boolean includeEditSelectedControls() {
        return !this.editableAttributes.empty() && (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().updateEnabled().get() != false;
    }

    private boolean includeDeleteSelectedControl() {
        return (Boolean)this.tableModel.editModel().readOnly().get() == false && (Boolean)this.tableModel.editModel().deleteEnabled().get() != false;
    }

    private FilteredTable<Entity, Attribute<?>> createTable() {
        return (FilteredTable)((FilteredTable.Builder)FilteredTable.builder((FilteredTableModel)this.tableModel).cellRendererFactory((FilteredTableCellRendererFactory)new EntityTableCellRendererFactory()).onBuild(filteredTable -> filteredTable.setRowHeight(filteredTable.getFont().getSize() + 4))).build();
    }

    private Control createConditionRefreshControl() {
        return Control.builder(() -> ((SwingEntityTableModel)this.tableModel).refresh()).enabled(this.tableModel.conditionChanged()).smallIcon((Icon)FrameworkIcons.instance().refreshRequired()).build();
    }

    private <T> ComponentValue<T, ? extends JComponent> cellEditorComponentValue(Attribute<T> attribute, T initialValue) {
        return this.cellEditorComponentFactories.computeIfAbsent(attribute, a -> new DefaultEntityComponentFactory()).componentValue(attribute, this.tableModel.editModel(), initialValue);
    }

    private JToolBar createRefreshButtonToolBar() {
        if (this.conditionRefreshControl == null) {
            this.conditionRefreshControl = this.createConditionRefreshControl();
        }
        KeyEvents.builder((int)116).condition(1).action((Action)this.conditionRefreshControl).enable((JComponent)this);
        return (JToolBar)((ToolBarBuilder)((ToolBarBuilder)((ToolBarBuilder)((ToolBarBuilder)Components.toolBar().action((Action)this.conditionRefreshControl)).focusable(false)).floatable(false).rollover(false).visible(false)).onBuild(toolBar -> toolBar.getComponentAtIndex(0).setFocusable(false))).build();
    }

    private FilteredTableConditionPanel<Attribute<?>> createConditionPanel(ColumnConditionPanel.Factory<Attribute<?>> conditionPanelFactory) {
        return conditionPanelFactory == null ? null : FilteredTableConditionPanel.filteredTableConditionPanel((TableConditionModel)this.tableModel.conditionModel(), (FilteredTableColumnModel)this.tableModel.columnModel(), conditionPanelFactory);
    }

    private JScrollPane createConditionPanelScrollPane() {
        return this.conditionPanel == null ? null : EntityTablePanel.createHiddenLinkedScrollPane(this.tableScrollPane, this.conditionPanel);
    }

    private JScrollPane createFilterPanelScrollPane() {
        return this.filterPanel == null ? null : EntityTablePanel.createHiddenLinkedScrollPane(this.tableScrollPane, this.filterPanel);
    }

    private FilteredTableColumnComponentPanel<Attribute<?>, JPanel> createSummaryPanel() {
        Map<Attribute<?>, JPanel> columnSummaryPanels = EntityTablePanel.createColumnSummaryPanels(this.tableModel);
        if (columnSummaryPanels.isEmpty()) {
            return null;
        }
        return FilteredTableColumnComponentPanel.filteredTableColumnComponentPanel((FilteredTableColumnModel)this.tableModel.columnModel(), columnSummaryPanels);
    }

    private JScrollPane createSummaryPanelScrollPane() {
        if (this.summaryPanel == null) {
            return null;
        }
        return EntityTablePanel.createHiddenLinkedScrollPane(this.tableScrollPane, this.summaryPanel);
    }

    private JPanel createTablePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.tableScrollPane, "Center");
        if (this.conditionPanelScrollPane != null) {
            panel.add((Component)this.conditionPanelScrollPane, "North");
        }
        JPanel tableSouthPanel = new JPanel(new BorderLayout());
        if (this.summaryPanelScrollPane != null) {
            tableSouthPanel.add((Component)this.summaryPanelScrollPane, "North");
        }
        if (this.filterPanelScrollPane != null) {
            tableSouthPanel.add((Component)this.filterPanelScrollPane, "Center");
        }
        panel.add((Component)tableSouthPanel, "South");
        return panel;
    }

    private void bindEvents() {
        if (((Boolean)INCLUDE_ENTITY_MENU.get()).booleanValue()) {
            KeyEvents.builder((int)86).modifiers(640).action((Action)Control.control(this::showEntityMenu)).enable(this.table);
        }
        this.control(ControlCode.DELETE_SELECTED).ifPresent(control -> KeyEvents.builder((int)127).action((Action)control).enable(this.table));
        this.conditionPanelVisibleState.addDataListener(this::setConditionPanelVisibleInternal);
        this.filterPanelVisibleState.addDataListener(this::setFilterPanelVisibleInternal);
        this.summaryPanelVisibleState.addDataListener(this::setSummaryPanelVisibleInternal);
        this.tableModel.conditionModel().addChangeListener(this::onConditionChanged);
        this.tableModel.refresher().observer().addDataListener(this::onRefreshingChanged);
        this.tableModel.refresher().addRefreshFailedListener(this::onException);
        this.tableModel.editModel().addInsertUpdateOrDeleteListener(() -> this.table.repaint());
        if (this.conditionPanel != null) {
            KeyEvents.builder((int)10).condition(1).action((Action)this.conditionRefreshControl).enable(this.conditionPanel);
            this.conditionPanel.addFocusGainedListener(arg_0 -> this.table.scrollToColumn(arg_0));
            EntityTablePanel.addRefreshOnEnterControl(this.tableModel.columnModel().columns(), this.conditionPanel, this.conditionRefreshControl);
            this.conditionPanel.advanced().addDataListener(advanced -> {
                if (((Boolean)this.conditionPanelVisibleState.get()).booleanValue()) {
                    this.revalidate();
                }
            });
        }
        if (this.filterPanel != null) {
            this.filterPanel.addFocusGainedListener(arg_0 -> this.table.scrollToColumn(arg_0));
            this.filterPanel.advanced().addDataListener(advanced -> {
                if (((Boolean)this.filterPanelVisibleState.get()).booleanValue()) {
                    this.revalidate();
                }
            });
        }
    }

    private void setConditionPanelVisibleInternal(boolean visible) {
        if (this.conditionPanelScrollPane != null) {
            this.conditionPanelScrollPane.setVisible(visible);
            this.refreshButtonToolBar.setVisible(this.refreshButtonVisible == RefreshButtonVisible.ALWAYS || visible);
            this.revalidate();
        }
    }

    private void setFilterPanelVisibleInternal(boolean visible) {
        if (this.filterPanelScrollPane != null) {
            this.filterPanelScrollPane.setVisible(visible);
            this.revalidate();
        }
    }

    private void setSummaryPanelVisibleInternal(boolean visible) {
        if (this.summaryPanelScrollPane != null) {
            this.summaryPanelScrollPane.setVisible(visible);
            this.revalidate();
        }
    }

    private void setupComponents() {
        if (this.conditionRefreshControl == null) {
            this.conditionRefreshControl = this.createConditionRefreshControl();
        }
        if (this.conditionPanel == null) {
            this.conditionPanel = this.configureHorizontalAlignment(this.createConditionPanel(this.conditionPanelFactory));
        }
        this.tableScrollPane = new JScrollPane((Component)this.table);
        this.conditionPanelScrollPane = this.createConditionPanelScrollPane();
        if (this.includeFilterPanel) {
            this.filterPanel = this.configureHorizontalAlignment(this.table.filterPanel());
            this.filterPanelScrollPane = this.createFilterPanelScrollPane();
        }
        this.summaryPanel = this.createSummaryPanel();
        this.summaryPanelScrollPane = this.createSummaryPanelScrollPane();
        this.tablePanel = this.createTablePanel();
        if (this.refreshButtonToolBar == null) {
            this.refreshButtonToolBar = this.createRefreshButtonToolBar();
        }
        this.conditionPanelVisibleState.addValidator((Value.Validator)new PanelAvailableValidator((JPanel)this.conditionPanel, "condition"));
        this.filterPanelVisibleState.addValidator((Value.Validator)new PanelAvailableValidator((JPanel)this.filterPanel, "filter"));
        this.summaryPanelVisibleState.addValidator((Value.Validator)new PanelAvailableValidator((JPanel)this.summaryPanel, "summary"));
    }

    private void setupControls() {
        if (this.includeDeleteSelectedControl()) {
            this.controls.putIfAbsent(ControlCode.DELETE_SELECTED, this.createDeleteSelectedControl());
        }
        if (this.includeEditSelectedControls()) {
            this.controls.putIfAbsent(ControlCode.EDIT_SELECTED, (Control)this.createEditSelectedControls());
        }
        if (this.includeClearControl) {
            this.controls.putIfAbsent(ControlCode.CLEAR, this.createClearControl());
        }
        this.controls.putIfAbsent(ControlCode.REFRESH, this.createRefreshControl());
        this.controls.putIfAbsent(ControlCode.SELECT_COLUMNS, (Control)(this.columnSelection == ColumnSelection.DIALOG ? this.table.createSelectColumnsControl() : this.table.createToggleColumnsControls()));
        this.controls.putIfAbsent(ControlCode.RESET_COLUMNS, this.table.createResetColumnsControl());
        this.controls.putIfAbsent(ControlCode.COLUMN_AUTO_RESIZE_MODE, this.table.createAutoResizeModeControl());
        if (this.includeViewDependenciesControl()) {
            this.controls.putIfAbsent(ControlCode.VIEW_DEPENDENCIES, this.createViewDependenciesControl());
        }
        if (this.summaryPanelScrollPane != null) {
            this.controls.putIfAbsent(ControlCode.TOGGLE_SUMMARY_PANEL, this.createToggleSummaryPanelControl());
        }
        if (this.includeConditionPanel && this.conditionPanel != null) {
            this.controls.putIfAbsent(ControlCode.CONDITION_PANEL_VISIBLE, this.createConditionPanelControl());
            this.controls.putIfAbsent(ControlCode.TOGGLE_CONDITION_PANEL, this.createToggleConditionPanelControl());
            this.controls.put(ControlCode.SELECT_CONDITION_PANEL, Control.control(this::selectConditionPanel));
        }
        if (this.includeFilterPanel && this.filterPanel != null) {
            this.controls.putIfAbsent(ControlCode.FILTER_PANEL_VISIBLE, this.createFilterPanelControl());
            this.controls.putIfAbsent(ControlCode.TOGGLE_FILTER_PANEL, this.createToggleFilterPanelControl());
            this.controls.put(ControlCode.SELECT_FILTER_PANEL, Control.control(this::selectFilterPanel));
        }
        this.controls.putIfAbsent(ControlCode.CLEAR_SELECTION, this.createClearSelectionControl());
        this.controls.putIfAbsent(ControlCode.MOVE_SELECTION_UP, this.createMoveSelectionDownControl());
        this.controls.putIfAbsent(ControlCode.MOVE_SELECTION_DOWN, this.createMoveSelectionUpControl());
        this.controls.putIfAbsent(ControlCode.COPY_TABLE_DATA, (Control)this.createCopyControls());
        if (this.includeSelectionModeControl) {
            this.controls.putIfAbsent(ControlCode.SELECTION_MODE, (Control)this.table.createSingleSelectionModeControl());
        }
        this.controls.put(ControlCode.REQUEST_TABLE_FOCUS, Control.control(() -> this.table().requestFocus()));
        this.controls.put(ControlCode.CONFIGURE_COLUMNS, (Control)this.createColumnControls());
    }

    private boolean includeViewDependenciesControl() {
        return this.tableModel.entities().definitions().stream().flatMap(entityDefinition -> entityDefinition.foreignKeys().definitions().stream()).filter(foreignKeyDefinition -> !foreignKeyDefinition.soft()).anyMatch(foreignKeyDefinition -> foreignKeyDefinition.attribute().referencedType().equals(this.tableModel.entityType()));
    }

    private void setupTable() {
        this.tableModel.columnModel().columns().forEach(this::configureColumn);
        if (this.includePopupMenu) {
            this.addTablePopupMenu();
        }
    }

    private void configureColumn(FilteredTableColumn<Attribute<?>> column) {
        TableCellEditor tableCellEditor = this.createTableCellEditor((Attribute)column.getIdentifier());
        if (tableCellEditor != null) {
            column.setCellEditor(tableCellEditor);
        }
        column.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(column.getHeaderRenderer()));
    }

    private void addTablePopupMenu() {
        Controls popupControls = this.createPopupMenuControls(this.additionalPopupControls);
        if (popupControls == null || popupControls.empty()) {
            return;
        }
        JPopupMenu popupMenu = Components.menu((Controls)popupControls).createPopupMenu();
        this.table.setComponentPopupMenu(popupMenu);
        this.tableScrollPane.setComponentPopupMenu(popupMenu);
        KeyEvents.builder((int)71).modifiers(128).action((Action)Control.control(() -> {
            Point location = EntityTablePanel.popupLocation(this.table);
            popupMenu.show((Component)this.table, location.x, location.y);
        })).enable(this.table);
    }

    private void throwIfInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Method must be called before the panel is initialized");
        }
    }

    private void addConditionControls(Controls popupControls) {
        Controls conditionControls = Controls.builder().name(FrameworkMessages.search()).smallIcon((Icon)FrameworkIcons.instance().search()).build();
        this.control(ControlCode.CONDITION_PANEL_VISIBLE).ifPresent(arg_0 -> ((Controls)conditionControls).add(arg_0));
        Controls conditionPanelControls = this.conditionPanel.controls();
        if (conditionPanelControls.notEmpty()) {
            conditionControls.addAll(conditionPanelControls);
            conditionControls.addSeparator();
        }
        conditionControls.add((Action)ToggleControl.builder((State)this.tableModel.conditionRequired()).name(MESSAGES.getString("require_query_condition")).description(MESSAGES.getString("require_query_condition_description")).build());
        if (conditionControls.notEmpty()) {
            popupControls.add(conditionControls);
        }
    }

    private void addFilterControls(Controls popupControls) {
        Controls filterControls = Controls.builder().name(FrameworkMessages.filter()).smallIcon((Icon)FrameworkIcons.instance().filter()).build();
        this.control(ControlCode.FILTER_PANEL_VISIBLE).ifPresent(arg_0 -> ((Controls)filterControls).add(arg_0));
        Controls filterPanelControls = this.filterPanel.controls();
        if (filterPanelControls.notEmpty()) {
            filterControls.addAll(filterPanelControls);
        }
        if (filterControls.notEmpty()) {
            popupControls.add(filterControls);
        }
    }

    private void showEntityMenu() {
        Point location = EntityTablePanel.popupLocation(this.table);
        this.tableModel.selectionModel().selectedItem().ifPresent(selected -> new EntityPopupMenu(selected.copy(), this.tableModel.connectionProvider().connection()).show((Component)this.table, location.x, location.y));
    }

    private void onConditionChanged() {
        this.table.getTableHeader().repaint();
        this.table.repaint();
    }

    private void onRefreshingChanged(boolean refreshing) {
        if (refreshing) {
            WaitCursor.show((JComponent)this);
        } else {
            WaitCursor.hide((JComponent)this);
        }
    }

    private void toggleConditionPanel(JScrollPane scrollPane, State advancedState, State visibleState) {
        if (scrollPane != null && scrollPane.isVisible()) {
            if (((Boolean)advancedState.get()).booleanValue()) {
                boolean parentOfFocusOwner = Utilities.parentOfType(JScrollPane.class, (Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == scrollPane;
                visibleState.set((Object)false);
                if (parentOfFocusOwner) {
                    this.table.requestFocusInWindow();
                }
            } else {
                advancedState.set((Object)true);
            }
        } else {
            advancedState.set((Object)false);
            visibleState.set((Object)true);
        }
    }

    private boolean nonUpdatableForeignKey(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return foreignKey.references().stream().map(ForeignKey.Reference::column).map(referenceAttribute -> this.tableModel.entityDefinition().columns().definition(referenceAttribute)).filter(ColumnDefinition.class::isInstance).map(ColumnDefinition.class::cast).noneMatch(ColumnDefinition::updatable);
        }
        return false;
    }

    private FilteredTableConditionPanel<Attribute<?>> configureHorizontalAlignment(FilteredTableConditionPanel<Attribute<?>> tableConditionPanel) {
        if (tableConditionPanel != null) {
            tableConditionPanel.conditionPanels().forEach(this::configureHorizontalAlignment);
        }
        return tableConditionPanel;
    }

    private void configureHorizontalAlignment(ColumnConditionPanel<Attribute<?>, ?> columnConditionPanel) {
        EntityTablePanel.configureHorizontalAlignment(columnConditionPanel, this.tableModel.columnModel().column((Object)((Attribute)columnConditionPanel.model().columnIdentifier())).getCellRenderer());
    }

    private static void configureHorizontalAlignment(ColumnConditionPanel<Attribute<?>, ?> columnConditionPanel, TableCellRenderer cellRenderer) {
        if (cellRenderer instanceof DefaultTableCellRenderer) {
            int horizontalAlignment = ((DefaultTableCellRenderer)cellRenderer).getHorizontalAlignment();
            JComponent component = columnConditionPanel.equalField();
            if (component instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(horizontalAlignment);
            }
            if ((component = columnConditionPanel.lowerBoundField()) instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(horizontalAlignment);
            }
            if ((component = columnConditionPanel.upperBoundField()) instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(horizontalAlignment);
            }
        }
    }

    private static final void selectConditionPanel(FilteredTableConditionPanel<Attribute<?>> tableConditionPanel, JScrollPane conditionPanelScrollPane, State conditionPanelVisibleState, SwingEntityTableModel tableModel, JComponent dialogOwner, String dialogTitle) {
        if (tableConditionPanel != null) {
            List attributeDefinitions;
            if (conditionPanelScrollPane == null || !conditionPanelScrollPane.isVisible()) {
                conditionPanelVisibleState.set((Object)true);
            }
            if ((attributeDefinitions = tableConditionPanel.conditionPanels().stream().filter(panel -> (Boolean)tableModel.columnModel().visible((Object)((Attribute)panel.model().columnIdentifier())).get()).map(panel -> tableModel.entityDefinition().attributes().definition((Attribute)panel.model().columnIdentifier())).sorted(AttributeDefinition.definitionComparator()).collect(Collectors.toList())).size() == 1) {
                tableConditionPanel.conditionPanel((Object)((AttributeDefinition)attributeDefinitions.get(0)).attribute()).ifPresent(ColumnConditionPanel::requestInputFocus);
            } else if (!attributeDefinitions.isEmpty()) {
                ((SelectionDialogBuilder)((SelectionDialogBuilder)Dialogs.selectionDialog(attributeDefinitions).owner((Component)dialogOwner)).title(dialogTitle)).selectSingle().flatMap(attributeDefinition -> tableConditionPanel.conditionPanel((Object)attributeDefinition.attribute())).ifPresent(ColumnConditionPanel::requestInputFocus);
            }
        }
    }

    private static GridBagConstraints createHorizontalFillConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        return constraints;
    }

    private static void addRefreshOnEnterControl(Collection<FilteredTableColumn<Attribute<?>>> columns, FilteredTableConditionPanel<Attribute<?>> tableConditionPanel, Control refreshControl) {
        columns.stream().map(column -> tableConditionPanel.conditionPanel((Object)((Attribute)column.getIdentifier()))).filter(Optional::isPresent).map(Optional::get).forEach(columnConditionPanel -> {
            EntityTablePanel.enableRefreshOnEnterControl(columnConditionPanel.operatorComboBox(), refreshControl);
            EntityTablePanel.enableRefreshOnEnterControl(columnConditionPanel.equalField(), refreshControl);
            EntityTablePanel.enableRefreshOnEnterControl(columnConditionPanel.lowerBoundField(), refreshControl);
            EntityTablePanel.enableRefreshOnEnterControl(columnConditionPanel.upperBoundField(), refreshControl);
        });
    }

    private static void enableRefreshOnEnterControl(JComponent component, Control refreshControl) {
        if (component instanceof JComboBox) {
            new ComboBoxEnterPressedAction((JComboBox)component, (Action)refreshControl);
        } else if (component instanceof TemporalField) {
            ((TemporalField)component).addActionListener((ActionListener)refreshControl);
        }
    }

    private static void addAdditionalControls(Controls popupControls, List<Controls> additionalPopupControls) {
        additionalPopupControls.forEach(controls -> {
            if (NullOrEmpty.nullOrEmpty((String)controls.getName())) {
                popupControls.addAll(controls);
            } else {
                popupControls.add(controls);
            }
            popupControls.addSeparator();
        });
    }

    private static Map<Attribute<?>, JPanel> createColumnSummaryPanels(FilteredTableModel<?, Attribute<?>> tableModel) {
        HashMap components = new HashMap();
        tableModel.columnModel().columns().forEach(column -> tableModel.summaryModel().summaryModel((Object)((Attribute)column.getIdentifier())).ifPresent(columnSummaryModel -> components.put((Attribute<?>)((Attribute)column.getIdentifier()), (JPanel)ColumnSummaryPanel.columnSummaryPanel((ColumnSummaryModel)columnSummaryModel))));
        return components;
    }

    private static JScrollPane createHiddenLinkedScrollPane(JScrollPane parentScrollPane, JPanel panelToScroll) {
        return (JScrollPane)((ScrollPaneBuilder)((ScrollPaneBuilder)Components.scrollPane((JComponent)panelToScroll).horizontalScrollBarPolicy(31).verticalScrollBarPolicy(21).visible(false)).onBuild(scrollPane -> Utilities.linkBoundedRangeModels((BoundedRangeModel)parentScrollPane.getHorizontalScrollBar().getModel(), (BoundedRangeModel)scrollPane.getHorizontalScrollBar().getModel()))).build();
    }

    private static Point popupLocation(JTable table) {
        Rectangle visibleRect = table.getVisibleRect();
        int x = visibleRect.x + visibleRect.width / 2;
        int y = table.getSelectionModel().isSelectionEmpty() ? visibleRect.y + visibleRect.height / 2 : table.getCellRect((int)table.getSelectedRow(), (int)table.getSelectedColumn(), (boolean)true).y;
        return new Point(x, y + table.getRowHeight() / 2);
    }

    private /* synthetic */ void lambda$createEditSelectedControls$19(Controls editControls, StateObserver enabledState, AttributeDefinition attributeDefinition) {
        editControls.add((Action)Control.builder(() -> this.editSelectedEntities(attributeDefinition.attribute())).name(attributeDefinition.caption() == null ? attributeDefinition.attribute().name() : attributeDefinition.caption()).enabled(enabledState).build());
    }

    public static enum ControlCode {
        PRINT,
        DELETE_SELECTED,
        VIEW_DEPENDENCIES,
        EDIT_SELECTED,
        SELECT_COLUMNS,
        RESET_COLUMNS,
        COLUMN_AUTO_RESIZE_MODE,
        SELECTION_MODE,
        CLEAR,
        REFRESH,
        TOGGLE_SUMMARY_PANEL,
        TOGGLE_CONDITION_PANEL,
        CONDITION_PANEL_VISIBLE,
        TOGGLE_FILTER_PANEL,
        FILTER_PANEL_VISIBLE,
        CLEAR_SELECTION,
        MOVE_SELECTION_UP,
        MOVE_SELECTION_DOWN,
        COPY_TABLE_DATA,
        REQUEST_TABLE_FOCUS,
        SELECT_CONDITION_PANEL,
        SELECT_FILTER_PANEL,
        CONFIGURE_COLUMNS;

    }

    private final class DeleteConfirmer
    implements EntityEditPanel.Confirmer {
        private DeleteConfirmer() {
        }

        @Override
        public boolean confirm(JComponent dialogOwner) {
            return this.confirm(dialogOwner, FrameworkMessages.confirmDeleteSelected((int)EntityTablePanel.this.tableModel.selectionModel().selectionCount()), FrameworkMessages.delete());
        }
    }

    public static enum RefreshButtonVisible {
        ALWAYS,
        WHEN_CONDITION_PANEL_IS_VISIBLE;

    }

    public static enum ColumnSelection {
        DIALOG,
        MENU;

    }

    private final class EditMenuAttributeValidator
    implements Value.Validator<Set<Attribute<?>>> {
        private EditMenuAttributeValidator() {
        }

        public void validate(Set<Attribute<?>> attributes) {
            EntityTablePanel.this.throwIfInitialized();
            attributes.forEach(attribute -> EntityTablePanel.this.tableModel.entityDefinition().attributes().definition(attribute));
        }
    }

    private final class StatusPanel
    extends JPanel {
        private static final String STATUS = "status";
        private static final String REFRESHING = "refreshing";
        private final Value<String> statusMessage;
        private final Value<Function<SwingEntityTableModel, String>> statusMessageFunction;
        private final State showRefreshProgressBar;

        private StatusPanel() {
            super(new CardLayout());
            this.statusMessage = Value.value((Object)"", (Object)"");
            this.statusMessageFunction = Value.value(DEFAULT_STATUS_MESSAGE, DEFAULT_STATUS_MESSAGE);
            this.showRefreshProgressBar = State.state((boolean)((Boolean)SHOW_REFRESH_PROGRESS_BAR.get()));
            this.add((Component)Components.label(this.statusMessage).horizontalAlignment(0).build(), STATUS);
            this.add((Component)this.createRefreshingProgressPanel(), REFRESHING);
            CardLayout layout = (CardLayout)this.getLayout();
            EntityTablePanel.this.tableModel.refresher().observer().addDataListener(isRefreshing -> {
                if (((Boolean)this.showRefreshProgressBar.get()).booleanValue()) {
                    layout.show(this, isRefreshing != false ? REFRESHING : STATUS);
                }
            });
            Runnable statusListener = this::updateStatusMessage;
            this.statusMessageFunction.addListener(statusListener);
            EntityTablePanel.this.tableModel.selectionModel().addSelectionListener(statusListener);
            EntityTablePanel.this.tableModel.addDataChangedListener(statusListener);
            this.updateStatusMessage();
        }

        private JPanel createRefreshingProgressPanel() {
            return (JPanel)Components.panel((LayoutManager)new GridBagLayout()).add((JComponent)Components.progressBar().indeterminate(true).string(MESSAGES.getString(REFRESHING)).stringPainted(true).build(), (Object)EntityTablePanel.createHorizontalFillConstraints()).build();
        }

        private void updateStatusMessage() {
            this.statusMessage.set((Object)((String)((Function)this.statusMessageFunction.get()).apply(EntityTablePanel.this.tableModel)));
        }
    }

    private final class EntityTableCellRendererFactory
    implements FilteredTableCellRendererFactory<Attribute<?>> {
        private EntityTableCellRendererFactory() {
        }

        public TableCellRenderer tableCellRenderer(FilteredTableColumn<Attribute<?>> column) {
            return EntityTablePanel.this.createTableCellRenderer((Attribute)column.getIdentifier());
        }
    }

    private static final class PanelAvailableValidator
    implements Value.Validator<Boolean> {
        private final JPanel panel;
        private final String panelType;

        private PanelAvailableValidator(JPanel panel, String panelType) {
            this.panel = panel;
            this.panelType = panelType;
        }

        public void validate(Boolean visible) throws IllegalArgumentException {
            if (visible.booleanValue() && this.panel == null) {
                throw new IllegalArgumentException("No " + this.panelType + " panel available");
            }
        }
    }

    private final class HeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer wrappedRenderer;

        private HeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.wrappedRenderer == null ? table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            FilteredTableColumn tableColumn = EntityTablePanel.this.tableModel.columnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            boolean useBoldFont = renderer instanceof FilteredTableCellRenderer && ((FilteredTableCellRenderer)renderer).columnShadingEnabled() && EntityTablePanel.this.tableModel.conditionModel().enabled((Object)((Attribute)tableColumn.getIdentifier()));
            Font defaultFont = component.getFont();
            component.setFont(useBoldFont ? defaultFont.deriveFont(defaultFont.getStyle() | 1) : defaultFont);
            return component;
        }
    }

    private static final class DefaultStatusMessage
    implements Function<SwingEntityTableModel, String> {
        private static final NumberFormat STATUS_MESSAGE_NUMBER_FORMAT = NumberFormat.getIntegerInstance();

        private DefaultStatusMessage() {
        }

        @Override
        public String apply(SwingEntityTableModel tableModel) {
            int rowCount = tableModel.getRowCount();
            if (rowCount == 0) {
                return "";
            }
            int filteredCount = tableModel.filteredCount();
            int selectionCount = tableModel.selectionModel().selectionCount();
            StringBuilder builder = new StringBuilder(STATUS_MESSAGE_NUMBER_FORMAT.format(rowCount));
            if (selectionCount > 0 || filteredCount > 0) {
                builder.append(" (");
                if (selectionCount > 0) {
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(selectionCount)).append(" ").append(MESSAGES.getString("selected"));
                }
                if (filteredCount > 0) {
                    if (selectionCount > 0) {
                        builder.append(" - ");
                    }
                    builder.append(STATUS_MESSAGE_NUMBER_FORMAT.format(filteredCount)).append(" ").append(MESSAGES.getString("hidden"));
                }
                builder.append(")");
            }
            return builder.toString();
        }
    }
}

