/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.ui;

import is.codion.common.Configuration;
import is.codion.common.Memory;
import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.logging.LoggerProxy;
import is.codion.common.model.CancelException;
import is.codion.common.model.UserPreferences;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.value.ValueObserver;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.i18n.FrameworkMessages;
import is.codion.framework.model.EntityApplicationModel;
import is.codion.swing.common.ui.UiManagerDefaults;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.WaitCursor;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.model.SwingEntityApplicationModel;
import is.codion.swing.framework.ui.DefaultEntityApplicationPanelBuilder;
import is.codion.swing.framework.ui.EntityEditPanel;
import is.codion.swing.framework.ui.EntityPanel;
import is.codion.swing.framework.ui.KeyboardShortcutsPanel;
import is.codion.swing.framework.ui.TabbedApplicationLayout;
import is.codion.swing.framework.ui.icon.FrameworkIcons;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityApplicationPanel<M extends SwingEntityApplicationModel>
extends JPanel {
    private static final String LOG_LEVEL = "log_level";
    private static final String LOG_LEVEL_DESC = "log_level_desc";
    private static final String HELP = "help";
    private static final String KEYBOARD_SHORTCUTS = "keyboard_shortcuts";
    private static final String ABOUT = "about";
    private static final String ALWAYS_ON_TOP = "always_on_top";
    private static final String APPLICATION_VERSION = "application_version";
    private static final String CODION_VERSION = "codion_version";
    private static final String MEMORY_USAGE = "memory_usage";
    private static final Logger LOG = LoggerFactory.getLogger(EntityApplicationPanel.class);
    static final String DEFAULT_USERNAME_PROPERTY = "is.codion.swing.framework.ui.defaultUsername";
    static final String LOOK_AND_FEEL_PROPERTY = "is.codion.swing.framework.ui.LookAndFeel";
    static final String FONT_SIZE_PROPERTY = "is.codion.swing.framework.ui.FontSize";
    public static final PropertyValue<String> HELP_URL = Configuration.stringValue((String)"is.codion.swing.framework.ui.EntityApplicationPanel.helpUrl", (String)("https://codion.is/doc/" + Version.versionString() + "/help/client.html"));
    public static final PropertyValue<Boolean> CONFIRM_EXIT = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityApplicationPanel.confirmExit", (boolean)false);
    public static final PropertyValue<Boolean> SHOW_STARTUP_DIALOG = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityApplicationPanel.showStartupDialog", (boolean)true);
    public static final PropertyValue<Boolean> CACHE_ENTITY_PANELS = Configuration.booleanValue((String)"is.codion.swing.framework.ui.EntityApplicationPanel.cacheEntityPanels", (boolean)false);
    private static final int DEFAULT_LOGO_SIZE = 68;
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle(EntityApplicationPanel.class.getName());
    private final String applicationDefaultUsernameProperty;
    private final String applicationLookAndFeelProperty;
    private final String applicationFontSizeProperty;
    private final M applicationModel;
    private final Collection<EntityPanel.Builder> supportPanelBuilders = new ArrayList<EntityPanel.Builder>();
    private final List<EntityPanel> entityPanels = new ArrayList<EntityPanel>();
    private final ApplicationLayout applicationLayout;
    private final State alwaysOnTopState = State.state();
    private final Event<?> onExitEvent = Event.event();
    private final Event<EntityApplicationPanel<?>> onInitialized = Event.event();
    private final Map<EntityPanel.Builder, EntityPanel> cachedEntityPanels = new HashMap<EntityPanel.Builder, EntityPanel>();
    private final Map<Object, State> logLevelStates = EntityApplicationPanel.createLogLevelStateMap();
    private boolean initialized = false;

    public EntityApplicationPanel(M applicationModel) {
        this(applicationModel, new TabbedApplicationLayout());
    }

    public EntityApplicationPanel(M applicationModel, ApplicationLayout applicationLayout) {
        this.applicationModel = (SwingEntityApplicationModel)Objects.requireNonNull(applicationModel);
        this.applicationLayout = Objects.requireNonNull(applicationLayout);
        this.applicationDefaultUsernameProperty = "is.codion.swing.framework.ui.defaultUsername#" + this.getClass().getSimpleName();
        this.applicationLookAndFeelProperty = "is.codion.swing.framework.ui.LookAndFeel#" + this.getClass().getSimpleName();
        this.applicationFontSizeProperty = "is.codion.swing.framework.ui.FontSize#" + this.getClass().getSimpleName();
        UiManagerDefaults.initialize();
    }

    public final void displayException(Throwable exception) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this;
        }
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)focusOwner));
    }

    public final M applicationModel() {
        return this.applicationModel;
    }

    public final <T extends ApplicationLayout> T applicationLayout() {
        return (T)this.applicationLayout;
    }

    public final <T extends EntityPanel> T entityPanel(EntityType entityType) {
        Objects.requireNonNull(entityType);
        return (T)this.entityPanels.stream().filter(entityPanel -> entityPanel.model().entityType().equals(entityType)).findFirst().orElseThrow(() -> new IllegalArgumentException("EntityPanel for entity: " + entityType + " not found in application panel: " + this.getClass()));
    }

    public final List<EntityPanel> entityPanels() {
        return Collections.unmodifiableList(this.entityPanels);
    }

    public final Optional<Window> parentWindow() {
        return Optional.ofNullable(Utilities.parentWindow((Component)this));
    }

    public final State alwaysOnTop() {
        return this.alwaysOnTopState;
    }

    public final void viewApplicationTree() {
        ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.createApplicationTree()).owner((Component)this)).title(this.resourceBundle.getString("view_application_tree"))).modal(false).show();
    }

    public final void viewDependencyTree() {
        ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.createDependencyTree()).owner((Component)this)).title(FrameworkMessages.dependencies())).modal(false).show();
    }

    public final void addInitializationListener(Consumer<EntityApplicationPanel<?>> listener) {
        this.onInitialized.addDataListener(listener);
    }

    public final void exit() {
        if (this.cancelExit()) {
            throw new CancelException();
        }
        try {
            this.onExitEvent.run();
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Exception while exiting", (Throwable)e);
        }
        try {
            this.savePreferences();
            UserPreferences.flushUserPreferences();
        }
        catch (Exception e) {
            LOG.debug("Exception while saving preferences", (Throwable)e);
        }
        try {
            this.applicationModel.connectionProvider().close();
        }
        catch (Exception e) {
            LOG.debug("Exception while disconnecting from database", (Throwable)e);
        }
        this.parentWindow().ifPresent(Window::dispose);
        System.exit(0);
    }

    public void displayHelp() throws Exception {
        Desktop.getDesktop().browse(new URL((String)HELP_URL.get()).toURI());
    }

    public final void displayKeyboardShortcuts() {
        KeyboardShortcutsPanel shortcutsPanel = new KeyboardShortcutsPanel();
        shortcutsPanel.setPreferredSize(new Dimension(shortcutsPanel.getPreferredSize().width, Windows.screenSizeRatio((double)0.5).height));
        ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)shortcutsPanel).owner((Component)this)).title(this.resourceBundle.getString(KEYBOARD_SHORTCUTS))).modal(false).show();
    }

    public final void displayAbout() {
        ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)this.createAboutPanel()).owner((Component)this)).title(this.resourceBundle.getString(ABOUT))).resizable(false).show();
    }

    public final void initialize() {
        if (!this.initialized) {
            try {
                this.createEntityPanels().forEach(this::addEntityPanel);
                this.supportPanelBuilders.addAll(this.createSupportEntityPanelBuilders());
                this.applicationLayout.layout(this);
                this.bindEventsInternal();
                this.bindEvents();
                this.onInitialized.accept((Object)this);
            }
            finally {
                this.initialized = true;
            }
        }
    }

    public static TreeModel createDependencyTreeModel(Entities entities) {
        Objects.requireNonNull(entities);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        for (EntityDefinition definition : entities.definitions()) {
            if (!definition.foreignKeys().get().isEmpty() && !EntityApplicationPanel.referencesOnlySelf(entities, definition.entityType())) continue;
            root.add(new EntityDependencyTreeNode(definition.entityType(), entities));
        }
        return new DefaultTreeModel(root);
    }

    public static <M extends SwingEntityApplicationModel, P extends EntityApplicationPanel<M>> Builder<M, P> builder(Class<M> applicationModelClass, Class<P> applicationPanelClass) {
        return new DefaultEntityApplicationPanelBuilder<M, P>(applicationModelClass, applicationPanelClass);
    }

    protected Controls createMainMenuControls() {
        Controls helpMenuControls;
        Controls supportTableMenuControls;
        Controls toolsMenuControls;
        Controls viewMenuControls;
        Controls menuControls = Controls.controls();
        Controls fileMenuControls = this.createFileMenuControls();
        if (fileMenuControls != null && fileMenuControls.notEmpty()) {
            menuControls.add(fileMenuControls);
        }
        if ((viewMenuControls = this.createViewMenuControls()) != null && viewMenuControls.notEmpty()) {
            menuControls.add(viewMenuControls);
        }
        if ((toolsMenuControls = this.createToolsMenuControls()) != null && toolsMenuControls.notEmpty()) {
            menuControls.add(toolsMenuControls);
        }
        if ((supportTableMenuControls = this.createSupportTableMenuControls()) != null && supportTableMenuControls.notEmpty()) {
            menuControls.add(supportTableMenuControls);
        }
        if ((helpMenuControls = this.createHelpMenuControls()) != null && helpMenuControls.notEmpty()) {
            menuControls.add(helpMenuControls);
        }
        return menuControls;
    }

    protected Controls createFileMenuControls() {
        return Controls.builder().name(FrameworkMessages.file()).mnemonic(FrameworkMessages.fileMnemonic()).control(this.createExitControl()).build();
    }

    protected Controls createToolsMenuControls() {
        return Controls.builder().name(this.resourceBundle.getString("tools")).mnemonic(this.resourceBundle.getString("tools_mnemonic").charAt(0)).build();
    }

    protected Controls createViewMenuControls() {
        return Controls.builder().name(FrameworkMessages.view()).mnemonic(FrameworkMessages.viewMnemonic()).control(this.createSelectLookAndFeelControl()).control(this.createSelectFontSizeControl()).separator().control((Control)this.createAlwaysOnTopControl()).build();
    }

    protected Controls createHelpMenuControls() {
        Controls controls = Controls.builder().name(this.resourceBundle.getString(HELP)).mnemonic(this.resourceBundle.getString("help_mnemonic").charAt(0)).control(this.createHelpControl()).control(this.createViewKeyboardShortcutsControl()).separator().control(this.createAboutControl()).build();
        Controls logControls = this.createLogControls();
        if (logControls != null && !logControls.empty()) {
            controls.addSeparatorAt(2);
            controls.addAt(3, logControls);
        }
        return controls;
    }

    protected Controls createSupportTableMenuControls() {
        return Controls.builder().name(FrameworkMessages.supportTables()).mnemonic(FrameworkMessages.supportTablesMnemonic()).controls((Control[])this.supportPanelBuilders.stream().sorted(new SupportPanelBuilderComparator(this.applicationModel.entities())).map(this::createSupportPanelControl).toArray(Control[]::new)).build();
    }

    protected final Control createExitControl() {
        return Control.builder(this::exit).name(FrameworkMessages.exit()).description(FrameworkMessages.exitTip()).mnemonic(FrameworkMessages.exitMnemonic()).build();
    }

    protected final Control createLogLevelControl() {
        Controls logLevelControls = Controls.builder().name(this.resourceBundle.getString(LOG_LEVEL)).description(this.resourceBundle.getString(LOG_LEVEL_DESC)).build();
        this.logLevelStates.forEach((logLevel, state) -> logLevelControls.add((Action)ToggleControl.builder((State)state).name(logLevel.toString()).build()));
        return logLevelControls;
    }

    protected final Control createRefreshAllControl() {
        return Control.builder(() -> this.applicationModel.refresh()).name(FrameworkMessages.refreshAll()).build();
    }

    protected final Control createViewApplicationTreeControl() {
        return Control.builder(this::viewApplicationTree).name(this.resourceBundle.getString("view_application_tree")).build();
    }

    protected final Control createViewDependencyTree() {
        return Control.builder(this::viewDependencyTree).name(FrameworkMessages.dependencies()).build();
    }

    protected final Control createSelectLookAndFeelControl() {
        return Dialogs.lookAndFeelSelectionDialog().owner((JComponent)this).userPreferencePropertyName(this.applicationLookAndFeelProperty).createControl();
    }

    protected final Control createSelectFontSizeControl() {
        return Dialogs.fontSizeSelectionDialog((String)this.applicationFontSizeProperty).owner((JComponent)this).createControl();
    }

    protected final ToggleControl createAlwaysOnTopControl() {
        return ToggleControl.builder((State)this.alwaysOnTopState).name(this.resourceBundle.getString(ALWAYS_ON_TOP)).build();
    }

    protected final Control createAboutControl() {
        return Control.builder(this::displayAbout).name(this.resourceBundle.getString(ABOUT) + "...").build();
    }

    protected final Control createHelpControl() {
        return Control.builder(this::displayHelp).name(this.resourceBundle.getString(HELP) + "...").build();
    }

    protected final Control createViewKeyboardShortcutsControl() {
        return Control.builder(this::displayKeyboardShortcuts).name(this.resourceBundle.getString(KEYBOARD_SHORTCUTS) + "...").build();
    }

    protected JPanel createAboutPanel() {
        PanelBuilder versionMemoryPanel = (PanelBuilder)Components.gridLayoutPanel((int)0, (int)2).border(Borders.emptyBorder());
        this.applicationModel().version().ifPresent(version -> versionMemoryPanel.add((JComponent)new JLabel(this.resourceBundle.getString(APPLICATION_VERSION) + ":")).add((JComponent)new JLabel(version.toString())));
        versionMemoryPanel.add((JComponent)new JLabel(this.resourceBundle.getString(CODION_VERSION) + ":")).add((JComponent)new JLabel(Version.versionAndMetadataString())).add((JComponent)new JLabel(this.resourceBundle.getString(MEMORY_USAGE) + ":")).add((JComponent)new JLabel(Memory.memoryUsage()));
        return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().border(Borders.emptyBorder())).westComponent((JComponent)new JLabel(FrameworkIcons.instance().logo(68))).centerComponent(versionMemoryPanel.build()).build();
    }

    protected void bindEvents() {
    }

    protected final void displayEntityPanel(EntityPanel.Builder panelBuilder) {
        this.displayEntityPanel(this.entityPanel(panelBuilder));
    }

    protected final void displayEntityPanel(EntityPanel entityPanel) {
        if (((Boolean)EntityPanel.USE_FRAME_PANEL_DISPLAY.get()).booleanValue()) {
            this.displayEntityPanelFrame(entityPanel);
        } else {
            this.displayEntityPanelDialog(entityPanel);
        }
    }

    protected final void displayEntityPanelFrame(EntityPanel entityPanel) {
        Objects.requireNonNull(entityPanel, "entityPanel");
        WaitCursor.show((JComponent)this);
        try {
            if (entityPanel.isShowing()) {
                Window parentWindow = Utilities.parentWindow((Component)entityPanel);
                if (parentWindow != null) {
                    parentWindow.toFront();
                }
            } else {
                Windows.frame((JComponent)EntityApplicationPanel.createEmptyBorderBasePanel(entityPanel)).locationRelativeTo((Component)this).title((String)entityPanel.caption().get()).defaultCloseOperation(2).onClosed(windowEvent -> {
                    entityPanel.model().savePreferences();
                    entityPanel.savePreferences();
                }).show();
            }
        }
        finally {
            WaitCursor.hide((JComponent)this);
        }
    }

    protected final void displayEntityPanelDialog(EntityPanel entityPanel) {
        this.displayEntityPanelDialog(entityPanel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void displayEntityPanelDialog(EntityPanel entityPanel, boolean modalDialog) {
        Objects.requireNonNull(entityPanel, "entityPanel");
        WaitCursor.show((JComponent)this);
        try {
            if (entityPanel.isShowing()) {
                Window parentWindow = Utilities.parentWindow((Component)entityPanel);
                if (parentWindow != null) {
                    parentWindow.toFront();
                }
            } else {
                ((ComponentDialogBuilder)((ComponentDialogBuilder)Dialogs.componentDialog((JComponent)EntityApplicationPanel.createEmptyBorderBasePanel(entityPanel)).owner((Window)this.parentWindow().orElse(null))).title((String)entityPanel.caption().get())).onClosed(e -> {
                    entityPanel.model().savePreferences();
                    entityPanel.savePreferences();
                }).modal(modalDialog).resizable(true).show();
            }
        }
        finally {
            WaitCursor.hide((JComponent)this);
        }
    }

    protected abstract List<EntityPanel> createEntityPanels();

    protected Collection<EntityPanel.Builder> createSupportEntityPanelBuilders() {
        return Collections.emptyList();
    }

    protected final void addOnExitListener(Runnable listener) {
        this.onExitEvent.addListener(listener);
    }

    protected JMenuBar createMenuBar() {
        Controls mainMenuControls = this.createMainMenuControls();
        if (mainMenuControls == null || mainMenuControls.empty()) {
            return null;
        }
        return Components.menu((Controls)mainMenuControls).createMenuBar();
    }

    protected final String defaultUsername() {
        return UserPreferences.getUserPreference((String)this.applicationDefaultUsernameProperty, (String)((String)EntityApplicationModel.USERNAME_PREFIX.get() + System.getProperty("user.name")));
    }

    protected void savePreferences() {
        this.entityPanels().forEach(EntityPanel::savePreferences);
        this.applicationModel().savePreferences();
    }

    private void bindEventsInternal() {
        this.alwaysOnTopState.addDataListener(alwaysOnTop -> this.parentWindow().ifPresent(parent -> parent.setAlwaysOnTop((boolean)alwaysOnTop)));
    }

    private Control createSupportPanelControl(EntityPanel.Builder panelBuilder) {
        return Control.builder(() -> this.displayEntityPanel(panelBuilder)).name(panelBuilder.caption().orElse(this.applicationModel.entities().definition(panelBuilder.entityType()).caption())).build();
    }

    private void addEntityPanel(EntityPanel entityPanel) {
        EntityPanel.addEntityPanelAndLinkSiblings(entityPanel, this.entityPanels);
        entityPanel.addActivateListener(this.applicationLayout::select);
        if (entityPanel.containsEditPanel()) {
            ((EntityEditPanel)entityPanel.editPanel()).active().addDataListener((Consumer)new SelectActivatedPanelListener(entityPanel));
        }
    }

    private EntityPanel entityPanel(EntityPanel.Builder panelBuilder) {
        if (((Boolean)CACHE_ENTITY_PANELS.get()).booleanValue() && this.cachedEntityPanels.containsKey(panelBuilder)) {
            return this.cachedEntityPanels.get(panelBuilder);
        }
        EntityPanel entityPanel = panelBuilder.buildPanel(this.applicationModel.connectionProvider());
        entityPanel.initialize();
        if (((Boolean)CACHE_ENTITY_PANELS.get()).booleanValue()) {
            this.cachedEntityPanels.put(panelBuilder, entityPanel);
        }
        return entityPanel;
    }

    private static JPanel createEmptyBorderBasePanel(EntityPanel entityPanel) {
        int gap = (Integer)Layouts.GAP.get();
        return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent((JComponent)entityPanel).border(BorderFactory.createEmptyBorder(gap, gap, 0, gap))).build();
    }

    private JScrollPane createApplicationTree() {
        return EntityApplicationPanel.createTree(EntityApplicationPanel.createApplicationTree(this.entityPanels));
    }

    private JScrollPane createDependencyTree() {
        return EntityApplicationPanel.createTree(EntityApplicationPanel.createDependencyTreeModel(this.applicationModel.entities()));
    }

    private boolean cancelExit() {
        boolean cancelForUnsavedData = (Boolean)this.applicationModel().warnAboutUnsavedData().get() != false && this.applicationModel().containsUnsavedData() && JOptionPane.showConfirmDialog(this, FrameworkMessages.unsavedDataWarning(), FrameworkMessages.unsavedDataWarningTitle(), 0) == 1;
        boolean exitNotConfirmed = (Boolean)CONFIRM_EXIT.get() != false && JOptionPane.showConfirmDialog(this, FrameworkMessages.confirmExit(), FrameworkMessages.confirmExitTitle(), 0) == 1;
        return cancelForUnsavedData || exitNotConfirmed;
    }

    private static Map<Object, State> createLogLevelStateMap() {
        LoggerProxy loggerProxy = LoggerProxy.instance();
        if (loggerProxy == LoggerProxy.NULL_PROXY) {
            return Collections.emptyMap();
        }
        Object currentLogLevel = loggerProxy.getLogLevel();
        LinkedHashMap levelStateMap = new LinkedHashMap();
        State.Group logLevelStateGroup = State.group((State[])new State[0]);
        for (Object logLevel : loggerProxy.levels()) {
            State logLevelState = State.state((boolean)Objects.equals(logLevel, currentLogLevel));
            logLevelStateGroup.add(logLevelState);
            logLevelState.addDataListener(enabled -> {
                if (enabled.booleanValue()) {
                    loggerProxy.setLogLevel(logLevel);
                }
            });
            levelStateMap.put(logLevel, logLevelState);
        }
        return Collections.unmodifiableMap(levelStateMap);
    }

    private Controls createLogControls() {
        Control logFileControl;
        Controls.Builder builder = Controls.builder().name(this.resourceBundle.getString("log")).mnemonic(this.resourceBundle.getString("log_mnemonic").charAt(0));
        if (!this.logLevelStates.isEmpty()) {
            builder.control(this.createLogLevelControl());
        }
        if ((logFileControl = this.createLogFileControl()) != null) {
            builder.control(logFileControl);
        }
        return builder.build();
    }

    private Control createLogFileControl() {
        Collection files = LoggerProxy.instance().files();
        if (files.isEmpty()) {
            return null;
        }
        String firstLogFile = (String)files.iterator().next();
        return Control.builder(() -> Desktop.getDesktop().open(new File(firstLogFile))).name(this.resourceBundle.getString("open_log_file")).description(this.resourceBundle.getString("open_log_file") + " (" + firstLogFile + ")").build();
    }

    private static JScrollPane createTree(TreeModel treeModel) {
        JTree tree = new JTree(treeModel);
        tree.setShowsRootHandles(true);
        tree.setToggleClickCount(1);
        tree.setRootVisible(false);
        Utilities.expandAll((JTree)tree, (TreePath)new TreePath(tree.getModel().getRoot()));
        return new JScrollPane(tree, 20, 30);
    }

    private static DefaultTreeModel createApplicationTree(Collection<? extends EntityPanel> entityPanels) {
        DefaultTreeModel applicationTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        EntityApplicationPanel.addModelsToTree((DefaultMutableTreeNode)applicationTreeModel.getRoot(), entityPanels);
        return applicationTreeModel;
    }

    private static void addModelsToTree(DefaultMutableTreeNode root, Collection<? extends EntityPanel> panels) {
        for (EntityPanel entityPanel : panels) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(entityPanel.caption().get());
            root.add(node);
            if (entityPanel.detailPanels().isEmpty()) continue;
            EntityApplicationPanel.addModelsToTree(node, entityPanel.detailPanels());
        }
    }

    private static boolean referencesOnlySelf(Entities entities, EntityType entityType) {
        return entities.definition(entityType).foreignKeys().get().stream().allMatch(foreignKey -> foreignKey.referencedType().equals(entityType));
    }

    public static interface ApplicationLayout
    extends EntityPanel.Selector {
        public void layout(EntityApplicationPanel<?> var1);

        @Override
        default public void select(EntityPanel entityPanel) {
        }
    }

    private static final class EntityDependencyTreeNode
    extends DefaultMutableTreeNode {
        private final Entities entities;

        private EntityDependencyTreeNode(EntityType entityType, Entities entities) {
            super(Objects.requireNonNull(entityType, "entityType"));
            this.entities = entities;
        }

        public EntityType entityType() {
            return (EntityType)this.getUserObject();
        }

        @Override
        public void setParent(MutableTreeNode newParent) {
            super.setParent(newParent);
            this.removeAllChildren();
            for (EntityDependencyTreeNode child : this.getChildren()) {
                this.add(child);
            }
        }

        private List<EntityDependencyTreeNode> getChildren() {
            ArrayList<EntityDependencyTreeNode> childrenList = new ArrayList<EntityDependencyTreeNode>();
            for (EntityDefinition definition : this.entities.definitions()) {
                for (ForeignKeyDefinition foreignKeyDefinition : definition.foreignKeys().definitions()) {
                    if (!foreignKeyDefinition.attribute().referencedType().equals(this.entityType()) || foreignKeyDefinition.soft() || this.foreignKeyCycle(foreignKeyDefinition.attribute().referencedType())) continue;
                    childrenList.add(new EntityDependencyTreeNode(definition.entityType(), this.entities));
                }
            }
            return childrenList;
        }

        private boolean foreignKeyCycle(EntityType referencedEntityType) {
            TreeNode tmp = this.getParent();
            while (tmp instanceof EntityDependencyTreeNode) {
                if (((EntityDependencyTreeNode)tmp).entityType().equals(referencedEntityType)) {
                    return true;
                }
                tmp = tmp.getParent();
            }
            return false;
        }
    }

    private static final class SupportPanelBuilderComparator
    implements Comparator<EntityPanel.Builder> {
        private final Entities entities;
        private final Comparator<String> comparator = Text.spaceAwareCollator();

        private SupportPanelBuilderComparator(Entities entities) {
            this.entities = entities;
        }

        @Override
        public int compare(EntityPanel.Builder ep1, EntityPanel.Builder ep2) {
            String caption1 = ep1.caption().orElse(this.entities.definition(ep1.entityType()).caption());
            String caption2 = ep2.caption().orElse(this.entities.definition(ep2.entityType()).caption());
            return this.comparator.compare(caption1, caption2);
        }
    }

    private final class SelectActivatedPanelListener
    implements Consumer<Boolean> {
        private final EntityPanel entityPanel;

        private SelectActivatedPanelListener(EntityPanel entityPanel) {
            this.entityPanel = entityPanel;
        }

        @Override
        public void accept(Boolean active) {
            if (active.booleanValue()) {
                EntityApplicationPanel.this.applicationLayout.select(this.entityPanel);
            }
        }
    }

    public static interface Builder<M extends SwingEntityApplicationModel, P extends EntityApplicationPanel<M>> {
        public Builder<M, P> domainType(DomainType var1);

        public Builder<M, P> applicationName(String var1);

        public Builder<M, P> applicationIcon(ImageIcon var1);

        public Builder<M, P> applicationVersion(Version var1);

        public Builder<M, P> defaultLookAndFeelClassName(String var1);

        public Builder<M, P> lookAndFeelClassName(String var1);

        public Builder<M, P> connectionProviderFactory(ConnectionProviderFactory var1);

        public Builder<M, P> applicationModelFactory(Function<EntityConnectionProvider, M> var1);

        public Builder<M, P> applicationPanelFactory(Function<M, P> var1);

        public Builder<M, P> loginProvider(LoginProvider var1);

        public Builder<M, P> defaultLoginUser(User var1);

        public Builder<M, P> automaticLoginUser(User var1);

        public Builder<M, P> saveDefaultUsername(boolean var1);

        public Builder<M, P> loginPanelSouthComponent(Supplier<JComponent> var1);

        public Builder<M, P> beforeApplicationStarted(Runnable var1);

        public Builder<M, P> onApplicationStarted(Consumer<P> var1);

        public Builder<M, P> frameSupplier(Supplier<JFrame> var1);

        public Builder<M, P> frameTitle(String var1);

        public Builder<M, P> frameTitleProvider(ValueObserver<String> var1);

        public Builder<M, P> includeMainMenu(boolean var1);

        public Builder<M, P> maximizeFrame(boolean var1);

        public Builder<M, P> displayFrame(boolean var1);

        public Builder<M, P> setUncaughtExceptionHandler(boolean var1);

        public Builder<M, P> displayStartupDialog(boolean var1);

        public Builder<M, P> frameSize(Dimension var1);

        public Builder<M, P> loginRequired(boolean var1);

        public void start();

        public void start(boolean var1);

        public static interface ConnectionProviderFactory {
            default public EntityConnectionProvider createConnectionProvider(User user, DomainType domainType, String clientTypeId, Version clientVersion) {
                return EntityConnectionProvider.builder().user(user).domainType(domainType).clientTypeId(clientTypeId).clientVersion(clientVersion).build();
            }
        }

        public static interface LoginProvider {
            public User login();
        }
    }
}

