/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import is.codion.swing.framework.server.monitor.ConnectionPoolMonitor;
import is.codion.swing.framework.server.monitor.HostMonitor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public final class EntityServerMonitor {
    private static final int DEFAULT_SERVER_MONITOR_UPDATE_RATE = 5;
    public static final PropertyValue<Integer> SERVER_MONITOR_UPDATE_RATE = Configuration.integerValue((String)"codion.server.monitor.updateRate", (int)5);
    private final Event<String> hostAddedEvent = Event.event();
    private final Collection<HostMonitor> hostMonitors = new ArrayList<HostMonitor>();

    public EntityServerMonitor(String hostNames, int registryPort, User adminUser) throws RemoteException {
        if (Text.nullOrEmpty((String)hostNames)) {
            throw new IllegalArgumentException("No server host names specified for server monitor");
        }
        Objects.requireNonNull(adminUser);
        for (String hostname : hostNames.split(",")) {
            this.addHost(hostname, registryPort, adminUser);
        }
    }

    public Collection<HostMonitor> hostMonitors() {
        return this.hostMonitors;
    }

    public void refresh() throws RemoteException {
        for (HostMonitor hostMonitor : this.hostMonitors) {
            hostMonitor.refresh();
        }
    }

    public void setUpdateInterval(Integer interval) {
        for (HostMonitor hostMonitor : this.hostMonitors) {
            hostMonitor.serverMonitors().forEach(serverMonitor -> {
                serverMonitor.updateInterval().set((Object)interval);
                serverMonitor.databaseMonitor().updateInterval().set((Object)interval);
                serverMonitor.databaseMonitor().connectionPoolMonitor().connectionPoolInstanceMonitors().forEach(poolMonitor -> poolMonitor.updateInterval().set((Object)interval));
                serverMonitor.clientMonitor().updateInterval().set((Object)interval);
            });
        }
    }

    public void clearCharts() {
        for (HostMonitor hostMonitor : this.hostMonitors) {
            hostMonitor.serverMonitors().forEach(serverMonitor -> {
                serverMonitor.clearStatistics();
                serverMonitor.databaseMonitor().clearStatistics();
                serverMonitor.databaseMonitor().connectionPoolMonitor().connectionPoolInstanceMonitors().forEach(ConnectionPoolMonitor::clearStatistics);
            });
        }
    }

    private void addHost(String hostname, int registryPort, User adminUser) throws RemoteException {
        this.hostMonitors.add(new HostMonitor(hostname, registryPort, adminUser, (Integer)SERVER_MONITOR_UPDATE_RATE.get()));
        this.hostAddedEvent.accept((Object)hostname);
    }
}

