/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.version.Version;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.framework.server.monitor.ClientMonitor;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUserMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUserMonitor.class);
    private static final int THOUSAND = 1000;
    private final EntityServerAdmin server;
    private final Value<Integer> idleConnectionTimeoutValue;
    private final ClientMonitor clientMonitor;
    private final FilterTableModel<UserInfo, UserHistoryColumns.Id> userHistoryTableModel = FilterTableModel.builder((FilterTableModel.Columns)new UserHistoryColumns()).items((Supplier)new UserHistoryItems()).refreshStrategy(FilterTableModel.RefreshStrategy.MERGE).build();
    private final TaskScheduler updateScheduler;

    public ClientUserMonitor(EntityServerAdmin server, int updateRate) {
        this.server = Objects.requireNonNull(server);
        this.clientMonitor = new ClientMonitor(server);
        this.idleConnectionTimeoutValue = Value.nonNull((Object)0).initialValue((Object)this.getIdleConnectionTimeout()).consumer(this::setIdleConnectionTimeout).build();
        this.updateScheduler = TaskScheduler.builder(this::refreshUserHistoryTableModel).interval(updateRate, TimeUnit.SECONDS).start();
    }

    public void shutdown() {
        this.updateScheduler.stop();
    }

    public ClientMonitor clientMonitor() {
        return this.clientMonitor;
    }

    public FilterTableModel<?, UserHistoryColumns.Id> userHistoryTableModel() {
        return this.userHistoryTableModel;
    }

    public void disconnectAll() throws RemoteException {
        this.server.disconnectAllClients();
        this.clientMonitor.refresh();
    }

    public void disconnectTimedOut() throws RemoteException {
        this.server.disconnectTimedOutClients();
        this.clientMonitor.refresh();
    }

    public void setMaintenanceInterval(int interval) throws RemoteException {
        this.server.setMaintenanceInterval(interval * 1000);
    }

    public int getMaintenanceInterval() throws RemoteException {
        return this.server.getMaintenanceInterval() / 1000;
    }

    public void resetHistory() {
        this.userHistoryTableModel.clear();
    }

    public Value<Integer> idleConnectionTimeout() {
        return this.idleConnectionTimeoutValue;
    }

    public Value<Integer> updateInterval() {
        return this.updateScheduler.interval();
    }

    private int getIdleConnectionTimeout() {
        try {
            return this.server.getIdleConnectionTimeout() / 1000;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void setIdleConnectionTimeout(int idleConnectionTimeout) {
        if (idleConnectionTimeout < 0) {
            throw new IllegalArgumentException("Idle connection timeout must be a positive integer");
        }
        try {
            this.server.setIdleConnectionTimeout(idleConnectionTimeout * 1000);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void refreshUserHistoryTableModel() {
        try {
            this.userHistoryTableModel.refresh();
        }
        catch (Exception e) {
            LOG.error("Error while refreshing user history table model", (Throwable)e);
        }
    }

    public static final class UserHistoryColumns
    implements FilterTableModel.Columns<UserInfo, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            switch (identifier) {
                case USERNAME_COLUMN: {
                    return String.class;
                }
                case CLIENT_TYPE_COLUMN: {
                    return String.class;
                }
                case CLIENT_VERSION_COLUMN: {
                    return Version.class;
                }
                case FRAMEWORK_VERSION_COLUMN: {
                    return Version.class;
                }
                case CLIENT_HOST_COLUMN: {
                    return String.class;
                }
                case LAST_SEEN_COLUMN: {
                    return LocalDateTime.class;
                }
                case CONNECTION_COUNT_COLUMN: {
                    return Integer.class;
                }
            }
            throw new IllegalArgumentException(identifier.toString());
        }

        public Object value(UserInfo row, Id identifier) {
            switch (identifier) {
                case USERNAME_COLUMN: {
                    return row.user().username();
                }
                case CLIENT_TYPE_COLUMN: {
                    return row.clientTypeId();
                }
                case CLIENT_VERSION_COLUMN: {
                    return row.clientVersion();
                }
                case FRAMEWORK_VERSION_COLUMN: {
                    return row.frameworkVersion();
                }
                case CLIENT_HOST_COLUMN: {
                    return row.clientHost();
                }
                case LAST_SEEN_COLUMN: {
                    return row.getLastSeen();
                }
                case CONNECTION_COUNT_COLUMN: {
                    return row.connectionCount();
                }
            }
            throw new IllegalArgumentException(identifier.toString());
        }

        public static enum Id {
            USERNAME_COLUMN,
            CLIENT_TYPE_COLUMN,
            CLIENT_VERSION_COLUMN,
            FRAMEWORK_VERSION_COLUMN,
            CLIENT_HOST_COLUMN,
            LAST_SEEN_COLUMN,
            CONNECTION_COUNT_COLUMN;

        }
    }

    private final class UserHistoryItems
    implements Supplier<Collection<UserInfo>> {
        private UserHistoryItems() {
        }

        @Override
        public Collection<UserInfo> get() {
            try {
                ArrayList<UserInfo> items = new ArrayList<UserInfo>(ClientUserMonitor.this.userHistoryTableModel.items());
                for (RemoteClient remoteClient : ClientUserMonitor.this.server.clients()) {
                    UserInfo newUserInfo = new UserInfo(remoteClient.user(), remoteClient.clientTypeId(), remoteClient.clientHost(), LocalDateTime.now(), remoteClient.clientId(), remoteClient.clientVersion().orElse(null), remoteClient.frameworkVersion());
                    int index = items.indexOf(newUserInfo);
                    if (index == -1) {
                        items.add(newUserInfo);
                        continue;
                    }
                    UserInfo currentUserInfo = (UserInfo)items.get(index);
                    currentUserInfo.setLastSeen(newUserInfo.getLastSeen());
                    if (!currentUserInfo.isNewConnection(newUserInfo.getClientId())) continue;
                    currentUserInfo.incrementConnectionCount();
                    currentUserInfo.setClientID(newUserInfo.getClientId());
                }
                return items;
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class UserInfo {
        private final User user;
        private final String clientTypeId;
        private final String clientHost;
        private final Version clientVersion;
        private final Version frameworkVersion;
        private LocalDateTime lastSeen;
        private UUID clientId;
        private int connectionCount = 1;

        private UserInfo(User user, String clientTypeId, String clientHost, LocalDateTime lastSeen, UUID clientId, Version clientVersion, Version frameworkVersion) {
            this.user = user;
            this.clientTypeId = clientTypeId;
            this.clientHost = clientHost;
            this.lastSeen = lastSeen;
            this.clientId = clientId;
            this.clientVersion = clientVersion;
            this.frameworkVersion = frameworkVersion;
        }

        public User user() {
            return this.user;
        }

        public String clientTypeId() {
            return this.clientTypeId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public LocalDateTime getLastSeen() {
            return this.lastSeen;
        }

        public UUID getClientId() {
            return this.clientId;
        }

        public Version clientVersion() {
            return this.clientVersion;
        }

        public Version frameworkVersion() {
            return this.frameworkVersion;
        }

        public int connectionCount() {
            return this.connectionCount;
        }

        public void setLastSeen(LocalDateTime lastSeen) {
            this.lastSeen = lastSeen;
        }

        public void setClientID(UUID clientId) {
            this.clientId = clientId;
        }

        public void incrementConnectionCount() {
            ++this.connectionCount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UserInfo)) {
                return false;
            }
            UserInfo that = (UserInfo)obj;
            return this.user.username().equalsIgnoreCase(that.user.username()) && this.clientTypeId.equals(that.clientTypeId) && this.clientHost.equals(that.clientHost);
        }

        public int hashCode() {
            int result = this.user.username().toLowerCase().hashCode();
            result = 31 * result + this.clientTypeId.hashCode();
            result = 31 * result + this.clientHost.hashCode();
            return result;
        }

        public boolean isNewConnection(UUID clientId) {
            return !this.clientId.equals(clientId);
        }
    }
}

