/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.rmi.server.RemoteClient;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.swing.common.model.component.table.FilterTableModel;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class ClientMonitor {
    private final EntityServerAdmin server;
    private final FilterTableModel<RemoteClient, RemoteClientColumns.Id> clientInstanceTableModel = FilterTableModel.builder((FilterTableModel.Columns)new RemoteClientColumns()).items((Supplier)new RemoteClientItems()).build();

    public ClientMonitor(EntityServerAdmin server) {
        this.server = Objects.requireNonNull(server);
        this.refresh();
    }

    public void refresh() {
        this.clientInstanceTableModel.refresh();
    }

    public FilterTableModel<RemoteClient, RemoteClientColumns.Id> clientInstanceTableModel() {
        return this.clientInstanceTableModel;
    }

    public EntityServerAdmin server() {
        return this.server;
    }

    public static final class RemoteClientColumns
    implements FilterTableModel.Columns<RemoteClient, Id> {
        private static final List<Id> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(Id.values()));

        public List<Id> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(Id identifier) {
            if (identifier.equals((Object)Id.CREATION_TIME)) {
                return LocalDateTime.class;
            }
            return String.class;
        }

        public Object value(RemoteClient row, Id identifier) {
            switch (identifier) {
                case USER: {
                    return row.user().username();
                }
                case CLIENT_HOST: {
                    return row.clientHost();
                }
                case CLIENT_TYPE: {
                    return row.clientTypeId();
                }
                case CLIENT_VERSION: {
                    return row.clientVersion().map(Object::toString).orElse(null);
                }
                case CODION_VERSION: {
                    return row.frameworkVersion().toString();
                }
                case CLIENT_ID: {
                    return row.clientId().toString();
                }
                case LOCALE: {
                    return row.clientLocale().toString();
                }
                case TIMEZONE: {
                    return row.clientTimeZone().toString();
                }
                case CREATION_TIME: {
                    return row.creationTime();
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        public static enum Id {
            USER,
            CLIENT_HOST,
            CLIENT_TYPE,
            CLIENT_VERSION,
            CODION_VERSION,
            CLIENT_ID,
            LOCALE,
            TIMEZONE,
            CREATION_TIME;

        }
    }

    private final class RemoteClientItems
    implements Supplier<Collection<RemoteClient>> {
        private RemoteClientItems() {
        }

        @Override
        public Collection<RemoteClient> get() {
            try {
                return ClientMonitor.this.server.clients();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

