/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor.ui;

import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.server.monitor.ClientInstanceMonitor;
import is.codion.swing.framework.server.monitor.ClientMonitor;
import is.codion.swing.framework.server.monitor.ui.ClientInstanceMonitorPanel;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public final class ClientMonitorPanel
extends JPanel {
    private final ClientMonitor model;
    private final FilteredTable<RemoteClient, Integer> clientInstanceTable;
    private final JScrollPane filterScrollPane;
    private final JScrollPane clientInstanceScroller;
    private final State advancedFilterState = State.state();

    public ClientMonitorPanel(ClientMonitor model) {
        this.model = model;
        this.clientInstanceTable = (FilteredTable)((FilteredTable.Builder)FilteredTable.builder(model.clientInstanceTableModel()).popupMenu(this::createPopupMenu)).autoResizeMode(4).build();
        this.clientInstanceScroller = (JScrollPane)((ScrollPaneBuilder)Components.scrollPane(this.clientInstanceTable).border((Border)BorderFactory.createTitledBorder("Clients"))).build();
        this.filterScrollPane = ClientMonitorPanel.createLinkedScrollPane(this.clientInstanceScroller, (JPanel)this.clientInstanceTable.filterPanel());
        this.advancedFilterState.addDataListener(this::toggleAdvancedFilters);
        this.initializeUI();
    }

    public ClientMonitor model() {
        return this.model;
    }

    public void refresh() {
        this.model.refresh();
    }

    private void initializeUI() {
        JPanel clientInstanceBase = (JPanel)Components.borderLayoutPanel().northComponent((JComponent)this.filterScrollPane).centerComponent((JComponent)this.clientInstanceScroller).southComponent(Components.borderLayoutPanel().southComponent(Components.borderLayoutPanel().centerComponent((JComponent)this.clientInstanceTable.searchField()).eastComponent(Components.flexibleGridLayoutPanel((int)1, (int)2).add(((CheckBoxBuilder)Components.checkBox((Value)this.advancedFilterState).text("Advanced filters")).build()).add(Components.button((Control)Control.control(this::refresh)).text("Refresh").build()).build()).build()).build()).build();
        JPanel clientInstancePanel = (JPanel)Components.borderLayoutPanel().build();
        JSplitPane splitPane = (JSplitPane)Components.splitPane().orientation(1).oneTouchExpandable(true).continuousLayout(true).leftComponent((JComponent)clientInstanceBase).rightComponent((JComponent)clientInstancePanel).build();
        this.model.clientInstanceTableModel().selectionModel().addSelectedItemListener(remoteClient -> {
            clientInstancePanel.removeAll();
            try {
                if (this.model != null && remoteClient != null) {
                    ClientInstanceMonitorPanel clientMonitor = new ClientInstanceMonitorPanel(new ClientInstanceMonitor(this.model.server(), (RemoteClient)remoteClient));
                    clientInstancePanel.add((Component)clientMonitor, "Center");
                }
                this.revalidate();
                this.repaint();
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        });
        this.setLayout(Layouts.borderLayout());
        this.add((Component)splitPane, "Center");
    }

    private JPopupMenu createPopupMenu(FilteredTable<RemoteClient, Integer> table) {
        return Components.menu((Controls)((Controls)Controls.builder().control(Control.builder(this::disconnect).name("Disconnect").enabled(this.model.clientInstanceTableModel().selectionModel().selectionNotEmpty())).separator().controls(new Control[]{((Controls.Builder)Controls.builder().name("Columns")).control((Control)table.createToggleColumnsControls()).control(table.createResetColumnsControl()).control(table.createAutoResizeModeControl()).build()}).build())).createPopupMenu();
    }

    private void disconnect() throws RemoteException {
        for (RemoteClient remoteClient : this.model.clientInstanceTableModel().selectionModel().getSelectedItems()) {
            this.model.server().disconnect(remoteClient.clientId());
            this.model.clientInstanceTableModel().removeItem((Object)remoteClient);
        }
    }

    private void toggleAdvancedFilters(Boolean advanced) {
        this.clientInstanceTable.filterPanel().advanced().set((Object)advanced);
        this.revalidate();
    }

    private static JScrollPane createLinkedScrollPane(JScrollPane parentScrollPane, JPanel panelToScroll) {
        return (JScrollPane)((ScrollPaneBuilder)Components.scrollPane((JComponent)panelToScroll).horizontalScrollBarPolicy(31).verticalScrollBarPolicy(21).onBuild(scrollPane -> Utilities.linkBoundedRangeModels((BoundedRangeModel)parentScrollPane.getHorizontalScrollBar().getModel(), (BoundedRangeModel)scrollPane.getHorizontalScrollBar().getModel()))).build();
    }
}

