/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.db.pool.ConnectionPoolState;
import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.event.Event;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;

public final class ConnectionPoolMonitor {
    private static final int THOUSAND = 1000;
    private final Event<?> statisticsUpdatedEvent = Event.event();
    private final String username;
    private final ConnectionPoolWrapper connectionPool;
    private ConnectionPoolStatistics poolStatistics;
    private final Value<Integer> pooledConnectionTimeoutValue;
    private final Value<Integer> pooledCleanupIntervalValue;
    private final Value<Integer> minimumPoolSizeValue;
    private final Value<Integer> maximumPoolSizeValue;
    private final Value<Integer> maximumCheckoutTimeValue;
    private final State collectSnapshotStatisticsState;
    private final State collectCheckOutTimesState;
    private final XYSeries poolSizeSeries = new XYSeries((Comparable)((Object)"Size"));
    private final XYSeries minimumPoolSizeSeries = new XYSeries((Comparable)((Object)"Min. size"));
    private final XYSeries maximumPoolSizeSeries = new XYSeries((Comparable)((Object)"Max. size"));
    private final XYSeries inPoolSeries = new XYSeries((Comparable)((Object)"Available"));
    private final XYSeries inUseSeries = new XYSeries((Comparable)((Object)"In use"));
    private final XYSeriesCollection snapshotStatisticsCollection = new XYSeriesCollection();
    private final XYSeriesCollection statisticsCollection = new XYSeriesCollection();
    private final XYSeries failedRequestsPerSecond = new XYSeries((Comparable)((Object)"Failed requests/sec"));
    private final XYSeries connectionRequestsPerSecond = new XYSeries((Comparable)((Object)"Requests/sec"));
    private final XYSeriesCollection connectionRequestsPerSecondCollection = new XYSeriesCollection();
    private final YIntervalSeries averageCheckOutTime = new YIntervalSeries((Comparable)((Object)"Average check out time (ms)"));
    private final YIntervalSeriesCollection checkOutTimeCollection = new YIntervalSeriesCollection();
    private final TaskScheduler updateScheduler;
    private long lastStatisticsUpdateTime = 0L;

    public ConnectionPoolMonitor(ConnectionPoolWrapper connectionPool, int updateRate) {
        this.username = Objects.requireNonNull(connectionPool).user().username();
        this.connectionPool = connectionPool;
        this.pooledConnectionTimeoutValue = Value.value((Object)connectionPool.getIdleConnectionTimeout(), (Object)0);
        this.pooledConnectionTimeoutValue.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setIdleConnectionTimeout(arg_0));
        this.pooledCleanupIntervalValue = Value.value((Object)connectionPool.getCleanupInterval(), (Object)0);
        this.pooledCleanupIntervalValue.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setCleanupInterval(arg_0));
        this.minimumPoolSizeValue = Value.value((Object)connectionPool.getMinimumPoolSize(), (Object)0);
        this.minimumPoolSizeValue.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setMinimumPoolSize(arg_0));
        this.maximumPoolSizeValue = Value.value((Object)connectionPool.getMaximumPoolSize(), (Object)0);
        this.maximumPoolSizeValue.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setMaximumPoolSize(arg_0));
        this.maximumCheckoutTimeValue = Value.value((Object)connectionPool.getMaximumCheckOutTime(), (Object)0);
        this.maximumCheckoutTimeValue.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setMaximumCheckOutTime(arg_0));
        this.collectSnapshotStatisticsState = State.state((boolean)connectionPool.isCollectSnapshotStatistics());
        this.collectSnapshotStatisticsState.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setCollectSnapshotStatistics(arg_0));
        this.collectCheckOutTimesState = State.state((boolean)connectionPool.isCollectCheckOutTimes());
        this.collectCheckOutTimesState.addDataListener(arg_0 -> ((ConnectionPoolWrapper)connectionPool).setCollectCheckOutTimes(arg_0));
        this.statisticsCollection.addSeries(this.inPoolSeries);
        this.statisticsCollection.addSeries(this.inUseSeries);
        this.statisticsCollection.addSeries(this.poolSizeSeries);
        this.statisticsCollection.addSeries(this.minimumPoolSizeSeries);
        this.statisticsCollection.addSeries(this.maximumPoolSizeSeries);
        this.connectionRequestsPerSecondCollection.addSeries(this.connectionRequestsPerSecond);
        this.connectionRequestsPerSecondCollection.addSeries(this.failedRequestsPerSecond);
        this.checkOutTimeCollection.addSeries(this.averageCheckOutTime);
        this.updateScheduler = TaskScheduler.builder(this::updateStatistics).interval(updateRate, TimeUnit.SECONDS).start();
        this.bindEvents();
    }

    public String username() {
        return this.username;
    }

    public ConnectionPoolStatistics connectionPoolStatistics() {
        return this.poolStatistics;
    }

    public Value<Integer> pooledConnectionTimeout() {
        return this.pooledConnectionTimeoutValue;
    }

    public Value<Integer> poolCleanupInterval() {
        return this.pooledCleanupIntervalValue;
    }

    public Value<Integer> minimumPoolSize() {
        return this.minimumPoolSizeValue;
    }

    public Value<Integer> maximumPoolSize() {
        return this.maximumPoolSizeValue;
    }

    public Value<Integer> maximumCheckOutTime() {
        return this.maximumCheckoutTimeValue;
    }

    public boolean datasetContainsData() {
        return this.snapshotStatisticsCollection.getSeriesCount() > 0 && this.snapshotStatisticsCollection.getSeries(0).getItemCount() > 0 && this.snapshotStatisticsCollection.getSeries(1).getItemCount() > 0;
    }

    public XYDataset snapshotDataset() {
        XYSeriesCollection poolDataset = new XYSeriesCollection();
        poolDataset.addSeries(this.snapshotStatisticsCollection.getSeries(0));
        poolDataset.addSeries(this.snapshotStatisticsCollection.getSeries(1));
        poolDataset.addSeries(this.snapshotStatisticsCollection.getSeries(2));
        return poolDataset;
    }

    public XYDataset inPoolDataset() {
        return this.statisticsCollection;
    }

    public XYDataset requestsPerSecondDataset() {
        return this.connectionRequestsPerSecondCollection;
    }

    public IntervalXYDataset checkOutTimeCollection() {
        return this.checkOutTimeCollection;
    }

    public void resetStatistics() {
        this.connectionPool.resetStatistics();
    }

    public void clearStatistics() {
        this.inPoolSeries.clear();
        this.inUseSeries.clear();
        this.connectionRequestsPerSecond.clear();
        this.failedRequestsPerSecond.clear();
        this.poolSizeSeries.clear();
        this.minimumPoolSizeSeries.clear();
        this.maximumPoolSizeSeries.clear();
        this.averageCheckOutTime.clear();
    }

    public State collectSnapshotStatistics() {
        return this.collectSnapshotStatisticsState;
    }

    public State collectCheckOutTimes() {
        return this.collectCheckOutTimesState;
    }

    public void addStatisticsListener(Runnable listener) {
        this.statisticsUpdatedEvent.addListener(listener);
    }

    public Value<Integer> updateInterval() {
        return this.updateScheduler.interval();
    }

    public void shutdown() {
        this.updateScheduler.stop();
    }

    private void setPoolCleanupInterval(int poolCleanupInterval) {
        this.connectionPool.setCleanupInterval(poolCleanupInterval * 1000);
    }

    private void setMinimumPoolSize(int minimumPoolSize) {
        this.connectionPool.setMinimumPoolSize(minimumPoolSize);
    }

    private void setMaximumPoolSize(int maximumPoolSize) {
        this.connectionPool.setMaximumPoolSize(maximumPoolSize);
    }

    private void setMaximumCheckOutTime(int maximumCheckOutTime) {
        this.connectionPool.setMaximumCheckOutTime(maximumCheckOutTime);
    }

    private void updateStatistics() {
        long timestamp;
        this.poolStatistics = this.connectionPool.statistics(this.lastStatisticsUpdateTime);
        this.lastStatisticsUpdateTime = timestamp = this.poolStatistics.timestamp();
        this.poolSizeSeries.add((double)timestamp, (double)this.poolStatistics.size());
        this.minimumPoolSizeSeries.add((double)timestamp, (double)this.connectionPool.getMinimumPoolSize());
        this.maximumPoolSizeSeries.add((double)timestamp, (double)this.connectionPool.getMaximumPoolSize());
        this.inPoolSeries.add((double)timestamp, (double)this.poolStatistics.available());
        this.inUseSeries.add((double)timestamp, (double)this.poolStatistics.inUse());
        this.connectionRequestsPerSecond.add((double)timestamp, (double)this.poolStatistics.requestsPerSecond());
        this.failedRequestsPerSecond.add((double)timestamp, (double)this.poolStatistics.failedRequestsPerSecond());
        this.averageCheckOutTime.add((double)timestamp, (double)this.poolStatistics.averageGetTime(), (double)this.poolStatistics.minimumCheckOutTime(), (double)this.poolStatistics.maximumCheckOutTime());
        List snapshotStatistics = this.poolStatistics.snapshot();
        if (!snapshotStatistics.isEmpty()) {
            XYSeries snapshotInPoolSeries = new XYSeries((Comparable)((Object)"In pool"));
            XYSeries snapshotInUseSeries = new XYSeries((Comparable)((Object)"In use"));
            XYSeries snapshotWaitingSeries = new XYSeries((Comparable)((Object)"Waiting"));
            for (ConnectionPoolState inPool : snapshotStatistics) {
                snapshotInPoolSeries.add((double)inPool.timestamp(), (double)inPool.size());
                snapshotInUseSeries.add((double)inPool.timestamp(), (double)inPool.inUse());
                snapshotWaitingSeries.add((double)inPool.timestamp(), (double)inPool.waiting());
            }
            this.snapshotStatisticsCollection.removeAllSeries();
            this.snapshotStatisticsCollection.addSeries(snapshotInPoolSeries);
            this.snapshotStatisticsCollection.addSeries(snapshotInUseSeries);
            this.snapshotStatisticsCollection.addSeries(snapshotWaitingSeries);
        }
        this.pooledConnectionTimeoutValue.set((Object)this.connectionPool.getIdleConnectionTimeout());
        this.pooledCleanupIntervalValue.set((Object)(this.connectionPool.getCleanupInterval() / 1000));
        this.minimumPoolSizeValue.set((Object)this.connectionPool.getMinimumPoolSize());
        this.maximumPoolSizeValue.set((Object)this.connectionPool.getMaximumPoolSize());
        this.maximumCheckoutTimeValue.set((Object)this.connectionPool.getMaximumCheckOutTime());
        this.statisticsUpdatedEvent.run();
    }

    private void bindEvents() {
        this.pooledCleanupIntervalValue.addDataListener(this::setPoolCleanupInterval);
        this.minimumPoolSizeValue.addDataListener(this::setMinimumPoolSize);
        this.maximumPoolSizeValue.addDataListener(this::setMaximumPoolSize);
        this.maximumCheckoutTimeValue.addDataListener(this::setMaximumCheckOutTime);
        this.collectSnapshotStatisticsState.addDataListener(arg_0 -> ((ConnectionPoolWrapper)this.connectionPool).setCollectSnapshotStatistics(arg_0));
        this.collectCheckOutTimesState.addDataListener(arg_0 -> ((ConnectionPoolWrapper)this.connectionPool).setCollectCheckOutTimes(arg_0));
    }
}

