/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.rmi.server.RemoteClient;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class ClientMonitor {
    private static final int CREATION_TIME = 8;
    private static final int TIMEZONE = 7;
    private static final int LOCALE = 6;
    private static final int CLIENT_ID = 5;
    private static final int CODION_VERSION = 4;
    private static final int CLIENT_VERSION = 3;
    private static final int CLIENT_TYPE = 2;
    private static final int CLIENT_HOST = 1;
    private static final int USER = 0;
    private final EntityServerAdmin server;
    private final FilteredTableModel<RemoteClient, Integer> clientInstanceTableModel = FilteredTableModel.builder((FilteredTableModel.ColumnFactory)new RemoteClientColumnFactory(), (FilteredTableModel.ColumnValueProvider)new RemoteClientColumnValueProvider()).itemSupplier((Supplier)new RemoteClientItemSupplier()).build();

    public ClientMonitor(EntityServerAdmin server) {
        this.server = Objects.requireNonNull(server);
        this.refresh();
    }

    public void refresh() {
        this.clientInstanceTableModel.refresh();
    }

    public FilteredTableModel<RemoteClient, Integer> clientInstanceTableModel() {
        return this.clientInstanceTableModel;
    }

    public EntityServerAdmin server() {
        return this.server;
    }

    private static final class RemoteClientColumnFactory
    implements FilteredTableModel.ColumnFactory<Integer> {
        private RemoteClientColumnFactory() {
        }

        public List<FilteredTableColumn<Integer>> createColumns() {
            return Arrays.asList(FilteredTableColumn.builder((int)0).headerValue((Object)"User").columnClass(String.class).build(), FilteredTableColumn.builder((int)1).headerValue((Object)"Host").columnClass(String.class).build(), FilteredTableColumn.builder((int)2).headerValue((Object)"Type").columnClass(String.class).build(), FilteredTableColumn.builder((int)3).headerValue((Object)"Version").columnClass(String.class).build(), FilteredTableColumn.builder((int)4).headerValue((Object)"Framework version").columnClass(String.class).build(), FilteredTableColumn.builder((int)5).headerValue((Object)"Id").columnClass(String.class).build(), FilteredTableColumn.builder((int)6).headerValue((Object)"Locale").columnClass(String.class).build(), FilteredTableColumn.builder((int)7).headerValue((Object)"Timezone").columnClass(String.class).build(), FilteredTableColumn.builder((int)8).headerValue((Object)"Created").columnClass(LocalDateTime.class).build());
        }
    }

    private static final class RemoteClientColumnValueProvider
    implements FilteredTableModel.ColumnValueProvider<RemoteClient, Integer> {
        private RemoteClientColumnValueProvider() {
        }

        public Object value(RemoteClient row, Integer columnIdentifier) {
            switch (columnIdentifier) {
                case 0: {
                    return row.user().username();
                }
                case 1: {
                    return row.clientHost();
                }
                case 2: {
                    return row.clientTypeId();
                }
                case 3: {
                    return row.clientVersion() == null ? null : row.clientVersion().toString();
                }
                case 4: {
                    return row.frameworkVersion().toString();
                }
                case 5: {
                    return row.clientId().toString();
                }
                case 6: {
                    return row.clientLocale().toString();
                }
                case 7: {
                    return row.clientTimeZone().toString();
                }
                case 8: {
                    return row.creationTime();
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }
    }

    private final class RemoteClientItemSupplier
    implements Supplier<Collection<RemoteClient>> {
        private RemoteClientItemSupplier() {
        }

        @Override
        public Collection<RemoteClient> get() {
            try {
                return ClientMonitor.this.server.clients();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

