/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor.ui;

import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.combobox.ComboBoxBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.ExceptionDialogBuilder;
import is.codion.swing.framework.server.monitor.ClientUserMonitor;
import is.codion.swing.framework.server.monitor.ui.ClientMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public final class ClientUserMonitorPanel
extends JPanel {
    private static final int SPINNER_COLUMNS = 3;
    private static final Integer[] MAINTENANCE_INTERVAL_VALUES = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 120, 180, 340, 6000, 10000};
    private final ClientUserMonitor model;
    private final ClientMonitorPanel clientTypeMonitorPanel;

    public ClientUserMonitorPanel(ClientUserMonitor model) throws RemoteException {
        this.model = Objects.requireNonNull(model);
        this.clientTypeMonitorPanel = new ClientMonitorPanel(model.clientMonitor());
        this.initializeUI();
    }

    public void disconnectAll() throws RemoteException {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to disconnect all clients?", "Disconnect all", 2) == 0) {
            this.model.disconnectAll();
        }
    }

    private void initializeUI() throws RemoteException {
        this.setLayout(new BorderLayout());
        this.add((Component)Components.tabbedPane().tab("Current", (JComponent)this.createCurrentConnectionsPanel()).tab("History", (JComponent)this.createConnectionHistoryPanel()).build(), "Center");
    }

    private JPanel createCurrentConnectionsPanel() throws RemoteException {
        JPanel actionBase = (JPanel)((PanelBuilder)Components.flowLayoutPanel((int)0).border((Border)BorderFactory.createTitledBorder("Remote connection controls"))).add((JComponent)new JLabel("Reaper interval (s)", 4)).add(this.createMaintenanceIntervalComponent()).add((JComponent)new JLabel("Idle connection timeout (s)")).add(((NumberSpinnerBuilder)Components.integerSpinner((SpinnerNumberModel)new SpinnerNumberModel(), this.model.idleConnectionTimeout()).columns(4)).build()).add(((ButtonBuilder)Components.button((Control)Control.control(this.model::disconnectTimedOut)).text("Disconnect idle").toolTipText("Disconnect those that have exceeded the allowed idle time")).build()).add(((ButtonBuilder)Components.button((Control)Control.control(this::disconnectAll)).text("Disconnect all").toolTipText("Disconnect all clients")).build()).build();
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)actionBase).centerComponent((JComponent)this.clientTypeMonitorPanel).build();
    }

    private JPanel createConnectionHistoryPanel() {
        JPanel configPanel = (JPanel)Components.flowLayoutPanel((int)0).add((JComponent)new JLabel("Update interval (s)")).add(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.updateInterval()).minimum((Number)1).columns(3)).editable(false)).build()).build();
        JPanel configBase = (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)configPanel).eastComponent(Components.button((Control)Control.control(this.model::resetHistory)).text("Reset").build()).build();
        FilteredTable userHistoryTable = (FilteredTable)((FilteredTable.Builder)FilteredTable.builder(this.model.userHistoryTableModel()).popupMenuControls(table -> (Controls)Controls.builder().controls(new Control[]{((Controls.Builder)Controls.builder().name("Columns")).control((Control)table.createToggleColumnsControls()).control(table.createResetColumnsControl()).control(table.createAutoResizeModeControl()).build()}).build())).autoResizeMode(4).build();
        return (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)new JScrollPane((Component)userHistoryTable)).southComponent((JComponent)configBase).build();
    }

    private JComponent createMaintenanceIntervalComponent() throws RemoteException {
        return ((ComboBoxBuilder)Components.comboBox(new DefaultComboBoxModel<Integer>(MAINTENANCE_INTERVAL_VALUES)).initialValue((Object)this.model.getMaintenanceInterval())).itemListener(e -> {
            try {
                this.model.setMaintenanceInterval((Integer)((JComboBox)e.getSource()).getSelectedItem());
            }
            catch (RemoteException ex) {
                this.onException(ex);
            }
        }).build();
    }

    private void onException(Exception exception) {
        ((ExceptionDialogBuilder)Dialogs.exceptionDialog().owner((Component)this)).show((Throwable)exception);
    }
}

