/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.version.Version;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.framework.server.monitor.ClientMonitor;
import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUserMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUserMonitor.class);
    private static final int THOUSAND = 1000;
    private static final int USERNAME_COLUMN = 0;
    private static final int CLIENT_TYPE_COLUMN = 1;
    private static final int CLIENT_VERSION_COLUMN = 2;
    private static final int FRAMEWORK_VERSION_COLUMN = 3;
    private static final int CLIENT_HOST_COLUMN = 4;
    private static final int LAST_SEEN_COLUMN = 5;
    private static final int CONNECTION_COUNT_COLUMN = 6;
    private final EntityServerAdmin server;
    private final Value<Integer> idleConnectionTimeoutValue;
    private final ClientMonitor clientMonitor;
    private final FilteredTableModel<UserInfo, Integer> userHistoryTableModel = FilteredTableModel.builder(ClientUserMonitor::createUserHistoryColumns, (FilteredTableModel.ColumnValueProvider)new UserHistoryColumnValueProvider()).itemSupplier((Supplier)new UserHistoryItemSupplier()).mergeOnRefresh(true).build();
    private final TaskScheduler updateScheduler;

    public ClientUserMonitor(EntityServerAdmin server, int updateRate) {
        this.server = Objects.requireNonNull(server);
        this.clientMonitor = new ClientMonitor(server);
        this.idleConnectionTimeoutValue = Value.value((Object)this.getIdleConnectionTimeout(), (Object)0);
        this.idleConnectionTimeoutValue.addDataListener(this::setIdleConnectionTimeout);
        this.updateScheduler = TaskScheduler.builder(this::refreshUserHistoryTableModel).interval(updateRate, TimeUnit.SECONDS).start();
    }

    public void shutdown() {
        this.updateScheduler.stop();
    }

    public ClientMonitor clientMonitor() {
        return this.clientMonitor;
    }

    public FilteredTableModel<?, Integer> userHistoryTableModel() {
        return this.userHistoryTableModel;
    }

    public void disconnectAll() throws RemoteException {
        this.server.disconnectAllClients();
        this.clientMonitor.refresh();
    }

    public void disconnectTimedOut() throws RemoteException {
        this.server.disconnectTimedOutClients();
        this.clientMonitor.refresh();
    }

    public void setMaintenanceInterval(int interval) throws RemoteException {
        this.server.setMaintenanceInterval(interval * 1000);
    }

    public int getMaintenanceInterval() throws RemoteException {
        return this.server.getMaintenanceInterval() / 1000;
    }

    public void resetHistory() {
        this.userHistoryTableModel.clear();
    }

    public Value<Integer> idleConnectionTimeout() {
        return this.idleConnectionTimeoutValue;
    }

    public Value<Integer> updateInterval() {
        return this.updateScheduler.interval();
    }

    private int getIdleConnectionTimeout() {
        try {
            return this.server.getIdleConnectionTimeout() / 1000;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void setIdleConnectionTimeout(int idleConnectionTimeout) {
        if (idleConnectionTimeout < 0) {
            throw new IllegalArgumentException("Idle connection timeout must be a positive integer");
        }
        try {
            this.server.setIdleConnectionTimeout(idleConnectionTimeout * 1000);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void refreshUserHistoryTableModel() {
        try {
            this.userHistoryTableModel.refresh();
        }
        catch (Exception e) {
            LOG.error("Error while refreshing user history table model", (Throwable)e);
        }
    }

    private static List<FilteredTableColumn<Integer>> createUserHistoryColumns() {
        return Arrays.asList(ClientUserMonitor.createColumn(0, "Username", String.class), ClientUserMonitor.createColumn(1, "Client type", String.class), ClientUserMonitor.createColumn(2, "Client version", Version.class), ClientUserMonitor.createColumn(3, "Framework version", Version.class), ClientUserMonitor.createColumn(4, "Host", String.class), ClientUserMonitor.createColumn(5, "Last seen", LocalDateTime.class, new LastSeenRenderer()), ClientUserMonitor.createColumn(6, "Connections", Integer.class));
    }

    private static FilteredTableColumn<Integer> createColumn(Integer identifier, String headerValue, Class<?> columnClass) {
        return ClientUserMonitor.createColumn(identifier, headerValue, columnClass, null);
    }

    private static FilteredTableColumn<Integer> createColumn(Integer identifier, String headerValue, Class<?> columnClass, TableCellRenderer cellRenderer) {
        return FilteredTableColumn.builder((int)identifier).headerValue((Object)headerValue).columnClass(columnClass).cellRenderer(cellRenderer).build();
    }

    private static final class UserHistoryColumnValueProvider
    implements FilteredTableModel.ColumnValueProvider<UserInfo, Integer> {
        private UserHistoryColumnValueProvider() {
        }

        public Object value(UserInfo row, Integer columnIdentifier) {
            switch (columnIdentifier) {
                case 0: {
                    return row.user().username();
                }
                case 1: {
                    return row.clientTypeId();
                }
                case 2: {
                    return row.clientVersion();
                }
                case 3: {
                    return row.frameworkVersion();
                }
                case 4: {
                    return row.clientHost();
                }
                case 5: {
                    return row.getLastSeen();
                }
                case 6: {
                    return row.connectionCount();
                }
            }
            throw new IllegalArgumentException(columnIdentifier.toString());
        }
    }

    private final class UserHistoryItemSupplier
    implements Supplier<Collection<UserInfo>> {
        private UserHistoryItemSupplier() {
        }

        @Override
        public Collection<UserInfo> get() {
            try {
                ArrayList<UserInfo> items = new ArrayList<UserInfo>(ClientUserMonitor.this.userHistoryTableModel.items());
                for (RemoteClient remoteClient : ClientUserMonitor.this.server.clients()) {
                    UserInfo newUserInfo = new UserInfo(remoteClient.user(), remoteClient.clientTypeId(), remoteClient.clientHost(), LocalDateTime.now(), remoteClient.clientId(), remoteClient.clientVersion(), remoteClient.frameworkVersion());
                    int index = items.indexOf(newUserInfo);
                    if (index == -1) {
                        items.add(newUserInfo);
                        continue;
                    }
                    UserInfo currentUserInfo = (UserInfo)items.get(index);
                    currentUserInfo.setLastSeen(newUserInfo.getLastSeen());
                    if (!currentUserInfo.isNewConnection(newUserInfo.getClientId())) continue;
                    currentUserInfo.incrementConnectionCount();
                    currentUserInfo.setClientID(newUserInfo.getClientId());
                }
                return items;
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class LastSeenRenderer
    extends DefaultTableCellRenderer {
        private final DateTimeFormatter formatter = LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutesSeconds().build().createFormatter();

        private LastSeenRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Temporal) {
                super.setValue(this.formatter.format((Temporal)value));
            } else {
                super.setValue(value);
            }
        }
    }

    private static final class UserInfo {
        private final User user;
        private final String clientTypeId;
        private final String clientHost;
        private final Version clientVersion;
        private final Version frameworkVersion;
        private LocalDateTime lastSeen;
        private UUID clientId;
        private int connectionCount = 1;

        private UserInfo(User user, String clientTypeId, String clientHost, LocalDateTime lastSeen, UUID clientId, Version clientVersion, Version frameworkVersion) {
            this.user = user;
            this.clientTypeId = clientTypeId;
            this.clientHost = clientHost;
            this.lastSeen = lastSeen;
            this.clientId = clientId;
            this.clientVersion = clientVersion;
            this.frameworkVersion = frameworkVersion;
        }

        public User user() {
            return this.user;
        }

        public String clientTypeId() {
            return this.clientTypeId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public LocalDateTime getLastSeen() {
            return this.lastSeen;
        }

        public UUID getClientId() {
            return this.clientId;
        }

        public Version clientVersion() {
            return this.clientVersion;
        }

        public Version frameworkVersion() {
            return this.frameworkVersion;
        }

        public int connectionCount() {
            return this.connectionCount;
        }

        public void setLastSeen(LocalDateTime lastSeen) {
            this.lastSeen = lastSeen;
        }

        public void setClientID(UUID clientId) {
            this.clientId = clientId;
        }

        public void incrementConnectionCount() {
            ++this.connectionCount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UserInfo)) {
                return false;
            }
            UserInfo that = (UserInfo)obj;
            return this.user.username().equalsIgnoreCase(that.user.username()) && this.clientTypeId.equals(that.clientTypeId) && this.clientHost.equals(that.clientHost);
        }

        public int hashCode() {
            int result = this.user.username().toLowerCase().hashCode();
            result = 31 * result + this.clientTypeId.hashCode();
            result = 31 * result + this.clientHost.hashCode();
            return result;
        }

        public boolean isNewConnection(UUID clientId) {
            return !this.clientId.equals(clientId);
        }
    }
}

