/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.logging.MethodLogger;
import is.codion.common.rmi.server.ClientLog;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.state.State;
import is.codion.framework.server.EntityServerAdmin;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public final class ClientInstanceMonitor {
    private static final NumberFormat MICROSECOND_FORMAT = NumberFormat.getIntegerInstance();
    private final RemoteClient remoteClient;
    private final EntityServerAdmin server;
    private final State loggingEnabled;
    private final StyledDocument logDocument = new DefaultStyledDocument();
    private final DefaultMutableTreeNode logRootNode = new DefaultMutableTreeNode();
    private final DefaultTreeModel logTreeModel = new DefaultTreeModel(this.logRootNode);

    public ClientInstanceMonitor(EntityServerAdmin server, RemoteClient remoteClient) throws RemoteException {
        this.remoteClient = Objects.requireNonNull(remoteClient);
        this.server = Objects.requireNonNull(server);
        this.loggingEnabled = State.state((boolean)server.isLoggingEnabled(remoteClient.clientId()));
        this.bindEvents();
    }

    public RemoteClient remoteClient() {
        return this.remoteClient;
    }

    public State loggingEnabled() {
        return this.loggingEnabled;
    }

    public void refreshLog() throws RemoteException {
        ClientLog log = this.server.clientLog(this.remoteClient.clientId());
        try {
            this.logDocument.remove(0, this.logDocument.getLength());
            this.logRootNode.removeAllChildren();
            if (log != null) {
                StringBuilder logBuilder = new StringBuilder();
                for (MethodLogger.Entry entry : log.entries()) {
                    entry.appendTo(logBuilder);
                    DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(ClientInstanceMonitor.entryString(entry));
                    if (entry.hasChildEntries()) {
                        ClientInstanceMonitor.addChildEntries(entryNode, entry.childEntries());
                    }
                    this.logRootNode.add(entryNode);
                }
                this.logDocument.insertString(0, logBuilder.toString(), null);
                this.logTreeModel.setRoot(this.logRootNode);
            } else {
                this.logDocument.insertString(0, "Disconnected!", null);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public Document logDocument() {
        return this.logDocument;
    }

    public DefaultTreeModel logTreeModel() {
        return this.logTreeModel;
    }

    public String toString() {
        return this.remoteClient.toString();
    }

    private void setLoggingEnabled(boolean status) {
        try {
            this.server.setLoggingEnabled(this.remoteClient.clientId(), status);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void bindEvents() {
        this.loggingEnabled.addDataListener(this::setLoggingEnabled);
    }

    private static void addChildEntries(DefaultMutableTreeNode entryNode, List<MethodLogger.Entry> childEntries) {
        for (MethodLogger.Entry entry : childEntries) {
            DefaultMutableTreeNode subEntry = new DefaultMutableTreeNode(ClientInstanceMonitor.entryString(entry));
            if (entry.hasChildEntries()) {
                ClientInstanceMonitor.addChildEntries(subEntry, entry.childEntries());
            }
            entryNode.add(subEntry);
        }
    }

    private static String entryString(MethodLogger.Entry entry) {
        StringBuilder builder = new StringBuilder(entry.method()).append(" [").append(MICROSECOND_FORMAT.format(TimeUnit.NANOSECONDS.toMicros(entry.duration()))).append(" \u03bcs").append("]");
        if (entry.enterMessage() != null) {
            builder.append(": ").append(entry.enterMessage().replace('\n', ' '));
        }
        return builder.toString();
    }
}

